/*********************************************************************************************************/
/**
 * twodeeeditor plugin for CKEditor 
 */
/** ****************************************************************************************************** */

var mmlHolder = null;
var eSelected = null;
var theEditor;

//var appletCode = '<div class="mathEditorArea" id="twodeeeditorMathArea">' +
//					'<div class="mathEditor" id="twodeeeditorMath">' +
//					'<input type="hidden" name="answer" class="mathEditorValue" id="twodeeeditorMathValue">' + 
//					'</div></div>';

var CKTwoDeeEditorPlugin = (function() {
	return {
		appletToTextarea : function(dialog) {
			
			var editorDiv = $(dialog.definition.getIdStr('twodeeeditorMathArea'));
			readEquationEditor(editorDiv);
				
			var resp = $(dialog.definition.getIdStr('twodeeeditorMathValue')).val();

			$('.mathMlArea textarea', dialog.getElement().$).val(resp);

		},
		filterHtml: function(input, callback){
			if ( CKTwoDeeEditorPlugin.useImageRendering()  ) {
				// Don't do the filtering in IE
				callback(input);
			}else{
				var url = getBaseURL() + 'rest/questions/filter';
				$.ajax({
					type: 'POST',
					url: url,
					data: input,
					contentType: 'application/json',
					dataType: 'json'
						
				}).always( function(result){
					var response;
					
					if( result != null && result.responseText != null ){
						response = result.responseText;
						
						callback(response);
					}
					
					
				});
			}
		},	
		updateMath : function(dialog) {

			var TeX = $('.mathMlArea textarea', dialog.getElement().$).val();

			var selector = 'a.cke_dialog_tab[title="Equation Editor"]';

			if (TeX.indexOf("\\[") != -1 || TeX.indexOf("\\(") != -1 ) {
				// hide the Equation editor tab
				$(selector, dialog.getElement().$).hide();
			} else {
				$(selector, dialog.getElement().$).show();
			}

			var mathOutput = $('#mathOutput', dialog.getElement().$);
			
			this.filterHtml( TeX, function(filtered){
				$('#texBuffer').html(filtered);
	
				MathJax.Hub.Queue([ "Typeset", MathJax.Hub, 'texBuffer' ]);

				MathJax.Hub.queue.Push(function() {
					mathOutput.html($('#texBuffer').html());
				});
			});

		},
		updatePreview : function(dialog) {
			if (dialog.lastTab == 'applet') {
				this.appletToTextarea(dialog);

			}

			CKTwoDeeEditorPlugin.updateMath(dialog);
		},
		getMath: function(dialog) {
			if (dialog.lastTab == 'applet') {
				this.appletToTextarea(dialog);
			}

			return $('.mathMlArea textarea', dialog.getElement().$).val();
		},
		createSpans: function(bodyHtml) {

			// Match <math>...</math>
			bodyHtml = bodyHtml.replace(/<math[^>]*?>[\S\s]*?<\/math>/g,
					function(capture) {
						var tag = 'span';
						
						if( capture.indexOf('block') >= 0 ){
							tag = 'div';
						}
						
						capture = capture.replace('\n', '');
						var source = capture.replace(/&#x26;DifferentialD;/g, '&DifferentialD;');
						source = source.replace(/&#x26;ExponentialE;/g, '&ExponentialE;');
						source = source.replace(/&#x26;ImaginaryI;/g, '&ImaginaryI;');
						source = source.replace(/&#x26;InvisibleTimes;/g, '&InvisibleTimes;');

						var output = '<' + tag + ' class="mtaMath" source="'
								+ encodeURIComponent(source) + '"  contenteditable="false">\n' + capture
								+ '\n</' + tag + '><span>&nbsp;</span>';

						return output;
			});
			
			// Match /[ .... /]
			bodyHtml = bodyHtml.replace(/(\\\[[ -~\t\r\n]*?\\\])/g, function(
					capture) {
				return '<div class="mtaMath" source="' + encodeURIComponent(capture) + '" contenteditable="false">'
						+ capture + '</div>';
			});

			// Match /( .... /)
			bodyHtml = bodyHtml.replace(/(\\\([ -~\r\n]*?\\\))/g, function(
					capture) {
				return '<span class="mtaMath" source="' + encodeURIComponent(capture)
						+ '" contenteditable="false">' + capture + '</span><span>&nbsp;</span>';
			});

			return bodyHtml;
		},
		typesetHtmlWithMathJax: function(input, callback){
			var holderId = "holder" +  new Date().getTime() + Math.floor(Math.random()*1000);
			
			$('body').append('<div id="' + holderId + '" style="display: none;">' + input + '</div>');

			var tempHolder = $('#' + holderId);

			MathJax.Hub.Queue([ "Typeset", MathJax.Hub, holderId ]);

			MathJax.Hub.queue.Push(function() {

				var output = $(tempHolder).html();

				$(tempHolder).remove();
				
				callback(output);
			});
		},
		typesetHtmlWithImages: function(input, callback){

			$('body').append('<div id="tempHolder" style="display: none;">' + input + '</div>');

			var tempHolder = $('#tempHolder');
			
			var spans = $('.mtaMath', tempHolder);

			var replacements = [];
			
			// Create function that will only run after being called spans.length times
			var finishedRendering = _.after( spans.length, function(){
				_.each( replacements, function(replacement){

						$(replacement.element, tempHolder).first().html(replacement.image);
				});
				
				var output = $(tempHolder).html();
				
				$(tempHolder).remove();
				
				callback(output);
			});
			
			_.each(spans, function(curSpan){
				
				var source = $(curSpan).attr('source');
				
				var mathMl = decodeURIComponent( source );
				
				if( mathMl.indexOf("<math") != -1){
				
					 $.ajax({
						 url: 'qbeditor/TwoDAction.do', 
						 data: {
							 action: "submit",
							 mmlID: '',
							 mml: mathMl
						 },
						 type: 'POST',
						 success: function(data){
		            		 var startString = "FCKtwod.update('";
		            		 
		            		 var urlStart = data.indexOf(startString);
		            		 var urlEnd = data.indexOf( "'", urlStart + startString.length + 1);
		            		 
		            		var url = data.substring( urlStart + startString.length, urlEnd );
				 
		            		 var image = '<img src="' + url + '" class="mtaImg"/>';
		            		 
		            		 
		            		 replacements.push({
		            			 element: curSpan,
		            			 image: image
		            		 });
		            		 
		            	 }
					 }).always(function(){
	            		  // Call finishedRendering - this will actually only run after it is called spans.length times
	            		 finishedRendering();
	            	 });	
				}else{
					// LaTeX, leave as is
					finishedRendering();
				}
			});
		},
		useImageRendering: function(){
			return ( typeof( MathJax ) == 'undefined' );
		},
		typesetElement : function(element, callback) {
			var self = this;
			
			self.filterHtml( element , function(filtered){
				self.typesetHtml(self.createSpans(filtered), function(result) {
					if( callback ){
						callback(result);
					}
				});		
			} );
		},
		typesetHtml: function(input, callback) {		
			if ( CKTwoDeeEditorPlugin.useImageRendering() ) {
			    //IE rendering mode or inside the response area iframe
				CKTwoDeeEditorPlugin.typesetHtmlWithImages(input, callback);
			}else{
				CKTwoDeeEditorPlugin.typesetHtmlWithMathJax(input, callback);
			}

		},
		typesetEditor : function(editor, callback) {
			var iframe = $('.cke_contents iframe', editor.container.$)[0];

			var body = $(iframe.contentWindow.window.document.body);

			var cleaned = this.removeMathJax( $(body).html(), false );
			
			var self = this;
			
			self.filterHtml( cleaned , function(bodyHtml){
				self.typesetHtml(self.createSpans(bodyHtml), function(result) {
					
					CKTwoDeeEditorPlugin.setEditorData(editor, result, callback);
				});		
			} );
		},
		setEditorData: function(editor, result, callback){
			var iframe = $('.cke_contents iframe', editor.container.$)[0];
			$(iframe.contentWindow.window.document.body).html(result);
			if( callback ){
				callback();
			}
			
		},
		removeMathJax: function(input, preserveSpans) {
			$('body').append(
					'<div id="tempHolder" style="display: none">' + input
							+ '</div>');

			var tempHolder = $('#tempHolder');
			
			$('.mtaMath', tempHolder).html('');
			
			var output = $(tempHolder).html();
			
			// Clear out spacer spans
			output = output.replace(/<span>&nbsp;<\/span>/gi, "");
			
			output = output.replace(/<(span|div)[^>]*?class=['"]?mtaMath['"]?[^>]*?source=['"]?([^"]*)['"]?[^>]*?>[\S\s]*?<\/(span|div)>/gi,
				function(capture, tag, escaped) {
					var source = decodeURIComponent(escaped);

					if( preserveSpans ){
						var output = '<' + tag + ' class="mtaMath" source="'
								+ escaped + '" contenteditable="false">\n' + source
								+ '\n</' + tag + '><span>&nbsp;</span>';

						return output;
					}else{
						return source;
					}
			});
		
			$(tempHolder).remove();

			return output;
		},
		setSelected : function(span) {

			eSelected = CKEDITOR.dom.element.get(span);

			var source = $(span).attr('source');
			mmlHolder = decodeURIComponent(source);
			
			
		},
		cleanSourceArea : function(editor) {
			var textArea = $('.cke_contents textarea', editor.container.$)[0];

			var input = $(textArea).val();

			var cleaned = this.removeMathJax(input, false);
			
			$(textArea).val(cleaned);
		},
		setEditor : function(editor) {
			theEditor = editor;
		},
		removeSelection: function() {
			var sel = theEditor.getSelection();
			var range = sel.getRanges()[0];
			range.collapse(false);
			sel.selectRanges([range]);
		},
		resetVariables : function(dialog) {
			
			this.removeSelection();
			
			mmlHolder = null;
			eSelected = null;

			dialog.lastTab = 'applet';
			dialog.initialized = false;

			var selector = 'a.cke_dialog_tab[title="Equation Editor"]';
//			$(selector, dialog.getElement().$).show();
//			
//			MapleCloud.getMathContainerForId(dialog.definition.getId('twodeeeditorMath')).uninstall();
		}
	};
})();

(function() {
	CKEDITOR.plugins
			.add(
					'twodeeeditor',
					{
						lang : [ 'en', 'fr', 'ja', 'zh-tw', 'zh-cn', 'es', 'pt', 'ko' ],
						init : function(editor) {

							editor.on('instanceReady', function(evt) {
								editor.modeFlipped = false;
								CKTwoDeeEditorPlugin.typesetEditor(editor);
							});

							editor.on('doubleclick', function(evt) {

								var span = evt.data.element.$;
								
								if ($(span).attr('class') == null || $(span).attr('class') == 'mtaImg'
										|| $(span).attr('class').search(
												"mtaMath") == -1 ) {

									span = $(span).parents('.mtaMath');
								} else {
									span = null;
								}

								if (span != null && span.length > 0) {

									var spanElement = CKEDITOR.dom.element.get(span[0]);
									
									var sel = editor.getSelection();
									
									sel.selectElement(spanElement);
									
									CKTwoDeeEditorPlugin.setSelected(spanElement);
									
									evt.data.dialog = 'twodeeeditorDialog';

//									return false;
								}
							});

							editor.on('mode', function(e) {

								if (editor.mode
										.localeCompare('wysiwyg') == 0
										&& editor.modeFlipped) {
									CKTwoDeeEditorPlugin.typesetEditor(editor);
								} else {

									CKTwoDeeEditorPlugin
											.cleanSourceArea(editor);

								}

								editor.modeFlipped = true;

							});

							CKEDITOR.dialog
									.add(
											'twodeeeditorDialog',
											function(editor) {
												CKTwoDeeEditorPlugin.setEditor(editor);
												
												return {
													
													suffix: editor.id,
													getId: function(theId) {
														return theId + '_' + this.suffix;
													},
													getIdStr: function(theId) {
														return '#' + this.getId(theId);
													},
													getAppletCode: function() {
														return '<div class="mathEditorArea" data-toolbar="EqeFullToolbar.xml" id="'+ this.getId('twodeeeditorMathArea') +'">' +
														'<div class="mathEditor" id="'+ this.getId('twodeeeditorMath') +'">' +
														'<input type="hidden" name="answer" class="mathEditorValue" id="'+ this.getId('twodeeeditorMathValue') +'">' + 
														'</div></div>';
													},
													mathApplet : function() {
														return 
														'<link rel="stylesheet" href="' + getBaseURL() + 
														'/modules/scripts/MathEditor/MapleCloudPlayer.css">' + 
														'<link rel="stylesheet" href="' + getBaseURL() + 
														'/modules/skin/css/eqe.css">' + 
																'<div id="' + 
																this.getId('appletBox') +
																'" class="appletBox">' + 
																this.getAppletCode() + 
																'</div>';
													},
													
													
													
													title : editor.lang.twodeeeditor.title,
													minWidth : 570,
													minHeight : 220,
													contents : [
															{
																id : 'applet',
																label : editor.lang.twodeeeditor.editorTab,
																expand : true,
																elements : [ {
																	type : 'html',
																	html : '<link rel="stylesheet" href="' + 
																			getBaseURL() + 
																			'/modules/scripts/MathEditor/MapleCloudPlayer.css">' + 
																			'<link rel="stylesheet" href="' + getBaseURL() + '/modules/skin/css/eqe.css">' +
																			'<div id="'+ 
																			'appletBox_' + 
																			editor.id +
																			'" class="appletBox">' + 
																			'<div class="mathEditorArea" data-toolbar="EqeFullToolbar.xml" id="'+ 'twodeeeditorMathArea_' + 
																			editor.id +
																			'">' + 
																			'<div class="mathEditor" id="'+ 
																			'twodeeeditorMath_' + 
																			editor.id +'">' + 
																			'<input type="hidden" name="answer" class="mathEditorValue" id="'+ 
																			'twodeeeditorMathValue_' + 
																			editor.id +'">' + 
																			'</div></div>' + 
																			'</div>',
																	width : '570',
																	height : '220'
																} ]
															},
															{
																id : 'mathml',
																label : editor.lang.twodeeeditor.mathmlTab,
																expand : true,
																elements : [
																		{
																			type : 'html',
																			html : editor.lang.twodeeeditor.mathmlText
																		},
																		{
																			type : 'textarea',
																			className : 'mathMlArea',
																			rows : 8,
																			cols : 15
																		},
																		{
																			type : 'html',
																			html : '<div id="texBuffer" style="display:none"></div>'
																		},
																		{
																			type : 'html',
																			html : ' <span id="mathOutput"></span> '
																		} ]
															}

													],
													onLoad : function() {

														var self = this;

														this
																.on(
																		'selectPage',
																		function(
																				e) {

																			var page = e.data.page;
																			var currentPage = e.data.currentPage;

																			if (page == 'mathml') {

																				if (currentPage == 'applet') {

																					if (self.initialized) {
																						CKTwoDeeEditorPlugin.appletToTextarea(self);
																						
																						CKTwoDeeEditorPlugin.updatePreview(self);
																					} else {
																						$(
																								'.mathMlArea textarea',
																								self
																										.getElement().$)
																								.val(
																										mmlHolder);
																					}
																					
																				}

																			} else if (page == 'applet') {
																				if (currentPage == 'mathml'
																						&& self.initialized) {
																					mmlHolder = $(
																							'.mathMlArea textarea',
																							self
																									.getElement().$)
																							.val();
																					
																					MapleCloud.getMathContainerForId(this.definition.getId('twodeeeditorMath')).updateMathModel(mmlHolder);
																				}

																			}

																			self.lastTab = page;
																		});

														$(
																'.mathMlArea textarea')
																.bind(
																		'keyup',
																		function() {
																			CKTwoDeeEditorPlugin
																					.updatePreview(self);
																});
													},
													onShow : function() {
														$(this.definition.getIdStr('appletBox')).html(this.definition.getAppletCode());

														$(
																'.cke_contents iframe',
																editor.container.$)
																.css(
																		'position',
																		"relative");
														$(
																'.cke_contents iframe',
																editor.container.$)
																.css('z-index',
																		"10");

														$(
																'#mathEditor',
																this
																		.getElement().$)
																.css('width',
																		"100%");
														$(
																'#mathEditor',
																this
																		.getElement().$)
																.css('height',
																		"100%");

														$('.cke_dialog_contents').css('height','100%');
														$('.cke_dialog_contents').css('width','100%');
//														$('.cke_dialog_background_cover').css('z-index', '7000');
//														$('.cke_dialog').css('z-index', '7500');
														
														var self = this;

														self.lastTab = 'applet';
														self.initialized = false;

														setTimeout(
																function() {
																	if (mmlHolder != null
																			&& mmlHolder
																					.indexOf("<math") == -1) {
																		// Don't
																		// have
																		// a
																		// math
																		// tag -
																		// don't
																		// display
																		// the
																		// applet,
																		// go to
																		// mathMl
																		// view
																		
																		self.selectPage('mathml');

																		$('.mathMlArea textarea',
																				self
																						.getElement().$)
																				.val(
																						mmlHolder);

																		CKTwoDeeEditorPlugin
																				.updatePreview(self);

																		$(self.definition.getIdStr('twodeeeditorMathValue')).val(encodeURIComponent(mmlHolder));
																	} else {
																		self
																				.selectPage('applet');

																		$(self.definition.getIdStr('twodeeeditorMathValue')).val(encodeURIComponent(mmlHolder));
																		
																		var editorDiv = $(self.definition.getIdStr('twodeeeditorMathArea'));
																		initializeEditor(editorDiv);
																		
																		self.initialized = true;
																	}
																	
																}, 100);
													},
													onOk : function() {

														var self = this;
														var math = CKTwoDeeEditorPlugin.getMath(this);
														
														CKTwoDeeEditorPlugin.typesetElement(math, function(result) {
															
															var element  = CKEDITOR.dom.element.createFromHtml(result);
															
															if (eSelected != null) {
																setTimeout( function(){
																	element.replace(eSelected);
																	CKTwoDeeEditorPlugin.resetVariables(self); 
																}, 100);
															} else {
																editor.insertElement(element);
																CKTwoDeeEditorPlugin.resetVariables(self); 
															}
														});
														
													},
													onCancel : function() {
														var self = this;
														setTimeout( function(){
															CKTwoDeeEditorPlugin.resetVariables(self); 
														}, 100);
													}
												};
											});

							editor.addCommand('twodeeeditor',
									new CKEDITOR.dialogCommand(
											'twodeeeditorDialog'));

							editor.ui.addButton('twodeeeditor', {
								label : editor.lang.twodeeeditor.title,
								command : 'twodeeeditor',
								icon : this.path + "images/2D.GIF"
							});
						}
					});
})();
