<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"
	language="java"%>

<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://displaytag.sf.net" prefix="display"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>

<tiles:importAttribute ignore="false" name="formAction" scope="page" />

<fmt:bundle
	basename="com.maplesoft.mapleta.application.ApplicationResources">

	<logic:notEmpty name="rosterValidationBean" property="invalidProfiles">

			<tiles:insert definition=".rosteradmin.validation.invalid"
				flush="false">
				<tiles:put name="invalidProfiles" beanName="rosterValidationBean"
					beanProperty="invalidProfiles" />
			</tiles:insert>

	</logic:notEmpty>
	<div class="row section">
		<div class="span3 sectionName">
			<h3>
				<fmt:message
								key="RosterAdmin.class.validation.summary.create.heading"/>
			</h3>
			<c:if test="${fn:length(rosterValidationBean.profilesToCreate)>0}">
			<p><c:choose>
					<c:when test="${rosterValidationBean.allowCreate}">
						<fmt:message
								key="RosterAdmin.class.validation.summary.create.msg">
								<fmt:param>${fn:length(rosterValidationBean.profilesToCreate)}</fmt:param>
							</fmt:message>
					
					</c:when>
					<c:otherwise>
						<span class="errorStyle1">
							<fmt:message
									key="RosterAdmin.class.validation.summary.create.error.msg">
									<fmt:param>${fn:length(rosterValidationBean.profilesToCreate)}</fmt:param>
								</fmt:message>
						</span>
					</c:otherwise>
				</c:choose>
				</p>
			</c:if>
		</div>

		<div class="span9 sectionMain">


			<tiles:insert definition=".rosteradmin.usertable.display"
				flush="false">
				<tiles:put name="profiles" beanName="rosterValidationBean"
					beanProperty="profilesToCreate" />
				<tiles:put name="id" value="id1" />
			</tiles:insert>
		</div>
	</div>

	<div class="row section">
		<div class="span3 sectionName">
			<h3>
				<fmt:message
								key="RosterAdmin.class.validation.summary.update.heading"/>
				
			</h3>
			<p><c:choose>
					<c:when test="${rosterValidationBean.allowUpdate || rosterValidationBean.allowClassCreate}">
					<fmt:message
								key="RosterAdmin.class.summary.register.msg">
								<fmt:param>${fn:length(rosterValidationBean.profilesToUpdate)}</fmt:param>
							</fmt:message>
						
					</c:when>
					<c:otherwise>
						<span class="errorStyle1">
							<fmt:message
									key="RosterAdmin.class.validation.summary.update.error.msg">
									<fmt:param>${fn:length(rosterValidationBean.profilesToUpdate)}</fmt:param>
							</fmt:message>
						</span>
					</c:otherwise>
				</c:choose>
			</p>
		</div>

		<div class="span9 sectionMain">
			<tiles:insert definition=".rosteradmin.usertable.display"
				flush="false">
				<tiles:put name="profiles" beanName="rosterValidationBean"
					beanProperty="profilesToUpdate" />
				<tiles:put name="id" value="id2" />
			</tiles:insert>
		</div>
	</div>

		
<%-- rosterValidationBean.allowUpdate && fn:length(rosterValidationBean.profilesToUpdate) > 0 --%>		
	<c:if test="${ (rosterValidationBean.allowCreate && fn:length(rosterValidationBean.profilesToCreate) > 0) || ( fn:length(rosterValidationBean.profilesToUpdate) > 0) }">

			<html:form method="post" action="${pageScope.formAction}"
				styleClass="form-horizontal">
			<div class="float-space">&nbsp;</div>
		<div class="form-actions actions-float">
					<html:submit styleClass="btn btn-primary">
						<fmt:message key="RosterAdmin.roster_upload.label" />
					</html:submit>
				</div>
			</html:form>
	</c:if>
	

</fmt:bundle>
