/*
 * This set of Javascript functions is used by the frames containing questions
 * in student assignments.  None of the functions in this file are directly 
 * related to look and feel. It is strongly recommended NOT to modify these functions.
 */

var isLoaded = false;
var controlbar;

function onSubmit() {

	/*
	 * We need to verify that all page components (EQEs, MapleCloud, CKEditors and MathApps) are loaded before we allow submitting the page.
	 * Otherwise, display an alert to the user.
	 */
	
	var pageLoaded = pageFullyLoaded();
  
	if (!pageLoaded) {
		alert(msgAssignmentWaitForPageToLoad);
	}
  
	return pageLoaded && readAppletItems();
}

/*
 * Redefined in the question page
 */
function initControlbar() {
  // Do nothing
}

/*
 * Called by the links in the syntax report.
 */
function doReturn(i) {
  document.edu_form.elements["goto"].value=i;
  doAction("goto");
}

/*
 * Called by the View Details button on the gradebar
 */
function viewDetails(i) {
  document.edu_form.show.value = i;
  doAction("showQuestion");
}
  

function doInSessionFeedback() {
	if (readAppletItems()) {
		
		if( typeof openuw == 'undefined' || openuw != true ){
			try {
				$('#pageDialog').dialog("destroy");
			} catch (ex) {
			}

			$('#pageDialog').dialog({
				"title" : "How did I do?",
				"resizable" : true,
				"autoOpen" : true,
				"width" : 800,
				"height" : 600,
				"open" : function() {
					setAppletsEnabled($(this).closest(".ui-dialog")[0], false);
					
					var container = $(this).html("<div id='helpContainer'></div>").find('#helpContainer'),
					    data = $(document.forms.edu_form).serialize();
					data += '&html5LibLoaded=' + ((typeof html5Ques !== 'undefined') ? html5Ques.LibLoaded.join(',') : '');
					
					$.ajax({
						type : "POST",
						url : getBaseURL()+ "modules/unproctoredTest.InSessionGradeReport",
						data : data,
						dataType : "html",
						error : function(response) {
							alert('Woops, unable to connect to server. Please check your internet connection.');
						},
						success : function(response) {
							var div = document.createElement('div');
							div.innerHTML = response;
							container.html($("div.questionstyle", div).html());						
							MathJax.Hub.Queue([ "Typeset", MathJax.Hub ]);	
						}
					});		
				},
				"beforeclose" : function() {
					setAppletsEnabled($(this).closest(".ui-dialog")[0]);
				},
				"beforeClose" : function() {
					setAppletsEnabled($(this).closest(".ui-dialog")[0]);
				},
				"buttons" : {
					"Ok" : function() {
						$(this).dialog("close");
					}
				}
			});
			$('#pageDialog').dialog("open");
		}else{

			var data = $(document.forms.edu_form).serialize();
			data += '&html5LibLoaded=' + ((typeof html5Ques !== 'undefined') ? html5Ques.LibLoaded.join(',') : '');
			
			$.ajax({
				type : "POST",
				url : getBaseURL()+ "modules/unproctoredTest.InSessionGradeReport",
				data : data,
				dataType : "html",
				error : function(response) {
					alert('Unable to connect to server. Please check your internet connection.');
				},
				success : function(data) {
					var modal = $('.modal', data);
					
					$('#pageDialog').html(modal);
					$('#pageDialog').show();
					$('#pageDialog .modal').modal({
						backdrop: true
					});
					
					setAppletsEnabled($("#pageDialog .modal")[0], false);
					
					
					$('#pageDialog .modal').on('hide.bs.modal', function(){
						setAppletsEnabled($("#pageDialog .modal")[0]);
						$('.tryAnother').show();
					});
					
					MathJax.Hub.Queue(["Typeset",MathJax.Hub,$('#pageDialog')[0]]);
					
				}
			});		
		}
		

	}
}
