<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ page import="com.maplesoft.mapleta.gateway.GatewayService"%>

<%@ page import="com.maplesoft.mapleta.configuration.MapleTASystemConfiguration"%>

<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>

<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>

<fmt:setBundle
	basename="com.maplesoft.mapleta.application.ApplicationResources"
	scope="request" var="ApplicationResources" />

<!DOCTYPE html>
<html>

<head>
	<!--  inlinePopupLayout.jsp -->
	<base href="<%=GatewayService.getServerURL()%>">

	<meta http-equiv="Pragma" content="no-cache">
	<meta http-equiv="Cache-Control" content="no-cache">
	<meta http-equiv="Expires" content="0">
	
	<tiles:insert page="/WEB-INF/tiles/wsscript.jsp" beanScope="request" flush="false" />

	<link rel="stylesheet" type="text/css" href="<%=GatewayService.getServerURL()%>modules/skin/css/jquery.ui.css">
	<link rel="stylesheet"	href="<%=request.getContextPath()%>/modules/skin/css/bootstrap.min.css">
	
	<link rel="stylesheet" type="text/css" href="<%=GatewayService.getServerURL()%>modules/scripts/MathEditor/MapleCloudPlayer.css">
	
	<link rel="stylesheet" type="text/css" href="<%=GatewayService.getServerURL()%>modules/skin/css/main.css">
	<link rel="stylesheet" type="text/css" href="<%=GatewayService.getServerURL()%>modules/skin/css/print.css" media="print">  
	<link rel="stylesheet" type="text/css" href="modules/skin/css/eqe.css">

	<script src="<%=GatewayService.getServerURL()%>modules/scripts/inline.js"></script>
	<script SRC="<%=GatewayService.getServerURL()%>modules/mathEditor/mathEdit.js"></script>
<logic:present name="submitBean" scope="request">
	<script type="text/javascript">
$(function()
{
	<%--
	If submitBean is in the request, that means we are returning after saving a question object.
	--%>

		$('#qTypeHidden').val('<c:out value='${InlineForm.questionType}' />');
		$('#displayHidden').val('<c:out value="${submitBean.displayHtml}" escapeXml="false" />');
		$('#idHidden').val('<c:out value="${submitBean.questionId}" escapeXml="false" />');
		
		window.parent.frameLoaded();
});

</script>
</logic:present>
	<link rel="shortcut icon" href="<%=GatewayService.getServerURL()%>modules/skin/images/titlebar/favicon.ico" />
	<%= MapleTASystemConfiguration.getCUSTOM_HTML_HEAD() %>
</head>

<body>

	<div id="pageContainer">


		<table class="inlineLayout" cellspacing="10">
			<tr>
				<td class="leftCell" valign="top"><tiles:insert name="chooseType" /></td>
				<td class="rightCell"><tiles:insert name="questionType" /></td>
			</tr>
		</table>
		<input type="hidden" id="qTypeHidden"/><input type="hidden" id="displayHidden"/><input type="hidden" id="idHidden"/>
	</div>
</body>

</html>
