<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"
	language="java"%>
<%@ page import="com.maplesoft.mapleta.gateway.GatewayService"%>

<%@ page import="com.maplesoft.mapleta.configuration.MapleTASystemConfiguration"%>


<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>

<%--
taglibs for the html2 plugin, which improve error handling.  Comment/Uncomment the
base taglib and validator, as required.
--%>
<%-- without validation
<%@ taglib uri="http://www.rabago.net/tags-html2" prefix="html2"%>
--%>
<%-- with validation
<%@ taglib uri="http://www.rabago.net/tags-valid2" prefix="html2"%>
 --%>

<tiles:useAttribute name="otherMenu" ignore="true" classname="java.util.List" />
<tiles:useAttribute name="navMenu" ignore="true" classname="java.util.List" />

<!DOCTYPE html>
<html lang="true" oncontextmenu="return false;">
<head>
<!--  assignmentLayout.jsp -->
<base href="<%=GatewayService.getServerURL()%>">

<title><%= MapleTASystemConfiguration.getSCHOOL_NAME() %> - <tiles:getAsString
		name="module_title" ignore="true" /></title>

<meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Cache-Control" content="no-cache">
<meta http-equiv="Expires" content="0">
<meta http-equiv="description"
	content="This is the standard page layout">

<link rel="stylesheet" type="text/css"
	href="<%=GatewayService.getServerURL()%>modules/skin/css/jquery.ui.css">
<link rel="stylesheet"
	href="<%=request.getContextPath()%>/modules/skin/css/bootstrap.min.css">

<link rel="stylesheet"
	href="<%=GatewayService.getServerURL()%>modules/scripts/MathEditor/MapleCloudPlayer.css">

<link rel="stylesheet" type="text/css"
	href="<%=GatewayService.getServerURL()%>modules/skin/css/main.css">


<link rel="stylesheet" type="text/css" href="modules/skin/css/eqe.css">

<c:if test="${sessionScope.bb_enabled}">
	<link rel="stylesheet" type="text/css" href="modules/blackboard/skin/css/main.css">
	<style>

@import URL("${bb_server_url}/ui/styles/blackboard.css");

@import URL("${bb_server_url}/ui/styles/palette.css");
</style>
</c:if>

<tiles:insert page="/WEB-INF/tiles/wsscript.jsp" beanScope="request"
	flush="false" />
	
<script type="text/javascript">
	function confirmAction() {
		<logic:present name="popupConfirm">
		return confirm("<c:out value='${popupConfirm}' escapeXml="false"/>");
		</logic:present>
		return false;
	}
	<c:if test="${ useLockdown }" >
		var assignmentUrl = "${ assignmentUrl }";
		ensureLockdown(assignmentUrl);
	</c:if>
</script>


<link rel="stylesheet" type="text/css"
	href="<%=GatewayService.getServerURL()%>modules/skin/css/print.css"
	media="print">
	
<link rel="shortcut icon"
	href="<%=GatewayService.getServerURL()%>modules/skin/images/titlebar/favicon.ico" />


	

<%=MapleTASystemConfiguration.getCUSTOM_HTML_HEAD()%>

</head>

<%-- store the user context in page scope --%>
<c:set var="context" value="${sessionScope.context}" />
<c:set var="bb_enabled" value="${sessionScope.bb_enabled}" />

<%-- alert the user if another session is opened for this context --%>
<%--
<c:if test="${context.multipleSession}">
	<c:if test="${! context.multipleSessionWarningDelivered}" var="warningDelivered">
		<c:set target="${context}" property="multipleSessionWarningDelivered" value="${true}" />
		<fmt:bundle basename="com.maplesoft.mapleta.session.auth.resources.MessageResource">
			<fmt:message key="multiple.session.warning.title" var="user_warning_title" />
			<fmt:message key="multiple.session.warning.msg" var="user_warning"/>
		</fmt:bundle>
		<script type="text/javascript">
			var log = "<center><h1>${user_warning_title}</h1></center>";
			log += "<p>${user_warning}</p><br>";
			<c:forEach items="${context.usageLog}" var="log">
				log += "${log}<br>";
			</c:forEach>
			popupMessage(log);
		</script>
	</c:if>
</c:if>
--%>

<body id="assignment" oncontextmenu="return false;">
	<div id="main">
		<tiles:insert name="header">
			<tiles:put name="module">
				<tiles:getAsString name="module_title" ignore="true" />
			</tiles:put>
			<tiles:put name="group">
				<tiles:getAsString name="group_title" ignore="true" />
			</tiles:put>
		</tiles:insert>
		<div id="inner">
		<div id="holder" 
			<c:if test="${not bb_enabled}">class="assignmentHolder"</c:if> 
			<c:if test="${bb_enabled}">class="bbHolder"</c:if>>
			<div class="content">
					<% if( MapleTASystemConfiguration.isOPENUW() ){ %>
						<div class="detail">
							<div class="container">
								<h1><tiles:getAsString name="module_title" ignore="true" /></h1>
							</div>
						</div>
					<% } %>
				<div <% if( MapleTASystemConfiguration.isOPENUW() ){ %> class="container"<% } %>>
					<c:if test="${ not empty instruction_module_menu }">
						<div id="instructionModuleMenu">
							<tiles:insert name="instructionModuleMenu">
								<tiles:put name="menuItems" beanName="instruction_module_menu">							
								</tiles:put>	
							</tiles:insert>	
						</div>
					</c:if>
					<div id="pageContainer" <c:if test="${ not empty instruction_module_menu }">class="instructionRight"</c:if>>
					
			
						<tiles:getAsString name="content" />
	
					</div>
				</div>

				<c:if test="${  empty instruction_module_menu && ( not empty navMenu || not empty otherMenu ) }">
					<div class="float-space">&nbsp;</div>
					<div class="form-actions actions-float" id="assignmentButtons">
						<tiles:insert name="menu">
							<tiles:put name="menuItems" beanName="navMenu">							
							</tiles:put>	
						</tiles:insert>
						
						<tiles:insert name="menu">
							<tiles:put name="menuItems" beanName="otherMenu">		
							</tiles:put>
						</tiles:insert>
					</div>

				</c:if>
			</div>
		</div>
	<div id="pageDialog"></div>
	<div id="modal" class="modal hide fade"></div>

	<logic:present name="popupAlert">
		<script type="text/javascript">
			alert("${popupAlert}");
		</script>
	</logic:present>
	</div>
	<%=MapleTASystemConfiguration.getCUSTOM_HTML_FOOTER()%>
	</div>
</body>
</html>
