<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"
	language="java"%>

<%@ page import="com.maplesoft.mapleta.configuration.MapleTASystemConfiguration"%>
<%@ page import="com.maplesoft.mapleta.persistence.service.systemproperty.SystemConstants"%>

<%@ taglib uri="http://www.rabago.net/tags-valid2" prefix="html2"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<c:set var="readOnlyFieldMap"
	value="<%=request.getAttribute(com.maplesoft.mapleta.useradmin.Constants.REQUEST_KEY_PASSWORDUPDATE_RETURNURL)%>" />
<c:set var="LDAPEnabled"
	value='<%=MapleTASystemConfiguration.getProperty(SystemConstants.KEY_LDAP_ENABLED)%>' />
<tiles:useAttribute name="formAction" />
<tiles:useAttribute name="cancelAction" />
<fmt:bundle
	basename="com.maplesoft.mapleta.application.ApplicationResources">
	<script src="modules/scripts/edituser.js"></script>
	<c:choose>
		<c:when test='${userEditReadOnlyProperties["userPassword"] == null}'>
			<c:set var="validatorForm" value="UserAddForm" />
		</c:when>
		<c:otherwise>
			<c:set var="validatorForm" value="UserEditForm" />
		</c:otherwise>
	</c:choose>
	<html2:form method="post" action="${formAction}"
		validatorForm="${validatorForm}" styleClass="form-horizontal">
		<html2:hidden property="referer" />
		<html2:hidden property="id" />
		<html2:hidden property="readOnlyFields" />
		<html2:hidden property="deleted"/>




		<div class="row section">
			<div class="span3 sectionName">
				<h3>
					<fmt:message key="UserEditForm.systemrole.label" />
				</h3>

			</div>

			<div class="span9 sectionMain">

				<label class="control-label" for="systemRoleId"><fmt:message key="UserEditForm.systemrole.label" />
				</label>
				
				<div class="controls">

					<c:choose>
						<c:when test="${context.currentRole.editUser && context.user.id != UserEditForm.id}">	
	
							<tiles:insert definition=".useradmin.roles.sufficient.dropdown" flush="false"/>
						</c:when>
						<c:otherwise>
							<input type="text" value="${UserEditForm.systemRole}" readOnly="true"/>
							<html:hidden property="systemRoleId"/>
						</c:otherwise>
					</c:choose>

				</div>
			</div>
		</div>

		<div class="row section">
			<div class="span3 sectionName">
				<h3>
					<fmt:message key="UserEditForm.account_settings.label" />
				</h3>

			</div>

			<div class="span9 sectionMain">

				<logic:messagesPresent message="true">
					<p>
						<span class="errorStyle1"> <html:messages id="msg" message="true">
								<c:out value="${msg}" />
							</html:messages>
						</span>
					</p>
				</logic:messagesPresent>
				<c:if test="${LDAPEnabled == 'true'}">
					<br />
					<p>
						<fmt:message key="UserEditForm.ldap_enabled.msg" />
					</p>
					<br />
				</c:if>
				<html2:field property="givenName">
					<div class="control-group">
						<label class="control-label" for="givenName"> <html2:label />
						</label>
						<div class="controls">
							<html2:text size="32" property="givenName"
								disabled='${(userEditReadOnlyProperties["givenName"] != null) ? "true" : "false" }'
								onkeyup="editCn();" />
							<html2:error styleClass="errorStyle1" />
						</div>
					</div>
				</html2:field>
				<html2:field property="sn">
					<div class="control-group">
						<label class="control-label" for="sn"> <html2:label />
						</label>
						<div class="controls">
							<html2:text size="32" styleId="sn" onkeyup="editCn();"
								disabled='${(userEditReadOnlyProperties["sn"] != null) ? "true" : "false" }' />
							<html2:error styleClass="errorStyle1" />
						</div>
					</div>
				</html2:field>
				<html2:field property="cn">
					<div class="control-group">
						<label class="control-label" for="cn"> <html2:label /></label>
						<div class="controls">
							<html2:text size="32" styleId="cn"
								disabled='${(userEditReadOnlyProperties["email"] != null) ? "true" : "false" }' />
							<html2:error styleClass="errorStyle1" />
						</div>
					</div>
				</html2:field>
				<html2:field property="studentID">
					<div class="control-group">
						<label class="control-label" for="studentID"> <html2:label /></label>
						<div class="controls">
							<html2:text size="32" styleId="studentID"
								disabled='${(userEditReadOnlyProperties["studentID"] != null) ? "true" : "false" }'
								onblur="document.getElementById('StudentIDInUse').style.display = 'none';" />
							<html2:error styleClass="errorStyle1" />
							<span id="StudentIDInUse" class="errorStyle1"> <logic:messagesPresent>
									<html:messages id="msg" property="StudentIDInUse">
										<bean:write name="msg" />
									</html:messages>
								</logic:messagesPresent>
							</span>
						</div>
					</div>
				</html2:field>
				<html2:field property="email">
					<div class="control-group">
						<label class="control-label" for="email"> <html2:label /></label>
						<div class="controls">
							<html2:text size="32"
								disabled='${(userEditReadOnlyProperties["email"] != null) ? "true" : "false" }'
								onblur="document.getElementById('EmailInUse').style.display = 'none';" />
							<html2:error styleClass="errorStyle1" />
							<span id="EmailInUse" class="errorStyle1"> <logic:messagesPresent>
									<html:messages id="msg" property="EmailInUse">
										<bean:write name="msg" />
									</html:messages>
								</logic:messagesPresent>
							</span>
						</div>
					</div>
				</html2:field>
				<logic:notEmpty name="fields">
					<c:forEach items="${fields}" var="field">
						<div class="control-group">
							<label class="control-label" for="field${ field.fieldId }">
								${ field.name } </label>
							<div class="controls">
								<input type="text" size="32" name="field${ field.fieldId }"
									id="field${ field.fieldId }" value="${ field.value }" /> <span
									class="errorStyle1"> <logic:messagesPresent>
										<html:messages id="msg" property="field${ field.fieldId }Required">
											<bean:write name="msg" />
										</html:messages>
									</logic:messagesPresent>
								</span>
							</div>
						</div>
					</c:forEach>
				</logic:notEmpty>
				<c:choose>
					<c:when test="${editUID}">
						<html2:field property="uid">
							<div class="control-group">
								<label class="control-label" for="uid"> <html2:label /></label>
								<div class="controls">
									<html2:text size="32" styleId="uid"
										disabled='${(userEditReadOnlyProperties["uid"] != null) ? "true" : "false" }'
										onblur="document.getElementById('UidInUse').style.display = 'none';" />
									<html2:error styleClass="errorStyle1" />
									<span id="UidInUse" class="errorStyle1"> <logic:messagesPresent>
											<html:messages id="msg" property="UidInUse">
												<bean:write name="msg" />
											</html:messages>
										</logic:messagesPresent>
									</span>
								</div>
							</div>
						</html2:field>
					</c:when>
					<c:otherwise>
						<html2:field property="uid">
							<div class="control-group">
								<label class="control-label" for="uid"> <html2:label />
								</label>
								<div class="controls">
									<html2:hidden property="uid" />
									<input type="text" disabled="disabled" value="${uidValue}"
										size="32" />
								</div>
							</div>
						</html2:field>
					</c:otherwise>
				</c:choose>
				<c:if test='${userEditReadOnlyProperties["userPassword"] == null}'>
					<html2:field property="userPassword">
						<div class="control-group">
							<label class="control-label" for="userPassword"> <html2:label />
							</label>
							<div class="controls">
								<html2:password size="32" />
								<html2:error styleClass="errorStyle1" />
							</div>
						</div>
					</html2:field>
					<html2:field property="userPasswordConfirm">
						<div class="control-group">
							<label class="control-label" for="userPasswordConfirm"> <html2:label />
							</label>
							<div class="controls">
								<html2:password size="32" />
								<html2:error styleClass="errorStyle1" />
								<span id="MatchPassword" class="errorStyle1"> <logic:messagesPresent>
										<html:messages id="msg" property="MatchPassword">
											<bean:write name="msg" />
										</html:messages>
									</logic:messagesPresent>
								</span>
							</div>
						</div>
					</html2:field>
				</c:if>
				<c:choose>
					<c:when
						test='${userEditReadOnlyProperties["requireValidation"] == null && context.user.validated}'>
						<html2:field property="requireValidation">
							<div class="control-group">
								<label class="control-label" for="requireValidation"> <html2:label />
								</label>
								<div class="controls">
									<html2:checkbox />
									<html2:error styleClass="errorStyle1" />
								</div>
							</div>
						</html2:field>
					</c:when>
					<c:otherwise>
						<html2:field property="requireValidation">
							<html2:hidden property="requireValidation" />
						</html2:field>
					</c:otherwise>
				</c:choose>


			</div>
		</div>


		<div class="float-space">&nbsp;</div>
		<div class="form-actions actions-float">
			<html2:submit styleClass="btn btn-primary">
				<fmt:message key="JspDefault.Submit.Button" />
			</html2:submit>
			<input type="button" class="btn btn-danger"
				value='<fmt:message key="JspDefault.Cancel.Button"/>'
				onclick="javascript:document.location.href='<%=request.getContextPath()%>${cancelAction}?id=${UserEditForm.id}';"></input>
		</div>
				

	</html2:form>
	<html2:html2Javascript xmlHttpRequest="false" />
</fmt:bundle>
