
/*
 * This set of Javascript functions provides general utilities for the system. None
 * of the functions in this file are directly related to look and feel. It is strongly
 * recommended NOT to modify these functions.
 */

/*
 * Variable to hold page submission counter. 
 */
var clickCounter; 

var questionMenu; // The question menu in the top bar

/*
 * Variable to hold assignment window instance reference.
 */
var edu_window;
var inDialog = false; // If a popup dialog is open (for lockdown)
var lockdownUrl;

/*
 * Help URLs from former helpURLs.js file.
 */
var INSTRUCTOR_HELP_URL = "help/MapleTAInstructor/pr01.html";
var SYSADMIN_HELP_URL = "help/MapleTASystemAdministrator/ch01.html";
var PROCTOR_HELP_URL = "help/MapleTAProctor/ch01.html";
var STUDENT_HELP_URL = "help/MapleTAStudent/localization/" + theLocale + "/ch01.html";
var ASSIGNMENT_TYPE_HELP_URL = "help/MapleTAStudent/localization/" + theLocale + "/ch03.html#Chapter03_TypesofAssignments";
// var INLINE_EDITOR_HELP_URL = "help/instructors/index.html#mergedProjects/Advanced_Authoring/mergedProjects/inline_question_visual_editor/editing_with_the_visual_editor.htm"
var MATH_SYMBOL_MODE_HELP_URL = "help/MapleTAStudent/localization/" + theLocale + "/ch04s02.html#Chapter04_AboutSymbolMode";
var MATH_TEXT_MODE_HELP_URL = "help/MapleTAStudent/localization/" + theLocale + "/ch04s02.html#Chapter04_AboutTextMode";
var CHEM_SYMBOL_MODE_HELP_URL = "help/MapleTAInstructor/ch06s04.html#Chapter06_EnteringChemistryExpressions";
var CHEM_TEXT_MODE_HELP_URL = CHEM_SYMBOL_MODE_HELP_URL;
var INSTRUCTOR_MATH_EDITOR_HELP = "help/MapleTAInstructor/ch06s06.html";
var STUDENT_MATH_EDITOR_HELP = MATH_SYMBOL_MODE_HELP_URL;
var INSTRUCTOR_GETTIN_STARTED = "help/MapleTAInstructor/ch01s03.html";
var INSTRUCTOR_USER_GUIDE_PDF = "help/MapleTAUserGuide.pdf";

var QueryString = function () {
	  // This function is anonymous, is executed immediately and 
	  // the return value is assigned to QueryString!
	  var query_string = {};
	  var query = window.location.search.substring(1);
	  var vars = query.split("&");
	  for (var i=0;i<vars.length;i++) {
	    var pair = vars[i].split("=");
	    	// If first entry with this name
	    if (typeof query_string[pair[0]] === "undefined") {
	      query_string[pair[0]] = pair[1];
	    	// If second entry with this name
	    } else if (typeof query_string[pair[0]] === "string") {
	      var arr = [ query_string[pair[0]], pair[1] ];
	      query_string[pair[0]] = arr;
	    	// If third or later entry with this name
	    } else {
	      query_string[pair[0]].push(pair[1]);
	    }
	  } 
	    return query_string;
} ();

/*
 * Hook to be called whenever a form is submitted. Override this to provide
 * functionality.
 */
function onSubmit() {
	return true;
}

function readCookie(name) {
	var nameEQ = name + "=";
	var ca = document.cookie.split(';');
	for(var i=0;i < ca.length;i++) {
		var c = ca[i];
		while (c.charAt(0)==' ') c = c.substring(1,c.length);
		if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
	}
	return null;
}

/*
 * This is the basic action-delegation method called to submit forms to EDU.
 * Most button clicks result in a call to this function.
 */
function doAction(action, method) {
	if (firstClick(action) && onSubmit()) {
		readAppletItems();
		
		var frm = document.forms["edu_form"];
		
		if( frm != null ){
			if( method != null ){
				$(frm).attr('method', method);
			}
			frm.elements.actionID.value = action;
			frm.submit();
		}
	}
}

function disableme(theId) {
	return false;
}

function readEssayAreas(){
	if( typeof CKTwoDeeEditorPlugin != 'undefined'){
		// Have a CKeditor somewhere, clean it up

		var textareas = $('textarea');
		
	
		for( var i = 0; i< textareas.length; i++){
			var curTextarea = textareas[i];
			
			var id = $(curTextarea).attr('id');
			var instance = CKEDITOR.instances[id];
			
			if( instance != null ){
				var input =  instance.getData();
				
				var output = CKTwoDeeEditorPlugin.removeMathJax(input, false);

				var valueId = id.replace('.textarea', '.value');
				
				$('[name="' + valueId + '"]').val(output);
			}
		}
	}
}



function readHtml5Response(){
	//get response of html5 questions
	var brds = $('div[id^="sro_id_"][class^="html5"]');
	if(brds.length > 0){		
		brds.each(function(){						
			var question_id = this.getAttribute('id').substr('sro_id_'.length),
			    regex = new RegExp('_', 'gi'),			    
			    answer_id = question_id.replace(regex, '.') + '.0',
			    input = $(this.parentNode).find('input[type="hidden"][name="ans.'+ answer_id +'"]');
			if(input.length>0){
				input=input[0];
			}else{
				return;
			}
			try{
			  var type = $(this).attr('class').substr('html5'.length), ins=null;
			  if(type == html5Ques.TYPE.SKETCH){
				ins = html5Ques.sketch.getInstances(question_id);
			  }else if(type == html5Ques.TYPE.UWINSTRUCTION){
				ins =  html5Ques.uwinstruction.getInstances(question_id);
			  }else if(type == html5Ques.TYPE.FREEBODYDIAGRAM){
				ins =  html5Ques.fbd.getInstances(question_id);
			  }
			  if(ins!=null)input.value = ins.getResponse();
		    }catch(e){
		    	console.error(e);
			  ;//in case library are not correctly loaded
			}
		});		
	}
	return true;
}

/*
 * Read a question response from a Java applet that conforms to the contract of
 * Java question type.
 */
function readAppletItems() {
	readEssayAreas();
	readEquationEditors();
	readHtml5Response();
	
	var form = document.edu_form;
	
	if( form != null ){
		var elts = form.elements;
		var pattern = /ans\.(\d+)\.(\d+)/;
		
		for (var i = 0; i < elts.length; i++) {
			var name = elts[i].name;
			if (name.match(pattern) != null) {
				var appl = document[name + ".sro"];
				var resp = null;
				if (appl != null) {
					try {
						resp = new String(appl.getResponse());
					} catch (err) {
					}
				} else {
					if ((appl = document[name + ".swf"]) != null) {
						if (!('length' in appl)) {
							try {
								resp = new String(appl.getResponse());	// AS3.0 authors must define, and register with ExternalInterface, a getResponse() method in the Flash movie.
							} catch (err) {
								resp = new String(appl.GetVariable("response")); // As before, AS2.0 authors must define a response variable in the Flash movie.
							}
						} else {
							for (var j=0; j<appl.length; j++) {
								try {
									try {
										resp = new String(appl[j].getResponse());	// AS3.0 authors must define, and register with ExternalInterface, a getResponse() method in the Flash movie.
										break;
									} catch (err) {
										resp = new String(appl[j].GetVariable("response")); // As before, AS2.0 authors must define a response variable in the Flash movie.
										break;
									}
								} catch (err) {
									;
								} 
							}
							appl = appl[j];
						}
	
					} else if ((appl = document[name + ".mw"]) != null) {
						
						var gradeid = name+".0"; 
						var stateid = name+".1"; 
						
						try {
							callMapleNet(appl.value, '', gradeid);
							callMapleNet(appl.value, '', stateid);
							resp == null;
						} catch(err) {
							alert("error");
						}
					}
					
				
				}
				if (resp != null) {
					form.elements[i].value = resp;
					if (resp.indexOf("error:") == 0) {
						var errm = resp.substring(6, resp.length);
						if (!confirm(errm)) {
							appl.requestFocus();
							return false;
						}
					}
				}
			}
		}
	}
	return true;
}

function mapleNetStateChanged(elemid) {
    if (xmlHttp.readyState==4) {
       document.getElementById(elemid).value=xmlHttp.responseText;
    }
}

function GetXmlHttpObject() {
	var xmlHttp = null;
	try {
		// Firefox, Opera 8.0+, Safari
		xmlHttp = new XMLHttpRequest();
	} catch (e) {
		// Internet Explorer
		try {
			xmlHttp = new ActiveXObject("Msxml2.XMLHTTP");
		} catch (e) {
			xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
		}
	}
	return xmlHttp;
}

function callMapleNet(url, params, elemid) {
    xmlHttp=GetXmlHttpObject();
    if (xmlHttp==null) {
       alert ("Your browser does not support AJAX!");
       return;
    }

    xmlHttp.onreadystatechange=mapleNetStateChanged(elemid);
    xmlHttp.open("POST",url,true);
    xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    xmlHttp.setRequestHeader("Content-length", params.length);
    xmlHttp.setRequestHeader("Connection", "close");
    xmlHttp.send(params);
}

/*
 * Redirect the window to the home page for the ambient class.
 */
function toClassPage() {
	var w = window;
	if (window.parent.frames.controlbar != null) {
		w = window.parent.opener;
	}
	if (w != null) {
		if (className != "") {
			w.location = getBaseURL() + "registration.Redirect?className=" + className;
		} else {
			w.location = getBaseURL();
		}
		w.focus();
	}
	if (window.parent.frames.controlbar != null) {
		window.parent.close();
	}
}
/*
 * Draw the content of a popup hints window.
 */
function showHint(hintVal, hintRefVal, testId, assignmentMode) {
	var hintUrl = getBaseURL() + "modules/proctoredTest.ShowHint";
	$.post(hintUrl,{ hint: hintVal, hintRef: hintRefVal, testId: testId, assignment_mode: assignmentMode}, function(data){
	
		var modal = $('.modal', data);
		
		$('#pageDialog').html(modal);
		$('#pageDialog').show();
		$('#pageDialog .modal').modal({
			backdrop: false
		});
		MathJax.Hub.Queue(["Typeset",MathJax.Hub,$('#pageDialog')[0]]);
		
	});


}
/*
 * Provide help for a user in one of the system roles of instructor, student,
 * administrator, or proctor.
 */
function getHelp(what,where) {
	var help;
	// The definitions of the help urls are in helpURLs.js
	if (what == "instructor") {
		help = INSTRUCTOR_HELP_URL;
	} else if (what == "administrator") {
		help = SYSADMIN_HELP_URL;
	} else if (what == "proctor") {
		help = PROCTOR_HELP_URL;
	} else if (what == "student") {
		help =STUDENT_HELP_URL;
	} else if (what == "getting_started") {
		help = INSTRUCTOR_GETTIN_STARTED;
	} else if (what == "user_guide_pdf") {
		help = INSTRUCTOR_USER_GUIDE_PDF;
	} else if (what == "math_symbol_mode" || what == "student_math_editor") {
		help = MATH_SYMBOL_MODE_HELP_URL;
	} else if (what == "math_text_mode") {
		help = MATH_TEXT_MODE_HELP_URL;
	} else if (what == "instructor_math_editor") {
		help = INSTRUCTOR_MATH_EDITOR_HELP;
	} else if (what == "chem_symbol_mode" || what == "chem_text_mode") {
		help = CHEM_SYMBOL_MODE_HELP_URL;
	} else {
		help = ASSIGNMENT_TYPE_HELP_URL;
	}


	openWindow(where+help, "helpWindow", "scrollbars,resizable,width=800,height=600");

}




function getFileName( url )
{

	var index = url.lastIndexOf('/');

	if( index > 0){
		return url.substr( index +1  );
	}else{
		return url;
	}
}

function setImageWidth( img ){
	$("<img/>") // Make in memory copy of image to avoid css issues
	.attr("src", $(img).attr("src") + "?t=" + new Date().getTime())
	.load(function() {
		if( this.width > 740 )
		{
			$(img).css('width', '740px');
		}
	} );
}



function toggleItem(id){
	var target = $('#' + id + 'Table');

	$(target).toggle();

}
/*
 * Utility method. Not called from outside this package.
 */
function getMaplePlotURL(maple, plot, type, libname, driver, width, height) {
	var url = getBaseURL() + "modules/mapleTA.plotserver.PlotServer" + "?maple=" + myEscape(maple) + (plot != null ? "&plot=" + myEscape(plot) : "") + (type != null ? "&type=" + myEscape(type) : "") + (libname != null ? "&libname=" + myEscape(libname) : "") + ((driver == null || driver.length == 0) ? "" : "&plotdriver=" + myEscape(driver)) + ((width == null || height == null) ? "" : "&width=" + width + "&height=" + height);
	return url;
}
/*
 * Create a plot using the provided Maple code. Utility method. Not called from
 * outside this package.
 */
function drawMaplePlot(maple, width, height, libname, driver) {
	var url = getMaplePlotURL(maple, null, null, libname, driver, width, height);
	document.write("<IMG title=\"Maple plot\"");
	document.write("SRC=\"" + url + "\" ");
	// size the image if we have that parameters, otherwise, let the browser
	// figure it out
	if (width != null && height != null) {
		document.write("WIDTH=" + width + " ");
		document.write("HEIGHT=" + height);
	}
	document.write(">");
}
/*
 * Create a popup plot of Maple code.
 */
function popupMaplePlot(maple, plot, type, libname, driver) {
	var url = getMaplePlotURL(maple, plot, type, libname, driver, 560, 430);
	
	var popupUrl = getBaseURL() + "modules/preview.Preview";

	previewModal(popupUrl, function(){
		$('.modal-body').html("<img src='"+ url + "'/>");
	});

}
/*
 * Utility method to perform URL escaping since there are problems with the
 * Javascript built-in function.
 */
function myEscape(s) {
	return encodeURIComponent(s);
}
/*
 * Generate a popup message
 */
function popupMessage(msg) {
	var w = openWindow("", "popup", "width=500,height=380,scrollbars=no,resizable=yes,status=no,location=no,dependent=yes");
	var d = w.document;
	d.open("text/html");
	d.writeln("<HTML>");
	d.writeln("<HEAD>");
	d.writeln("</HEAD>");
	d.writeln("<BODY>");
	d.writeln("<TABLE ALIGN=\"CENTER\">");
	d.writeln("<TR VALIGN=\"CENTER\"><TD>");
	d.writeln(msg);
	d.writeln("</TD></TR>");
	d.writeln("</TABLE>");
	d.writeln("</BODY>");
	d.writeln("</HTML>");
	d.close();
}
var _preview = null;
var _previewEq = null;

function previewModal( url, callback ){
	$.get(url, function(data){
		var modal = $('.modal', data);
		
		$('#pageDialog').html(modal);
		$('#pageDialog').show();
		$('#pageDialog .modal').modal({
			backdrop: false
		});
		MathJax.Hub.Queue(["Typeset",MathJax.Hub,$('#pageDialog')[0]]);
		
		if( callback != null ){
			callback();
		}
	});
}

function previewFormula(quesName, s, m, l, fromQE, callback) {
	//var platf = navigator.platform;
	//var useJava = (platf != null) && (platf.indexOf("Win32") == 0 || platf.indexOf("Linux") == 0);
	var elem =$('input[name="' + quesName +'"]')[0], f = (typeof elem !== 'undefined') ? elem.value : null, b = myEscape(f);
	_previewEq = f;	
	if (_preview != null) {
		_preview.close();
	}

	if (typeof m === "undefined") {
		m = "";
	}
	if (typeof l === "undefined") {
		l = "";
	}
	var requestParam = 'eq=' + b + '&actionID=' + s + '&maple=' + myEscape(m) + '&libname=' + myEscape(l) + '&', requestUrl=getBaseURL();
	requestUrl += (typeof fromQE !== 'undefined' && fromQE == 'true') ? 'ws/launcher.do?wsActionID=questionPreviewFormula&wsQuestionEngine=true&' :  'modules/preview.Preview?';
		
	previewModal(requestUrl + requestParam, callback);
}
function previewChemistry(f) {
	var b = myEscape(f);
	previewModal(getBaseURL() + "modules/preview.Preview?actionID=chemistry&eq=" + b);
}

/*
 * Holds a pointer to an inline question's webeq input control applet. Used by
 * popupMathToolbar() (below) and the JS in mathEditor/toolbar.html.
 */
var _math_toolbar_target;
/*
 * Pop up a toolbar window which writes templates to a webeq IC. Used by the
 * Inline question.
 */
function popupMathToolbar(name) {
	_math_toolbar_target = document[name + ".sro"];
	openWindow(getBaseURL() + "modules/mathEditor/toolbar.html", "math_editor_toolbar", "width=240,height=50");
}
/*
 * Pop up a toolbar window which writes templates to a webeq IC. Used by the
 * Inline question.
 */
function popupChemToolbar(name) {
	_math_toolbar_target = document[name + ".sro"];
	openWindow(getBaseURL() + "modules/mathEditor/chem_toolbar.html", "math_editor_toolbar", "width=240,height=50");
}
/*
 * Popup describing EDU server, version, etc.
 */
function aboutPopup(server_url) {
	openWindow(server_url+"About.do", "version_info", "width=350,height=250,resizable,scrollbars");
}

/*
 * Get a handle to the object matching the given name
 */
function findObj(n, d) {
	var p, i, x;
	if (!d) {
		d = document;
	}
	if ((p = n.indexOf("?")) > 0 && parent.frames.length) {
		d = parent.frames[n.substring(p + 1)].document;
		n = n.substring(0, p);
	}
	if (!(x = d[n]) && d.all) {
		x = d.all[n];
	}
	for (i = 0; !x && i < d.forms.length; i++) {
		x = d.forms[i][n];
	}
	for (i = 0; !x && d.layers && i < d.layers.length; i++) {
		x = findObj(n, d.layers[i].document);
	}
	if (!x && d.getElementById) {
		x = d.getElementById(n);
	}
	return x;
}
/*
 * Change the visibility of the style element to be hidden
 */
function hide(objName) {
	obj = findObj(objName);
	if (obj.style) {
		obj.style.visibility = "hidden";
	}
}
/*
 * Change the visibility of the style element to be visible
 */
function show(objName) {
	obj = findObj(objName);
	if (obj.style) {
		obj.style.visibility = "visible";
	}
}
/*
 * This method installs CSS to enable (certain browsers) to display scrollable
 * tables. The method must be called in the document's <head>. The feature is
 * enabled for Mozilla/Firefox based on Gecko 1.7 or better, and for MSIE 6.0.
 * Usage: Wrap the table in a div.scrollableTableWrapper and include the
 * scrollable body in <tbody>: <div class="scrollableTableWrapper"> <table>
 * <thead><tr><td>Planes</td><td>Trains</td><td>Automobiles</td></tr></thead>
 * <tbody> <tr><td>3</td><td>2</td><td>1</td></tr> <tr><td>1</td><td>2</td><td>1</td></tr>
 * <tr><td>3</td><td>4</td><td>1</td></tr> etc... </tbody> </table>
 * </div>
 */
function deployScrollableTableFeature() {
	var browser = getBrowserCategory();

	if (browser == "gecko") {
		document.writeln("<style type='text/css'> ");
		document.writeln("  div.scrollableTableWrapper tbody {  ");
		document.writeln("    overflow: auto;  ");
		document.writeln("    height: 35em;  ");
		document.writeln("  } ");
		document.writeln("</style>");
	} else {
		if (browser == "ie") {
			document.writeln("<style type='text/css'> ");
			document.writeln("  div.scrollableTableWrapper { ");
			document.writeln("    clear: left; ");
			document.writeln("    float:left; ");
			document.writeln("    height:250px; ");
			document.writeln("    width:100%; ");
			document.writeln("    overflow:scroll; ");
			document.writeln("  } ");
			document.writeln("  div.scrollableTableWrapper table th { ");
			document.writeln("    position: relative; ");
			document.writeln("    background:#f7f7f7; ");
			document.writeln("  } ");
			document.writeln("  div.scrollableTableWrapper table { ");
			document.writeln("    margin-right:16px; ");
			document.writeln("   } ");
			document.writeln("</style>");
		}
	}
}

function getBrowserCategory()
{
	var browser = "unavailable";
	if (navigator.userAgent.indexOf("MSIE") >= 0) {
		browser = "ie";
	} else {
		if (navigator.userAgent.indexOf("Gecko") >= 0) {
			var re = /rv:(\d+\.\d+)/;
			var m = re.exec(navigator.userAgent);
			if (m != null) {
				var v = parseFloat(m[1]);
				if (v >= 1.7) {
					browser = "gecko";
				}
			}
		}
	}

	return browser;
}

selectAllItems = function (obj) {
	var check = obj.checked;
	var boxes = document.getElementsByName("selectedItems");
	for (var i = 0; i < boxes.length; i++) {
		boxes[i].checked = check;
	}
};

//override the back button if the history is empty, meaning the window
//is brand new and should be closed
function sidebarBack() {
	if (history.length <= 1) {
		closeWindow();
	} else {
		history.back();
	}
}

/*
 * Checks for double-clicks on the test screen. Checks Grade button only for
 * now.
 */
function firstClick(action) {
	var status;

//	if (action != "grade")
//	return true;

	if (clickCounter != 1)
		status=true;
	else
		status=false;

	clickCounter=1;
	return status;
}

function isAssignmentWindowClosed(){

	return (edu_window == null || edu_window.closed);

}

function doAssignment(id,tn,timed,isPractice,isLockdown, groupId) {
	if (!firstClick("")) {
		return;
	}
	
	var assignmentUrl ="modules/test.Test?className=" + className + "&testName=" + encodeURIComponent(tn) + "&testId=" + id;
	
	if( typeof openuw != 'undefined' && openuw == true ){
		window.location = getBaseURL() + assignmentUrl + "&gid=" + groupId;
	}else{	
		var url;
		
		if( isLockdown ){
			url = getBaseURL() + "LockdownFrame.do?url=" + encodeURIComponent(assignmentUrl);
		}else{
			url = getBaseURL() + assignmentUrl;
		}
	
		if (isAssignmentWindowClosed() ) {
			var accept;
			if( timed && !isPractice) {
				accept = confirm(msgMainScriptTimedAssignmentWarning);
			}
			else {
				accept = true;
			}
			if( accept ) {
				edu_window = openWindow(url, "assignment_window", "scrollbars,resizable,width=960, height=700");
			}
		} else {
			alert(msgMainScriptFinishOtherAssignmentFirst);
			focusWindow(edu_window);
		}
		clickCounter=0;
	}
}

function doStudentExternal(aid) {
	if (!firstClick("")) {
		return;
	}
	var url = getBaseURL()+"contentmanager/RubricList.do?actionID=preview&assignmentId=" + aid;
	openWindow(url, "external_window", "width=800,height=600,scrollbars=yes,resizable=yes");
	clickCounter=0;
}

function doInstructorExternal(id) {
	if (!firstClick("")) {
		return;
	}
	var url = getBaseURL()+"gradebook/External.do?asgnId="+id;
	openWindow(url, "external_window", "width=800,height=600,scrollbars=yes,resizable=yes");
	clickCounter=0;
}

function doRubricGrade(trId) {
	if (extmodified) {
		alert(AddExternalFormSaveBeforeGradingMsg);
		return;
	}
  	var url = getBaseURL()+ "contentmanager/RubricList.do?";
  	url += "actionID=grade";
  	url += "&trId=" + trId;
  	openWindow(url, "rubricView", "width=800,height=600,scrollbars=yes,resizable=yes");
}

function showAssignmentPolicies(id,tn) {
	var url = getBaseURL()+"modules/test.ShowPolicies?className=" + className + "&testName=" + encodeURIComponent(tn) + "&testId=" + id;
	openWindow(url, "show_policies_window","width=400,height=300,scrollbars,resizable");
}

function isInLockdown(){
	try {
		if( $('#lockdownFrame').length > 0 || $('#lockdownFrame', window.parent.document.body).length > 0 ){
			return true;
		}else{
			return false;
		}
	} catch (e) {
		return false;
	}
}

function ensureLockdown( assignmentUrl ){
	var violation = false;
	
	if( top == self ){
		// Not in an iframe
		violation = true;
	}else if( top.location.href.indexOf('LockdownFrame') == -1 ){
		violation = true;
	}
	
	if ( violation ){
		
		var url = getBaseURL() + "LockdownFrame.do?url=" + encodeURIComponent(assignmentUrl);
		
		window.location = url;
	}
}

function openAjaxWindow(url){
	var popupUrl = getBaseURL() + "modules/preview.Preview";

	previewModal(popupUrl, function(){
		$.get(url, function(data){
			
			$('.modal-body').html(data);
		});
	});
}

/*
 * Opens a new window and sets the focus on the window Use this function instead
 * of window.open(...).focus() to avoid problems with the Lockdown browser
 */
function openWindow(url, name, features)
{
	if( !isInLockdown() ){
		var win = window.open( url, name, features );
		
		if( win != null ){
			win.focus();
		}
	
	
		return win;
	}else{
		openAjaxWindow(url);
	}
}

/*
 * Focuses the given window if it is not null; otherwise, does nothing.
 */
function focusWindow(win)
{
	if( win != null)
	{
		win.focus();
	}
}

/*
 * Closes the current window. Use this instead of window.close() to avoid
 * problems with the Lockdown browser
 */
function closeWindow()
{

	window.close();

}

//Set the size of the #holder div to handle the sperate scrolling
function setHolderSize()
{
	if (typeof wsQuestionEngine != 'undefined' && wsQuestionEngine == true) {
		return;
	}

	var width = $(document).width();

	$('#title').show();
	$('#logo').show();
	$('.crumbTrail').show();	
	
	if( width < 780 )
	{
		$('#title').hide();
		$('.crumbTrail').hide();
	}

	if( width < 390 )
	{
		$('#logo').hide();
	}           

}

function resetSelectDialog(){
	var currentValue = readCookie("useMathEditor");

	if( currentValue == "true")
	{
		$('#symbol').attr("checked", true);
	}else{
		$('#text').attr("checked", true);
	}

}

function displayPopupDialog(title, url,width,height){
	$('#pageDialog').load(url, function(){	
		try{
		$('#pageDialog').dialog("destroy");
		}catch(ex){}
		
		$('#pageDialog').dialog(  { 
			"title": title,
			"resizable": false,
			"width": width,
			"height": height,
			"open": function(){
				setAppletsEnabled($(this).closest(".ui-dialog")[0], false);	
			},
			"beforeclose": function(){
				setAppletsEnabled($(this).closest(".ui-dialog")[0]);
			},
			"beforeClose": function(){
				setAppletsEnabled($(this).closest(".ui-dialog")[0]);
			},
			"buttons": {"Ok": function() {


				$(this).dialog("close");


			}}
		});


	});

}

function loadMathSelect()
{
	var currentValue = readCookie('useMathEditor');
	
	if(currentValue !='true' )
	{
		document.cookie="useMathEditor=true; path="+getBaseContext() + "/";
	}else{
		document.cookie="useMathEditor=false; path="+getBaseContext() + "/";
	}

	// Reload the window to get the new editor
	doAction("refresh");
	
	return false;

}

function stopRightClick(){
	// Stop the right click menu from appearing
	document.oncontextmenu = function(){
		return false;
	};
}

function labelDiv(div){
	
	if( !$(div).hasClass('labelled')){
	var numberPattern = /\d+/g;
	
	var labels = $('.centered', div);
	
	for (var i = 0; i < labels.length; i++) {
		  var curLabel = labels[i];
		  
		  if( curLabel != null  ){
	  		  
			  var width = $(curLabel).width();
			  
			  var oldLeft = parseInt( $(curLabel).css('left').match(numberPattern)[0] );
			  var newLeft = oldLeft - width/2;
			  
			  $(curLabel).css('left', newLeft);
		  }
	}
		$(div).addClass('labelled');
	}
	
}

function displayLabelledDivs(){
	var labels = $('.labelledImage');
	
	for (var i = 0; i < labels.length; i++) {
		  var curLabel = labels[i];
		  
		  labelDiv(curLabel);
		  
	}
}

function showAllDynamicAttempts(id) { 
	var toggle = document.getElementById('toggle_attempts_'+id);
	var c=0;
	var att=document.getElementById('attempts'+id+'_'+c);
	while( att ) {
		att.style.display = toggle.checked ? 'block' : 'none';
		c++;
		att=document.getElementById('attempts'+id+'_'+c);
	}
}

function MGH_resize2() {
	if (typeof MathJax != 'undefined' && typeof MathJax.isReady != 'undefined' && MathJax.isReady && MathJax.Hub.queue.queue.length == 0) {
		wsExpanded = false;
		window.setTimeout("MGH_resize();", 1000);
//		MathJax.Hub.queue.Push("MGH_resize");
	} else {
		window.setTimeout("MGH_resize2();", 1000);
	}
}

function MGH_resize() {
	if (wsExpanded || typeof parent.wsQuestionEngine != 'undefined' || document.forms.length < 1) {
		return;
	}

	var newWidth = document.forms[0].scrollWidth + 50;
	var newHeight = document.forms[0].scrollHeight + 200;
	
	newWidth = (newWidth > 900 ? newWidth : 900);
	newHeight = (newHeight > 900 ? newHeight : 900);

	EZ.resize(newWidth, newHeight);
	wsExpanded = true;
	
	$('#holder').css('width', '100%');
	$('#holder').css('height', '100%');
	
}

/*disable or hide applets when a modal is open, and enable or show them when the modal is closed*/
function setAppletsEnabled(dialog, enabled){
	var $applets = $('applet');
	if($applets.length == 0 ) return;	
	enabled = typeof enabled === 'undefined' ? true : enabled;
	
	showAppletOverIframe(dialog, !enabled);
	for(var i=0; i<$applets.length; i++){
		if(typeof $applets[i].setEnabled === 'function'){
			$applets[i].setEnabled(enabled);
		}else{
			$($applets[i]).css('visibility', enabled ? 'visible' : 'hidden');
		}
	}	
}

function showAppletOverIframe(elem, state){           
    var IfrRef = document.getElementById('DivShim');
    if(IfrRef == null){
    	var divShim = document.createElement('iframe');
    	$(divShim).attr({'id': 'DivShim', 'src': 'javascript:false;', 'scrolling': 'no', 'frameborder':'0'});
    	$(divShim).css({'position':'absolute', 'display':'none'});
    	document.body.appendChild(divShim);
    	IfrRef = divShim;
    }
    if(state){
     IfrRef.style.width = elem.offsetWidth + "px";
     IfrRef.style.height = elem.offsetHeight + "px";
     IfrRef.style.top = elem.style.top ;
     IfrRef.style.left = elem.style.left;
     IfrRef.style.zIndex = 100;
     IfrRef.style.display = "block";
    }else{
     IfrRef.style.display = "none";
    }
}

function createLockdownIframe(src){
	$('#frameContainer iframe').remove();
	$('#frameContainer').append('<iframe width="100%" height="100%" name="asgnFrame" allowfullscreen="true" src="' + src + '"></iframe>')
}
function reportTaskSwitch(){
	// The user switched appliations, let the instructor know
	cancelFullscreen();

	$('#taskSwitched').show();
	$('#taskSwitched').removeClass('hidden');
	$('#goFullscreen').show();

	if( asgnFrame != null ){
		asgnFrame.doAction('reporttaskswitch');
	}
	
	$('#goFullscreen').html('Resume Fullscreen and enter authorization');
	
	setTimeout(function(){
	
		createLockdownIframe(lockdownUrl);
		
	}, 1000);
}

function launchFullscreen() {

	var element = $('#frameContainer')[0];
	
	var success = true;

  if(element.requestFullScreen) {
    element.requestFullScreen();
  } else if(element.mozRequestFullScreen) {
    element.mozRequestFullScreen();
  } else if(element.webkitRequestFullScreen) {
    element.webkitRequestFullScreen();
  }else{
	  // Browser doesn't support fullscreen
	  success = false;
  }
	
  if( success ){
	  createLockdownIframe(lockdownUrl);
		$('#lockdownControls').hide();
		$('.goFullscreen').hide();
		$('#taskSwitched').hide();
		
  }

 	  
}


function cancelFullscreen() {
	  if(document.cancelFullScreen) {
	    document.cancelFullScreen();
	  } else if(document.mozCancelFullScreen) {
	    document.mozCancelFullScreen();
	  } else if(document.webkitCancelFullScreen) {
	    document.webkitCancelFullScreen();
	  }
}


var BrowserDetect = {
		init: function () {
			this.browser = this.searchString(this.dataBrowser) || "An unknown browser";
			this.version = this.searchVersion(navigator.userAgent)
				|| this.searchVersion(navigator.appVersion)
				|| "an unknown version";
			this.OS = this.searchString(this.dataOS) || "an unknown OS";
		},
		searchString: function (data) {
			for (var i=0;i<data.length;i++)	{
				var dataString = data[i].string;
				var dataProp = data[i].prop;
				this.versionSearchString = data[i].versionSearch || data[i].identity;
				if (dataString) {
					if (dataString.indexOf(data[i].subString) != -1)
						return data[i].identity;
				}
				else if (dataProp)
					return data[i].identity;
			}
		},
		searchVersion: function (dataString) {
			var index = dataString.indexOf(this.versionSearchString);
			if (index == -1) return;
			return parseFloat(dataString.substring(index+this.versionSearchString.length+1));
		},
		dataBrowser: [
			{
				string: navigator.userAgent,
				subString: "Chrome",
				identity: "Chrome"
			},
			{ 	string: navigator.userAgent,
				subString: "OmniWeb",
				versionSearch: "OmniWeb/",
				identity: "OmniWeb"
			},
			{
				string: navigator.vendor,
				subString: "Apple",
				identity: "Safari",
				versionSearch: "Version"
			},
			{
				prop: window.opera,
				identity: "Opera",
				versionSearch: "Version"
			},
			{
				string: navigator.vendor,
				subString: "iCab",
				identity: "iCab"
			},
			{
				string: navigator.vendor,
				subString: "KDE",
				identity: "Konqueror"
			},
			{
				string: navigator.userAgent,
				subString: "Firefox",
				identity: "Firefox"
			},
			{
				string: navigator.vendor,
				subString: "Camino",
				identity: "Camino"
			},
			{		// for newer Netscapes (6+)
				string: navigator.userAgent,
				subString: "Netscape",
				identity: "Netscape"
			},
			{
				string: navigator.userAgent,
				subString: "MSIE",
				identity: "Explorer",
				versionSearch: "MSIE"
			},
			{
				string: navigator.userAgent,
				subString: "Gecko",
				identity: "Mozilla",
				versionSearch: "rv"
			},
			{ 		// for older Netscapes (4-)
				string: navigator.userAgent,
				subString: "Mozilla",
				identity: "Netscape",
				versionSearch: "Mozilla"
			}
		],
		dataOS : [
			{
				string: navigator.platform,
				subString: "Win",
				identity: "Windows"
			},
			{
				string: navigator.platform,
				subString: "Mac",
				identity: "Mac"
			},
			{
				   string: navigator.userAgent,
				   subString: "iPhone",
				   identity: "iPhone/iPod"
		    },
			{
				string: navigator.platform,
				subString: "Linux",
				identity: "Linux"
			}
		]

	};

function ckeditorHasFocus(){
	var hasFocus = _.find( CKEDITOR.instances, function(curEditor){
		return curEditor.focusManager.hasFocus;
		
	});

	return hasFocus !== undefined;
	
}
function showLockdownControls(){
	window.onblur = function(){

		setTimeout(function(){
		// Check if the current element is a CKeditor, this also fires the blur event
		if( !inDialog  && ckeditorHasFocus() != true && document.activeElement.tagName != 'IFRAME'){
			parent.reportTaskSwitch();	
		}}, 500); 
	}
}

function initLockdown(){

	if( BrowserDetect.browser != "Chrome" && BrowserDetect.browser != "Firefox" ){
		$('#notSupported').removeClass('hidden');
		$('#notSupported').show();
		$('#lockdownControls').hide();
		$('.startLockdown').hide();
		
		$('#closeWindow').click(function(){
			window.close();
		});
	
	}else{

		lockdownUrl = getBaseURL() + decodeURIComponent(QueryString.url);
		
		$('iframe').attr('src', lockdownUrl);
		$('iframe').attr('height', $(window).height() );
	
		$('#taskSwitched').hide();
		
		$('.startLockdown').click(function(){
			launchFullscreen();
			return false;
		});
	}
}

function showConfirm(message){
	inDialog = true;
	
	var result = confirm(message);
	
	inDialog = false;
	
	return result;
}

function readEquationEditor(curEditor){
	var editorDiv = $('.mathEditor', curEditor);
	var valueField = $('.mathEditorValue', curEditor);

	var mc = MapleCloud.getMathContainerForId( $(editorDiv).attr('id') );
	if( mc != null ){
		var mathml = mc.getMathML( false );
		    
		$(valueField).val(mathml);
	}
}

function readEquationEditors(){
	var editors = $('.mathEditorArea');
	
	_.each(editors, readEquationEditor );
}

function initializeEditor( curEditor ){

	var editorDiv = $('.mathEditor', curEditor);
	
	//Check if this editor has already been initialized. If yes - do nothing.
	
//	if (MapleCloud.getMathContainerForId($(editorDiv).attr('id')) != null) {
//		return;
//	}
	
	var toolbar= $(curEditor).data('toolbar');
	var xtoolbar= $(curEditor).data('xtoolbar');
	
	if ((toolbar == null || toolbar == '') && (xtoolbar == null || xtoolbar == '')) {
		toolbar="EqeDefaultToolbar.xml";
	}
	
	var value = decodeURIComponent( $('.mathEditorValue', curEditor).val() );

	var editorParams = { installLocation : $(editorDiv).attr('id'),
			 width : 500,
			 height : 200,
			 dollarIdentifier: true
		   };
	

	if (toolbar != null && toolbar != '') {
		editorParams.toolbarXMLLocation = getBaseURL() + "modules/eqeToolbars/" + toolbar; 
	} else {
		editorParams.toolbarXMLString = xtoolbar;
	}

	MapleCloud.installMathEditor( editorParams );
	var mc = MapleCloud.getMathContainerForId( $(editorDiv).attr('id') );
  	if( mc != null ){
  		mc.updateMathModel(value);
  	}
}

function mapleCloudOnLoad() {
	createEditors();

	var editors = $('.mathEditorArea');
	
	_.each(editors, initializeEditor);
	
	if( typeof(startJavascriptEditors) === "function" ){
		startJavascriptEditors();
	}
}

function createEditor(curEditor){

	var textArea = $('textarea', curEditor)[0];
	
	//Check if this editor has already been initialized. If yes - do nothing.
	
	if (CKEDITOR.instances[$(textArea).attr('name')] != null) {
		return;
	}
	
	var toolbar= $(curEditor).data('toolbar');
	var width = $(curEditor).data('width');
	if( width == null ){
		width = 680;
	}
	
	var height = $(curEditor).data('height');
	if( height == null ){
		height = 400;
	}
	
	CKEDITOR.on('instanceReady', function(ev) {
	    var editor = ev.editor;
	    
	    if(typeof(editor) !== 'undefined') {
	    	var html = editor.document.$.getElementsByTagName('html')[0];
	    	$(html).on("contextmenu",function(){
	            return false;   // suppress browsers default right click menu
	    	});
	    }
	});	
	
	CKEDITOR.replace(textArea, {
		toolbar : toolbar,
		language : theLocale,
		width : width,
		height : height

	});	
}

function createEditors(){
	var editors = $('.editorArea');
	
	_.each(editors, createEditor);
}

function readEditor(curEditor){
	
	var textArea = $('textarea', curEditor)[0];
	
	var oEditor = CKEDITOR.instances[$(textArea).attr('name')];
	
	if( oEditor != null ){
		var inner = oEditor.getData();
	
		var cleaned = CKTwoDeeEditorPlugin
				.removeMathJax(inner);
	
		$('input[type="hidden"]', curEditor).val(cleaned);
		$('textarea', curEditor).val(cleaned);
	}
	
}

function readEditors(){
	var editors = $('.editorArea');
	
	_.each(editors, readEditor);
}

function typeSetEditor(curEditor){
	
	var textArea = $('textarea', curEditor)[0];
	
	var oEditor = CKEDITOR.instances[$(textArea).attr('name')];
	
	CKTwoDeeEditorPlugin.typesetEditor(oEditor, function(){
	});
}

function typeSetEditors(){
	var editors = $('.editorArea');
	
	_.each(editors, typeSetEditor);
}

function showInputHelp(){
	var name = $(this).attr('name');

	$( '.helpLink').hide();
	$( '.helpLink[data-input="' + name + '"]').show();
	
	return false;
}

$(document).keydown(function(e) {
    var nodeName = e.target.nodeName.toLowerCase();

    if (e.altKey && (e.which == 37 || e.which == 39)) {
        e.preventDefault();
    } else if (e.which == 8) {
        if (!((nodeName === 'input' && (e.target.type === 'text' || e.target.type === 'password')) || nodeName === 'textarea')) {
            e.preventDefault();
        }
    }
});


$(function(){
	BrowserDetect.init();
	
	if(  BrowserDetect.browser == "Explorer" && BrowserDetect.version <= 8  ){
		// In IE8 - show a warning
		var message = '<div class="alert alert-danger">' + msgIE8Warning + '</div>';
		
		$('#holder .container:first, #assignmentHolder .content, .hero-unit').before(message);
	}
	
	// Resolve name collision between jQuery UI and Twitter Bootstrap
	$.widget.bridge('uitooltip', $.ui.tooltip);
	
	// Disable enforceFocus for boostrap modals. Allows typing in equation editor.
	$.fn.modal.Constructor.prototype.enforceFocus = function () {};
	
	$("#pageMessage").appendTo("#top");

	if (typeof wsQuestionEngine != 'undefined' && wsQuestionEngine == true) {
		window.setTimeout("MGH_resize2();", 1000);
	} else {
		setHolderSize();
		$(window).bind('resize', function(){ setHolderSize(); } );   
	}

	$('.changeMathMode').click(loadMathSelect);

	displayLabelledDivs();
	
	// Force the body margin to override Blackboard CSS
	$('body').css('margin', 0);
	
	$('.sectionName h3').click(function(){
		var parent = $(this).parents('.section');
		$(parent).toggleClass('collapsed');
	});
	
	var open = QueryString.open;
	
	if( open != null && open.length > 0 ){
		$('.section').addClass('collapsed');
		
		var parts = open.split(',');
		
		_.each(parts, function(curPart){
			$('#' + curPart).removeClass('collapsed');
		});
	}
	
	// Blocking Backspace
	if ( ( $('#assignmentButtons').length > 0 || $( '#instructionModuleMenu').length > 0 ) && history && history.pushState) {

	    var newPage = true;
		history.pushState(null, "Current Page");
		
		window.onpopstate = function(event) {
			var isChrome = /Chrome/.test(navigator.userAgent) && /Google Inc/.test(navigator.vendor);
			var isSafari = /Safari/.test(navigator.userAgent) && /Apple Computer/.test(navigator.vendor);
			var doBack = ((!newPage || (!isChrome && !isSafari)) && document.getElementById('MenuItem.actions.assignment.back') != null);

			if (doBack) {
				disableme('MenuItem.actions.assignment.back');
				doAction('back');
			} else {
				history.pushState(null, "Current Page");
				newPage = false;
			}
		};
	}

	$('.helpLink, .visibleLink').click(function(){
		var url = $(this).prop('href');
		var name = $(this).data('input');
		previewModal(url, function() {
			if ($('[name="' + name + '"]').length > 0) {
				$('#myModal').on('hidden', function () {
					$('[name="' + name + '"]')[0].focus();
				});
			}
		});
		return false;
	});
	
	$('.questionstyle input').focus(showInputHelp);
	$('.questionstyle input').change(showInputHelp);
	
	
	if( typeof openuw == 'undefined' || openuw != true ){
		$('.groupLink').click(function(){
			$(this).siblings().slideToggle();
			return false;
		});
	}
	
	if($('#search').length > 0){
		$('#search')[0].onsubmit = function(){
		if(this.elements[0].value.trim() == ''){
		    return false;			    
		}
		return true;	    
   };

}

});


