
<%@ page import="com.maplesoft.mapleta.configuration.MapleTASystemConfiguration"%>
<%@ page import="com.maplesoft.mapleta.persistence.service.systemproperty.SystemConstants"%>


<%@ taglib uri="http://www.rabago.net/tags-valid2" prefix="html2"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>

<c:set var="readOnlyFieldMap"
	value="<%=request.getAttribute(com.maplesoft.mapleta.useradmin.Constants.REQUEST_KEY_PASSWORDUPDATE_RETURNURL)%>" />
<c:set var="LDAPEnabled"
	value='<%=MapleTASystemConfiguration.getProperty(SystemConstants.KEY_LDAP_ENABLED)%>' />

<tiles:useAttribute name="formAction" />
<tiles:useAttribute name="cancelAction" />

<fmt:bundle
	basename="com.maplesoft.mapleta.application.ApplicationResources">



	<script>
		function editCn() {
			var cn = document.getElementById("cn");
			var givenName = document.getElementById("UserEditForm.givenName");
			var sn = document.getElementById("sn");
			cn.value = givenName.value + " " + sn.value;
		}
		
		function confirmPassword() {
			var pass = document.getElementById("UserEditForm.userPassword");
			var confirm = document.getElementById("UserEditForm.userPasswordConfirm");

			if( pass.value == confirm.value ) {
				return validateUserEditForm(document.getElementById('UserEditForm'));
			}
			var err = document.getElementById("UserEditForm.userPasswordConfirm.error");
			err.innerHTML = document.getElementById("confirmError").value;
			err.style.display = "inline";
			return false;
		}
		
		function updatePrivilege(element, privilegeName) {
			var privilegeElement = document.getElementById(privilegeName);
			privilegeElement.value = ((element.checked) ? "on" : "off");
		}
	</script>

	<c:choose>
		<c:when test='${userEditReadOnlyProperties["userPassword"] == null}'>
			<c:set var="validatorForm" value="UserAddForm" />
		</c:when>
		<c:otherwise>
			<c:set var="validatorForm" value="SimpleUserEditForm" />
		</c:otherwise>
	</c:choose>

	<html2:form method="post" action="${formAction}"
		validatorForm="${validatorForm}" styleClass="form-horizontal">


		<html2:hidden property="referer" />

		<html2:hidden property="id" />
		<html2:hidden property="readOnlyFields" />

		<div class="row section">
			<div class="span3 sectionName">
				<h3>
					<fmt:message key="UserEditForm.systemrole.label" />
				</h3>

			</div>

			<div class="span9 sectionMain">

				<%-- Only an administrator can change the role of an existing user.  Other users only his/her role and can't change it. --%>
				<c:choose>
					<c:when test="${roles != null }">
						<%-- if the bean has no selected role, use the default--%>
						<c:if test="${empty UserEditForm.role}">
							<c:set target="${UserEditForm}" property="role"
								value="${default_role}" />
						</c:if>
						<logic:iterate id="row" name="roles">
							<label class="radio inline"> <html2:radio property="role"
									value="value" idName="row"
									onblur="setPrivilegesByRoleName(this)"
									onclick="setPrivilegesByRoleName(this)"
									onchange="setPrivilegesByRoleName(this)" /> <bean:write
									name="row" property="label" />
							</label>
						</logic:iterate>
					</c:when>
					<c:otherwise>
						<html2:field property="role">
							<div class="control-group">
								<label class="control-label"> <html2:label />
								</label>
								<div class="controls">
									<label class="control-label" style="float: left; width: auto;">
										<fmt:bundle
											basename="com.maplesoft.mapleta.application.ApplicationResources">
											<fmt:message key="Role.${UserEditForm.role}" var="user_role" />
										</fmt:bundle> <c:out value="${user_role}" />
									</label>
								</div>
							</div>
						</html2:field>
					</c:otherwise>
				</c:choose>
			</div>
		</div>

		<div class="row section">
			<div class="span3 sectionName">
				<h3>
					<fmt:message key="UserEditForm.privileges.label" />
				</h3>

			</div>

			<div class="span9 sectionMain">
				<div class="control-group">
					<label class="control-label"> <html2:label
							key="UserEditForm.userprivileges.label" />
					</label>
					<div class="controls">
						<label class="checkbox inline"> <html2:hidden
								styleId="insertuser" property="insertuser" /> <input
							type="checkbox" name="insertuserCheckbox"
							${UserEditForm.insertuser ? "checked='checked'
									" : ""}
							value='${(UserEditForm.insertuser) ? "on" : "off"}'
							${(userEditReadOnlyPrivileges["insertuser"] !=null)
									? "disabled='true'
									" : ""}
							onBlur="updatePrivilege(this, 'insertuser');" /> <html2:label
								key="UserEditForm.insertuser.label" />
						</label> <label class="checkbox inline"> <html2:hidden
								styleId="modifyuser" property="modifyuser" /> <input
							type="checkbox" name="modifyuserCheckbox"
							${UserEditForm.modifyuser ? "checked='checked'
									" : ""}
							value='${(UserEditForm.modifyuser) ? "on" : "off"}'
							${(userEditReadOnlyPrivileges["modifyuser"] !=null)
									? "disabled='true'
									" : ""}
							onBlur="updatePrivilege(this, 'modifyuser');" /> <html2:label
								key="UserEditForm.modifyuser.label" />
						</label> <label class="checkbox inline"> <html2:hidden
								styleId="deleteuser" property="deleteuser" /> <input
							type="checkbox" name="deleteuserCheckbox"
							${UserEditForm.deleteuser ? "checked='checked'
									" : ""}
							value='${(UserEditForm.deleteuser) ? "on" : "off"}'
							${(userEditReadOnlyPrivileges["deleteuser"] !=null)
									? "disabled='true'
									" : ""}
							onBlur="updatePrivilege(this, 'deleteuser');" /> <html2:label
								key="UserEditForm.deleteuser.label" />
						</label> <label class="checkbox inline"> <html2:hidden
								styleId="viewuser" property="viewuser" /> <input
							type="checkbox" name="viewuserCheckbox"
							${UserEditForm.viewuser ? "checked='checked'
									" : ""}
							value='${(UserEditForm.viewuser) ? "on" : "off"}'
							${(userEditReadOnlyPrivileges["viewuser"] !=null)
									? "disabled='true'
									" : ""}
							onBlur="updatePrivilege(this, 'viewuser');" /> <html2:label
								key="UserEditForm.viewuser.label" />
						</label>
					</div>
				</div>
				<div class="control-group">
					<label class="control-label"> <html2:label
							key="UserEditForm.classprivileges.label" />
					</label>
					<div class="controls">
						<html2:hidden styleId="insertclass" property="insertclass" />
						<label class="checkbox inline"> <input type="checkbox"
							name="insertclassCheckbox"
							${UserEditForm.insertclass ? "checked='checked'
									" : ""}
							value='${(UserEditForm.insertclass) ? "on" : "off"}'
							${(userEditReadOnlyPrivileges["insertclass"] !=null)
									? "disabled='true'
									" : ""}
							onBlur="updatePrivilege(this, 'insertclass');" /> <html2:label
								key="UserEditForm.insertclass.label" />
						</label> <label class="checkbox inline"> <html2:hidden
								styleId="modifyclass" property="modifyclass" /> <input
							type="checkbox" name="modifyclassCheckbox"
							${UserEditForm.modifyclass ? "checked='checked'
									" : ""}
							value='${(UserEditForm.modifyclass) ? "on" : "off"}'
							${(userEditReadOnlyPrivileges["modifyclass"] !=null)
									? "disabled='true'
									" : ""}
							onBlur="updatePrivilege(this, 'modifyclass');" /> <html2:label
								key="UserEditForm.modifyclass.label" />
						</label> <label class="checkbox inline"> <html2:hidden
								styleId="deleteclass" property="deleteclass" /> <input
							type="checkbox" name="deleteclassCheckbox"
							${UserEditForm.deleteclass ? "checked='checked'
									" : ""}
							value='${(UserEditForm.deleteclass) ? "on" : "off"}'
							${(userEditReadOnlyPrivileges["deleteclass"] !=null)
									? "disabled='true'
									" : ""}
							onBlur="updatePrivilege(this, 'deleteclass');" /> <html2:label
								key="UserEditForm.deleteclass.label" />
						</label> <label class="checkbox inline"> <html2:hidden
								styleId="viewclass" property="viewclass" /> <input
							type="checkbox" name="viewclassCheckbox"
							${UserEditForm.viewclass ? "checked='checked'
									" : ""}
							value='${(UserEditForm.viewclass) ? "on" : "off"}'
							${(userEditReadOnlyPrivileges["viewclass"] !=null)
									? "disabled='true'
									" : ""}
							onBlur="updatePrivilege(this, 'viewclass');" /> <html2:label
								key="UserEditForm.viewclass.label" />
						</label>
					</div>
				</div>
			</div>
		</div>

		<div class="row section">
			<div class="span3 sectionName">
				<h3>
					<fmt:message key="UserEditForm.account_settings.label" />
				</h3>

			</div>

			<div class="span9 sectionMain">

				<logic:messagesPresent message="true">
					<p>
						<span class="errorStyle1"> <html:messages id="msg"
								message="true">
								<c:out value="${msg}" />
							</html:messages>
						</span>
					</p>
				</logic:messagesPresent>

				<html2:field property="givenName">
					<div class="control-group">
						<label class="control-label" for="givenName"> <html2:label />
						</label>
						<div class="controls">
							<html2:text size="32" property="givenName" disabled="true"/>
							<html2:error styleClass="errorStyle1" />
						</div>
					</div>
				</html2:field>
				<html2:field property="sn">
					<div class="control-group">
						<label class="control-label" for="sn"> <html2:label />
						</label>
						<div class="controls">
							<html2:text size="32" styleId="sn" disabled="true"/>
							<html2:error styleClass="errorStyle1" />
						</div>
					</div>
				</html2:field>
				<html2:field property="cn">
					<div class="control-group">
						<label class="control-label" for="cn"> <html2:label /></label>
						<div class="controls">
							<html2:text size="32" styleId="cn" disabled="true"/>
							<html2:error styleClass="errorStyle1" />
						</div>
					</div>
				</html2:field>
				<html2:field property="studentID">
					<div class="control-group">
						<label class="control-label" for="studentID"> <html2:label /></label>
						<div class="controls">
							<html2:text size="32" styleId="studentID" disabled="true"/>
							<html2:error styleClass="errorStyle1" />

						</div>
					</div>
				</html2:field>
				<html2:field property="email">
					<div class="control-group">
						<label class="control-label" for="email"> <html2:label /></label>
						<div class="controls">
							<html2:text size="32" disabled="true"/>
							<html2:error styleClass="errorStyle1" />

						</div>
					</div>
				</html2:field>

				<html2:field property="uid">
					<div class="control-group">
						<label class="control-label" for="uid"> <html2:label />
						</label>
						<div class="controls">
							<html2:hidden property="uid" />
							<input type="text" disabled="disabled" value="${uidValue}"
								size="32" />
						</div>
					</div>
				</html2:field>


			</div>
		</div>

				<div class="form-actions">
					<html2:submit styleClass="btn btn-primary">
						<fmt:message key="JspDefault.Submit.Button" />
					</html2:submit>
					<input type="button" class="btn btn-danger"
						value='<fmt:message key="JspDefault.Cancel.Button"/>'
						onclick="javascript:document.location.href='<%=request.getContextPath()%>${cancelAction}?uid=${UserEditForm.uid}';"></input>
				</div>
				

	</html2:form>
	<html2:html2Javascript xmlHttpRequest="false" />
</fmt:bundle>
