<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"
	language="java"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://displaytag.sf.net" prefix="display"%>

<tiles:useAttribute name="currentUser" ignore="false" />
<tiles:useAttribute name="activeUsers" ignore="false" />
<tiles:useAttribute name="requestURI" ignore="true" />
<tiles:useAttribute name="allowLogoff" ignore="true" />

<fmt:bundle
	basename="com.maplesoft.mapleta.application.ApplicationResources">

	<c:choose>
		<c:when test='${ fn:length(activeUsers) <= 0 }'>
			<br>
			<br>
			<fmt:message key="ActiveUsers.nousers.label" />
		</c:when>
		<c:otherwise>
			<form method="post" action="systemadmin/LogoutUser.do"
					name="ActiveUserForm" class="form-horizontal">
			<display:table id="row" name="${activeUsers}" defaultsort="6"
				requestURI="${requestURI}" pagesize="25" class="gradientTable"
				sort="list">

				<%@ include file="/WEB-INF/jsp/displaytag_defaultProperties.jsp"%>

				<display:setProperty name="paging.banner.placement" value="bottom" />
				<c:if test="${allowLogoff == 'true' &&  sessionScope.context.currentRole.editActiveUsers}">
					<display:column>
						<c:choose>
							<c:when test="${currentUser.id == row.id}">
								<input type="checkbox" name="ids" value="${row.id}"
									disabled="disabled" />
							</c:when>
							<c:otherwise>
								<input type="checkbox" name="ids" value="${row.id}" />
							</c:otherwise>
						</c:choose>
					</display:column>
				</c:if>
				<display:column titleKey="ActiveUsers.uid.msg" sortable="true">
					<c:choose>
						<c:when test="${ sessionScope.context.currentRole.viewUser }">
							<html:link action="useradmin/UserInfo.do?id=${row.id}" module="">${row.uid}</html:link>
						</c:when>
						<c:otherwise>
							${row.uid}
						</c:otherwise>
					</c:choose>
				</display:column>
				<display:column property="givenName" sortable="true"
					titleKey="ActiveUsers.firstname.msg" />
				<display:column property="sn" sortable="true"
					titleKey="ActiveUsers.lastname.msg" />
				<display:column property="role" sortable="true"
					titleKey="ActiveUsers.role.msg" />
				<display:column property="email" sortable="true"
					titleKey="ActiveUsers.email.msg" />
				<logic:empty name="row" property="lastLogin">
					<display:column sortable="true"
						titleKey="ActiveUsers.lastlogin.msg" />
				</logic:empty>
				<logic:notEmpty name="row" property="lastLogin">
					<display:column property="lastLogin" sortable="true"
						titleKey="ActiveUsers.lastlogin.msg"
						format="{0,date,short} {0,time,short}" />
				</logic:notEmpty>
				<c:if test="${allowLogoff == 'true' &&  sessionScope.context.currentRole.editActiveUsers}">
					<display:column>
						<c:choose>
							<c:when test="${currentUser.id == row.id}">
								<fmt:message key="ActiveUsers.logoff.label" />
							</c:when>
							<c:otherwise>
								<a
									href="<%= request.getContextPath() %>/systemadmin/LogoutUser.do?id=${row.id}"><fmt:message
										key="ActiveUsers.logoff.label" /></a>
							</c:otherwise>
						</c:choose>
					</display:column>
				</c:if>
			</display:table>
			<c:if test="${allowLogoff == 'true' &&  sessionScope.context.currentRole.editActiveUsers}">
				<div class="form-actions">
					<input type="submit"
						value="<fmt:message key='ActiveUsers.logoff.label' />"
						class="btn btn-primary" /> <input type="button"
						value="<fmt:message key='ActiveUsers.refresh.label'/>"
						onclick="location.replace('<%=request.getContextPath()%>/systemadmin/ActiveUsers.do');"
						class="btn" />
				</div>
				
			</c:if>
			</form>

		</c:otherwise>
	</c:choose>

</fmt:bundle>
