<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://www.rabago.net/tags-valid2" prefix="html2"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>

<%@ page import="com.maplesoft.mapleta.configuration.MapleTASystemConfiguration"%>


<tiles:useAttribute name="isLDAPEnabled" ignore="true"/>
<tiles:useAttribute name="allowSelfRegistration" ignore="true"/>
<tiles:useAttribute name="referrer" ignore="true"/>

<tiles:useAttribute name="startError" ignore="true"/>

<fmt:bundle	basename="com.maplesoft.mapleta.application.ApplicationResources">

<c:choose>
	<c:when test="${startError}">
		<span class="errorStyle1"><fmt:message key="ServerStart.error.msg"/></span>
	</c:when>
<c:otherwise>

<h1 id="loginWelcome">Welcome</h1>

<div class="<% if( !MapleTASystemConfiguration.isOPENUW() ){ %>hero-unit <% } %>row">

<% if( !MapleTASystemConfiguration.isOPENUW() ){ %>
	<div class="span6">
		<h1>
			<% out.println( MapleTASystemConfiguration.getSCHOOL_NAME()); %>
		</h1>
	</div>
	<% }else{ // OPENUW %>
		<div class="span8">
		<p>
		Welcome to the Centre for Education in Mathematics and Computing’s open resources. Resources on this site have been designed for both students and teachers and include lessons, interactive worksheets, and unlimited practise opportunities. Minimal system and software requirements are required to use the site 
		(<a href="http://de.uwaterloo.ca/comp_req.html" target="_blank">test your technical settings</a>) and, unlike many math resources that are presented in video format, the HTML nature of the lessons is compatible
		 with many assistive technologies. Best of all, the materials have been developed by University of Waterloo faculty and staff, are completely free to use, and do not require any registration to access. Begin learning from a world-class group of math teachers today!</p>
		
		<div class="text-center">
				<a href="#" class="btn btn-large  btn-success calltoaction"><small style="text-transform:uppercase;">I want to start</small><br><span style="font-size: 140%;">LEARNING</span></a>
		</div>
					
		
		</div>
	<% } %>
	<div class="span4">
	
	<html2:form action="/login" method="post" focus="login" validatorForm="LoginActionForm" styleClass="form-horizontal">
		<p id="loginMessage"><small>If you would like to keep track of your progress, please log in below or <a href="#">create an account</a>. You do not have to log in to access the content.</small></p>
		
		<html:hidden property="terminateOldSession"/>
		<input type="hidden" name="referrer" value="${referrer}"/>

		<logic:messagesPresent message="false">
			<p>
				<html:messages id="msg" message="false" property="userCreated">
					<span class="errorStyle1"><c:out value='${msg}' /></span><br/>
				</html:messages>
			</p>
		</logic:messagesPresent>
		<html2:field property="login">
			<div class="control-group">
				<span class="control-label">
					<fmt:message key="LoginActionForm.login.label"/>
				</span>
				<div class="controls">
					<html2:text styleClass="input-block-level"/><br/>
					<html2:error styleClass="errorStyle1" />
				</div>
			</div>
		</html2:field>
		<html2:field property="password">
			<div class="control-group">
				<span class="control-label">
					<fmt:message key="LoginActionForm.password.label"/>
				</span>
				<div class="controls">
					<html2:password styleClass="input-block-level"/><br/>
					<html2:error styleClass="errorStyle1" />
				</div>
			</div>
		</html2:field>
		<html2:submit styleClass="btn btn-primary btn-block" styleId="loginButton"><fmt:message key='LoginActionForm.button.submit.label' /></html2:submit>
		<logic:messagesPresent>
				<span class="errorStyle1">
					<html:messages id="msg" property="badLogin">
						<bean:write name="msg" />
					</html:messages>
				</span>		
		</logic:messagesPresent>
		
		<c:if test="${ not isLDAPEnabled }">		
			<c:if test="${ allowSelfRegistration }">
					
			<div class="control-group" id="registration">

					<a href="login/Register.do" class="btn btn-block">	      			
										<fmt:message key="LoginActionForm.register.label" />
					</a>
				
			</div>		
			</c:if>
				
			<div class="text-right">
				<a href="passwordreset/PasswordReset.do"><fmt:message key="LoginActionForm.passwordForgot.msg" /></a>
			</div>
		</c:if>	

			
	</html2:form>
		</div>
	</div>

	
	<html2:html2Javascript labelErrorStyleClass="errorStyle1" xmlHttpRequest="false" />
	

	<c:if test="${LoginActionForm.showConfirmation}">
		<script type="text/javascript">
			var msg = "<fmt:message key='LoginActionForm.sessionExists.error'/>";
			if (confirm(msg)) {
				LoginActionForm.terminateOldSession.value=true;
				LoginActionForm.submit();
			}
		</script>
	</c:if>

</c:otherwise>
</c:choose>


</fmt:bundle>


