<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"
	language="java"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://displaytag.sf.net" prefix="display"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>


<fmt:bundle
	basename="com.maplesoft.mapleta.application.ApplicationResources">

	<c:set var="uid">
		<fmt:message key="UserAdmin.uid.label" />
	</c:set>
	<c:set var="firstname">
		<fmt:message key="UserAdmin.firstname.label" />
	</c:set>
	<c:set var="lastname">
		<fmt:message key="UserAdmin.lastname.label" />
	</c:set>
	<c:set var="email">
		<fmt:message key="UserAdmin.email.label" />
	</c:set>
	<c:set var="studentID">
		<fmt:message key="UserAdmin.studentID.label" />
	</c:set>
	<c:set var="role">
		<fmt:message key="UserEditForm.roles.label" />
	</c:set>

</fmt:bundle>

<div class="row section">
	<div class="span3 sectionName">
		<h3>
			<fmt:message
				key="ClassManagerSearchForm.classmanager.user.search.panel.label" />
		</h3>
		<p>
			<fmt:message
				key="ClassManagerSearchForm.classmanager.user.search.panel.message" />
		</p>
	</div>

	<div class="span9 sectionMain">
		<tiles:insert definition=".classmanager.user.search" flush="false" />


		<html:messages id="msg" message="false">
			<span class="errorStyle1"><c:out value='${msg}' /> </span>
			<br>
		</html:messages>
	</div>
</div>

<logic:present name="users">



	<html:form action="/ListUsersInClass" method="post" styleId="userForm">

		<div class="expand">
				<h3>
					<fmt:message key="ClassManagerSearchForm.table.header.users.msg" />
				</h3>

			
				<c:choose>

					<c:when test="${fn:length(users) gt 0}">

						<html:hidden property="dispatch" />



						<display:table id="row" name="${users}" defaultsort="2"
							pagesize="${pageLimit}"
							requestURI="/classmanager/ListUsersInClass.do" sort="list"
							class="gradientTable" export="true">

							<%@ include file="/WEB-INF/jsp/displaytag_defaultProperties.jsp"%>

							<display:setProperty name="export.csv.filename"
								value="class_students.csv" />



							<display:setProperty name="paging.banner.placement"
								value="bottom" />



							<display:column title="${uid}" sortable="true" media="html">

								<c:choose>
									<c:when test="${sessionScope.context.currentRole.viewSystemSettings}">
															<html:link action="/UserInfo.do?id=${row.id}">${row.uid}</html:link>
									</c:when>
									<c:otherwise>${row.uid}</c:otherwise>
								</c:choose>
		
							</display:column>

							<display:column property="uid" title="${uid}" sortable="true"
								media="csv" />

							<display:column property="sn" sortable="true"
								sortProperty="lastNameSortKey" title="${lastname}" />

							<display:column property="givenName" sortable="true"
								sortProperty="givenNameSortKey" title="${firstname}" />

							<display:column property="email" sortable="true" title="${email}" />

							<display:column property="studentID" sortable="true"
								title="${studentID}" />

							<display:column property="role" sortable="true"
								sortProperty="roleSortKey" title="${role}" />

						</display:table>

					</c:when>

					<c:otherwise>

						<fmt:message key="classmanager.no_students.msg" />


					</c:otherwise>
				</c:choose>

	</html:form>
</logic:present>




