<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"
	language="java"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://displaytag.sf.net" prefix="display"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib prefix="mapleta" tagdir="/WEB-INF/tags" %>

<%@ page import="java.net.*"%>
<%@ page import="com.maplesoft.mapleta.gateway.GatewayService" %>

<%@ page import="com.maplesoft.mapleta.configuration.MapleTASystemConfiguration"%>


<%
	String encodedName = URLEncoder.encode(request.getAttribute("className").toString(),"UTF-8");
%>  

<c:set var="uid" value="${context.user.uid}"></c:set>

<fmt:bundle
	basename="com.maplesoft.mapleta.application.ApplicationResources">

	<tiles:useAttribute name="assignments" classname="java.util.List" scope="request" ignore="true" />
	<tiles:useAttribute name="externals" classname="java.util.List" scope="request" ignore="true"/>
	<tiles:useAttribute name="nodes"  scope="request" ignore="true"/>
	<tiles:useAttribute name="assignmentsNotInGroup"  scope="request" ignore="true" />
	<tiles:useAttribute name="activeGroupId"  scope="request" ignore="true" />
	
	<% if( !MapleTASystemConfiguration.isOPENUW() ){ %>
	<div class="section"><%-- Display assignments --%>
		<div class="sectionName">
			<h3>
				<fmt:message key="ClassHomepage.ClassHomepage.Assignments" />
			</h3>
		</div>
		<div class="sectionMain">
		  <c:choose>
 				<c:when test="${nodes != null}"><%-- Display assignments in tree view --%>
     				<div class="asgnTreeView">
     				   <ul>
     				      <mapleta:assignmentTreeView nodes="${nodes}" classname="<%=encodedName %>" />
     				      <c:if test="${assignmentsNotInGroup != null}">
     				         <c:forEach var="assignment" items="${assignmentsNotInGroup}">
     				            <li>
     				               <c:choose>
					                    <c:when test="${assignment.current eq 'true' }">
						                    <a class="asgnLink<c:if test="${assignment.active eq 'true' }"> active</c:if>" 
						                       onclick='javascript:doAssignment("${assignment.testId}","${assignment.qeName}",false,true,false ); return false;'
						                       href="modules/test.Test?className=${classname}&testName=${assignment.qeName}&testId=${assignment.testId}">
						                       <i class="icon-list-alt">&nbsp;</i>${assignment.name}
						                    </a>                    
					                    </c:when>
					                    <c:otherwise>
					                       <span class="asgnLink"><i class="icon-list-alt">&nbsp;</i>${assignment.name}</span>
					                    </c:otherwise>
					                 </c:choose>
     				            </li>
     				         </c:forEach>
     				      </c:if>
     				   </ul>
     				</div>    				
				</c:when>
        <c:otherwise> <%-- Display assignments in table view --%>   
					<display:table id="row" class="gradientTable assignmentList"
						name="${assignments}">
						<%@ include file="/WEB-INF/jsp/displaytag_defaultProperties.jsp"%>
						<display:setProperty name="paging.banner.placement" value="bottom" />
						<display:column titleKey="chp.assignment.msg" class="noBorder" headerClass="noBorder">
		
							<c:choose>
								<c:when test="${row.current eq 'true' }">
									<script type="text/javascript">
										${row.randomAssignmentVar} = "${row.qeName}";
										${row.randomAssignmentIdVar} = "${row.testId}";
									</script>
									<a href="modules/test.Test?className=<%=encodedName %>&testName=${row.qeName}&testId=${ row.testId }" 
										<c:if test="${row.active eq 'true' }">class="active"</c:if>
											onclick="javascript:doAssignment(${row.randomAssignmentIdVar},${row.randomAssignmentVar},${row.timed},${row.practice}, ${row.lockdown} ); return false">${row.name}</a>
								</c:when>
								<c:otherwise>
									${row.name}
								</c:otherwise>
							</c:choose>
						</display:column>
		
						<display:column title="">
							<c:choose>
								<c:when test="${row.showPolicies eq 'true'}">
									<script type="text/javascript">
										${row.randomPolicyVar} = "${row.qeName}";						
										${row.randomPolicyIdVar} = "${row.testId}";						
									</script>
									<a
										href="javascript:showAssignmentPolicies(${row.randomPolicyIdVar},${row.randomPolicyVar})"><fmt:message
											key="Assignmentlist.policies.label" /></a>
								</c:when>
								<c:otherwise>
								</c:otherwise>
							</c:choose>
						</display:column>
		
						<display:column titleKey="chp.assignment_availability.msg"
							property="availability" />
						<display:column titleKey="chp.assignment_attempts.msg"
							property="attempts" />
						<display:column titleKey="chp.assignment_best_score.msg">
						
							<c:choose>
								<c:when test="${row.haveRecords eq 'true' and row.active eq 'true' and row.numAttempts eq 1}">
									<c:set var="activeSelection" value="0"/>
								</c:when>
								<c:when test="${row.haveRecords eq 'true' and not row.fullyGraded}">
									<c:set var="activeSelection" value="2"/>
								</c:when>
								<c:otherwise>
									<c:set var="activeSelection" value="1"/>
								</c:otherwise>
							</c:choose>
						
							<c:choose>
								<c:when test="${row.haveRecords eq 'true' and context.student}">
									<a
										href="gradebook/Student.do?assignmentSelection=${row.assignmentId }&active=${activeSelection}&userList=1&classSelection=${row.classId }&uid=${uid}&showGivenName=true&showLastName=true&showAsgnTotalPoints=true">
										${row.bestScore } </a>
								</c:when>
								<c:when test="${row.haveRecords eq 'true' and not context.student}">
									<a
										href="gradebook/Class.do?assignmentSelection=${row.assignmentId }&active=${activeSelection}&userList=2&classSelection=${row.classId }&uid=${uid}&showGivenName=true&showLastName=true&showAsgnTotalPoints=true">
										${row.bestScore } </a>
								</c:when>
								<c:otherwise>
								${row.bestScore }
							</c:otherwise>
							</c:choose>
						</display:column>
					</display:table>
			  </c:otherwise><%--end of display assignments in table view --%>	
      </c:choose>
		</div>
	</div><%-- End of display assignments --%>

	<%-- All Rubrics --%>
	<c:if test="${not empty externals}">
	<div class="row section">
		<div class="span3 sectionName">
			<h3>
				<fmt:message key="AssignmentList.Rubrics.label" />
			</h3>
		</div>
			<div class="span9 sectionMain">

					<table class="gradientTable rubricList">
						<tr>
							<th><fmt:message key="chp.rubric.msg"/></th>
							<c:if test="${isStudent}">
									<th  class="centered"><fmt:message key="chp.assignment_attempts.msg"/></th>
							</c:if>
							<c:choose>
								<c:when test="${isStudent}">
									<th>
										<fmt:message key="chp.assignment_score.msg"/>
									</th>
								</c:when>
								<c:otherwise>
									<th class="centered">
										<fmt:message key="chp.assignment_points.msg"/>
									</th>
								</c:otherwise>
							</c:choose>
						</tr>
						<logic:iterate name="externals" id="erow" indexId="eindex">
							<tr>
								<td>
									<c:choose>
										<c:when test="${isStudent}">
											<A HREF="javascript:doStudentExternal(${erow.id})">${erow.name}</a>
										</c:when>
										<c:otherwise>
											<A HREF="<%=GatewayService.getServerURL()%>gradebook/External.do?asgnId=${erow.id}">${erow.name}</a>
										</c:otherwise>
									</c:choose>
								</td>
								
								<c:choose>
									<c:when test="${isStudent}">
										<td class="centered">
											<c:choose>
												<c:when test="${erow.score2 >= 0.0}">
													1 / 1
												</c:when>
												<c:otherwise>
													0 / 1
												</c:otherwise>
											</c:choose>
										</td>
									</c:when>
									<c:otherwise>
									</c:otherwise>
								</c:choose>
								
								<c:choose>
									<c:when test="${isStudent}">
										<td>
											<c:choose>
												<c:when test="${erow.score2 >= 0.0}">
													<fmt:formatNumber type="number" minFractionDigits="1" maxFractionDigits="1" value="${erow.score2}"/> 
													/ 
													<fmt:formatNumber type="number" minFractionDigits="1" maxFractionDigits="1" value="${erow.score1}"/> 
													(<fmt:formatNumber type="percent" minFractionDigits="1" maxFractionDigits="1" value="${erow.score2 / erow.score1}"/>) 
												</c:when>
												<c:otherwise>
													<fmt:message key="chp.assignment.not_attempted"/>
												</c:otherwise>
											</c:choose>
										</td>
									</c:when>
									<c:otherwise>
										<td class="centered">
											<fmt:formatNumber type="number" minFractionDigits="1" maxFractionDigits="1" value="${erow.score1}"/>
										</td>
									</c:otherwise>
								</c:choose>
							</tr>
						</logic:iterate> 
					</table>
		</div>
		
	</div>
	</c:if>
	
	<% }else{ // OPENUW %>
		<p>&nbsp;</p>
		<section class="container">
			<div class="row">

				<aside class="span4">
					<h3>Units</h3>
					<nav>
						<ul class="unstyled unitnav">
							<mapleta:assignmentTreeView nodes="${nodes}" classname="<%=encodedName %>" />
						</ul>
					</nav>
				</aside>

				<section class="span8" id="unitDisplay">
					<h3></h3>
					<div id="unitDescription"></div>
					
					<h4>Modules</h4>
					<div id="moduleList"></div>
				</section>
			</div>
		</section>
	<% } %>
	<c:if test="${activeGroupId != null}">
	  <script type="text/javascript">
	     $(function(){     				         
	          $('.groupLink#<%=activeGroupId%>').click();
	     }); 
	  </script>
    </c:if>
</fmt:bundle>
