<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"
	language="java"%>

<%@ page import="com.maplesoft.mapleta.configuration.MapleTASystemConfiguration"%>

<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://www.rabago.net/tags-valid2" prefix="html2"%>
<%@ taglib uri="http://displaytag.sf.net" prefix="display"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>

<tiles:useAttribute name="cancel_action" />
<tiles:useAttribute name="save_action" />

<fmt:bundle
	basename="com.maplesoft.mapleta.application.ApplicationResources">
	
	<html2:form action="${save_action}" method="post"
		validatorForm="ClassEdit" focus="courseId" styleClass="form-horizontal">
		
		<div class="row section">
			<div class="span3 sectionName">
				<h3>
					<fmt:message key="ClassAdmin.class.label" />
				</h3>
			</div>
			
			<div class="span9 sectionMain">

				<logic:messagesPresent message="false">
					<span class="errorStyle1"><fmt:message
							key="SaveClass.error.heading" /></span>
					<table>
						<tr>
							<td class="errorStyle1"><html:messages id="msg"
									message="false">
									<c:out value='${msg}' />
								</html:messages></td>
						</tr>
					</table>
				</logic:messagesPresent>
				<br />

				<html2:hidden property="mode" value="save" />
				<html2:hidden property="classId" />


			

					<html:hidden property="updateInstructor" />

					<c:if test="${InfoForm.updateInstructor}">

						<div class="control-group">
							<html2:field property="courseId">
								<label class="control-label"><fmt:message
										key="ClassAdmin.instructor.label" /> </label>
								<div class="controls">
									<input type="text" value="${userForm.givenName} ${userForm.sn}"
										readonly="readonly" size="35" />
									<c:if test='${InfoForm.editInstructor}'>
										<html:link action="/ChooseInstructor">
											<fmt:message key="ClassMgrEdit.changeinstructor.label" />
										</html:link>
									</c:if>
									<html2:error styleClass="errorStyle1" />
								</div>
							</html2:field>
						</div>
	
						<div class="control-group">
							<html2:field property="courseId">
								<label class="control-label"><fmt:message key="ClassAdmin.instructoremail.label" /></label>
								<div class="controls">
									<input type="text" value="${userForm.email}"
									readonly="readonly" size="35" />
								</div>
							</html2:field>
						</div>

				

						<html:hidden property="uid" value="${userForm.uid}" />

					</c:if>
							
				<div class="control-group">
					<html2:field property="courseId">
					<label class="control-label"><html2:label /> 
					</label>
					<div class="controls">
						<html2:text/>
						<html2:error styleClass="errorStyle1" />
					</div>
					</html2:field>
				</div>

				<div class="control-group">
					<html2:field property="className">
					<label class="control-label"><html2:label />
					</label>
					<div class="controls">
						<html2:text/>
						<html2:error styleClass="errorStyle1" />
					</div>
					</html2:field>
				</div>
				
				<div class="control-group">
					<html2:field property="classShortName">
					<label class="control-label"><html2:label />
					</label>
					<div class="controls">
						<html2:text/>
						<html2:error styleClass="errorStyle1" />
					</div>
					</html2:field>
				</div>
							
				<div class="control-group">
					<html2:field property="school">
					<label class="control-label">
					<% if( MapleTASystemConfiguration.isOPENUW() ){ %>
						Subheading
					<% }else{ %>
					<fmt:message
								key="ClassAdmin.school.label" />
					<% } %>
					</label>
					<div class="controls">
						<html2:text/>
						<html2:error styleClass="errorStyle1" />
					</div>
					</html2:field>
				</div>
				
				
				<div class="control-group">
					<html2:field property="registrationLocked">
					<label class="control-label"><html2:label />
					</label>
					<div class="controls">
						<html2:checkbox property="registrationLocked" />
						<html2:error styleClass="errorStyle1" />
					</div>
					</html2:field>
				</div>


				<% if( MapleTASystemConfiguration.isALLOW_ANONYMOUS_HOMEPAGE() ){ %>
				<div class="control-group">
					<html2:field property="anonymousAccess">
					<label class="control-label"><html2:label />
					</label>
					<div class="controls">
						<html2:checkbox property="anonymousAccess" />
						<html2:error styleClass="errorStyle1" />
					</div>
					</html2:field>
				</div>
				<% } else { %>
					<html:hidden property="anonymousAccess"/>
				<% } %>
				
				
								
				<% if( MapleTASystemConfiguration.isENABLE_ASSIGNMENT_REPOSITORY() ){ %>
				<div class="control-group">
					<html2:field property="assignmentDisplayMode">
					<label class="control-label"><fmt:message key="ClassAdmin.assignmentDisplayMode.label" /></label>
					<div class="controls">
						<label><html2:radio property="assignmentDisplayMode" value="0"/><fmt:message key="ClassAdmin.assignmentDisplayMode.table" /></label>
						<label><html2:radio property="assignmentDisplayMode" value="1"/><fmt:message key="ClassAdmin.assignmentDisplayMode.tree" /></label>
						<html2:error styleClass="errorStyle1" />
					</div>
					</html2:field>
				</div>
				<% } %>

					
					<c:if test='${empty InfoForm.parentDTO}'>
						<div class="control-group">
							<html2:field property="featured">
							<label class="control-label"><html2:label />
							</label>
							<div class="controls">
								<html2:checkbox property="featured" />
								<html2:error styleClass="errorStyle1" />
							</div>
							</html2:field>
						</div>
							
		
					</c:if>
					<c:if test='${InfoForm.mode=="add"}'>
					
					<div class="control-group">
							<html2:field property="parent">
								<label class="control-label"><html2:label /></label>
								<div class="controls">
									<c:choose>
									<c:when test="${not empty InfoForm.parentDTO }">
										${InfoForm.parentDTO.name}<input type="hidden"
											name="parent" value="${InfoForm.parentDTO.cid}" />
										
									</c:when>
									<c:otherwise>
										<html2:select property="parent">
												<html2:option value="-1">
													<fmt:message key="InfoForm.inheriteddefault.label" />
												</html2:option>
												<c:forEach var="item" items="${InfoForm.sharedClasses}">
													<html2:option value="${item.cid}">${item.name}</html2:option>
												</c:forEach>
											</html2:select>
										<html2:error styleClass="errorStyle1" />
									</c:otherwise>
								</c:choose>
								</div>
							</html2:field>
						</div>
						
						
					</c:if>
					
					
					<div class="control-group">
						<label class="control-label"><fmt:message key="ClassAdmin.defaultClassRole.label"/></label>
						<div class="controls">
							<tiles:insert definition=".classadmin.roles.class.dropdown" flush="false"/>
						</div>
					</div>		
					
					
					<% if( MapleTASystemConfiguration.isOPENUW() ){ %>
					<html2:field property="weight">
					<label class="control-label"><fmt:message key="ClassAdmin.weight.label" /></label>
						<div class="controls">
							<html2:text property="weight" />
							<html2:error styleClass="errorStyle1" />
						</div>
					</html2:field>
					<% } %>
					
			</div>
		</div>

		<c:if test='${InfoForm.classId> 0}'>
		
		<div class="row section">
			<div class="span3 sectionName">
				<h3>
					<fmt:message key="ClassAdmin.descriptionUrl.label" />
				</h3>
				<p><fmt:message key="ClassAdmin.descriptionUrl.description" />
			</div>
			
			<div class="span9 sectionMain">
						
				
				<div class="control-group">
					<html2:field property="descriptionUrl">
					<label class="control-label"><html2:label />
					</label>
					<div class="controls">
						<input type="text" value="${InfoForm.descriptionUrl}" id="descriptionUrl" name="descriptionUrl"/>
						<html2:error styleClass="errorStyle1" />
					</div>
					</html2:field>
				</div>
				
				<div class="control-group">
					<html2:field property="descriptionUrlText">
					<label class="control-label"><html2:label />
					</label>
					<div class="controls">
						<input type="text" value="${InfoForm.descriptionUrlText}" id="descriptionUrlText" name="descriptionUrlText"/>
						<html2:error styleClass="errorStyle1" />
					</div>
					</html2:field>
				</div>
				
			</div>
		</div>
		
		<div class="row section collapsed">
			<div class="span3 sectionName">
				<h3>
					<fmt:message key="ClassAdmin.description.label" />
				</h3>
				<p><fmt:message key="ClassAdmin.description.description" /></p>
			</div>
			
			<div class="span9 sectionMain">
			      <div class="editorArea" data-toolbar="Instructor" data-width="600" id="descriptionEditorArea"
			        data-height="200">
			        <html:hidden property="description" />
					<textarea id="descriptionEditor" name="descriptionEditor">${ InfoForm.description }</textarea>
			    </div>
			</div>
		</div>
		
		<div class="row section">
			<div class="span3 sectionName">
				<h3>
					<fmt:message key="ClassAdmin.detailsHtml.label" />
				</h3>
				<p><fmt:message key="ClassAdmin.detailsHtml.description" /></p>
			</div>
			
			<div class="span9 sectionMain">
			      <div class="editorArea" data-toolbar="Instructor" data-width="600" id="detailsHtmlEditorArea"
			        data-height="200">
			        <html:hidden property="detailsHtml" />
					<textarea id="detailsHtmlEditor" name="detailsHtmlEditor">${ InfoForm.detailsHtml }</textarea>
			    </div>
			</div>
		</div>
		</c:if>
		
		<div class="float-space">&nbsp;</div>
		<div class="form-actions actions-float">
		
		<c:if test="${sessionScope.context.currentRole.editClass}">
		
		
			<html2:submit onclick="javascript: readEditors(); return true;" styleClass="btn btn-primary">
				<fmt:message key="InfoForm.submit.label" />
			</html2:submit>
		</c:if>
			<input type="button" class="btn btn-danger"
				value='<fmt:message key="JspDefault.Cancel.Button"/>'
				onclick="javascript:document.location.href='<%=request.getContextPath()%>${cancel_action}';"></input>
		</div>

	</html2:form>
	<html2:html2Javascript xmlHttpRequest="false" />
</fmt:bundle>




