<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"
	language="java"%>
<%@ page import="com.maplesoft.mapleta.gateway.GatewayService"%>

<%@ page import="com.maplesoft.mapleta.configuration.MapleTASystemConfiguration"%>

<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<tiles:useAttribute name="module_title" ignore="true" />
<tiles:useAttribute name="fullwidth" ignore="true" />

<!DOCTYPE html>
<html:html lang="true">
<head>
<!--  stdLayout.jsp -->
<base href="<%=GatewayService.getServerURL()%>">
<title><%= MapleTASystemConfiguration.getSCHOOL_NAME() %> - <c:if
		test="${not empty module_title}">
		<fmt:message key="${module_title}" />
	</c:if></title>
<meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Cache-Control" content="no-cache">
<meta http-equiv="Expires" content="0">
<meta http-equiv="description"
	content="This is the standard page layout">

<link rel="stylesheet" type="text/css"
	href="<%=GatewayService.getServerURL()%>modules/skin/css/jquery.ui.css">
<link rel="stylesheet"
	href="<%=request.getContextPath()%>/modules/skin/css/bootstrap.min.css">

<link rel="stylesheet"
	href="<%=request.getContextPath()%>/modules/scripts/MathEditor/MapleCloudPlayer.css">


<link rel="stylesheet" type="text/css"
	href="<%=GatewayService.getServerURL()%>modules/skin/css/main.css">

<link rel="stylesheet" type="text/css"
	href="<%=GatewayService.getServerURL()%>modules/skin/css/print.css"
	media="print">
<link rel="stylesheet" type="text/css" href="modules/skin/css/eqe.css">

<c:if test="${sessionScope.bb_enabled}">
	<link rel="stylesheet" type="text/css" href="modules/blackboard/skin/css/main.css">
	<style>
@import URL("${bb_server_url}/ui/styles/blackboard.css");

@import URL("${bb_server_url}/ui/styles/palette.css");
</style>
</c:if>

<script type="text/javascript">
	function confirmAction() {
		<logic:present name="popupConfirm">
		return confirm("<c:out value='${popupConfirm}' escapeXml="false"/>");
		</logic:present>
		return false;
	}
</script>

<tiles:insert page="/WEB-INF/tiles/wsscript.jsp" beanScope="request"
	flush="false" />

<link rel="shortcut icon"
	href="<%=GatewayService.getServerURL()%>modules/skin/images/titlebar/favicon.ico" />

<%=MapleTASystemConfiguration.getCUSTOM_HTML_HEAD()%>
</head>

<%-- store the user context in page scope --%>
<c:set var="context" value="${sessionScope.context}" />
<c:set var="bb_enabled" value="${sessionScope.bb_enabled}" />

<%-- alert the user if another session is opened for this context --%>
<%--
<c:if test="${context.multipleSession}">
	<c:if test="${! context.multipleSessionWarningDelivered}" var="warningDelivered">
		<c:set target="${context}" property="multipleSessionWarningDelivered" value="${true}" />
		<fmt:bundle basename="com.maplesoft.mapleta.session.auth.resources.MessageResource">
			<fmt:message key="multiple.session.warning.title" var="user_warning_title" />
			<fmt:message key="multiple.session.warning.msg" var="user_warning"/>
		</fmt:bundle>
		<script type="text/javascript">
			var log = "<center><h1>${user_warning_title}</h1></center>";
			log += "<p>${user_warning}</p><br>";
			<c:forEach items="${context.usageLog}" var="log">
				log += "${log}<br>";
			</c:forEach>
			popupMessage(log);
		</script>
	</c:if>
</c:if>
--%>

<tiles:insert attribute="scripts" ignore="true" />

<body>
	<div id="main">
		<tiles:insert name="header">
			<tiles:put name="module">
				<%-- <tiles:getAsString name="module_title" /> --%>
				<c:if test="${not empty module_title}">
					<fmt:message key="${module_title}" />
				</c:if>
			</tiles:put>
		</tiles:insert>
		<div id="inner">
			<div <c:if test="${fullwidth ne 'true'}"> class="container"</c:if>>
				<div id="holder" <c:if test="${sessionScope.bb_enabled}">class="bbHolder"</c:if>>
					<tiles:insert name="content" />
				</div>
			</div>
			<div id="pageDialog"></div>
			<div id="modal" class="modal hide fade"></div>
	
			<logic:present name="popupAlert">
				<script type="text/javascript">
					alert("${popupAlert}");
				</script>
			</logic:present>
		</div>
		<%=MapleTASystemConfiguration.getCUSTOM_HTML_FOOTER()%>
	</div>
</body>
</html:html>
