<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<jsp:directive.page import="com.maplesoft.mapleta.gateway.GatewayService"/>

<%@ page import="com.maplesoft.mapleta.configuration.MapleTASystemConfiguration"%>

<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>

<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>

<fmt:setBundle
	basename="com.maplesoft.mapleta.application.ApplicationResources"
	scope="request" var="ApplicationResources" />

<!DOCTYPE html>
<html:html lang="true">
  <head>
  	<!--  skinSimpleFrame.jsp -->
	<base href="<%=GatewayService.getServerURL()%>">
    
	 <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
	<meta http-equiv="Pragma" content="no-cache">
	<meta http-equiv="Cache-Control" content="no-cache">
	<meta http-equiv="Expires" content="0">
    
    <link rel="stylesheet" type="text/css" href="<%=GatewayService.getServerURL()%>modules/skin/css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<%=GatewayService.getServerURL()%>modules/scripts/MathEditor/MapleCloudPlayer.css">
	
	<link rel="stylesheet" type="text/css" href="<%=GatewayService.getServerURL()%>modules/skin/css/main.css">
	<link rel="stylesheet" type="text/css" href="<%=GatewayService.getServerURL()%>modules/skin/css/print.css" media="print">  
	<link rel="stylesheet" type="text/css" href="modules/skin/css/eqe.css">

<tiles:insert page="/WEB-INF/tiles/wsscript.jsp" beanScope="request"
	flush="false" />

	<title><%= MapleTASystemConfiguration.getSCHOOL_NAME() %> - 
		<c:if test="${not empty module_title}">
			<fmt:message key="${module_title}" />
		</c:if>
	</title>

	<link rel="shortcut icon" href="<%=GatewayService.getServerURL()%>modules/skin/images/titlebar/favicon.ico" />
	<%= MapleTASystemConfiguration.getCUSTOM_HTML_HEAD() %>
  </head>
  
  <script type="text/javascript">
	 var title = "<c:if test="${not empty module_title}"><fmt:message key="${module_title}" /></c:if>";
  </script>
  
  <body id="skinSimpleFrame">
			<tiles:getAsString name="content" />
	<%= MapleTASystemConfiguration.getCUSTOM_HTML_FOOTER() %>
  </body>
  
</html:html>
