<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"
	language="java"%>
<jsp:directive.page	import="com.maplesoft.mapleta.gateway.GatewayService" />

<%@ page import="com.maplesoft.mapleta.configuration.MapleTASystemConfiguration"%>


<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>

<tiles:useAttribute name="module_title" ignore="true"/>

<fmt:setBundle
	basename="com.maplesoft.mapleta.application.ApplicationResources"
	scope="request" var="ApplicationResources" />

<!DOCTYPE html>
<html:html lang="true">
<head>
	<!--  simplePopupLayout.jsp -->
	<base href="<%=GatewayService.getServerURL()%>">

	<title><%= MapleTASystemConfiguration.getSCHOOL_NAME() %> - 
		<c:if test="${not empty module_title}">
			<fmt:message key="${module_title}" />
		</c:if>
	</title>
	
	<meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
	<meta http-equiv="Pragma" content="no-cache">
	<meta http-equiv="Cache-Control" content="no-cache">
	<meta http-equiv="Expires" content="0">
	<meta http-equiv="description"
		content="Simple page that has no layout design">

	<link rel="stylesheet" type="text/css" href="<%=GatewayService.getServerURL()%>modules/scripts/MathEditor/MapleCloudPlayer.css">
	
	<link rel="stylesheet" type="text/css" href="modules/skin/css/main.css">
	<link rel="stylesheet" type="text/css" href="<%=GatewayService.getServerURL()%>modules/skin/css/print.css" media="print">  
	<link rel="stylesheet" type="text/css" href="modules/skin/css/jquery.ui.css">
	<link rel="stylesheet" type="text/css" href="modules/skin/css/eqe.css">

	<tiles:insert page="/WEB-INF/tiles/wsscript.jsp" beanScope="request"	flush="false" />

	<script src="modules/scripts/ajax.js"></script>
	<script src="modules/contentmanager/assignment/displayQuestion.js"></script>
  <c:if test="${not empty sessionScope.wsQuestionEngine}">
    <tiles:insert page="/WEB-INF/tiles/wsscript.jsp" beanScope="request" flush="false" />
  	<script src="/MGH/mghDisplayQuestion.js"></script>
		<style>
				body{
				 font-size: 14px;
				 font-family: Helvetica,Arial,Geneva,Swiss,SunSans-Regular;
				}
				table{
				  font-size: 14px;
				}
				.ui-dialog{
				  border: 10px solid #333333;
				  border: 10px solid rgba(51, 51, 51, 0.5);
					-webkit-background-clip: padding-box;
			  	background-clip: padding-box;
				  background-color: #fff;
				  padding: 0;
				}
				.ui-dialog-titlebar {
					display:none
				}	
				.ui-dialog-buttonpane h4{
				   margin: 10px auto;
				}
				.ui-dialog-buttonpane p{
				  margin-bottom: 20px;
				}
				.ui-widget {
			    font-family: Helvetica,Arial,Geneva,Swiss,SunSans-Regular;
			    font-size: 1em;
			  }
			  .ui-widget input, .ui-widget select, .ui-widget textarea, .ui-widget button {
			     font-family: Helvetica,Arial,Geneva,Swiss,SunSans-Regular;     
			  }
			  .ui-widget-content a {
			    color: blue;
			  }
			.hidden{
			  display: none;
			}
			.content{
			 margin: 0;
			}
			.inline{
			  display: inline;
			}
			.gray{
			  color: gray;
			}
			.italic{
				font-style: italic;
			}
			.strong{
			  font-weight: bold;
			}
			form > .questionstyle p{
			  max-width: 630px;
			}
			p.tanote{
			   margin: 15px 0 0 0;
			}
			span.green{
			  color: green;
			}
			.red{
			  color: red;
			}
			span.large{
			  font-size: 150%;
			  font-weight: bold;
			}
			span.garamond{
			  font-family: Garamond, Georgia, serif;
			}
			button.mpl_button{
			  display: inline;
			}
			button.flr{
			  float: right;
			  white-space: nowrap;
			}
			a.mpl_button{
			  text-decoration: none; 
			  color: #444444;
			}
			a.img_close{
			  float: right;
			  margin: -10px;
			}
			a.img_close img{
			   border: medium none;
			    margin: 0;
			    padding: 0;
			}
			a.img_close:hover{
			 background-color: #fff;
			}
			
			#topbtns{
			  margin: 0 auto 30px;
			  width: 310px;
			}
			#topbtns div.img{
			  border: none;
			  background-color: #fff;
			  display: block;
			  margin-top: 10px;
			  padding-left: 50px;
			}
			#topbtns input{
			 margin: 0;
			 padding: 0;
			}
			div.mdialog h3{
			  text-decoration: none;
			  margin: 0 0 15px;
			}
			div.showDialog{
			  border: 10px solid #333;
				padding: 20px;
				background-color: #333333;
			}
			div.showDialog h3{
			  font-size: 100%;
			  font-weight: bold;
			}
			div.mdialog{
			  display: none;
			  background-color: #fff;
			  padding: 0;
			}
			div.ctl{
			  display:block;
			  width: 804px;
			  min-height: 300px;
			}
			
			#solutionDl, #gsDl{ 
				float: left; 
				width: 73%;
				display: block;
			} 
			.rightdlbtns{
				float: right;
			  width: 21%;
			}
			.rightdlbtns button{
			   width: 160px;
			   color: #444444;
			}
			#solutionDl, #gsDl{
			  border-right: 2px solid #DBDBDB;
			}
			#gsDl .gsbt, #gsDlNoBtns .gsbt{
			  background-color: #DDDDDD;
			   position: relative;
			   bottom: 0px;
			   padding: 15px 0;
			   width: 100%;
			   display:none;
			}
			#gsDl .gsbt div, #gsDlNoBtns .gsbt div{
			   float: right;
			}
			#gsDl .gsbt a, #gsDlNoBtns .gsbt a{
			  margin: 0 20px;
			}
			#gsDl .ques{
				min-height:250px;
				padding: 0 20px;
			}
			#gsDlNoBtns .ques{
			  margin: 20px 20px 0 ;
			}
			#gsDlNoBtns a.img_close{
			  margin: 0.5em 0.5em 0 0;
			}
			#gsDl .gsbt a.mpl_button, #gsDlNoBtns .gsbt a.mpl_button{
			  display: inline;
			  padding: 4px 15px;
			  cursor: pointer;
			}
			#gsDl .gsbt a.mpl_button.disabled, #gsDlNoBtns .gsbt a.mpl_button.disabled{
			  cursor: default;
			}
			#gsDlChangeEntryMode h3, #pageDialog h3{
			  margin-bottom: 10px;
			}
			#gsDlChangeEntryMode h3, #gsDlChangeEntryMode h4, #pageDialog h3, #pageDialog h4{
			  text-decoration: none;
			  font-size: 16px;
			}
			#gsDlChangeEntryMode table, #pageDialog table{
			  border-spacing: 0;
			}
			#gsDlChangeEntryMode table td, #pageDialog table td{
			  padding: 8px;
			}
			#gsDlChangeEntryMode a.img_close, #pageDialog a.img_close{
			   margin: 0px;
			}
			
			.mpl_button{
				background-color: #dbdbdb;
				background-image: linear-gradient(bottom, rgb(219,219,219) 23%, rgb(244,244,244) 62%);
				background-image: -o-linear-gradient(bottom, rgb(219,219,219) 23%, rgb(244,244,244) 62%);
				background-image: -moz-linear-gradient(bottom, rgb(219,219,219) 23%, rgb(244,244,244) 62%);
				background-image: -webkit-linear-gradient(bottom, rgb(219,219,219) 23%, rgb(244,244,244) 62%);
				background-image: -ms-linear-gradient(bottom, rgb(219,219,219) 23%, rgb(244,244,244) 62%);
				background-image: -webkit-gradient(
				linear,
				left bottom,
				left top,
				color-stop(0.23, rgb(219,219,219)),
				color-stop(0.62, rgb(244,244,244))
				);
				border: 1px solid #aaa;
				border-radius: 5px;/*add prefixed*/
				color: #000;
				font-family: helvetica;
				font-size: 14px;
				font-weight: bold;
				display: block;
				margin: 10px 0;
				padding: 4px;
				text-align: center;
				text-decoration: none;
				width: 125px;
			} 
			
			.mpl_button.disabled{
				opacity: 0.4;
			  -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=40)";
			  filter: alpha(opacity=40);
			  cursor: default;
			}
			.mpl_button.blue{
				background-color: #076bb2;
				background-image: linear-gradient(bottom,
				rgb(7,107,178) 23%, rgb(16,133,217) 62%);
				background-image: -o-linear-gradient(bottom,
				rgb(7,107,178) 23%, rgb(16,133,217) 62%);
				background-image: -moz-linear-gradient(bottom, rgb(7,107,178) 23%, rgb(16,133,217) 62%);
				background-image: -webkit-linear-gradient(bottom, rgb(7,107,178) 23%, rgb(16,133,217) 62%);
				background-image: -ms-linear-gradient(bottom, rgb(7,107,178) 23%, rgb(16,133,217) 62%);
				background-image: -webkit-gradient(
				linear,
				left bottom,
				left top,
				color-stop(0.23, rgb(7,107,178)),
				color-stop(0.62, rgb(16,133,217))
				);
				border: 1px solid #076bb2;
				color: #fff;
			} 
			.mpl_block{
				background-color: #ddd;
				background-image: linear-gradient(bottom, rgb(221,221,221) 23%, rgb(255,255,255) 62%);
				background-image: -o-linear-gradient(bottom, rgb(221,221,221) 23%, rgb(255,255,255) 62%);
				background-image: -moz-linear-gradient(bottom, rgb(221,221,221) 23%, rgb(255,255,255) 62%);
				background-image: -webkit-linear-gradient(bottom, rgb(221,221,221) 23%, rgb(255,255,255) 62%);
				background-image: -ms-linear-gradient(bottom, rgb(221,221,221) 23%, rgb(255,255,255) 62%);
				background-image: -webkit-gradient(
				linear,
				left bottom,
				left top,
				color-stop(0.23, rgb(221,221,221)),
				color-stop(0.62, rgb(255,255,255))
				);
				border: 1px solid #bbb;
				box-sizing: border-box;
				display: inline-block;
				font-family: helvetica;
				font-size: 14px;
				height: 50px;
				margin: 0;
				padding: 0 10px;
				vertical-align: middle;
			}
			.mpl_attempts{
				border-radius: 0 0 0 3px;
				margin-right: -2px;
			}
			.mpl_check{
				border-radius: 0 0 3px 0;
				border-left: 0;
			}
			.mpl_num_attempts{
				font-size: 30px;
				position: relative;
				top: 6px;
			}
		</style>
	</c:if>
	
	<link rel="shortcut icon" href="<%=GatewayService.getServerURL()%>modules/skin/images/titlebar/favicon.ico" />
	<%= MapleTASystemConfiguration.getCUSTOM_HTML_HEAD() %>
</head>

<body>
	<div class="content">
		<div id="pageContainer">		
			<tiles:importAttribute ignore="false" name="showbuttons"/>
			<c:choose>
				<c:when test="${showbuttons == 'true' }">			  
				  <tiles:insert name="top_buttons" flush="false" />  
					<div class="ctl">
						<div style="float: left; width: 80%">
						    <tiles:insert name="content" flush="false" />
						</div>
						<div id="right_buttons" style="float: right; width: 18%">
						    <tiles:insert name="right_buttons" flush="false" />
						</div>									
					</div>
				</c:when>
				<c:otherwise>
					<div class="ctl">
							<tiles:insert name="content" flush="false" />							
					</div>
				</c:otherwise>
			</c:choose>
		</div>
	</div>
	<div id="pageDialog"></div>
	<div style="position: absolute; right: 0; bottom: 0; font-size: smaller; color: gray;">
	   <tiles:insert name="version" flush="false" />
	</div>
	<%= MapleTASystemConfiguration.getCUSTOM_HTML_FOOTER() %>
</body>
</html:html>

