<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ page import="com.maplesoft.mapleta.gateway.GatewayService"%>
<%@ page import="com.maplesoft.mapleta.lti.BasicLTIConstants"%>
<%@ taglib uri="http://www.rabago.net/tags-valid2" prefix="html2"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>

<script type="text/javascript">
function setSave() {
	
	document.RoleMappingForm.actionType.value = "save";
	var id = $('#mapletaRoleIdDD').find(":selected").val();
	document.RoleMappingForm.mapletaRoleId.value = id;

	return true;
	
  }
  
function setCancel() {
	
	document.RoleMappingForm.actionType.value = "cancel";
	return true;
	
  }
  
  
</script>

<tiles:useAttribute name="action" />



<html2:form action="${action}" method="post"
		styleClass="form-horizontal">
	
	<html:hidden property="roleMappingId" value="${roleMappingId}"/>
	<html:hidden property="actionType" value=""/>
	<html:hidden property="mapletaRoleId" value=""/>
	<html:hidden property="lmsRole" value="${lmsRole}"/>
	
	
	<div class="row section">
		<div class="sectionName">
				<h3><fmt:message key="lti.editRoleMapping.Mappings.label"/></h3>	
			<div>
				<p><fmt:message key="lti.editRoleMapping.message1" /></p>
				
				
			</div>
		</div>
		
		<div class="sectionMain">
			<table>
				<tbody>
					<tr>
						<td><fmt:message key="lti.editRoleMapping.LmsRole.label"/></td>
						<td><html:text property="lmsRoleText" disabled="true" value="${lmsRole}" styleClass="form-control"/></td>
					</tr>
					<tr>
						<td><fmt:message key="lti.editRoleMapping.MapletaRole.label"/></td>
						<td>			
							<select name="mapletaRoleIdDD" id="mapletaRoleIdDD" class="form-control">
								    <c:forEach var="rls" items="${rolesList}">
						        		<option value="${rls.key}" ${rls.key == thisRole ? 'selected="selected"' : ''}>${rls.value}</option>
						    		</c:forEach>
							</select>
						</td>
					</tr>
				</tbody>
			</table>
 		</div>
 		
 		
	</div>
	<div class="float-space">&nbsp;</div>
		<div class="form-actions actions-float row">
			<div class="col-md-9 col-md-offset-3">
				<html2:submit onclick= "return setSave()" styleClass="btn btn-primary">
					<fmt:message key="InfoForm.submit.label" />
				</html2:submit>
				
				
				<html2:submit onclick= "return setCancel()" styleClass="btn btn-danger">
					<fmt:message key="JspDefault.Cancel.Button" />
				</html2:submit>
				
			</div>
		</div>
</html2:form>












