<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ page import="com.maplesoft.mapleta.gateway.GatewayService"%>
<%@ page import="com.maplesoft.mapleta.lti.BasicLTIConstants"%>
<%@ taglib uri="http://www.rabago.net/tags-valid2" prefix="html2"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>

<script type="text/javascript">
function setSave() {
	
	document.FieldMappingForm.actionType.value = "save";
	return true;
	
  }
  
function setCancel() {
	
	document.FieldMappingForm.actionType.value = "cancel";
	return true;
	
  }
  
  
</script>

<tiles:useAttribute name="action" />



<html2:form action="${action}" method="post"
		styleClass="form-horizontal">
	
	<html:hidden property="fieldMappingId" value="${fieldMapping.id}"/>
	<html:hidden property="actionType" value=""/>
	
	
	<div class="row section">
		<div class="sectionName">
				<h3><fmt:message key="lti.fieldMapping.Mappings.label"/></h3>	
			<div>
				<p><fmt:message key="lti.fieldMapping.message1" /></p>
				
				
			</div>
		</div>
		
		<div class="sectionMain">
			<table>
				<tbody>
					<tr>
						<td><fmt:message key="lti.fieldMapping.ExternalParameter.Label"/></td>
						<td><html:text property="externalParameter" readonly="true" value="${fieldMapping.externalParameter}" styleClass="form-control"/></td>
					</tr>
					<tr>
						<td><fmt:message key="lti.fieldMapping.UserProfileField.Label"/></td>
						<td>
								<select name="userProfileField" id="userProfileField" readonly="true" class="form-control">
								    <c:forEach var="field" items="${userProfileFieldList}">
						        		<option value="${field}" ${field == fieldMapping.userProfileField ? 'selected="selected"' : ''}>${field}</option>
						    		</c:forEach>
								</select>
						</td>
					</tr>
					<tr>
						<td><fmt:message key="lti.fieldMapping.Priority.Label"/></td>
						<td><html:text property="priority" value="${fieldMapping.priority}" styleClass="form-control"/></td>
					</tr>
				</tbody>
			</table>
						
 		</div>
 		
 		
	</div>
	<div class="float-space">&nbsp;</div>
		<div class="form-actions actions-float row">
			<div class="col-md-9 col-md-offset-3">
				<html2:submit onclick= "return setSave()" styleClass="btn btn-primary">
					<fmt:message key="InfoForm.submit.label" />
				</html2:submit>
				
				
				<html2:submit onclick= "return setCancel()" styleClass="btn btn-danger">
					<fmt:message key="JspDefault.Cancel.Button" />
				</html2:submit>
				
			</div>
		</div>
</html2:form>












