<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"
	language="java"%>
<jsp:directive.page import="com.maplesoft.mapleta.application.Constants" />
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ page import="com.maplesoft.mapleta.gateway.GatewayService"%>

<%@ page import="com.maplesoft.mapleta.configuration.MapleTASystemConfiguration"%>


<c:set property="hideMyProfile" scope="page" var="hideMyProfile">
	<tiles:getAsString name="hideMyProfile" ignore="true" />
</c:set>

<tiles:useAttribute name="remainingTime" ignore="true"/>
<tiles:importAttribute ignore="false" name="showlinks" scope="page" />
<%-- store the user context in page scope --%>
<c:set var="context" value="${sessionScope.context}" />


<tiles:importAttribute ignore="false" name="showlinks" scope="page" />

<c:set var="bb_enabled" value="${sessionScope.bb_enabled}" />

<tiles:importAttribute ignore="true" name="anonymous" scope="page" />
<tiles:useAttribute name="module" id="moduleName" />

<c:set var="bb_enabled" value="${sessionScope.bb_enabled}" />

<!--  assignmentHeader.jsp -->
<% if( !MapleTASystemConfiguration.isOPENUW() ){ %>
<div id="top">
	<c:if test="${! sessionScope.bb_enabled and empty sessionScope.wsQuestionEngine}">
		<c:if test="${ lockdownRequired ne true }">
			<div id="global">
				<div class="container">
				<a href="http://www.maplesoft.com/support/help/mapleta10"  target="_blank">
					<fmt:message key="MenuItem.help.label" /></a>
				
				</div>
			</div>
		</c:if>
		<div id="pageHeader" class="row assignmentHeader">
			<div class="container">
				<div id="logo"> <fmt:message
						key="TilesDefs.SystemHomepage.ModuleTitle" />
				</div>
				<div class="span4" id="welcome">
					<tiles:getAsString name="user" ignore="true" />
					<br />
	
					<tiles:getAsString name="studentId" ignore="true" />
				</div>
				<div class="span1" id="logoColumn">
					<div class="row" id="customerLogo">
					</div>
				</div>
			</div>
		</div>
		<tiles:useAttribute name="module" id="moduleName" />
		<div class="row" id="assignmentDetails">
			<h1>${moduleName}</h1>
		
						<c:if test="${ isShowCurrentGrade }">
							<div id="currentGrade">
								<fmt:message key="QuestionSheet.CurrentGrade.Label" />
								${ currentGrade } / ${ maxGrade }
							</div>
						</c:if>
						
						<c:if test="${ isShowClockMessage }">
						<div id="clockMessage">
							<fmt:message key="Common.RemainingTime.Label" />
							<span id="clock"> <c:choose>
									<c:when test="${remainingTime == null }">
										<fmt:message key="QuestionSheet.TimeRemaining.Infinite.Label" />
									</c:when>
									<c:otherwise>

										<script
											src="<%=GatewayService.getServerURL()%>modules/scripts/timer.js"></script>
										<script type="text/javascript">
											var remainingTime = ${remainingTime};
											clock();
										</script>

									</c:otherwise>
								</c:choose>
							</span>
						</div>
					</c:if>
		</div>

	</c:if>
	
	
	<c:if test="${sessionScope.bb_enabled and empty sessionScope.wsQuestionEngine}">
		<c:if test="${ lockdownRequired ne true }">
			<div id="global">
				<div class="container">
				<a href="http://www.maplesoft.com/support/help/mapleta10"  target="_blank">
					<fmt:message key="MenuItem.help.label" /></a>
				
				</div>
			</div>
		</c:if>
		<div id="pageHeader" class="row assignmentHeader bbAssignmentHeader">
			<div class="container">
				<div id="logo"> 
					<span id="logo" class="bbLogo"><img src="modules/blackboard/edu_button_32.gif"></span>
				</div>
				<div class="span4" id="welcome">
					<tiles:getAsString name="user" ignore="true" />
					<br />
	
					<tiles:getAsString name="studentId" ignore="true" />
				</div>
				<div class="span1" id="logoColumn">
					<div class="row" id="customerLogo">
					</div>
				</div>
			</div>
		</div>
		<tiles:useAttribute name="module" id="moduleName" />
		<div class="row" id="assignmentDetails">
			<h1>${moduleName}</h1>
		
						<c:if test="${ isShowCurrentGrade }">
							<div id="currentGrade">
								<fmt:message key="QuestionSheet.CurrentGrade.Label" />
								${ currentGrade } / ${ maxGrade }
							</div>
						</c:if>
						
						<c:if test="${ isShowClockMessage }">
						<div id="clockMessage">
							<fmt:message key="Common.RemainingTime.Label" />
							<span id="clock"> <c:choose>
									<c:when test="${remainingTime == null }">
										<fmt:message key="QuestionSheet.TimeRemaining.Infinite.Label" />
									</c:when>
									<c:otherwise>

										<script
											src="<%=GatewayService.getServerURL()%>modules/scripts/timer.js"></script>
										<script type="text/javascript">
											var remainingTime = ${remainingTime};
											clock();
										</script>

									</c:otherwise>
								</c:choose>
							</span>
						</div>
					</c:if>
		</div>

	</c:if>
	
	
	
	
	
	
	
</div>
<% }else{ // OPEN UW%>
	<div id="top">
		<div id="pageHeader">
			<div class="container">
				<a href="<%=request.getContextPath()%>" id="logo"> <fmt:message		
					key="TilesDefs.SystemHomepage.ModuleTitle" />
				</a>
				<div id="titleColumn">
				
						<ul class="inline pull-right">
							<c:if test="${ not empty context  }">
								<c:choose>
								<c:when test="${ anonymous }">
									<li><a href="login/login.do"><fmt:message key="Login.Login.ModuleTitle" /></a></li>
									<li><a href="login/Register.do">Create account</a></li>
								</c:when>
								<c:otherwise>
										<li><a href="useradmin/MyProfile.do?id=<bean:write name="context" property="user.id" filter="true"/>"><tiles:getAsString
												name="user" ignore="true" /></a></li>
									<li>
										<c:choose>
											<c:when test="${WS_SESSION}">
												<a href="javascript:window.close();"><fmt:message key="MenuItem.close.label" /></a>
											</c:when>
											<c:otherwise>
												<c:choose>
													<c:when test="${ltiSession}">
														<a href="login/login.do"><fmt:message key="MenuItem.close.label" /></a>
													</c:when>
													<c:otherwise>
														<a href="logout.do"><fmt:message key="MenuItem.logout.label" /></a>
													</c:otherwise>
												</c:choose>
											</c:otherwise>
										</c:choose>
									</li>
								</c:otherwise>
								</c:choose>		
							</c:if>
							<li><a href="http://www.maplesoft.com/support/help/mapleta10">
								<fmt:message key="MenuItem.help.label" /></a></li>
						
						</ul>
					</div>
				</div>
			</div>
		<div id="pageName">
			<div class="container">
				<nav class="span9">
						<ul class="inline">
							<li><a href="<%=request.getContextPath()%>">Homepage</a><span class="divider">/</span>
							</li>
							<c:if test="${context != null && context.cid != -1}">			
								<li><a href="<%=request.getContextPath()%>/modules/ClassHomepage.do?cid=${ context.cid }">${context.classDTO.availableShortName }</a><span class="divider">/</span></li>
							</c:if>
							<li><a href="<%=request.getContextPath()%>/modules/ClassHomepage.do?cid=${ context.cid }&gid=${groupId}">${groupShortName}</a><span class="divider">/</span>
							<li>${moduleShortName}</li>
						</ul>
					</nav>
					<form id="search" action="<%=request.getContextPath()%>/Search.do" method="get">
					   <input type="text" placeholder="Search" class="pull-right span3" name="query">					   
					</form>					
			</div>
		</div>
</div>
			
<% } %>



