SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET bytea_output = 'escape';
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

CREATE TABLE lti_key_secret
(
  consumer_key character varying(255) NOT NULL,
  shared_secret character varying(255) NOT NULL,
  tool_consumer_url character varying(2048),
  last_accessed timestamp without time zone,
  CONSTRAINT pk_lti_key_secret PRIMARY KEY (consumer_key)
);
ALTER TABLE public.lti_key_secret OWNER TO "mapleta";

CREATE TABLE lti_last_class_mapping
(
  context_guid character varying(512) NOT NULL,
  class_id integer,
  user_login character varying(255) NOT NULL,
  CONSTRAINT pk_lti_last_class_mapping PRIMARY KEY (context_guid, user_login)
);
ALTER TABLE public.lti_last_class_mapping OWNER TO "mapleta";

CREATE TABLE lti_launch
(
  consumer_key character varying(255) NOT NULL,
  course_id character varying(64) NOT NULL,
  resource_link_id character varying(64) NOT NULL,
  class_id integer NOT NULL,
  user_login character varying(255) NOT NULL,
  sourcedid character varying,
  result_url character varying(2048),
  assignment_id integer NOT NULL,
  CONSTRAINT pk_lti_launch PRIMARY KEY (consumer_key, course_id, resource_link_id, class_id, user_login, assignment_id),
  CONSTRAINT fk_lti_launch FOREIGN KEY (consumer_key)
      REFERENCES lti_key_secret (consumer_key) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
);
ALTER TABLE public.lti_launch OWNER TO "mapleta";
  
CREATE TABLE lti_mapping
(
  resource_guid character varying(512) NOT NULL,
  class_id integer,
  assignment_id integer,
  class_home_launch boolean,
  system_home_launch boolean,
  CONSTRAINT pk_lti_mapping PRIMARY KEY (resource_guid)
);
ALTER TABLE public.lti_mapping OWNER TO "mapleta";

CREATE SEQUENCE lti_role_mapping_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
ALTER TABLE public.lti_role_mapping_id_seq OWNER TO "mapleta";
CREATE TABLE lti_role_mapping
(
  id integer DEFAULT nextval(('lti_role_mapping_id_seq'::text)::regclass) NOT NULL,
  lms_role character varying(255) NOT NULL,
  mapleta_role_id integer NOT NULL
);
ALTER TABLE public.lti_role_mapping OWNER TO "mapleta";
ALTER TABLE ONLY lti_role_mapping
    ADD CONSTRAINT pk_lti_role_mapping PRIMARY KEY (id);

INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'Administrator', 1 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'Instructor', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'Learner', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'Student', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Administrator', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Administrator/Administrator', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Administrator/Developer', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Administrator/ExternalDeveloper', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Administrator/ExternalSupport', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Administrator/ExternalSystemAdministrator', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Administrator/Support', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Administrator/SystemAdministrator', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/ContentDeveloper', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/ContentDeveloper/ContentDeveloper', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/ContentDeveloper/ContentExpert', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/ContentDeveloper/ExternalContentExpert', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/ContentDeveloper/Librarian', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Instructor', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Instructor/ExternalInstructor', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Instructor/GuestInstructor', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Instructor/Lecturer', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Instructor/PrimaryInstructor', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Learner', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Learner/ExternalLearner', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Learner/GuestLearner', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Learner/Instructor', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Learner/Learner', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Learner/NonCreditLearner', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Manager', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Manager/AreaManager', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Manager/CourseCoordinator', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Manager/ExternalObserver', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Manager/Observer', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Member', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Member/Member', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Mentor', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Mentor/Advisor', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Mentor/Auditor', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Mentor/ExternalAdvisor', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Mentor/ExternalAuditor', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Mentor/ExternalLearningFacilitator', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Mentor/ExternalMentor', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Mentor/ExternalReviewer', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Mentor/ExternalTutor', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Mentor/LearningFacilitator', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Mentor/Mentor', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Mentor/Reviewer', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/Mentor/Tutor', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/TeachingAssistant', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/TeachingAssistant/Grader', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/TeachingAssistant/TeachingAssistant', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/TeachingAssistant/TeachingAssistantGroup', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/TeachingAssistant/TeachingAssistantOffering', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/TeachingAssistant/TeachingAssistantSection', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/TeachingAssistant/TeachingAssistantSectionAssociation', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:role:ims/lis/TeachingAssistant/TeachingAssistantTemplate', 2 );

INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:sysrole:ims/lis/SysAdmin', 1 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:sysrole:ims/lis/AccountAdmin', 1 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:sysrole:ims/lis/Administrator', 1 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:sysrole:ims/lis/SysSupport', 1 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:sysrole:ims/lis/Creator', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:sysrole:ims/lis/User', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:sysrole:ims/lis/None', 4 );

INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:instrole:ims/lis/Learner', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:instrole:ims/lis/Student', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:instrole:ims/lis/ProspectiveStudent', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:instrole:ims/lis/Member', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:instrole:ims/lis/Alumni', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:instrole:ims/lis/Guest', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:instrole:ims/lis/Other', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:instrole:ims/lis/Observer', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:instrole:ims/lis/Mentor', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:instrole:ims/lis/Staff', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:instrole:ims/lis/None', 4 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:instrole:ims/lis/Faculty', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:instrole:ims/lis/Instructor', 2 );
INSERT INTO lti_role_mapping( lms_role, mapleta_role_id) VALUES( 'urn:lti:instrole:ims/lis/Administrator', 1 );

CREATE SEQUENCE lti_field_mapping_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
ALTER TABLE lti_field_mapping_id_seq OWNER TO "mapleta";

CREATE TABLE lti_field_mapping
(
  id integer NOT NULL DEFAULT nextval(('lti_field_mapping_id_seq'::text)::regclass),
  external_parameter character varying(255) NOT NULL,
  user_profile_field character varying(255) NOT NULL,
  priority integer DEFAULT 0,
  CONSTRAINT pk_lti_field_mapping PRIMARY KEY (id)
);
ALTER TABLE lti_field_mapping OWNER TO "mapleta";

