<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"
	language="java"%>
<%@page import="com.maplesoft.mapleta.gateway.system.SystemConf"%>
<%@page import="com.maplesoft.mapleta.session.ActiveSessions"%>

<%@ taglib uri="http://www.rabago.net/tags-valid2" prefix="html2"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>

<tiles:useAttribute name="displayTime" ignore="true" />
<tiles:useAttribute name="maxCount" ignore="true" />
<tiles:useAttribute name="started" ignore="true" />
<tiles:useAttribute name="finished" ignore="true" />
<tiles:useAttribute name="verifyMaple" ignore="true" />
<tiles:useAttribute name="verifyMapleNet" ignore="true" />
<tiles:useAttribute name="verifyMathApp" ignore="true" />
<tiles:useAttribute name="verifyEmail" ignore="true" />
<tiles:useAttribute name="mml" ignore="true" />


<c:set var="verified">
	<c:choose>
		<c:when test="${sessionScope.context.currentRole.viewSystemSettings}">
			<html:link action="EditSystemProperties.do">
				<img src="modules/skin/images/grading/correct_small.png" border="false" />
			</html:link>
		</c:when>
		<c:otherwise>
			<img src="modules/skin/images/grading/correct_small.png" border="false" />
		</c:otherwise>
	</c:choose>
</c:set>

<c:set var="unverified">
	<c:choose>
		<c:when test="${sessionScope.context.currentRole.viewSystemSettings}">
			<html:link action="EditSystemProperties.do">
				<img src="modules/skin/images/grading/incorrect_small.png" border="false" />
			</html:link>
		</c:when>
		<c:otherwise>
			<img src="modules/skin/images/grading/incorrect_small.png" border="false" />
		</c:otherwise>
	</c:choose>
</c:set>

<fmt:bundle
	basename="com.maplesoft.mapleta.application.ApplicationResources">

	<logic:messagesPresent>
		<html:messages id="msg" message="false">
			<span class="errorStyle1"><c:out value='${msg}'
					escapeXml="false" /></span>
			<br>
		</html:messages>
		<br />
	</logic:messagesPresent>
	
	
		<div class="row section">
		<div class="span3 sectionName">
			<h3>
				<fmt:message key="SystemAdmin.version.heading" />
			</h3>
		</div>

		<div class="span9 sectionMain form-horizontal">

			<div class="control-group">
				<label class="control-label"> <fmt:message
						key="SystemAdmin.version.label" />
				</label>
				<div class="controls text">
					<fmt:message
						key="SystemAdmin.version.value" />
				</div>
			</div>

			<div class="control-group">
				<label class="control-label"> <fmt:message
						key="SystemAdmin.hotfix.label" />
				</label>
				<div class="controls text">
					<fmt:message
						key="SystemAdmin.hotfix.value" />
				</div>
			</div>
			
			<div class="control-group">
				<label class="control-label"> <fmt:message
						key="Help.BuildDate.Label" />
				</label>
				<div class="controls text">
					December 22, 2015 - Changelist 1098362
				</div>
			</div>


		</div>
	</div>
	
	

	<div class="row section">
		<div class="span3 sectionName">
			<h3>
				<fmt:message key="SystemAdmin.serverstarted.label" />
			</h3>
		</div>

		<div class="span9 sectionMain form-horizontal">
			<div class="control-group">
				<label class="control-label"> 		
					${displayTime}
				</label>
			</div>
		</div>
	</div>

	<div class="row section">
		<div class="span3 sectionName">
			<h3>
				<fmt:message key="SystemAdmin.sincelaststart.label" />
			</h3>
		</div>
		<div class="span9 sectionMain form-horizontal">

			<div class="control-group">
				<label class="control-label"> <fmt:message
						key="SystemAdmin.activeusers.current.label" />
				</label>
				<div class="controls text">
					<%=ActiveSessions.getUserCount()%>
				</div>
			</div>

			<div class="control-group">
				<label class="control-label"> <fmt:message
						key="SystemAdmin.usage.max.label" />
				</label>
				<div class="controls text">${maxCount}</div>
			</div>

			<div class="control-group">
				<label class="control-label"> <fmt:message
						key="SystemAdmin.assignments.started.label" />
				</label>
				<div class="controls text">${started}</div>
			</div>

			<div class="control-group">
				<label class="control-label"> <fmt:message
						key="SystemAdmin.assignments.finished.label" />
				</label>
				<div class="controls text">${finished}</div>
			</div>

		</div>
	</div>


	<div class="row section">
		<div class="span3 sectionName">
			<h3>
				<fmt:message key="SystemAdmin.connections.label" />
			</h3>
		</div>

		<div class="span9 sectionMain form-horizontal">

			<div class="control-group">
				<label class="control-label"> <fmt:message
						key="SystemAdmin.maple.label" />
				</label>
				<div class="controls text">
					<c:choose>
						<c:when test="${verifyMaple}">
							${verified}
						</c:when>
						<c:otherwise>
							${unverified}
						</c:otherwise>
					</c:choose>
				</div>
			</div>

			<div class="control-group">
				<label class="control-label"> <fmt:message
						key="SystemAdmin.maplenet.label" />
				</label>
				<div class="controls text">
					<c:choose>
						<c:when test="${verifyMapleNet}">
							${verified}
						</c:when>
						<c:otherwise>
							${unverified}
						</c:otherwise>
					</c:choose>
				</div>
			</div>

			<div class="control-group">
				<label class="control-label"><fmt:message
						key="SystemAdmin.mathapp.label" /> </label>
				<div class="controls text">
					<c:choose>
						<c:when test="${verifyMathApp}">
							${verified}
						</c:when>
						<c:otherwise>
							${unverified}
						</c:otherwise>
					</c:choose>
				</div>
			</div>

			<div class="control-group">
				<label class="control-label"> <fmt:message
						key="SystemAdmin.email.label" />
				</label>
				<div class="controls text">
					<c:choose>
						<c:when test="${verifyEmail}">
							${verified}
						</c:when>
						<c:otherwise>
							${unverified}
						</c:otherwise>
					</c:choose>
				</div>
			</div>

			<div class="control-group">
				<label class="control-label"><fmt:message
						key="SystemAdmin.mathml.label" /> </label>
				<div class="controls text">${mml}</div>
			</div>



		</div>
	</div>



</fmt:bundle>