<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ page import="com.maplesoft.mapleta.gateway.GatewayService"%>
<%@ taglib uri="http://www.rabago.net/tags-valid2" prefix="html2"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>

<%@ page import="com.maplesoft.mapleta.session.Context"%>



<script>
	$(document).ready(function() {
		$('input[name=assignmentClassId]:radio').change(function() {
			fillOptions('assignmentListRadios', $(this).val());
		});
		
		$('#classmappingsection input[class~="btn-primary"]').click(function(){
			var r = true;
			if($('#canPushbackGrade').val() === 'true'){
				r = confirm('<fmt:message key="lti.mapping.message3" />');
			}
			
			if(r == true){
				if (!$("input[name=classId]:checked").val())
				{
					alert('<fmt:message key="Msg.LTIMapping.ClassNotSelected"/>');
					return false;
				}else 
					return true;
			}
			
			return r;
		});
		
		$('#systemmappingsection input[class~="btn-primary"]').click(function(){
			if($('#canPushbackGrade').val() === 'true'){
				return confirm('<fmt:message key="lti.mapping.message3" />');
			}
		});

		
		if(typeof $('input[name=assignmentClassId]:checked').val() != 'undefined'){
			fillOptions('assignmentListRadios', $('input[name=assignmentClassId]:checked').val());			
		}
		
	});
	
	function fillOptions(ddId, classId) {
		var dd = $('#' + ddId);
		$.get(classId, function(data){
			$.ajax({
			//url : 'rest/assignments?source=instance',
			url : 'rest/assignments',
					cache : false,
			dataType : 'json',
			success : function(data) {
				//console.log('success', data);
				$( "#assignmentSection" ).show();
				$(dd).html("");
				var list = "";
				if (data) {
					
					$.each(data, function(i,row) {
						
						list = list +"<input type='radio' name='assignmentId' value="+ row.id +"> " +
						row.name + "\n<br>";
						//		$('<input/>').val(key).text(value).type("radio"));
					});
					$(dd).html(list);
				}
				
			},
			error : function(request, status, error) {
				console.log('error', error);
			}
		});
		
		});
	}
	
	function validateAssignmentClassMapping()
	{
		if (!$("input[name=assignmentClassId]:checked").val())
		{
			alert('<fmt:message key="Msg.LTIMapping.ClassNotSelected"/>');
			return false;
		}else 
			return true;
	}

	function validateAssignmentMapping()
	{
		if (!validateAssignmentClassMapping()){
			return false;
		}else if(!$("input[name=assignmentId]:checked").val())
		{
			alert('<fmt:message key="Msg.LTIMapping.AssignmentNotSelected"/>');
			return false;
		}else{
			return true;
		}
	}
	
	function validateClassHomeMapping()
	{
		if (!$("input[name=classId]:checked").val())
		{
			alert('<fmt:message key="Msg.LTIMapping.ClassNotSelected"/>');
			return false;
		}
		else return true;
	}
	
	
</script>

<style type="text/css">
table.properties {
	width: 75%;
}

table td.label {
	width: 20%;
}

table td.large {
	width: 60%;
}

table td.small {
	width: 10%;
}

table td.medium {
	width: 20%;
}
</style>

<tiles:useAttribute name="save_action" />



	<html2:form action="${save_action}" method="post"
		styleClass="form-horizontal">
		<input type="hidden" id="canPushbackGrade" value="${canPushbackGrade}" />
		
		<div id="classmappingsection">
			<div class="row section">
				<div class="span3 sectionName col-sm-3">
					<h3>
						<fmt:message key="ClassAdmin.Lti.ClassMapping.label" />
					</h3>
				</div>
	
				<div class="span9 sectionMain col-sm-9">
					<div>
					<table border="0" class="properties">
					<tr>
					
						<td class="medium"><fmt:message key="label.class" />:</td>
						<td class="large" colspan="4">
						<c:forEach items="${classList}" var="cls">
							<input type="radio" name="classId" value="${cls.key}" ${cls.key == lastClass ? 'checked' : ''}> ${cls.value}
							<br>
						</c:forEach>
						
						</td>
		   			    <td class="medium">&nbsp;</td>
					
					</tr>
					</table>
					<br>
					<div class="form-group">
						
						
						<html2:submit property="NewClass" styleClass="btn btn-default">
							<fmt:message key="ClassAdmin.Lti.NewClass.label"/>
						</html2:submit>
						
						<html2:submit property="ClassHomeMapping" styleClass="btn btn-primary">
							<fmt:message key="ClassAdmin.Lti.ClassHomeMapping.label"/>
						</html2:submit>	
						
						
					</div>
					</div>
				</div>
			</div>
		</div>
		
		<div id="assignmentmappingsection">
			<div class="row section" id="assignmentSection">
				<div class="span3 sectionName col-sm-3">
					<h3>
						<fmt:message key="ClassAdmin.Lti.AssignmentMapping.label" />
					</h3>
				</div>
	
				<div class="span9 sectionMain col-sm-9">	
	
					<table border="0" class="properties">
					<tr>
					
						<td class="medium"><fmt:message key="label.class" />:</td>
						<td class="large" colspan="4">
						<c:forEach items="${classList}" var="cls">
							<input type="radio" name="assignmentClassId" value="${cls.key}" ${cls.key == lastClass ? 'checked' : ''}> ${cls.value}
							<br>
						</c:forEach>
						
						</td>
		   			    <td class="medium">&nbsp;</td>
					
					</tr>
					
					<tr style="height: 20px;">
						
					</tr>
					
					<tr>
			
						<td class="medium"><fmt:message key="label.assignments" />:</td>
						<td class="large" colspan="4">
						<div id="assignmentListRadios">
						<c:forEach items="${assignmentList}" var="ass">
							<input type="radio" name="assignmentId" value="${ass.key}" ${ass.key == selectedAssignment ? 'checked' : ''}> ${ass.value}
							<br>
						</c:forEach>
						</div>
						</td>
		   			    <td class="medium">&nbsp;</td>
					
					</tr>
					</table>
					
					<br>
					<div class="form-group">
						
						
						<html2:submit property="NewClass" styleClass="btn btn-default">
							<fmt:message key="ClassAdmin.Lti.NewClass.label"/>
						</html2:submit>
						<html2:submit property="NewAssignment" styleClass="btn btn-default" onclick="return validateAssignmentClassMapping();">
							<fmt:message key="ClassAdmin.Lti.NewAssignment.label"/>
						</html2:submit>
						<html2:submit property="ImportContent" styleClass="btn btn-default" onclick="return validateAssignmentClassMapping();">
							<fmt:message key="ClassAdmin.Lti.ImportContent.label"/>
						</html2:submit>
						<html2:submit property="AssignmentMapping" styleClass="btn btn-primary" onclick= "return validateAssignmentMapping();">
							<fmt:message key="ClassAdmin.Lti.AssigmentMapping.label"/>
						</html2:submit>	
						
							
					</div>
				</div>
			</div>
		</div>
		
		<div id="systemmappingsection">
			<div class="row section">
				<div>
				<div class="span3 sectionName col-sm-3">
					<h3>
						<fmt:message key="ClassAdmin.Lti.SystemMappings.label" />
					</h3>
				</div>
	
				<div class="span9 sectionMain col-sm-9">
				
					
					<div class="form-group">
						
						<html2:submit property="SystemHomeMapping" styleClass="btn btn-primary">
							<fmt:message key="ClassAdmin.Lti.SystemHomeMapping.label"/>
						</html2:submit>	
						
					</div>
					
				</div>
				</div>
			</div>
		</div>
		
	</html2:form>

