/*
 * Decompiled with CFR 0.152.
 */
package applets.slidingLayers;

import applets.slidingLayers.Layer;
import java.applet.Applet;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.util.StringTokenizer;

public class SlidingLayers
extends Applet {
    private Image offscreen;
    private Layer[] layers;
    private Image background;
    Image inactiveHandle;
    Image activeHandle;
    boolean isLocked;

    public String getResponse() {
        StringBuffer sb = new StringBuffer(64);
        int i = 0;
        while (i < this.layers.length) {
            if (i > 0) {
                sb.append("; ");
            }
            sb.append("(");
            sb.append(this.layers[i].getPosX());
            sb.append(",");
            sb.append(this.layers[i].getPosY());
            sb.append(")");
            ++i;
        }
        return sb.toString();
    }

    public void init() {
        this.offscreen = this.createImage(this.size().width, this.size().height);
        this.inactiveHandle = this.getImage(this.getCodeBase(), "applets/slidingLayers/inactive_handle.gif");
        this.activeHandle = this.getImage(this.getCodeBase(), "applets/slidingLayers/active_handle.gif");
        int size = Integer.parseInt(this.getParameter("size"));
        this.layers = new Layer[size];
        int i = 1;
        while (i <= size) {
            Layer l;
            Image img = this.getImage(this.getCodeBase(), this.getParameter("layer." + i + ".image"));
            int x = Integer.parseInt(this.getParameter("layer." + i + ".anchor.x"));
            int y = Integer.parseInt(this.getParameter("layer." + i + ".anchor.y"));
            int hnd_x = Integer.parseInt(this.getParameter("layer." + i + ".handle.x"));
            int hnd_y = Integer.parseInt(this.getParameter("layer." + i + ".handle.y"));
            this.layers[i - 1] = l = new Layer(img, hnd_x, hnd_y, this);
            l.move(x, y);
            ++i;
        }
        this.background = this.getImage(this.getCodeBase(), this.getParameter("background.image"));
        this.isLocked = "true".equals(this.getParameter("locked"));
        if (this.getParameter("response") != null) {
            Point[] responsePositions = this.getPointList(this.getParameter("response"));
            int i2 = 0;
            while (i2 < responsePositions.length) {
                this.layers[i2].move(responsePositions[i2].x, responsePositions[i2].y);
                ++i2;
            }
        }
    }

    private Point[] getPointList(String text) {
        StringTokenizer stz = new StringTokenizer(text, ";");
        Point[] list = new Point[stz.countTokens()];
        int i = 0;
        while (i < list.length) {
            list[i] = this.parsePoint(stz.nextToken());
            ++i;
        }
        return list;
    }

    private Point parsePoint(String text) {
        text = text.trim();
        int commaPos = text.indexOf(44);
        int x = Integer.parseInt(text.substring(1, commaPos).trim());
        int y = Integer.parseInt(text.substring(commaPos + 1, text.length() - 1).trim());
        return new Point(x, y);
    }

    public boolean mouseDown(Event e, int x, int y) {
        if (this.isLocked) {
            return true;
        }
        int i = this.layers.length - 1;
        while (i >= 0) {
            if (this.layers[i].mouseDown(e, x, y)) {
                this.repaint();
                break;
            }
            --i;
        }
        return true;
    }

    public boolean mouseDrag(Event e, int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x > this.size().width) {
            x = this.size().width;
        }
        if (y > this.size().height) {
            y = this.size().height;
        }
        int i = 0;
        while (i < this.layers.length) {
            Layer l = this.layers[i];
            if (l.isSelected()) {
                l.move(x, y);
                this.repaint();
                break;
            }
            ++i;
        }
        return true;
    }

    public boolean mouseUp(Event e, int x, int y) {
        this.releaseAll();
        return true;
    }

    public void paint(Graphics g) {
        Graphics gr = this.offscreen.getGraphics();
        gr.setColor(this.getBackground());
        gr.fillRect(0, 0, this.size().width, this.size().height);
        gr.drawImage(this.background, 0, 0, this);
        int i = 0;
        while (i < this.layers.length) {
            this.layers[i].paint(gr);
            ++i;
        }
        g.drawImage(this.offscreen, 0, 0, this);
    }

    private void releaseAll() {
        int i = 0;
        while (i < this.layers.length) {
            this.layers[i].setSelected(false);
            ++i;
        }
        this.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

