/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mapleta.hotfix.installer;

import com.maplesoft.mapleta.hotfix.installer.BackupException;
import com.maplesoft.mapleta.hotfix.installer.FileOperationSpec;
import com.maplesoft.mapleta.hotfix.installer.FileTools;
import com.maplesoft.mapleta.hotfix.installer.InstallException;
import com.maplesoft.mapleta.hotfix.installer.RevertException;
import com.maplesoft.mapleta.hotfix.installer.UpdateLogger;
import com.maplesoft.mapleta.hotfix.installer.ValidationException;
import com.maplesoft.mapleta.hotfix.installer.WorkingFolderManager;
import java.io.File;

public class InstallableFileOperationSpec
extends FileOperationSpec {
    private String deploymentFolder;

    private String getSourcePath() {
        return String.valueOf(WorkingFolderManager.getFilesFolder()) + File.separator + this.getSource();
    }

    private String getBackupPath() {
        return String.valueOf(WorkingFolderManager.getBackupFolder()) + File.separator + this.getSource();
    }

    private String getInstalledPath() {
        return String.valueOf(this.deploymentFolder) + File.separator + this.getTarget();
    }

    private File getSourceFile() {
        return new File(this.getSourcePath());
    }

    private File getBackupFile() {
        return new File(this.getBackupPath());
    }

    private File getInstalledFile() {
        return new File(this.getInstalledPath());
    }

    public InstallableFileOperationSpec(FileOperationSpec spec, String deploymentFolder) {
        super(spec.getOp(), spec.getSource(), spec.getTarget());
        this.deploymentFolder = deploymentFolder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void ValidateInstall(boolean force) throws ValidationException {
        switch (this.getOp()) {
            case UPDATE: {
                try {
                    this.VerifySourceFileExists();
                    this.VerifyInstalledFileExists();
                    if (this.getInstalledFile().canWrite()) return;
                    throw new Exception(String.format("We do not have permisssion to write to the file '%s'.", this.getSource(), this.getInstalledFile().getAbsolutePath()));
                }
                catch (Exception ex) {
                    throw new ValidationException(String.format("Unable to update '%s'.", this.getSource()), ex);
                }
            }
            case ADD: {
                try {
                    this.VerifySourceFileExists();
                    if (!this.getInstalledFile().isFile() || force) return;
                    throw new Exception(String.format("Unable to add file '%s', target file '%s' already exists.", this.getSourceFile().getAbsolutePath(), this.getInstalledFile().getAbsolutePath()));
                }
                catch (Exception ex) {
                    throw new ValidationException(String.format("Unable to add '%s'.", this.getSource()), ex);
                }
            }
            case DELETE: {
                try {
                    if (force && this.isInstalled()) return;
                    this.VerifyInstalledFileExists();
                    if (this.getInstalledFile().canWrite()) return;
                    throw new Exception(String.format("We do not have permisssion to delete file '%s'.", this.getInstalledFile().getAbsolutePath()));
                }
                catch (Exception ex) {
                    throw new ValidationException(String.format("Unable to delete '%s'.", this.getTarget()), ex);
                }
            }
        }
    }

    public void ValidateRevert() throws ValidationException {
        switch (this.getOp()) {
            case UPDATE: {
                try {
                    this.VerifyBackupFileExists();
                    this.VerifyInstalledFileExists();
                    if (this.getInstalledFile().exists() && !this.getInstalledFile().canWrite()) {
                        throw new Exception(String.format("We do not have permisssion to write to the file '%s'.", this.getInstalledFile().getAbsolutePath()));
                    }
                    break;
                }
                catch (Exception ex) {
                    throw new ValidationException(String.format("Unable to revert update update for '%s'.", this.getSource()), ex);
                }
            }
            case ADD: {
                try {
                    if (this.getInstalledFile().exists() && !this.getInstalledFile().canWrite()) {
                        throw new Exception(String.format("We do not have permisssion to delete the file '%s'.", this.getInstalledFile().getAbsolutePath()));
                    }
                    break;
                }
                catch (Exception ex) {
                    throw new ValidationException(String.format("Unable to revert add for '%s'.", this.getSource()), ex);
                }
            }
            case DELETE: {
                try {
                    this.VerifyBackupFileExists();
                    if (this.getInstalledFile().exists() && !this.getInstalledFile().canWrite()) {
                        throw new Exception(String.format("We do not have permisssion to write to the file '%s'.", this.getInstalledFile().getAbsolutePath()));
                    }
                    break;
                }
                catch (Exception ex) {
                    throw new ValidationException(String.format("Unable to revert delete for '%s'.", this.getTarget()), ex);
                }
            }
        }
    }

    public boolean isInstalled() throws Exception {
        boolean rc = false;
        switch (this.getOp()) {
            case UPDATE: 
            case ADD: {
                rc = this.getSourceFile().exists() && this.getInstalledFile().exists() && FileTools.areIdentical(this.getSourceFile(), this.getInstalledFile());
                break;
            }
            case DELETE: {
                rc = !this.getInstalledFile().exists();
            }
        }
        return rc;
    }

    public void Backup() throws BackupException {
        if (this.getOp() == FileOperationSpec.FileOperation.UPDATE || this.getOp() == FileOperationSpec.FileOperation.DELETE) {
            try {
                FileTools.copy(this.getInstalledFile(), this.getBackupFile());
            }
            catch (Exception ex) {
                throw new BackupException(String.format("Error while backing up '%s'.", this.getSource()), ex);
            }
        }
    }

    public void Install() throws InstallException {
        try {
            switch (this.getOp()) {
                case UPDATE: {
                    FileTools.copy(this.getSourceFile(), this.getInstalledFile());
                }
                case ADD: {
                    File parentFolder = new File(this.getInstalledFile().getParent());
                    if (!parentFolder.exists() && !parentFolder.mkdirs()) {
                        throw new Exception(String.format("Error while creating folder '%s'.", parentFolder.getAbsolutePath()));
                    }
                    FileTools.copy(this.getSourceFile(), this.getInstalledFile());
                    break;
                }
                case DELETE: {
                    UpdateLogger.getLogger().Log(String.format("Deleting '%s'.", this.getInstalledFile().getAbsolutePath()));
                    if (this.isInstalled()) {
                        UpdateLogger.getLogger().Log(String.format("Warning, it appears that file '%s' has already been deleted, but you have specified '/force' so install will continue.", this.getInstalledFile().getAbsolutePath()));
                        break;
                    }
                    if (!this.getInstalledFile().delete()) {
                        throw new Exception(String.format("Error while deleting '%s'.", this.getSource()));
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            throw new InstallException(String.format("Error while installing '%s'.", this.getSource()), ex);
        }
    }

    public void Revert() throws RevertException {
        try {
            switch (this.getOp()) {
                case UPDATE: 
                case DELETE: {
                    FileTools.copy(this.getBackupFile(), this.getInstalledFile());
                    break;
                }
                case ADD: {
                    UpdateLogger.getLogger().Log(String.format("Deleting '%s'.", this.getInstalledFile().getAbsolutePath()));
                    if (!this.getInstalledFile().delete()) {
                        throw new Exception(String.format("Error while deleting '%s'.", this.getSource()));
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            throw new RevertException(String.format("Error while reverting '%s'.", this.getSource()), ex);
        }
    }

    public void VerifySourceFileExists() throws Exception {
        if (!this.getSourceFile().isFile()) {
            throw new Exception(String.format("Unable to find source file '%s'.", this.getSourceFile().getAbsolutePath()));
        }
    }

    public void VerifyBackupFileExists() throws Exception {
        if (!this.getBackupFile().isFile()) {
            throw new Exception(String.format("Unable to find backup file '%s'.", this.getBackupFile().getAbsolutePath()));
        }
    }

    public void VerifyInstalledFileExists() throws Exception {
        if (!this.getInstalledFile().isFile()) {
            throw new Exception(String.format("Unable to find target file '%s'.", this.getInstalledFile().getAbsolutePath()));
        }
    }
}

