/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import com.maplesoft.client.KernelAdapter;
import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.KernelEvent;
import com.maplesoft.client.KernelListener;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.kernelresult.KernelErrorResult;
import com.maplesoft.client.kernelresult.KernelRedirectResult;
import com.maplesoft.client.prettyprinter.TTYFormatter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class RedirectedKernelListener
extends KernelAdapter {
    protected KernelListener parent;
    protected KernelRedirectResult.Redirector redirector;
    protected KernelConnection connection;

    public RedirectedKernelListener(KernelConnection kernelConnection, KernelRedirectResult.Redirector redirector) {
        this.redirector = redirector;
        this.connection = kernelConnection;
    }

    public void setParentListener(KernelListener kernelListener) {
        this.parent = kernelListener;
    }

    public void writeInput(String string) {
        try {
            this.redirector.writeString(this.connection.getInterfaceProperties().getValue("prompt") + string + "\n");
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }

    public boolean processText(KernelEvent kernelEvent) {
        try {
            this.redirector.writeString(kernelEvent.getText());
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
        return true;
    }

    public boolean processChar(KernelEvent kernelEvent) {
        try {
            this.redirector.writeString(kernelEvent.getText());
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
        return true;
    }

    public boolean processError(KernelEvent kernelEvent) {
        try {
            KernelErrorResult.FormattedErrorMessage formattedErrorMessage = KernelErrorResult.parseErrorMessage((KernelEvent)kernelEvent);
            String string = "Error: " + formattedErrorMessage.getText();
            this.redirector.writeString(string);
            this.redirector.writeString("\n");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return false;
    }

    public boolean processWarning(KernelEvent kernelEvent) {
        try {
            KernelErrorResult.FormattedErrorMessage formattedErrorMessage = KernelErrorResult.parseErrorMessage((KernelEvent)kernelEvent);
            String string = "Warning: " + formattedErrorMessage.getText();
            this.redirector.writeString(string);
            this.redirector.writeString("\n");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return false;
    }

    public boolean processRealMath(KernelEvent kernelEvent) {
        try {
            Integer n = (Integer)this.connection.getInterfaceProperties().getValue("prettyprint");
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    TTYFormatter tTYFormatter = new TTYFormatter();
                    TTYWriter tTYWriter = new TTYWriter(this.redirector);
                    Dag dag = kernelEvent.getDag();
                    dag = DagBuilder.normalize(dag);
                    tTYFormatter.display(dag, (PrintWriter)tTYWriter);
                    tTYWriter.close();
                    break;
                }
                default: {
                    this.redirector.writeString(kernelEvent.getText());
                    break;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
        return true;
    }

    public KernelListener getParentListener() {
        return this.parent;
    }

    public KernelRedirectResult.Redirector getRedirector() {
        return this.redirector;
    }

    private static class TTYStream
    extends OutputStream {
        private static final int BUFFER_SIZE = 4000;
        private int offset;
        private char[] buffer;
        private KernelRedirectResult.Redirector redirector;

        private TTYStream(KernelRedirectResult.Redirector redirector) {
            this.redirector = redirector;
            this.buffer = new char[4000];
            this.offset = 0;
        }

        public void update() throws IOException {
            this.redirector.writeString(new String(this.buffer, 0, this.offset));
        }

        public void write(char[] cArray) throws IOException {
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                this.buffer[this.offset++] = cArray[i];
                if (this.offset != 4000) continue;
                this.update();
            }
        }

        public void close() {
            try {
                this.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void flush() throws IOException {
            super.flush();
            this.update();
        }

        public void write(int n) throws IOException {
            this.buffer[this.offset++] = (char)n;
            if (this.offset == 4000) {
                this.update();
            }
        }
    }

    private static class TTYWriter
    extends PrintWriter {
        private TTYWriter(KernelRedirectResult.Redirector redirector) {
            super(new TTYStream(redirector), false);
        }
    }
}

