/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.KernelConnectionListener;
import com.maplesoft.client.KernelEvent;
import com.maplesoft.client.KernelInterfaceProperties;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagUtil;

public class SetGetHandler {
    private KernelConnectionListener connector;
    private boolean setCallDisable = false;

    public SetGetHandler(KernelConnectionListener kernelConnectionListener) {
        this.connector = kernelConnectionListener;
    }

    private KernelInterfaceProperties transformSet(KernelEvent kernelEvent, KernelInterfaceProperties kernelInterfaceProperties) {
        Dag dag = kernelEvent.getDag();
        if (DagUtil.isExpSeq(dag) && dag.getLength() > 0) {
            Dag[] dagArray = new Dag[dag.getLength()];
            if (dag.getLength() == 2 && !DagUtil.isEquation(dag.getChild(0))) {
                dagArray = new Dag[]{this.processSetProperty(kernelInterfaceProperties, dag)};
            } else {
                for (int i = 0; i < dag.getLength(); ++i) {
                    Dag dag2 = dag.getChild(i);
                    dagArray[i] = this.processSetProperty(kernelInterfaceProperties, dag2);
                }
            }
            if (dagArray.length == 1 && DagUtil.isError(dagArray[0])) {
                kernelEvent.setResponseAsDag(dagArray[0]);
            } else {
                Dag dag3 = Dag.createDag(29, dagArray, null, false);
                kernelEvent.setResponseAsDag(dag3);
            }
        }
        return kernelInterfaceProperties;
    }

    protected Dag processSetProperty(KernelInterfaceProperties kernelInterfaceProperties, Dag dag) {
        Dag dag2 = null;
        String string = null;
        Dag dag3 = null;
        if ((DagUtil.isEquation(dag) || DagUtil.isExpSeq(dag)) && dag.getLength() >= 2) {
            if (DagUtil.isName(dag.getChild(0))) {
                string = dag.getChild(0).getData();
            }
            if (DagUtil.isComplex(dag3 = dag.getChild(1))) {
                dag3 = kernelInterfaceProperties.getDagValue("imaginaryunit");
            }
        }
        if (string == null) {
            dag2 = DagUtil.createErrorDag("No name for property set");
        } else if (dag3 == null) {
            dag2 = DagUtil.createErrorDag("A null value was found for the " + string + " property");
        } else {
            dag2 = this.setCallDisable && !KernelInterfaceProperties.shouldChangeOnReset(string) ? kernelInterfaceProperties.getDagValue(string) : kernelInterfaceProperties.setValue(string, dag3);
            if (dag2 == null) {
                dag2 = DagUtil.createErrorDag("A null value was found for the " + string + " property");
            }
        }
        return dag2;
    }

    public boolean getCallDisable() {
        return this.setCallDisable;
    }

    public boolean isConnected() {
        return this.connector.getConnection() != null;
    }

    public KernelEvent processGetHandler(KernelEvent kernelEvent) {
        KernelInterfaceProperties kernelInterfaceProperties;
        if (this.isConnected() && (kernelInterfaceProperties = this.connector.getConnection().getInterfaceProperties()) != null) {
            kernelEvent = kernelInterfaceProperties.createGetReply(kernelEvent.getDag(), kernelEvent);
        }
        return kernelEvent;
    }

    public KernelEvent processSetHandler(KernelEvent kernelEvent) {
        KernelConnection kernelConnection;
        KernelInterfaceProperties kernelInterfaceProperties;
        if (this.isConnected() && (kernelInterfaceProperties = (kernelConnection = this.connector.getConnection()).getInterfaceProperties()) != null) {
            kernelInterfaceProperties = this.transformSet(kernelEvent, kernelInterfaceProperties);
            kernelConnection.setInterfaceProperties(kernelInterfaceProperties);
        }
        return kernelEvent;
    }

    public void setCallDisable(boolean bl) {
        this.setCallDisable = bl;
    }
}

