/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.HybridDag;

public class HashDag
extends HybridDag {
    protected int hashSize;

    public HashDag(int n) {
        super(n, null, null);
    }

    public void setSize(int n) {
        this.hashSize = n;
    }

    public int getSize() {
        return this.hashSize;
    }

    public Dag copy() {
        HashDag hashDag = new HashDag(this.theType);
        hashDag.setSize(this.hashSize);
        hashDag.setData(this.theData);
        int n = this.getLength();
        Dag[] dagArray = new Dag[n];
        for (int i = 0; i < n; ++i) {
            dagArray[i] = this.getChild(i);
        }
        hashDag.setChildren(dagArray);
        return hashDag;
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DagBuilder.CLASS_NAMES[this.theType]);
        stringBuffer.append(" --------------------\n");
        stringBuffer.append(string);
        stringBuffer.append("-type:       ");
        stringBuffer.append(this.theType);
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("-data:       ");
        stringBuffer.append(this.theData);
        int n = this.getLength();
        if (n > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(string);
            stringBuffer.append("-children:   ");
            stringBuffer.append(n);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("\n");
                stringBuffer.append(string);
                stringBuffer.append("\n");
                stringBuffer.append(string);
                stringBuffer.append(".   SubDag #");
                stringBuffer.append(i);
                stringBuffer.append("  ");
                Dag dag = this.getChild(i);
                if (dag == null) {
                    stringBuffer.append("--> null");
                    continue;
                }
                stringBuffer.append(dag.toString(string + ".   "));
            }
        }
        return stringBuffer.toString();
    }
}

