/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractBinopDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;

public class ImpliesDagFactory
extends AbstractBinopDagFactory {
    public int getType() {
        return 28;
    }

    public String getStringOperator(WmiLPrintOptions wmiLPrintOptions) {
        return " implies ";
    }

    public boolean isVariableLength() {
        return false;
    }

    public int getPrecedence() {
        return 18;
    }

    public NotationLayoutBox createNotationBox(LayoutFormatter layoutFormatter) {
        return NotationLayoutBox.createNotationBox(layoutFormatter, 13);
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        int n = dag.getLength();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                Dag dag2 = dag.getChild(i);
                if (DagBuilder.getPrecedence(dag2, wmiLPrintOptions) >= this.getPrecedence()) {
                    stringBuffer.append("(");
                    DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
                    stringBuffer.append(")");
                } else {
                    DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
                }
                if (i >= n - 1) continue;
                stringBuffer.append(this.getStringOperator(wmiLPrintOptions));
            }
        }
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        return super.createLayout(layoutFormatter, dag, true);
    }
}

