/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.MapleNumbers;
import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.ProcDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class LexicalDagFactory
extends AbstractDagFactory {
    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream) throws IOException {
        int n = DagBuilder.dagCountPlus();
        int n2 = DagBuilder.parseShortInteger(wmiByteArrayInputStream);
        Dag[] dagArray = new Dag[1];
        n2 = n2 % 2 == 0 ? (n2 /= 2) : -(n2 / 2);
        dagArray[0] = Dag.createDag(2, null, Integer.toString(n2), false);
        Dag dag = Dag.createDag(33, dagArray, null, true);
        DagBuilder.putDag(dag, n);
        return dag;
    }

    public void writeDotm(StringBuffer stringBuffer, Dag dag) {
        int n = dag.getType();
        int n2 = LexicalDagFactory.isABackref(dag, n);
        if (n2 > 0) {
            this.writeBackref(stringBuffer, n2);
            return;
        }
        char c = (char)(MapleNumbers.dotMOutputTable[33] + 33 - 1);
        stringBuffer.append(c);
        int n3 = Integer.parseInt(dag.getChild(0).getData());
        n3 = n3 < 0 ? -(n3 * 2) + 1 : (n3 *= 2);
        DagBuilder.writeShortInteger(stringBuffer, n3);
    }

    public Dag normalize(Dag dag) {
        Dag dag2 = null;
        Dag dag3 = null;
        if (dag != null && dag.getType() == 33) {
            if (!dag.isNormalized()) {
                dag3 = dag.getChild(0);
                int n = Integer.parseInt(dag3.getData());
                if (n < 0) {
                    n = -n;
                }
                try {
                    dag2 = ProcDagFactory.getLexical(2 * n);
                    if (dag2 != null) {
                        int n2 = dag2.getType();
                        switch (n2) {
                            case 31: 
                            case 32: 
                            case 33: 
                            case 40: {
                                dag2 = ProcDagFactory.getLexical(2 * n - 1);
                                break;
                            }
                        }
                        dag2 = DagBuilder.normalize(dag2);
                    }
                    if (dag2 == null) {
                        Dag[] dagArray = new Dag[]{Dag.createDag(8, null, "lex", false), dag3};
                        dag2 = Dag.createDag(10, dagArray, null, false);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (dag2 != null && dag2.getType() == 11) {
                    dag2 = dag2.getChild(0);
                }
                if (dag2 != null) {
                    dag.setNormalized(dag2);
                }
            } else {
                dag2 = dag.getNormalized();
            }
        }
        return dag2;
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        int n = Integer.parseInt(dag.getChild(0).getData());
        if (n < 0) {
            n = -n;
        }
        try {
            Dag dag2 = ProcDagFactory.getLexical(n + n);
            dag2 = dag2 != null && (dag2.getType() == 32 || dag2.getType() == 31) ? ProcDagFactory.getLexical(n + n - 1) : ProcDagFactory.getLexical(n + n);
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public int getPrecedence() {
        return 1;
    }
}

