/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.ArrayData;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.RtableData;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;

public class RtableDoubleData
extends RtableData {
    double[] theData;
    int[] theDimensions;
    int[] theMultipliers;
    String theName;

    public double[] getDoubleData() {
        return this.theData;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RtableDoubleData)) {
            return false;
        }
        RtableDoubleData rtableDoubleData = (RtableDoubleData)object;
        if (this.theData != rtableDoubleData.theData && this.theData != null) {
            if (this.theData.length != rtableDoubleData.theData.length) {
                return false;
            }
            for (int i = 0; i < this.theData.length; ++i) {
                if (this.theData[i] == rtableDoubleData.theData[i]) continue;
                return false;
            }
        }
        return true;
    }

    void setDoubleData(double[] dArray) {
        this.theDimensions = new int[1];
        this.theDimensions[0] = dArray.length;
        this.theMultipliers = new int[0];
        this.theData = dArray;
    }

    public void readDotm(WmiByteArrayInputStream wmiByteArrayInputStream, int[] nArray, int[] nArray2) throws IOException {
        int n;
        int n2;
        super.readDotm(wmiByteArrayInputStream, nArray, nArray2);
        this.theData = new double[nArray[0]];
        this.theDimensions = nArray2;
        byte[] byArray = wmiByteArrayInputStream.getData();
        int n3 = wmiByteArrayInputStream.getPos();
        long l = 0L;
        for (int i = 0; i < nArray[0]; ++i) {
            l = 0L;
            for (n2 = 0; n2 < 16; ++n2) {
                if ((n = byArray[n3++]) <= 57) {
                    n -= 48;
                } else {
                    n -= 65;
                    n += 10;
                }
                l = (l << 4) + (long)n;
            }
            this.theData[i] = Double.longBitsToDouble(l);
        }
        wmiByteArrayInputStream.setPos(n3);
        if (nArray2.length == 3) {
            double[][][] dArray = new double[nArray2[0]][nArray2[1]][nArray2[2]];
            for (n2 = 0; n2 < nArray2[0]; ++n2) {
                for (n = 0; n < nArray2[1]; ++n) {
                    for (int i = 0; i < nArray2[2]; ++i) {
                        int n4 = this.getPosition(n2, n, i);
                        dArray[n2][n][i] = this.theData[n4];
                    }
                }
            }
            this.theName = ArrayData.put(dArray);
        } else if (nArray2.length == 4) {
            double[][][][] dArray = new double[nArray2[0]][nArray2[1]][nArray2[2]][nArray2[3]];
            for (n2 = 0; n2 < nArray2[0]; ++n2) {
                for (n = 0; n < nArray2[1]; ++n) {
                    for (int i = 0; i < nArray2[2]; ++i) {
                        for (int j = 0; j < nArray2[3]; ++j) {
                            int n5 = this.getPosition(n2, n, i, j);
                            dArray[n2][n][i][j] = this.theData[n5];
                        }
                    }
                }
            }
            this.theName = ArrayData.put(dArray);
        } else if (nArray2.length == 2) {
            double[][] dArray = new double[nArray2[0]][nArray2[1]];
            for (n2 = 0; n2 < nArray2[0]; ++n2) {
                for (n = 0; n < nArray2[1]; ++n) {
                    int n6 = this.getPosition(n2, n);
                    dArray[n2][n] = this.theData[n6];
                }
            }
            this.theName = ArrayData.put(dArray);
        } else {
            this.theName = ArrayData.put(this.theData);
        }
    }

    public StringBuffer writeDotm() {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.theData.length; ++i) {
            DagBuilder.doubleToHex(this.theData[i], stringBuffer);
        }
        return stringBuffer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{ ");
        int n = this.theDimensions.length;
        int[] nArray = new int[n];
        Arrays.fill(nArray, 1);
        for (int i = 0; i < this.theData.length; ++i) {
            if (this.theData[i] != 0.0) {
                stringBuffer.append("(");
                for (int j = 0; j < n; ++j) {
                    stringBuffer.append(nArray[j]);
                    if (j >= n - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(") = ");
                stringBuffer.append(this.theData[i]);
                if (i < this.theData.length - 1) {
                    stringBuffer.append(",");
                }
            }
            nArray = this.updateCounts(this.theDimensions, nArray, n - 1);
            nArray = this.checkCounts(this.theDimensions, nArray);
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    private int[] updateCounts(int[] nArray, int[] nArray2, int n) {
        int n2 = n;
        nArray2[n2] = nArray2[n2] + 1;
        if (nArray2[n] % nArray[n] == 1) {
            nArray2[n] = 1;
            if (n > 0) {
                nArray2 = this.updateCounts(nArray, nArray2, n - 1);
            }
        }
        return nArray2;
    }

    private int[] checkCounts(int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] <= nArray[i]) continue;
            nArray2[i] = 0;
        }
        return nArray2;
    }

    public int[] getDimensions() {
        return this.theDimensions;
    }

    public int getIntegerAt(int[] nArray) {
        return (int)this.theData[0];
    }

    public double getDoubleAt(int[] nArray) {
        int n = this.getPosition(nArray);
        return this.theData[n];
    }

    public Dag getDagAt(int n, int n2) {
        return null;
    }

    public float getFloatAt(int[] nArray) {
        return (float)this.theData[0];
    }

    public Dag getDagAt(int[] nArray) {
        return null;
    }

    public int getIntegerAt(int n) {
        return (int)this.theData[n];
    }

    public double getDoubleAt(int n) {
        return this.theData[n];
    }

    public float getFloatAt(int n) {
        return (float)this.theData[n];
    }

    public Dag getDagAt(int n) {
        return DagUtil.createDoubleDag(this.theData[n]);
    }

    public String getNamedArray() {
        return this.theName;
    }
}

