/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.MapleNumbers;
import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.FunctionDagFactory;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class ZppolyDagFactory
extends AbstractDagFactory {
    private static final int ZPPOLY_INDET = 0;
    private static final int ZPPOLY_MOD = 1;
    private static final int ZPPOLY_COEFF1 = 2;
    private static final int ZPPOLY_DEGREE = 1;
    private static final int MAX_HARDWARE_ZPPOLY = 46327;
    private static final int MAX_HARDWARE_DIGITS = 5;

    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream) throws IOException {
        return this.readDotm(wmiByteArrayInputStream, 17, DagBuilder.parseShortInteger(wmiByteArrayInputStream));
    }

    protected Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream, int n, int n2) {
        int n3 = DagBuilder.dagCountPlus();
        Dag[] dagArray = new Dag[--n2];
        Dag dag = Dag.createDag(n, dagArray, null, false);
        try {
            int n4;
            for (n4 = 0; n4 < 2; ++n4) {
                dagArray[n4] = DagBuilder.create(wmiByteArrayInputStream);
            }
            if (ZppolyDagFactory.isHardwareZPPOLY(dag) && ZppolyDagFactory.isOneVarZPPOLY(dag)) {
                for (n4 = 2; n4 < n2; ++n4) {
                    int n5 = DagBuilder.parseShortInteger(wmiByteArrayInputStream);
                    dagArray[n4] = Dag.createDag(2, null, Integer.toString(n5), false);
                }
            } else {
                for (n4 = 2; n4 < n2; ++n4) {
                    dagArray[n4] = DagBuilder.create(wmiByteArrayInputStream);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DagBuilder.putDag(dag, n3);
        return dag;
    }

    public void writeDotm(StringBuffer stringBuffer, Dag dag) {
        int n = dag.getType();
        int n2 = ZppolyDagFactory.isABackref(dag, n);
        if (n2 > 0) {
            this.writeBackref(stringBuffer, n2);
            return;
        }
        char c = (char)(MapleNumbers.dotMOutputTable[n] + 33 - 1);
        stringBuffer.append(c);
        int n3 = dag.getLength();
        if (n3 > 0) {
            int n4;
            DagBuilder.writeShortInteger(stringBuffer, n3 + 1);
            for (n4 = 0; n4 < 2; ++n4) {
                DagBuilder.writeDotm(stringBuffer, dag.getChild(n4));
            }
            if (ZppolyDagFactory.isHardwareZPPOLY(dag) && ZppolyDagFactory.isOneVarZPPOLY(dag)) {
                for (n4 = 2; n4 < n3; ++n4) {
                    int n5 = Integer.parseInt(dag.getChild(n4).getData());
                    DagBuilder.writeShortInteger(stringBuffer, n5);
                }
            } else {
                for (n4 = 2; n4 < n3; ++n4) {
                    DagBuilder.writeDotm(stringBuffer, dag.getChild(n4));
                }
            }
        } else {
            DagBuilder.writeShortInteger(stringBuffer, 1);
        }
    }

    public static boolean isHardwareZPPOLY(Dag dag) {
        String string;
        Dag dag2;
        int n;
        boolean bl = false;
        if (dag.getType() == 17 && (n = dag.getLength()) > 1 && (dag2 = dag.getChild(1)) != null && dag2.getType() == 2 && (string = dag2.getData()).length() <= 5) {
            bl = Integer.parseInt(string) < 46327;
        }
        return bl;
    }

    public static boolean isOneVarZPPOLY(Dag dag) {
        int n;
        boolean bl = false;
        if (dag.getType() == 17 && (n = dag.getLength()) > 0) {
            Dag dag2 = dag.getChild(0);
            bl = dag2 != null && dag2.getType() != 29;
        }
        return bl;
    }

    public StringBuffer toMathML(Dag dag) {
        return new StringBuffer();
    }

    public Dag normalize(Dag dag) {
        Dag dag2;
        Dag dag3 = null;
        Dag dag4 = null;
        if (dag != null && !dag.isNormalized()) {
            dag3 = this.convertToSum(dag);
        }
        this.invertSumDag(dag3);
        Dag dag5 = dag.getChild(0);
        Dag[] dagArray = null;
        if (dag5.getType() == 29) {
            int n = dag5.getLength();
            dagArray = new Dag[1 + n];
            for (int i = 0; i < n; ++i) {
                dagArray[i + 1] = dag5.getChild(i);
            }
        } else {
            dagArray = new Dag[2];
            dagArray[1] = dag5;
        }
        dagArray[0] = DagBuilder.normalize(dag3);
        Dag dag6 = FunctionDagFactory.createFunctionDag("ConvertIn", dagArray);
        Dag[] dagArray2 = new Dag[]{dag6, this.getDegree(dag)};
        String string = dagArray.length == 2 ? "modp1" : "modp2";
        dag4 = dag2 = FunctionDagFactory.createFunctionDag(string, dagArray2);
        dag.setNormalized(dag4);
        return dag4;
    }

    private Dag getDegree(Dag dag) {
        return dag.getChild(1);
    }

    private void invertSumDag(Dag dag) {
        int n = 0;
        int n2 = 0;
        int n3 = dag.getLength();
        if (dag.getType() == 16 && n3 > 2) {
            Dag dag2 = null;
            n = 0;
            for (n2 = n3 - 2; n < n2; n += 2, n2 -= 2) {
                dag2 = dag.getChild(n);
                dag.setChild(n, dag.getChild(n2));
                dag.setChild(n2, dag2);
                dag2 = dag.getChild(n + 1);
                dag.setChild(n + 1, dag.getChild(n2 + 1));
                dag.setChild(n2 + 1, dag2);
            }
        }
    }

    private Dag convertToSum(Dag dag) {
        Dag dag2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Dag[] dagArray = null;
        int n5 = dag.getLength();
        if (n5 > 0) {
            Object object;
            Dag dag3 = dag.getChild(0);
            if (n5 <= 2) {
                dag2 = DagConstants.ZERO;
            } else {
                if (dag3.getType() == 29 && dag3.getLength() > 0) {
                    dag3 = dag3.getChild(0);
                }
                n2 = 0;
                for (n = 2; n < n5; ++n) {
                    if (DagUtil.isZero(dag.getChild(n))) continue;
                    ++n2;
                }
                dagArray = new Dag[2 * n2];
                dag2 = Dag.createDag(16, dagArray, null, false);
                n3 = 0;
                for (n = 2; n < n5; ++n) {
                    Dag[] dagArray2;
                    object = DagBuilder.normalize(dag.getChild(n));
                    Dag dag4 = DagConstants.ONE;
                    boolean bl = true;
                    while (bl) {
                        if (((Dag)object).getType() == 18) {
                            dagArray2 = ((Dag)object).getChild(0).getData();
                            if (dagArray2.equals("modp1") || dagArray2.equals("ConvertIn")) {
                                object = ((Dag)object).getChild(1).getChild(0);
                                continue;
                            }
                            bl = false;
                            continue;
                        }
                        bl = false;
                    }
                    if (((Dag)object).getType() == 16 && ((Dag)object).getLength() == 2) {
                        object = ((Dag)object).getChild(0);
                    }
                    if (DagUtil.isZero((Dag)object)) continue;
                    n4 = n - 2;
                    if (n4 == 0) {
                        dagArray[n3++] = object;
                        dagArray[n3++] = dag4;
                        continue;
                    }
                    dagArray2 = null;
                    int n6 = 0;
                    if (DagUtil.isOne((Dag)object) && DagUtil.isOne(dag4)) {
                        dagArray2 = new Dag[2];
                    } else {
                        dagArray2 = new Dag[4];
                        dagArray2[n6++] = object;
                        dagArray2[n6++] = DagConstants.ONE;
                    }
                    dagArray2[n6++] = dag3;
                    dagArray2[n6++] = Dag.createDag(2, null, Integer.toString(n4), false);
                    Dag dag5 = Dag.createDag(14, dagArray2, null, false);
                    dagArray[n3++] = dag5;
                    dagArray[n3++] = DagConstants.ONE;
                }
            }
            if (dag2 == null) {
                dag2 = DagConstants.ZERO;
            } else if (dag2 != DagConstants.ZERO) {
                if (n3 < dagArray.length) {
                    if (n3 > 0) {
                        object = new Dag[n3];
                        for (n = 0; n < n3; ++n) {
                            object[n] = dagArray[n];
                        }
                        dag2 = Dag.createDag(16, (Dag[])object, null, false);
                    } else {
                        dag2 = DagConstants.ZERO;
                    }
                }
                dag2 = DagBuilder.normalize(dag2);
            }
        }
        return dag2;
    }
}

