/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.LayoutPoint;
import com.maplesoft.client.prettyprinter.linebreaker.DefaultLineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractLayoutBox
implements LayoutBox {
    protected double width = 0.0;
    protected double height = 0.0;
    protected double baseline = 0.0;
    protected double lsb;
    protected double rsb;
    protected boolean sizeSet = false;
    protected boolean validLayout = false;
    protected LayoutPoint origin = new LayoutPoint(0.0, 0.0);
    protected LayoutBox endPoint = null;
    protected Dag dag;
    protected LineBreaker linebreaker = LineBreakerFactory.newLineBreaker((int)0);
    protected LayoutBox displayLayoutBox;
    protected LayoutBox idealLayoutBox;

    protected AbstractLayoutBox() {
    }

    public void setLineBreaker(LineBreaker lineBreaker) {
        this.linebreaker = lineBreaker;
    }

    public LineBreaker getLineBreaker() {
        return this.linebreaker;
    }

    public abstract void setSelectionData(SelectionData var1);

    public abstract SelectionData getSelectionData();

    public List getSelectionBoxes() {
        return null;
    }

    public void setSelectionBoxes(List list) {
    }

    public LayoutBox getPairEndPointBox() {
        return this.endPoint;
    }

    public void setPairEndPointBox(LayoutBox layoutBox) {
        this.endPoint = layoutBox;
    }

    public abstract void setData(String var1);

    public abstract String getData();

    public abstract boolean hasChildren();

    public abstract int numChildren();

    public abstract int indexOf(LayoutBox var1);

    public abstract LayoutBox getChild(int var1);

    public abstract void addChild(LayoutBox var1);

    public abstract void removeChild(int var1);

    public abstract Iterator getChildren();

    public abstract void setTheFirstOrigin();

    public void setOrigin(LayoutPoint layoutPoint) {
        this.setOrigin(layoutPoint.getX(), layoutPoint.getY());
    }

    public void setOrigin(double d, double d2) {
        this.origin = new LayoutPoint(d, d2);
    }

    public LayoutPoint getOrigin() {
        return this.origin;
    }

    public void translateOrigin() {
        LayoutPoint layoutPoint = this.getOrigin();
        LayoutPoint layoutPoint2 = new LayoutPoint(2.0 - layoutPoint.getX(), 2.0 - layoutPoint.getY());
        this.translateOrigin(layoutPoint2);
    }

    public void translateOrigin(LayoutPoint layoutPoint) {
        LayoutPoint layoutPoint2 = this.getOrigin();
        this.setOrigin(layoutPoint2.getX() + layoutPoint.getX(), layoutPoint2.getY() + layoutPoint.getY());
    }

    public double getXorig() {
        return this.origin.getX();
    }

    public double getYorig() {
        return this.origin.getY();
    }

    public double getAdjustedYorig() {
        return this.origin.getY();
    }

    public double getBaseline() {
        return this.baseline;
    }

    public void setBaseline(double d) {
        this.baseline = d;
    }

    public void setSize(double d, double d2) {
        this.width = d;
        this.height = d2;
        this.sizeSet = true;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getLeftSideBearing() {
        return this.lsb;
    }

    public double getRightSideBearing() {
        return this.rsb;
    }

    public void setRightSideBearing(double d) {
        this.rsb = d;
    }

    public void setLeftSideBearing(double d) {
        this.lsb = d;
    }

    public double getTotalWidth() {
        return this.getWidth() + this.getRightSideBearing() + this.getLeftSideBearing();
    }

    public double getAdjustedHeight() {
        return this.height;
    }

    public double getDescentAdjustment() {
        return 0.0;
    }

    public String getSize() {
        return "" + this.width + "," + this.height;
    }

    public abstract void computeSize();

    public boolean isLayoutValid() {
        return this.validLayout;
    }

    public abstract void invalidateAll();

    public void validate(boolean bl) {
        this.validLayout = bl;
    }

    public abstract Iterator getAnchors();

    public abstract void addLayoutAnchor(LayoutAnchor var1);

    public abstract void applyLayout();

    public LayoutBox getDisplayLayoutBox() {
        LayoutBox layoutBox = this.displayLayoutBox == null ? this : this.displayLayoutBox;
        return layoutBox;
    }

    public void setDisplayLayoutBox(LayoutBox layoutBox) {
        this.displayLayoutBox = layoutBox;
    }

    public LayoutBox getIdealLayoutBox() {
        LayoutBox layoutBox = this.idealLayoutBox == null ? this : this.idealLayoutBox;
        return layoutBox;
    }

    public void setIdealLayoutBox(LayoutBox layoutBox) {
        this.idealLayoutBox = layoutBox;
    }

    public void linebreak(LayoutFormatter layoutFormatter, double d) {
        double d2 = d;
        if (this.getLineBreaker() != null && d2 < this.getWidth()) {
            d2 = Math.max(d2, DefaultLineBreaker.getMinimumBreakWidth((double)d, (LayoutFormatter)layoutFormatter));
            if (this.displayLayoutBox != null) {
                this.displayLayoutBox = null;
                AbstractLayoutBox.resetLayout(this);
            }
            this.displayLayoutBox = this.getLineBreaker().startLinebreak((LayoutBox)this, layoutFormatter, d2);
            this.displayLayoutBox.setIdealLayoutBox(this);
        } else if (this.displayLayoutBox != null) {
            this.displayLayoutBox = null;
            AbstractLayoutBox.resetLayout(this);
        }
    }

    static void resetLayout(LayoutBox layoutBox) {
        layoutBox.invalidateAll();
        layoutBox.applyLayout();
    }

    public void setDag(Dag dag) {
        this.dag = dag;
    }

    public void setAllDags(Dag dag) {
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).setAllDags(dag);
        }
        this.setDag(dag);
    }

    public Dag getDag() {
        return this.dag;
    }

    public int[] getAncestorPath() {
        return null;
    }

    public abstract String getName();

    public abstract String toString();
}

