/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakLayoutBox;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class BoxUtils {
    public static LayoutBox whichIsFirstBox(LayoutBox layoutBox, LayoutBox layoutBox2, LayoutBox layoutBox3) {
        SelectionData selectionData;
        int n;
        LayoutBox layoutBox4 = layoutBox2;
        List list = BoxUtils.findPathToBox(layoutBox, layoutBox2);
        List list2 = BoxUtils.findPathToBox(layoutBox, layoutBox3);
        list.add(layoutBox2);
        list2.add(layoutBox3);
        LayoutBox layoutBox5 = (LayoutBox)BoxUtils.findFirstCommonElement(list, list2);
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < list.size(); ++n) {
            if (list.get(n) != layoutBox5 || n + 1 >= list.size()) continue;
            n2 = layoutBox5.indexOf((LayoutBox)list.get(n + 1));
            break;
        }
        for (n = 0; n < list2.size(); ++n) {
            if (list2.get(n) != layoutBox5 || n + 1 >= list2.size()) continue;
            n3 = layoutBox5.indexOf((LayoutBox)list2.get(n + 1));
            break;
        }
        if ((selectionData = layoutBox5.getSelectionData()) != null && !(layoutBox5 instanceof LineBreakLayoutBox)) {
            int n4 = selectionData.getTraversalArrayIndex(n2, 1);
            int n5 = selectionData.getTraversalArrayIndex(n3, 1);
            n2 = n2 == n4 ? n2 : n4;
            n3 = n3 == n5 ? n3 : n5;
        }
        layoutBox4 = n2 <= n3 ? layoutBox2 : layoutBox3;
        return layoutBox4;
    }

    public static BoxIterator getBoxIterator(LayoutBox layoutBox) {
        return new BoxIterator(layoutBox);
    }

    public static boolean isBetween(LayoutBox layoutBox, LayoutBox layoutBox2, LayoutBox layoutBox3, LayoutBox layoutBox4) {
        int n;
        int n2;
        boolean bl = true;
        if (layoutBox2 == layoutBox3 || layoutBox2 == layoutBox4) {
            return true;
        }
        int[] nArray = BoxUtils.getBoxPath(layoutBox, layoutBox3);
        int[] nArray2 = BoxUtils.getBoxPath(layoutBox, layoutBox2);
        int[] nArray3 = BoxUtils.getBoxPath(layoutBox, layoutBox4);
        for (n2 = 0; n2 < nArray2.length && bl; ++n2) {
            n = nArray2[n2];
            if (n2 >= nArray.length) continue;
            bl = n > nArray[n2];
            if (bl) break;
            bl = n >= nArray[n2];
        }
        for (n2 = 0; n2 < nArray2.length && bl; ++n2) {
            n = nArray2[n2];
            if (n2 >= nArray3.length) continue;
            bl = n < nArray3[n2];
            if (bl) break;
            bl = n <= nArray3[n2];
        }
        return bl;
    }

    public static LayoutBox findParent(LayoutBox layoutBox, LayoutBox layoutBox2) {
        LayoutBox layoutBox3 = null;
        List list = BoxUtils.findPathToBox(layoutBox, layoutBox2);
        if (list != null) {
            layoutBox3 = (LayoutBox)list.get(list.size() - 1);
        }
        return layoutBox3;
    }

    public static List findPathToBox(LayoutBox layoutBox, LayoutBox layoutBox2, List list) {
        CollectDags collectDags = new CollectDags(list);
        BoxUtils.walkPath(layoutBox, layoutBox2, collectDags);
        return collectDags.getPath();
    }

    public static List findPathToBox(LayoutBox layoutBox, LayoutBox layoutBox2) {
        BuildPath buildPath = new BuildPath();
        BoxUtils.walkPath(layoutBox, layoutBox2, buildPath);
        return buildPath.getPath();
    }

    public static int[] getBoxPath(LayoutBox layoutBox, LayoutBox layoutBox2) {
        List list = BoxUtils.findPathToBox(layoutBox, layoutBox2);
        list.add(layoutBox2);
        int[] nArray = new int[list.size() - 1];
        LayoutBox layoutBox3 = layoutBox;
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        int n = 0;
        while (iterator.hasNext()) {
            LayoutBox layoutBox4 = (LayoutBox)iterator.next();
            nArray[n] = layoutBox3.indexOf(layoutBox4);
            layoutBox3 = layoutBox4;
            ++n;
        }
        return nArray;
    }

    public static LayoutBox getBoxFromPath(LayoutBox layoutBox, int[] nArray) throws IndexOutOfBoundsException {
        LayoutBox layoutBox2 = layoutBox;
        for (int i = 0; i < nArray.length; ++i) {
            if ((layoutBox2 = layoutBox2.getChild(nArray[i])) != null) continue;
            throw new IndexOutOfBoundsException("Path want wrong at step " + i + " index " + nArray[i]);
        }
        return layoutBox2;
    }

    public static void walkPath(LayoutBox layoutBox, LayoutBox layoutBox2, BoxWalkOperation boxWalkOperation) {
        LayoutBox layoutBox3 = layoutBox;
        LayoutBox layoutBox4 = null;
        block0: do {
            layoutBox4 = null;
            boxWalkOperation.visited(layoutBox3);
            for (int i = 0; i < layoutBox3.numChildren(); ++i) {
                layoutBox4 = layoutBox3.getChild(i);
                if (layoutBox4 != layoutBox2 && !BoxUtils.containsBoxInDepth(layoutBox4, layoutBox2)) continue;
                layoutBox3 = layoutBox4;
                continue block0;
            }
        } while (layoutBox3 != layoutBox2 && BoxUtils.containsBoxInDepth(layoutBox3, layoutBox2));
    }

    public static boolean containsBoxInDepth(LayoutBox layoutBox, LayoutBox layoutBox2) {
        boolean bl = false;
        if (layoutBox == layoutBox2) {
            bl = true;
        } else if (layoutBox != null) {
            for (int i = 0; i < layoutBox.numChildren() && !bl; ++i) {
                LayoutBox layoutBox3 = layoutBox.getChild(i);
                if (layoutBox3 == layoutBox2) {
                    bl = true;
                    break;
                }
                bl = BoxUtils.containsBoxInDepth(layoutBox3, layoutBox2);
                if (bl) break;
            }
        }
        return bl;
    }

    public static LayoutBox findCommonParent(LayoutBox layoutBox, LayoutBox layoutBox2, LayoutBox layoutBox3) {
        List list = BoxUtils.findPathToBox(layoutBox, layoutBox2);
        List list2 = BoxUtils.findPathToBox(layoutBox, layoutBox3);
        return (LayoutBox)BoxUtils.findFirstCommonElement(list, list2);
    }

    public static Object findFirstCommonElement(List list, List list2) {
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        int n = list.size();
        int n2 = list2.size();
        int n3 = Math.max(n, n2);
        for (int i = 0; i < n3 && i < n && i < n2 && (var3_3 = list.get(i)) == (var4_4 = list2.get(i)); ++i) {
            var2_2 = var3_3;
        }
        return var2_2;
    }

    public static class BoxIterator
    implements Iterator {
        private LayoutBox targBox;
        private int position = 0;
        private SelectionData sd = null;
        private LayoutBox lastBox;

        public BoxIterator(LayoutBox layoutBox) {
            this.targBox = layoutBox;
            this.sd = this.targBox.getSelectionData();
            this.position = 0;
        }

        public Object next() {
            return this.forward();
        }

        public boolean hasNext() {
            return this.isBoxForward();
        }

        public void remove() {
            throw new UnsupportedOperationException("BoxIterator cannot remove layout boxes");
        }

        public LayoutBox forward() {
            return this.targBox.getChild(this.position++);
        }

        public LayoutBox backward() {
            return this.targBox.getChild(this.position--);
        }

        public boolean isBoxForward() {
            return this.position < this.targBox.numChildren();
        }

        public boolean isBoxBehind() {
            return this.position > 0;
        }
    }

    public static class CollectDags
    extends BuildPath {
        private List daglist;

        public CollectDags(List list) {
            this.daglist = list;
        }

        public void visited(LayoutBox layoutBox) {
            super.visited(layoutBox);
            if (!this.daglist.contains(layoutBox.getDag())) {
                this.daglist.add(layoutBox.getDag());
            }
        }

        public List getDags() {
            return this.daglist;
        }
    }

    public static class BuildPath
    implements BoxWalkOperation {
        List path = new LinkedList();

        public void visited(LayoutBox layoutBox) {
            this.path.add(layoutBox);
        }

        public List getPath() {
            return this.path;
        }
    }

    public static interface BoxWalkOperation {
        public void visited(LayoutBox var1);
    }
}

