/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutPoint;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import java.util.Iterator;

public class MatrixLayoutBox
extends DefaultLayoutBox {
    public static final int COLUMN_FILL_ORDER = 0;
    public static final int ROW_FILL_ORDER = 1;
    public static final int LEFT_JUSTIFY = 0;
    public static final int CENTER_JUSTIFY = 1;
    public static final int RIGHT_JUSTIFY = 2;
    private int rows;
    private int cols;
    private int nextIndex;
    private int fillOrder;
    private int justification;
    private int rowSeparator = 1;
    private int columnSeparator = 2;
    LayoutBox[] elements;
    private double baselineFF = 0.0;

    public MatrixLayoutBox(int n, int n2, int n3) {
        super("Matrix");
        this.rows = n;
        this.cols = n2;
        this.fillOrder = n3;
        this.justification = 0;
        this.nextIndex = 0;
        this.elements = new LayoutBox[n * n2];
        this.setLineBreaker(LineBreakerFactory.newLineBreaker((int)5));
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public boolean hasChildren() {
        return true;
    }

    public int numChildren() {
        return this.elements.length;
    }

    public LayoutBox getChild(int n) {
        return n < this.elements.length ? this.elements[n] : null;
    }

    public void addChild(LayoutBox layoutBox) {
        if (this.nextIndex < this.elements.length) {
            if (this.fillOrder == 1) {
                this.elements[this.nextIndex] = layoutBox;
            } else {
                int n = this.nextIndex % this.rows;
                int n2 = this.nextIndex / this.rows;
                int n3 = n * this.cols + n2;
                this.elements[n3] = layoutBox;
            }
        }
        ++this.nextIndex;
        this.validate(false);
    }

    public Iterator getChildren() {
        return new MatrixLayoutIterator(this);
    }

    public void setTheFirstOrigin() {
        this.elements[0].setOrigin(0.0, 0.0);
    }

    public void computeSize() {
        if (this.numChildren() > 0) {
            Object object;
            LayoutBox layoutBox = this.getChild(0);
            double d = layoutBox.getXorig();
            double d2 = d + layoutBox.getWidth();
            double d3 = layoutBox.getYorig();
            double d4 = d3 + layoutBox.getHeight();
            int n = 0;
            for (n = 0; n < this.elements.length; ++n) {
                object = this.elements[n];
                if (object.getXorig() < d) {
                    d = object.getXorig();
                }
                if (object.getYorig() < d3) {
                    d3 = object.getYorig();
                }
                if (object.getXorig() + object.getWidth() > d2) {
                    d2 = object.getXorig() + object.getWidth();
                }
                if (!(object.getYorig() + object.getHeight() > d4)) continue;
                d4 = object.getYorig() + object.getHeight();
            }
            if (d != 0.0 || d3 != 0.0) {
                object = new LayoutPoint(-d, -d3);
                for (n = 0; n < this.elements.length; ++n) {
                    this.elements[n].translateOrigin((LayoutPoint)object);
                }
                d2 -= d;
                d4 -= d3;
                d3 = 0.0;
                d = 0.0;
            }
            this.setSize(d2 - d, d4 - d3);
            this.setBaseline((d4 - d3) / 2.0 + this.baselineFF);
            this.setOrigin(d, d3);
            this.validate(true);
        }
    }

    public void setSeparators(int n, int n2) {
        this.rowSeparator = n;
        this.columnSeparator = n2;
    }

    public int getRowSeparator() {
        return this.rowSeparator;
    }

    public int getColumnSeparator() {
        return this.columnSeparator;
    }

    public void setBaselineFudgeFactor(double d) {
        this.baselineFF = d;
    }

    public void setJustification(int n) {
        this.justification = n;
    }

    public void applyLayout() {
        if (!this.isLayoutValid()) {
            this.setOrigin(0.0, 0.0);
            int n = 0;
            for (n = 0; n < this.elements.length; ++n) {
                if (this.elements[n] == null || !this.elements[n].hasChildren()) continue;
                this.elements[n].applyLayout();
            }
            this.insertCells();
            this.computeSize();
        }
    }

    private void insertCells() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.rows > 0 && this.cols > 0) {
            double[] dArray = new double[this.cols];
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            for (n2 = 0; n2 < this.rows; ++n2) {
                Object object;
                int n4 = n = n2 * this.cols;
                double d9 = 0.0;
                d7 = 0.0;
                LayoutBox layoutBox = this.elements[n4];
                d3 = layoutBox.getBaseline();
                d4 = 0.0;
                d5 = layoutBox.getHeight();
                if (layoutBox.getWidth() > dArray[0]) {
                    dArray[0] = layoutBox.getWidth();
                }
                for (n3 = 0; n3 < this.cols; ++n3) {
                    object = this.elements[n4++];
                    object.setOrigin(0.0, d3 - object.getBaseline());
                    d7 = object.getYorig();
                    d6 = object.getXorig();
                    if (!(d7 < d9)) continue;
                    d9 = d7;
                }
                if (d9 < 0.0) {
                    n4 = n;
                    object = new LayoutPoint(0.0, -d9);
                    for (n3 = 0; n3 < this.cols; ++n3) {
                        this.elements[n4++].translateOrigin((LayoutPoint)object);
                    }
                }
                n4 = n;
                for (n3 = 0; n3 < this.cols; ++n3) {
                    int n5 = n4++;
                    object = this.elements[n5];
                    if (object.getWidth() > dArray[n3]) {
                        dArray[n3] = object.getWidth();
                    }
                    if ((d7 = object.getYorig()) < d4) {
                        d4 = d7;
                    }
                    if (!((d7 += object.getHeight()) > d5)) continue;
                    d5 = d7;
                }
                if (d8 != 0.0) {
                    object = new LayoutPoint(0.0, d8);
                    n = n2 * this.cols;
                    for (n3 = 0; n3 < this.cols; ++n3) {
                        LayoutBox layoutBox2 = this.elements[n++];
                        layoutBox2.translateOrigin((LayoutPoint)object);
                    }
                }
                d5 -= d4;
                d8 = d += (d5 += (double)this.rowSeparator);
            }
            for (n2 = 0; n2 < this.rows; ++n2) {
                n = n2 * this.cols;
                d2 = 0.0;
                n3 = 0;
                while (n3 < this.cols) {
                    d7 = this.elements[n].getYorig();
                    d6 = 0.0;
                    if (this.justification != 0) {
                        d6 = dArray[n3] - this.elements[n].getWidth();
                        if (this.justification == 1) {
                            d6 /= 2.0;
                        }
                    }
                    this.elements[n].setOrigin(d6 + d2, d7);
                    d2 += dArray[n3] + (double)this.columnSeparator;
                    ++n3;
                    ++n;
                }
            }
        }
    }

    private static class MatrixLayoutIterator
    implements Iterator {
        private MatrixLayoutBox parent;
        private int offset = 0;

        private MatrixLayoutIterator(MatrixLayoutBox matrixLayoutBox) {
            this.parent = matrixLayoutBox;
        }

        public boolean hasNext() {
            return this.offset < this.parent.numChildren();
        }

        public Object next() {
            LayoutBox layoutBox = this.parent.getChild(this.offset);
            ++this.offset;
            return layoutBox;
        }

        public void remove() {
        }
    }
}

