/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.AbstractBranchLayoutBox;
import com.maplesoft.client.prettyprinter.AbstractFormatter;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutPoint;
import com.maplesoft.client.prettyprinter.PowerAnchorIterator;
import com.maplesoft.client.prettyprinter.TTYFormatter;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import java.util.Iterator;

public class PowerLayoutBox
extends AbstractBranchLayoutBox {
    public static final double EXPONENT_ADJUSTMENT_FACTOR = 0.4;
    public static SelectionData sd = null;
    private static LineBreaker lb = LineBreakerFactory.newLineBreaker((int)9);
    private static final double ITALICS_ADJUSTMENT_FACTOR = 0.19438030913772;
    private boolean forceNoItalicAdjustment = false;
    private AbstractFormatter formatter = null;

    public PowerLayoutBox() {
        this.name = "";
        this.children = new LayoutBox[2];
    }

    public PowerLayoutBox(String string) {
        this();
        this.name = string;
    }

    public PowerLayoutBox(LayoutBox layoutBox, LayoutBox layoutBox2) {
        this.name = "";
        this.children = new LayoutBox[2];
        this.children[0] = layoutBox;
        this.children[1] = layoutBox2;
        this.numChildren = 2;
    }

    public PowerLayoutBox(String string, LayoutBox layoutBox, LayoutBox layoutBox2) {
        this(layoutBox, layoutBox2);
        this.name = string;
    }

    public PowerLayoutBox(String string, LayoutBox layoutBox, LayoutBox layoutBox2, boolean bl) {
        this(string, layoutBox, layoutBox2);
        this.forceNoItalicAdjustment = bl;
    }

    public PowerLayoutBox(LayoutBox layoutBox, LayoutBox layoutBox2, boolean bl, AbstractFormatter abstractFormatter) {
        this(layoutBox, layoutBox2);
        this.forceNoItalicAdjustment = bl;
        this.formatter = abstractFormatter;
    }

    public void setSelectionData(SelectionData selectionData) {
    }

    public SelectionData getSelectionData() {
        if (this.getDefaultSelectionData() == null) {
            this.setDefaultSelectionData(new SelectionData(this.getSelectionCode()));
            int[] nArray = new int[]{0, 1};
            sd.setStandardNorthSouthArray();
            sd.setTraversalEastWest(nArray);
        }
        return sd;
    }

    public void setDefaultSelectionData(SelectionData selectionData) {
        sd = selectionData;
    }

    public SelectionData getDefaultSelectionData() {
        return sd;
    }

    public void setLineBreaker(LineBreaker lineBreaker) {
        lb = lineBreaker;
    }

    public LineBreaker getLineBreaker() {
        return lb;
    }

    public void computeSize() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        LayoutBox layoutBox = this.getChild(0);
        LayoutBox layoutBox2 = this.getChild(1);
        d = layoutBox.getXorig() + layoutBox2.getXorig() + layoutBox2.getWidth();
        double d4 = layoutBox.getHeight();
        if (this.formatter != null && !(this.formatter instanceof TTYFormatter) && d4 == 0.0) {
            d4 = this.formatter.getFontHeight(0);
        }
        d2 = d4 - layoutBox2.getYorig();
        d3 = layoutBox2.getYorig();
        this.baseline = layoutBox.getBaseline();
        if (d3 != 0.0) {
            LayoutPoint layoutPoint = new LayoutPoint(0.0, -d3);
            this.getChild(0).translateOrigin(layoutPoint);
            this.getChild(1).translateOrigin(layoutPoint);
            this.baseline -= d3;
        }
        this.setSize(d, d2);
        this.setOrigin(0.0, 0.0);
        this.validLayout = true;
    }

    public Iterator getAnchors() {
        return new PowerAnchorIterator();
    }

    public void addLayoutAnchor(LayoutAnchor layoutAnchor) {
    }

    public void applyLayout() {
        double d = 0.0;
        if (!this.isLayoutValid()) {
            this.setOrigin(0.0, 0.0);
            if (this.hasChildren()) {
                LayoutBox layoutBox = this.getChild(0);
                LayoutBox layoutBox2 = this.getChild(1);
                if (layoutBox.hasChildren() && !layoutBox.isLayoutValid()) {
                    layoutBox.applyLayout();
                }
                if (layoutBox2.hasChildren() && !layoutBox2.isLayoutValid()) {
                    layoutBox2.applyLayout();
                }
                layoutBox.setOrigin(0.0, 0.0);
                double d2 = 0.0;
                if (this.formatter != null && !(this.formatter instanceof TTYFormatter)) {
                    d2 = this.formatter.getFontHeight(0);
                }
                double d3 = layoutBox.getHeight();
                double d4 = layoutBox.getXorig() + layoutBox.getWidth() + d3 * d;
                double d5 = d2 > 1.0 ? d2 * 0.4 : 0.0;
                double d6 = -1.0 * layoutBox2.getHeight() + d5;
                layoutBox2.setOrigin(d4, d6);
                this.computeSize();
            }
        }
    }
}

