/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.selection;

import com.maplesoft.client.prettyprinter.LayoutBox;

public class SelectionData {
    public static final int NO_SELECTION_CODE = 0;
    public static final int SUBSELECTABLE = 1;
    public static final int SELECT_ALL_ONLY = 16;
    public static final int SELECTABLE = 2;
    public static final int SINGLE_SUBSELECTABLE_OR_ALL = 3;
    public static final int SELECT_ALL_IN_PARENT = 4;
    public static final int CONTEXT_HELP_AVAILABLE = -128;
    public static final int TRAVERSE_ASCEND = -10;
    public static final int TRAVERSE_DESCEND = -12;
    public static final int NORTH = -2;
    public static final int UP = -2;
    public static final int SOUTH = 2;
    public static final int DOWN = 2;
    public static final int EAST = 1;
    public static final int LEFT = 1;
    public static final int WEST = -1;
    public static final int RIGHT = -1;
    private int selectionCode;
    private int[] traversalNorthSouth;
    private int[] traversalEastWest;
    private int firstCaretPosition = 0;
    private int lastCaretPosition = -1;

    public SelectionData() {
        this.setSelectionCode(0);
    }

    public SelectionData(int n) {
        this.setSelectionCode(n);
    }

    public int getSelectionCode() {
        return this.isContextHelpAvailable() ? this.selectionCode ^ 0xFFFFFF80 : this.selectionCode;
    }

    public void setSelectionCode(int n) {
        this.selectionCode = n;
        this.setContextHelpAvailable(true);
    }

    public void setContextHelpAvailable(boolean bl) {
        if (bl) {
            this.selectionCode |= 0xFFFFFF80;
        } else if (!bl && this.isContextHelpAvailable()) {
            this.selectionCode ^= 0xFFFFFF80;
        }
    }

    public boolean isContextHelpAvailable() {
        return (this.selectionCode & 0xFFFFFF80) == -128;
    }

    public void setFirstCaretPosition(int n) {
        this.firstCaretPosition = n;
    }

    public int getFirstCaretPosition() {
        return this.firstCaretPosition;
    }

    public void setLastCaretPosition(int n) {
        this.lastCaretPosition = n;
    }

    public int getLastCaretPosition() {
        return this.lastCaretPosition;
    }

    public boolean isIndividuallySelectable() {
        return this.getSelectionCode() == 1;
    }

    public void setTraversalNorthSouth(int[] nArray) {
        this.traversalNorthSouth = nArray;
    }

    public void setTraversalEastWest(int[] nArray) {
        this.traversalEastWest = nArray;
    }

    public static boolean isUp(int n) {
        return n == -2;
    }

    public static boolean isDown(int n) {
        return n == 2;
    }

    public static boolean isLeft(int n) {
        return n == -1;
    }

    public static boolean isRight(int n) {
        return n == 1;
    }

    public static boolean isUpDown(int n) {
        return n == -2 || n == 2;
    }

    public static boolean isRightLeft(int n) {
        return n == 1 || n == -1;
    }

    public static boolean isNorth(int n) {
        return SelectionData.isUp(n);
    }

    public static boolean isSouth(int n) {
        return SelectionData.isDown(n);
    }

    public static boolean isWest(int n) {
        return SelectionData.isLeft(n);
    }

    public static boolean isEast(int n) {
        return SelectionData.isRight(n);
    }

    public static boolean isNorthSouth(int n) {
        return SelectionData.isUpDown(n);
    }

    public static boolean isEastWest(int n) {
        return SelectionData.isRightLeft(n);
    }

    public static int determineTraversalDirection(int n) {
        int n2 = 0;
        if (n == 38 || n == 224) {
            n2 = -2;
        } else if (n == 40 || n == 225) {
            n2 = 2;
        } else if (n == 39 || n == 227) {
            n2 = 1;
        } else if (n == 37 || n == 226) {
            n2 = -1;
        }
        return n2;
    }

    public static int defaultTraversal(int n, int n2) {
        if (SelectionData.isUp(n2)) {
            --n;
        } else if (SelectionData.isDown(n2)) {
            ++n;
        } else if (SelectionData.isRight(n2)) {
            ++n;
        } else if (SelectionData.isLeft(n2)) {
            --n;
        }
        return n;
    }

    public int traverse(int n, int n2) {
        int n3 = 0;
        if (Math.abs(n2) == 2) {
            n2 = n2 < 0 ? -1 : 1;
            n3 = n + n2 < 0 || n + n2 >= this.traversalNorthSouth.length ? -10 : this.traversalNorthSouth[n + n2];
        } else {
            n3 = n + n2 < 0 || n + n2 >= this.traversalEastWest.length ? -10 : this.traversalEastWest[n + n2];
        }
        return n3;
    }

    public void setStandardEastWestArray(LayoutBox layoutBox) {
        int[] nArray = new int[2];
        int n = 0;
        nArray[1] = -10;
        nArray[0] = -10;
        if (layoutBox != null && (n = layoutBox.numChildren()) > 0) {
            nArray = new int[n + 1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
            nArray[n] = -10;
        }
        this.setTraversalEastWest(nArray);
    }

    public void setStandardNorthSouthArray() {
        int[] nArray = new int[2];
        nArray[1] = -10;
        nArray[0] = -10;
        this.setTraversalNorthSouth(nArray);
    }

    public int getTraversalArrayIndex(int n, int n2) {
        int n3;
        block3: {
            block4: {
                n3 = 0;
                if (!SelectionData.isRightLeft(n2)) break block4;
                if (this.traversalEastWest == null) break block3;
                for (int i = 0; i < this.traversalEastWest.length; ++i) {
                    if (this.traversalEastWest[i] != n) continue;
                    n3 = i;
                    break block3;
                }
                break block3;
            }
            if (this.traversalNorthSouth != null) {
                for (int i = 0; i < this.traversalNorthSouth.length; ++i) {
                    if (this.traversalNorthSouth[i] != n) continue;
                    n3 = i;
                    break;
                }
            }
        }
        return n3;
    }
}

