/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.prettyprinter.AncestorArrayLayoutBox;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;
import java.util.LinkedList;

public class VectorShorthandTemplate
implements SpecialFunctionTemplate {
    private int separator;

    public VectorShorthandTemplate(int n) {
        this.separator = n;
    }

    public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
        VectorShorthandLayoutBox vectorShorthandLayoutBox = new VectorShorthandLayoutBox();
        for (int i = 0; i < dagArray.length; ++i) {
            Dag dag2 = dagArray[i];
            int[] nArray = this.getAncestorPath(dag, dag2);
            if (dag2.getType() == 29) {
                int n = dag2.getLength();
                for (int j = 0; j < n; ++j) {
                    this.buildLayout(layoutFormatter, vectorShorthandLayoutBox, this.separator, dag, dag2.getChild(j), i);
                }
                continue;
            }
            this.buildLayout(layoutFormatter, vectorShorthandLayoutBox, this.separator, dag, dag2, i);
        }
        return BracketTemplate.apply(layoutFormatter, (LayoutBox)vectorShorthandLayoutBox, 26, 27);
    }

    private void buildLayout(LayoutFormatter layoutFormatter, LayoutBox layoutBox, int n, Dag dag, Dag dag2, int n2) {
        NotationLayoutBox notationLayoutBox = NotationLayoutBox.createNotationBox(layoutFormatter, n);
        LayoutBox layoutBox2 = DagBuilder.createLayout(layoutFormatter, dag2);
        layoutBox2 = BracketTemplate.apply(layoutFormatter, layoutBox2, dag2, 20);
        int[] nArray = this.getAncestorPath(dag, dag2);
        layoutBox2 = AncestorArrayLayoutBox.wrapWithAncestorData(layoutBox2, dag, nArray);
        if (n2 > 0) {
            layoutBox.addChild(notationLayoutBox);
        }
        layoutBox.addChild(layoutBox2);
    }

    private int[] getAncestorPath(Dag dag, Dag dag2) {
        LinkedList linkedList = this.generateDagPath(dag, dag2, null);
        int[] nArray = this.generateAncestorPath(linkedList);
        return nArray;
    }

    private int[] generateAncestorPath(LinkedList linkedList) {
        int[] nArray = new int[linkedList.size() - 1];
        Dag dag = (Dag)linkedList.removeLast();
        int n = 0;
        while (linkedList.size() > 0) {
            Dag dag2 = (Dag)linkedList.removeLast();
            nArray[n++] = this.getIndex(dag, dag2);
            dag = dag2;
        }
        return nArray;
    }

    private int getIndex(Dag dag, Dag dag2) {
        int n = -1;
        for (int i = 0; i < dag.getLength(); ++i) {
            if (dag2 != dag.getChild(i)) continue;
            n = i;
            break;
        }
        return n;
    }

    private LinkedList generateDagPath(Dag dag, Dag dag2, LinkedList linkedList) {
        LinkedList linkedList2 = linkedList = linkedList == null ? new LinkedList() : linkedList;
        if (linkedList.size() > 0 && linkedList.getFirst() == dag2) {
            return linkedList;
        }
        linkedList.addFirst(dag);
        for (int i = 0; i < dag.getLength(); ++i) {
            Dag dag3 = dag.getChild(i);
            if (dag3 == dag2) {
                linkedList.addFirst(dag3);
                return linkedList;
            }
            if (dag3.getLength() <= 0 || (linkedList = this.generateDagPath(dag3, dag2, linkedList)).getFirst() == dag2) continue;
            while (linkedList.getFirst() != dag3) {
                linkedList.removeFirst();
            }
            linkedList.removeFirst();
        }
        return linkedList;
    }

    static class VectorShorthandLayoutBox
    extends InlineLayoutBox {
        private static LineBreaker lb = LineBreakerFactory.newLineBreaker((int)2);

        VectorShorthandLayoutBox(String string, int n) {
            super(string, n);
        }

        VectorShorthandLayoutBox() {
        }

        public void setLineBreaker(LineBreaker lineBreaker) {
        }

        public LineBreaker getLineBreaker() {
            return lb;
        }
    }
}

