/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiDropDownButton;
import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class WmiCompositeDropDownButton
extends WmiDropDownButton {
    private JMenu menu = null;
    private AbstractButton[] buttons = null;
    private WmiCommand[] commands = null;
    private ButtonGroup group = null;
    private int selectedIndex = 0;

    public static void updateContext(WmiCompositeDropDownButton wmiCompositeDropDownButton, String[] stringArray, WmiView wmiView) {
        for (int i = 0; i < stringArray.length; ++i) {
            AbstractButton abstractButton = wmiCompositeDropDownButton.getButtonAtIndex(i);
            WmiCommandProxy wmiCommandProxy = WmiCommand.getCommandProxy(stringArray[i]);
            if (wmiCommandProxy == null) continue;
            WmiMathDocumentView wmiMathDocumentView = wmiView != null ? wmiView.getDocumentView() : null;
            boolean bl = ((WmiCommand)wmiCommandProxy).isEnabled(wmiMathDocumentView);
            boolean bl2 = ((WmiCommand)wmiCommandProxy).isSelected(wmiMathDocumentView);
            wmiCommandProxy.setEnabled(bl);
            abstractButton.setEnabled(bl);
            if (!bl2) continue;
            wmiCompositeDropDownButton.setSelectedIndex(i);
        }
    }

    public WmiCompositeDropDownButton(AbstractButton[] abstractButtonArray) {
        this(abstractButtonArray, 0);
    }

    public WmiCompositeDropDownButton(AbstractButton[] abstractButtonArray, int n) {
        this.initializeButtons(abstractButtonArray, n);
    }

    public WmiCompositeDropDownButton(String[] stringArray) {
        this(stringArray, 0);
    }

    public WmiCompositeDropDownButton(String[] stringArray, int n) {
        this(stringArray, n, 1);
    }

    public WmiCompositeDropDownButton(String[] stringArray, int n, int n2) {
        this.commands = WmiCompositeDropDownButton.getCommands(stringArray);
        AbstractButton[] abstractButtonArray = WmiCompositeDropDownButton.getButtons(this.commands, n2);
        this.initializeButtons(abstractButtonArray, n);
    }

    private void initializeButtons(AbstractButton[] abstractButtonArray, int n) {
        this.buttons = abstractButtonArray;
        this.menu = new JMenu();
        this.group = new ButtonGroup();
        for (int i = 0; i < abstractButtonArray.length; ++i) {
            JMenuItem jMenuItem = this.createMenuItem(abstractButtonArray[i], i);
            this.menu.add(jMenuItem);
        }
        this.popupMenu = this.menu.getPopupMenu();
        this.popupMenu.addPopupMenuListener(new DropDownMenuPopupListener());
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!WmiCompositeDropDownButton.this.popupMenu.isVisible()) {
                    WmiCompositeDropDownButton.this.doClickAtIndex(WmiCompositeDropDownButton.this.getSelectedIndex());
                }
            }
        });
        this.setSelectedIndex(n);
    }

    public void addMenuListener(MenuListener menuListener) {
        if (this.menu != null) {
            this.menu.addMenuListener(menuListener);
        }
    }

    public void removeMenuListener(MenuListener menuListener) {
        if (this.menu != null) {
            this.menu.removeMenuListener(menuListener);
        }
    }

    public void setSelectedIndex(int n) {
        this.selectedIndex = n;
        this.setIconIndex(n);
        this.setToolTipText(this.buttons[n].getToolTipText());
        JMenuItem jMenuItem = this.menu.getItem(n);
        jMenuItem.setSelected(true);
    }

    public void setSelectedButton(AbstractButton abstractButton) {
        if (this.buttons != null) {
            for (int i = 0; i < this.buttons.length; ++i) {
                if (this.buttons[i] != abstractButton) continue;
                this.setSelectedIndex(i);
                break;
            }
        }
    }

    public void showButtonAtIndex(int n, boolean bl) {
        this.menu.getItem(n).setVisible(bl);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public AbstractButton getButtonAtIndex(int n) {
        return this.buttons != null ? this.buttons[n] : null;
    }

    public AbstractButton getSelectedButton() {
        return this.buttons != null ? this.buttons[this.selectedIndex] : null;
    }

    public void doClickAtIndex(int n) {
        if (this.buttons != null) {
            final int n2 = n;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WmiCompositeDropDownButton.this.buttons[n2].doClick();
                }
            });
            if (n != this.getSelectedIndex()) {
                this.setSelectedIndex(n);
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.group = null;
        if (this.menu != null) {
            this.menu.removeAll();
        }
        this.menu = null;
        if (this.buttons != null) {
            Arrays.fill(this.buttons, null);
        }
        this.buttons = null;
    }

    private void setIconIndex(int n) {
        if (this.buttons != null) {
            AbstractButton abstractButton = this.buttons[n];
            this.setIcon(abstractButton.getIcon());
            this.setDisabledIcon(abstractButton.getDisabledIcon());
            this.setPressedIcon(abstractButton.getPressedIcon());
        }
    }

    private JMenuItem createMenuItem(AbstractButton abstractButton, int n) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
        jCheckBoxMenuItem.setIcon(abstractButton.getIcon());
        jCheckBoxMenuItem.setText(abstractButton.getText());
        jCheckBoxMenuItem.addActionListener(new DropDownMenuSelectionListener(n));
        this.group.add(jCheckBoxMenuItem);
        return jCheckBoxMenuItem;
    }

    private static WmiCommand[] getCommands(String[] stringArray) {
        WmiCommand[] wmiCommandArray = new WmiCommand[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            wmiCommandArray[i] = WmiCommand.getCommandProxy(stringArray[i]);
        }
        return wmiCommandArray;
    }

    private static AbstractButton[] getButtons(WmiCommand[] wmiCommandArray, int n) {
        AbstractButton[] abstractButtonArray = new AbstractButton[wmiCommandArray.length];
        for (int i = 0; i < wmiCommandArray.length; ++i) {
            abstractButtonArray[i] = wmiCommandArray[i].createButton(n);
        }
        return abstractButtonArray;
    }

    private class DropDownMenuSelectionListener
    implements ActionListener {
        private int index;

        private DropDownMenuSelectionListener(int n) {
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WmiCompositeDropDownButton.this.doClickAtIndex(this.index);
        }
    }

    private class DropDownMenuPopupListener
    implements PopupMenuListener {
        private DropDownMenuPopupListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            WmiCompositeDropDownButton.this.repaint();
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            WmiCompositeDropDownButton.this.repaint();
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            if (WmiCompositeDropDownButton.this.menu != null && WmiCompositeDropDownButton.this.commands != null) {
                for (int i = 0; i < WmiCompositeDropDownButton.this.menu.getItemCount(); ++i) {
                    if (WmiCompositeDropDownButton.this.commands[i] == null) continue;
                    WmiCompositeDropDownButton.this.menu.getItem(i).setEnabled(WmiCompositeDropDownButton.this.commands[i].isEnabled());
                }
            }
        }
    }
}

