/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiContextManager;
import com.maplesoft.mathdoc.components.WmiContextualMenu;
import com.maplesoft.mathdoc.components.WmiMathMLEditorButtonMenu;
import com.maplesoft.mathdoc.controller.WmiMenu;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiMathMLEditorDocumentView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class WmiMathMLContextMenuManager
extends WmiContextManager {
    public static final String CONTEXT_RESOURCES = "com.maplesoft.mathdoc.components.resources.palette.Palette";
    public static final String CONTEXT_MENUS = "contextMenus";
    public static final String MATHML_EDITOR_MENU = "MathMLEditorContextMenu";
    private static final String RESOURCES = "com/maplesoft/mathdoc/components/resources/palette/";
    private Hashtable tagToMenu = new Hashtable();
    private boolean popupEnabled = true;

    public WmiMathMLContextMenuManager(WmiMathMLEditorDocumentView wmiMathMLEditorDocumentView) {
        this(3, wmiMathMLEditorDocumentView, false);
    }

    public WmiMathMLContextMenuManager(int n, WmiMathMLEditorDocumentView wmiMathMLEditorDocumentView, boolean bl) {
        this.constructContextMenu(n, wmiMathMLEditorDocumentView, bl, "");
    }

    public WmiMathMLContextMenuManager(int n, WmiMathMLEditorDocumentView wmiMathMLEditorDocumentView, String string) {
        this.constructContextMenu(n, wmiMathMLEditorDocumentView, false, string);
    }

    private void constructContextMenu(int n, WmiMathMLEditorDocumentView wmiMathMLEditorDocumentView, boolean bl, String string) {
        WmiResourcePackage wmiResourcePackage = WmiResourcePackage.getResourcePackage(CONTEXT_RESOURCES);
        String string2 = wmiResourcePackage.getStringForKey(CONTEXT_MENUS);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                WmiContextualMenu wmiContextualMenu;
                String string3 = stringTokenizer.nextToken();
                if (string3.trim().length() <= 0) continue;
                WmiModelTag wmiModelTag = null;
                if (string3.equals(MATHML_EDITOR_MENU)) {
                    wmiContextualMenu = new WmiMathMLEditorButtonMenu(string3, CONTEXT_RESOURCES, RESOURCES, n, wmiMathMLEditorDocumentView, true, bl, string);
                    wmiModelTag = WmiModelUtil.getTagForString(wmiContextualMenu.getModelTagString());
                    if (wmiModelTag == null) continue;
                    this.tagToMenu.put(wmiModelTag, wmiContextualMenu);
                    continue;
                }
                wmiContextualMenu = new WmiContextualMenu(string3, CONTEXT_RESOURCES);
                wmiModelTag = WmiModelUtil.getTagForString(wmiContextualMenu.getModelTagString());
                if (wmiModelTag == null) continue;
                this.tagToMenu.put(wmiModelTag, wmiContextualMenu);
            }
        }
    }

    public WmiContextualMenu getMenuForModel(WmiModel wmiModel) {
        WmiModelTag wmiModelTag = wmiModel.getTag();
        WmiContextualMenu wmiContextualMenu = (WmiContextualMenu)this.tagToMenu.get(wmiModelTag);
        return wmiContextualMenu;
    }

    public void popupRequestNotification(WmiView wmiView, MouseEvent mouseEvent) {
        if (!this.popupEnabled) {
            return;
        }
        WmiMathMLEditorDocumentView wmiMathMLEditorDocumentView = (WmiMathMLEditorDocumentView)wmiView;
        WmiSelection wmiSelection = wmiMathMLEditorDocumentView.getSelection();
        this.setContextForDocument(wmiMathMLEditorDocumentView);
        WmiMenu wmiMenu = this.getActiveContextualMenu();
        if (wmiMenu == null) {
            this.buildMenu();
            wmiMenu = this.getActiveContextualMenu();
        }
        if (wmiMenu != null) {
            if (wmiMenu instanceof WmiMathMLEditorButtonMenu) {
                ((WmiMathMLEditorButtonMenu)wmiMenu).show(wmiMathMLEditorDocumentView, mouseEvent.getX(), mouseEvent.getY());
            } else {
                JPopupMenu jPopupMenu = wmiMenu.getPopupMenu();
                wmiMenu.setSelected(true);
                jPopupMenu.show(wmiMathMLEditorDocumentView, mouseEvent.getX(), mouseEvent.getY());
            }
            this.setContextForDocument(wmiMathMLEditorDocumentView);
        }
    }

    public void setPopupEnabled(boolean bl) {
        this.popupEnabled = bl;
    }

    public void popdownMenu() {
        WmiMenu wmiMenu = this.getActiveContextualMenu();
        if (wmiMenu != null && wmiMenu instanceof WmiMathMLEditorButtonMenu) {
            ((WmiMathMLEditorButtonMenu)wmiMenu).hide();
        }
    }

    protected void addCommonMenuElements(JMenu jMenu) {
    }

    protected void removeCommonMenuElements(JMenu jMenu) {
    }
}

