/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiContextualMenu;
import com.maplesoft.mathdoc.components.WmiMathMLMenuParser;
import com.maplesoft.mathdoc.components.palettes.WmiMathMLEditorPalette;
import com.maplesoft.mathdoc.components.palettes.WmiMathMLEditorPaletteManager;
import com.maplesoft.mathdoc.components.palettes.WmiMathMLPaletteButtonFactory;
import com.maplesoft.mathdoc.controller.WmiMenu;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorDictionary;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiMathMLEditorDocumentView;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.WmiMathEntityNameMapper;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class WmiMathMLEditorButtonMenu
extends WmiContextualMenu {
    public static final String BUTTON_PREFERRED_WIDTH_PROPERTY = "button.preferred.width";
    public static final String BUTTON_PREFERRED_HEIGHT_PROPERTY = "button.preferred.height";
    public static final int DEFAULT_BUTTON_WIDTH = 50;
    public static final int DEFAULT_BUTTON_HEIGHT = 40;
    private WmiMathMLEditorPaletteManager paletteManager;
    protected static WmiMathMLPaletteButtonFactory buttonFactory = null;
    protected JWindow activePaletteWindow = null;
    protected WmiMathMLEditorButtonMenu activeMenu = null;
    protected AbstractButton activeButton = null;
    public WmiMathMLButtonMenuPanel buttonPanel;
    public JWindow buttonMenuWindow = null;
    public JWindow buttonSubmenuWindow = null;
    private boolean paletteOpenMode = false;
    private boolean menuOpenMode = false;
    public boolean buildForToolbar = false;
    public int buttonWidth;
    public int buttonHeight;
    private WmiMathDocumentView view;
    private AbstractButton currentTopMenuItem = null;
    private WmiMathMLEditorButtonMenu parentMenu = null;
    private WmiMathMLEditorButtonMenu childMenu = null;
    private ArrayList actionControllerCallerList = new ArrayList();

    public WmiMathMLEditorButtonMenu(String string, String string2, String string3, int n, WmiMathMLEditorDocumentView wmiMathMLEditorDocumentView, boolean bl, boolean bl2, String string4) {
        super(string, string2, string3, bl2, string4);
        this.view = wmiMathMLEditorDocumentView;
        try {
            this.buttonWidth = Integer.parseInt(this.getMenuResourceBundle().getStringForKey(BUTTON_PREFERRED_WIDTH_PROPERTY));
            this.buttonHeight = Integer.parseInt(this.getMenuResourceBundle().getStringForKey(BUTTON_PREFERRED_HEIGHT_PROPERTY));
        }
        catch (Exception exception) {
            this.buttonWidth = 50;
            this.buttonHeight = 40;
        }
        this.buttonPanel = new WmiMathMLButtonMenuPanel();
        BoxLayout boxLayout = new BoxLayout(this.buttonPanel, n);
        this.buttonPanel.setLayout(boxLayout);
        this.paletteManager = new WmiMathMLEditorPaletteManager(bl2);
        if (bl && string4.equals("")) {
            this.createPalettes();
        }
        this.paletteManager.setView(wmiMathMLEditorDocumentView);
    }

    public void setParentMenu(WmiMathMLEditorButtonMenu wmiMathMLEditorButtonMenu) {
        this.parentMenu = wmiMathMLEditorButtonMenu;
    }

    public void setChildMenu(WmiMathMLEditorButtonMenu wmiMathMLEditorButtonMenu) {
        this.childMenu = wmiMathMLEditorButtonMenu;
    }

    public void setButtonWidth(int n) {
        this.buttonWidth = n;
    }

    public String getImageResourcePath() {
        return this.imageResourcePath;
    }

    public void removeAll() {
        super.removeAll();
        this.buttonPanel.removeAll();
    }

    protected void buildMenu() {
        if (this.buildForToolbar || this.buttonMenuWindow != null) {
            if (this.menuXML.equals("")) {
                WmiMathMLEditorButtonMenu.buildMenu(this.menuKey, this);
            } else {
                this.buildMenu(this.menuKey, this, this.menuXML, (WmiMathMLEditorDocumentView)this.view);
            }
        }
    }

    protected static void buildMenu(String string, WmiMenu wmiMenu) {
        String string2 = wmiMenu.getMenuElementKeys(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3;
                String string4 = stringTokenizer.nextToken();
                String string5 = wmiMenu.getItemNameForKey(string + "." + string4);
                if (string5 == null) {
                    string5 = string4;
                }
                if ((string3 = wmiMenu.getMenuElementKeys(string + "." + string4)) != null) continue;
                ((WmiMathMLEditorButtonMenu)wmiMenu).createMenuItem(string5);
            }
        }
    }

    protected void buildMenu(String string, WmiMenu wmiMenu, String string2, WmiMathMLEditorDocumentView wmiMathMLEditorDocumentView) {
        WmiMathMLMenuParser wmiMathMLMenuParser = new WmiMathMLMenuParser(wmiMenu, string2, wmiMathMLEditorDocumentView);
        wmiMathMLMenuParser.parse();
    }

    private JWindow createJWindowWithSharedOwner(Component component) {
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, component);
        JWindow jWindow = null;
        if (window instanceof Dialog) {
            jWindow = new JWindow(window);
        } else if (window instanceof Frame) {
            jWindow = new JWindow((Frame)window);
        } else {
            throw new IllegalArgumentException("component has no window");
        }
        jWindow.setFocusableWindowState(false);
        return jWindow;
    }

    protected void createMenuItem(String string) {
        String string2 = this.getIconNameForKey(string);
        AbstractButton abstractButton = buttonFactory.createButton(this.imageResourcePath, string2, true, 0, 0);
        abstractButton.setPreferredSize(new Dimension(this.buttonWidth, this.buttonHeight));
        this.buttonPanel.addMenuItem(abstractButton);
        WmiMathMLEditorPalette wmiMathMLEditorPalette = null;
        wmiMathMLEditorPalette = this.paletteManager.getPaletteByName(string);
        if (wmiMathMLEditorPalette != null) {
            if (this.buttonMenuWindow == null) {
                this.buttonMenuWindow = this.createJWindowWithSharedOwner(this.paletteManager.getView());
            }
            JWindow jWindow = this.createJWindowWithSharedOwner(this.buttonMenuWindow);
            jWindow.getContentPane().add(wmiMathMLEditorPalette);
            jWindow.pack();
            wmiMathMLEditorPalette.setMenu(this);
            WmiMathMLButtonListener wmiMathMLButtonListener = new WmiMathMLButtonListener(abstractButton, jWindow);
            abstractButton.addActionListener(wmiMathMLButtonListener);
            abstractButton.addMouseListener(wmiMathMLButtonListener);
        }
    }

    protected AbstractButton createMenuItem(WmiMathMLEditorPalette wmiMathMLEditorPalette, WmiResourcePackage wmiResourcePackage, String string, boolean bl) {
        wmiMathMLEditorPalette.setMenu(this);
        AbstractButton abstractButton = null;
        String string2 = this.getIconNameForKey(string);
        if (string2 != null) {
            abstractButton = buttonFactory.createButton(this.imageResourcePath, string2, !bl, this.buttonWidth, this.buttonHeight);
        } else {
            String string3 = wmiResourcePackage.getStringForKey(string + ".insert.2dmath");
            String string4 = "";
            if (string3 != null) {
                string4 = string3;
                abstractButton = buttonFactory.createButton(string3, !bl, this.buttonWidth, this.buttonHeight);
            } else if (WmiMathEntityNameMapper.getUnicodeCharacter(string) != '\u0000') {
                string4 = WmiMathOperatorDictionary.isNameForOperator("&" + string + ";") ? "<mrow><mo>&" + string + ";" + "</mo></mrow>" : "<mrow><mi>&" + string + ";" + "</mi></mrow>";
                abstractButton = buttonFactory.createButton(string4, !bl, this.buttonWidth, this.buttonHeight);
            } else {
                string4 = WmiMathOperatorDictionary.isNameForOperator(string) ? "<mrow><mo>" + string + "</mo></mrow>" : "<mrow><mi>" + string + "</mi></mrow>";
                abstractButton = string.length() == 1 ? buttonFactory.createButton(string.charAt(0), !bl) : buttonFactory.createButton(string4, !bl, this.buttonWidth, this.buttonHeight);
            }
            if (bl) {
                wmiMathMLEditorPalette.getInsert2DMathList().add(string4);
            }
        }
        return abstractButton;
    }

    protected void createMenuItemButton(String string, WmiResourcePackage wmiResourcePackage, String string2) {
        WmiMathMLEditorPalette wmiMathMLEditorPalette = (WmiMathMLEditorPalette)this.paletteManager.createEmptyPalette(string);
        AbstractButton abstractButton = this.createMenuItem(wmiMathMLEditorPalette, wmiResourcePackage, string, true);
        abstractButton.setToolTipText(string2);
        wmiMathMLEditorPalette.getButtonToIndex().put(abstractButton, new Integer(0));
        WmiMathMLEditorPalette.MathMLActionControllerCaller mathMLActionControllerCaller = new WmiMathMLEditorPalette.MathMLActionControllerCaller(wmiMathMLEditorPalette);
        this.actionControllerCallerList.add(mathMLActionControllerCaller);
        WmiMathMLButtonListener wmiMathMLButtonListener = new WmiMathMLButtonListener(abstractButton, null);
        abstractButton.addMouseListener(wmiMathMLButtonListener);
        this.buttonPanel.addMenuItem(abstractButton);
    }

    protected WmiMathMLEditorPalette createMenuButton(String string, WmiResourcePackage wmiResourcePackage, String string2) {
        WmiMathMLEditorPalette wmiMathMLEditorPalette = (WmiMathMLEditorPalette)this.paletteManager.createEmptyPalette(string);
        this.currentTopMenuItem = this.createMenuItem(wmiMathMLEditorPalette, wmiResourcePackage, string, false);
        if (this.currentTopMenuItem.getIcon() == null) {
            this.buttonPanel.addMenuItem(this.currentTopMenuItem);
        } else {
            this.buttonPanel.add(this.currentTopMenuItem);
        }
        if (string2 != null && !string2.trim().equals("")) {
            this.currentTopMenuItem.setToolTipText(string2);
        }
        if (wmiMathMLEditorPalette != null) {
            if (this.buttonMenuWindow == null) {
                this.buttonMenuWindow = this.createJWindowWithSharedOwner(this.paletteManager.getView());
            }
            JWindow jWindow = this.createJWindowWithSharedOwner(this.buttonMenuWindow);
            jWindow.getContentPane().add(wmiMathMLEditorPalette);
            wmiMathMLEditorPalette.setMenu(this);
            WmiMathMLButtonListener wmiMathMLButtonListener = new WmiMathMLButtonListener(this.currentTopMenuItem, jWindow);
            this.currentTopMenuItem.addActionListener(wmiMathMLButtonListener);
            this.currentTopMenuItem.addMouseListener(wmiMathMLButtonListener);
        }
        return wmiMathMLEditorPalette;
    }

    protected void replacePaletteWithMenu(WmiMathMLEditorButtonMenu wmiMathMLEditorButtonMenu, WmiMathMLEditorDocumentView wmiMathMLEditorDocumentView) {
        if (this.currentTopMenuItem != null) {
            MouseListener[] mouseListenerArray = this.currentTopMenuItem.getMouseListeners();
            for (int i = 0; i < mouseListenerArray.length; ++i) {
                if (!(mouseListenerArray[i] instanceof WmiMathMLButtonListener)) continue;
                ((WmiMathMLButtonListener)mouseListenerArray[i]).setMenu(wmiMathMLEditorButtonMenu, wmiMathMLEditorDocumentView);
            }
        }
        wmiMathMLEditorButtonMenu.buttonMenuWindow = null;
        wmiMathMLEditorButtonMenu.setParentMenu(this);
        this.setChildMenu(wmiMathMLEditorButtonMenu);
    }

    private void createPalettes() {
        if (this.paletteManager != null) {
            List list = this.paletteManager.getPaletteNames();
            for (int i = 0; i < list.size(); ++i) {
                this.paletteManager.createPalette(list.get(i).toString(), null);
            }
        }
    }

    public String getIconNameForKey(String string) {
        return this.getMenuResourceBundle().getStringForKey(string + ".icon");
    }

    public WmiContextualMenu copyMenu() {
        WmiMathMLEditorButtonMenu wmiMathMLEditorButtonMenu = null;
        try {
            wmiMathMLEditorButtonMenu = (WmiMathMLEditorButtonMenu)this.clone();
            if (wmiMathMLEditorButtonMenu != null) {
                wmiMathMLEditorButtonMenu.removeAll();
                wmiMathMLEditorButtonMenu.buildMenu();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            WmiErrorLog.log(cloneNotSupportedException);
        }
        return wmiMathMLEditorButtonMenu;
    }

    public void show(WmiMathDocumentView wmiMathDocumentView, int n, int n2) {
        this.view = wmiMathDocumentView;
        if (this.buttonMenuWindow == null) {
            this.buttonMenuWindow = this.createJWindowWithSharedOwner(wmiMathDocumentView);
            if (this.buttonPanel.getComponentCount() == 0) {
                this.buildMenu();
            }
            this.buttonMenuWindow.getContentPane().add(this.buttonPanel);
        }
        Point point = wmiMathDocumentView.getLocationOnScreen();
        this.buttonMenuWindow.setLocation(point.x + n, point.y + n2);
        this.buttonMenuWindow.pack();
        this.buttonMenuWindow.setVisible(true);
        this.buttonMenuWindow.toFront();
    }

    public void showSubmenu(WmiMathDocumentView wmiMathDocumentView, int n, int n2) {
        this.view = wmiMathDocumentView;
        if (this.buttonSubmenuWindow != null) {
            this.buttonSubmenuWindow.setVisible(false);
            this.buttonSubmenuWindow.dispose();
        }
        this.buttonSubmenuWindow = this.createJWindowWithSharedOwner(wmiMathDocumentView);
        this.buttonSubmenuWindow.getContentPane().add(this.buttonPanel);
        Point point = wmiMathDocumentView.getLocationOnScreen();
        this.buttonSubmenuWindow.setLocation(n, n2);
        this.buttonSubmenuWindow.pack();
        this.buttonSubmenuWindow.setVisible(true);
        this.buttonSubmenuWindow.toFront();
    }

    public void hide() {
        boolean bl = false;
        if (this.buttonSubmenuWindow != null) {
            this.buttonSubmenuWindow.setVisible(false);
            this.buttonSubmenuWindow.dispose();
            this.buttonSubmenuWindow = null;
            bl = true;
        }
        if (this.buttonMenuWindow != null) {
            this.buttonMenuWindow.setVisible(false);
            this.buttonMenuWindow.dispose();
            this.buttonMenuWindow = null;
            bl = true;
        }
        if (this.menuOpenMode) {
            this.activeMenu.hide();
        }
        if (bl && this.parentMenu != null) {
            this.parentMenu.hide();
        }
        if (this.activePaletteWindow != null && this.activePaletteWindow.isVisible()) {
            this.activePaletteWindow.setVisible(false);
            this.activePaletteWindow = null;
        }
        this.paletteOpenMode = false;
        this.menuOpenMode = false;
        this.paletteManager.getView().requestFocusInWindow();
    }

    public void hideSubmenu() {
        if (this.buttonSubmenuWindow != null) {
            this.buttonSubmenuWindow.setVisible(false);
            this.buttonSubmenuWindow.dispose();
            this.buttonSubmenuWindow = null;
            if (this.activePaletteWindow != null && this.activePaletteWindow.isVisible()) {
                this.activePaletteWindow.setVisible(false);
                this.activePaletteWindow = null;
            }
        }
        if (this.menuOpenMode) {
            this.activeMenu.hide();
        }
    }

    public void setActivePaletteWindow(JWindow jWindow) {
        this.activePaletteWindow = jWindow;
    }

    public WmiMathMLEditorPalette.MathMLActionControllerCaller findControllerCaller(AbstractButton abstractButton) {
        for (int i = 0; i < this.actionControllerCallerList.size(); ++i) {
            WmiMathMLEditorPalette.MathMLActionControllerCaller mathMLActionControllerCaller = (WmiMathMLEditorPalette.MathMLActionControllerCaller)this.actionControllerCallerList.get(i);
            if (!mathMLActionControllerCaller.handlesButton(abstractButton)) continue;
            return mathMLActionControllerCaller;
        }
        return null;
    }

    static {
        buttonFactory = new WmiMathMLPaletteButtonFactory();
    }

    public class WmiMathMLButtonMenuPanel
    extends JPanel {
        WmiMathMLButtonMenuPanel() {
        }

        public WmiMathMLEditorPaletteManager getPaletteManager() {
            return WmiMathMLEditorButtonMenu.this.paletteManager;
        }

        public void addMenuItem(AbstractButton abstractButton) {
            GridBagLayout gridBagLayout = new GridBagLayout();
            JPanel jPanel = new JPanel(gridBagLayout);
            GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(jPanel);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(abstractButton, gridBagConstraints);
            jPanel.add(abstractButton);
            this.add(jPanel);
        }
    }

    public class WmiMathMLButtonListener
    implements ActionListener,
    MouseListener {
        private AbstractButton menuItem;
        private JWindow paletteWindow;
        private WmiMathMLEditorButtonMenu menu;
        private WmiMathMLEditorDocumentView view;

        public WmiMathMLButtonListener(AbstractButton abstractButton, JWindow jWindow) {
            this.menuItem = abstractButton;
            this.paletteWindow = jWindow;
            this.menu = null;
            this.view = null;
        }

        public void setMenu(WmiMathMLEditorButtonMenu wmiMathMLEditorButtonMenu, WmiMathMLEditorDocumentView wmiMathMLEditorDocumentView) {
            this.menu = wmiMathMLEditorButtonMenu;
            this.view = wmiMathMLEditorDocumentView;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (WmiMathMLEditorButtonMenu.this.menuOpenMode && WmiMathMLEditorButtonMenu.this.activeMenu != this.menu) {
                WmiMathMLEditorButtonMenu.this.activeMenu.hideSubmenu();
            }
            if (this.menu != null) {
                if (actionEvent != null) {
                    AbstractButton abstractButton;
                    WmiMathMLEditorButtonMenu.this.activeButton = abstractButton = (AbstractButton)actionEvent.getSource();
                    int n = (int)WmiMathMLEditorButtonMenu.this.activeButton.getLocationOnScreen().getX();
                    int n2 = (int)WmiMathMLEditorButtonMenu.this.activeButton.getLocationOnScreen().getY();
                    int n3 = Math.round(WmiMathMLEditorButtonMenu.this.activeButton.getWidth() / 2);
                    int n4 = WmiMathMLEditorButtonMenu.this.activeButton.getHeight();
                    this.menu.showSubmenu(this.view, n + n3, n2 + n4);
                    WmiMathMLEditorButtonMenu.this.menuOpenMode = true;
                    WmiMathMLEditorButtonMenu.this.activeMenu = this.menu;
                }
            } else {
                if (WmiMathMLEditorButtonMenu.this.activePaletteWindow != null && WmiMathMLEditorButtonMenu.this.activePaletteWindow != this.paletteWindow) {
                    WmiMathMLEditorButtonMenu.this.activePaletteWindow.setVisible(false);
                }
                if ((WmiMathMLEditorButtonMenu.this.activePaletteWindow == null || WmiMathMLEditorButtonMenu.this.activePaletteWindow != this.paletteWindow) && this.paletteWindow != null) {
                    int n = (int)this.menuItem.getLocationOnScreen().getX();
                    int n5 = (int)this.menuItem.getLocationOnScreen().getY();
                    int n6 = this.menuItem.getWidth();
                    int n7 = this.menuItem.getHeight();
                    this.paletteWindow.setLocation(n + n6 / 3, n5 + n7);
                    this.paletteWindow.pack();
                    this.paletteWindow.setVisible(true);
                    this.paletteWindow.toFront();
                }
                WmiMathMLEditorButtonMenu.this.activePaletteWindow = this.paletteWindow;
                WmiMathMLEditorButtonMenu.this.paletteOpenMode = true;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            ActionEvent actionEvent = new ActionEvent(mouseEvent.getComponent(), 0, "");
            if (mouseEvent.getComponent() instanceof WmiMathMLPaletteButtonFactory.TopLevelPaletteButton) {
                this.actionPerformed(actionEvent);
            } else {
                WmiMathMLEditorPalette.MathMLActionControllerCaller mathMLActionControllerCaller = WmiMathMLEditorButtonMenu.this.findControllerCaller((AbstractButton)mouseEvent.getComponent());
                if (mathMLActionControllerCaller != null) {
                    mathMLActionControllerCaller.actionPerformed(actionEvent);
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (WmiMathMLEditorButtonMenu.this.paletteOpenMode) {
                if (WmiMathMLEditorButtonMenu.this.paletteOpenMode && WmiMathMLEditorButtonMenu.this.activePaletteWindow != null) {
                    WmiMathMLEditorButtonMenu.this.activePaletteWindow.setVisible(false);
                    if (RuntimePlatform.isMac()) {
                        WmiMathMLEditorButtonMenu.this.buttonMenuWindow.toFront();
                    }
                    WmiMathMLEditorButtonMenu.this.activePaletteWindow = null;
                }
                if ((WmiMathMLEditorButtonMenu.this.activePaletteWindow == null || WmiMathMLEditorButtonMenu.this.activePaletteWindow != this.paletteWindow) && this.paletteWindow != null) {
                    int n = (int)this.menuItem.getLocationOnScreen().getX();
                    int n2 = (int)this.menuItem.getLocationOnScreen().getY();
                    int n3 = this.menuItem.getWidth();
                    int n4 = this.menuItem.getHeight();
                    this.paletteWindow.setLocation(n + n3 / 3, n2 + n4);
                    this.paletteWindow.pack();
                    this.paletteWindow.setVisible(true);
                    this.paletteWindow.toFront();
                }
                WmiMathMLEditorButtonMenu.this.activePaletteWindow = this.paletteWindow;
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

