/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.platform.WmiComponentMetrics;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.border.MatteBorder;

public class WmiStatusBar
extends JComponent {
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final int DEFAULT_HORIZONTAL_GAP = 5;

    public WmiStatusBar(int n) {
        if (RuntimePlatform.isMac()) {
            MatteBorder matteBorder = new MatteBorder(1, 0, 0, 0, Color.GRAY);
            this.setBorder(matteBorder);
        }
        this.setLayout(new WmiStatusBarLayout(n));
    }

    public WmiStatusBar() {
        this(5);
    }

    public class WmiStatusBarLayout
    implements LayoutManager2 {
        public static final int MINIMUM_DIMENSIONS = 0;
        public static final int MAXIMUM_DIMENSIONS = 1;
        public static final int PREFERRED_DIMENSIONS = 2;
        protected Vector leftComponents = new Vector();
        protected Vector rightComponents = new Vector();
        protected int hGapSize;

        public WmiStatusBarLayout(int n) {
            this.hGapSize = n;
        }

        public void addLayoutComponent(Component component, Object object) {
            String string = (String)object;
            if (string.equals(WmiStatusBar.LEFT)) {
                this.leftComponents.add(component);
            } else if (string.equals(WmiStatusBar.RIGHT)) {
                this.rightComponents.add(component);
            }
        }

        public void addLayoutComponent(String string, Component component) {
            this.addLayoutComponent(component, string);
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }

        public void removeLayoutComponent(Component component) {
            if (this.leftComponents.contains(component)) {
                this.leftComponents.remove(component);
            }
            if (this.rightComponents.contains(component)) {
                this.rightComponents.remove(component);
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            Insets insets = container.getInsets();
            Dimension dimension = this.getTotalSize(this.leftComponents, 2);
            Dimension dimension2 = this.getTotalSize(this.rightComponents, 2);
            int n = dimension.height > dimension2.height ? dimension.height : dimension2.height;
            int n2 = dimension.width + dimension2.width + insets.left + insets.right;
            int n3 = n + insets.top + insets.bottom;
            return new Dimension(n2, n3);
        }

        public Dimension minimumLayoutSize(Container container) {
            Insets insets = container.getInsets();
            Dimension dimension = this.getTotalSize(this.leftComponents, 0);
            Dimension dimension2 = this.getTotalSize(this.rightComponents, 0);
            int n = dimension.height > dimension2.height ? dimension.height : dimension2.height;
            int n2 = dimension.width + dimension2.width + insets.left + insets.right;
            int n3 = n + insets.top + insets.bottom;
            return new Dimension(n2, n3);
        }

        public Dimension maximumLayoutSize(Container container) {
            Insets insets = container.getInsets();
            Dimension dimension = this.getTotalSize(this.leftComponents, 1);
            Dimension dimension2 = this.getTotalSize(this.rightComponents, 1);
            int n = dimension.height > dimension2.height ? dimension.height : dimension2.height;
            int n2 = dimension.width + dimension2.width + insets.left + insets.right;
            int n3 = n + insets.top + insets.bottom;
            return new Dimension(n2, n3);
        }

        public void layoutContainer(Container container) {
            this.computeLayout(container);
        }

        private Dimension getTotalSize(Vector vector, int n) {
            int n2 = -this.hGapSize;
            int n3 = WmiComponentMetrics.STATUS_BAR_MINIMUM_HEIGHT;
            for (int i = 0; i < vector.size(); ++i) {
                int n4;
                JComponent jComponent = (JComponent)vector.get(i);
                if (jComponent == null) continue;
                if (n == 2) {
                    n2 = (int)((double)n2 + jComponent.getPreferredSize().getWidth());
                    n4 = (int)jComponent.getPreferredSize().getHeight();
                } else if (n == 0) {
                    n2 = (int)((double)n2 + jComponent.getMinimumSize().getWidth());
                    n4 = (int)jComponent.getMinimumSize().getHeight();
                } else {
                    n2 = (int)((double)n2 + jComponent.getMaximumSize().getWidth());
                    n4 = (int)jComponent.getMaximumSize().getHeight();
                }
                n2 += this.hGapSize;
                n3 = n4 > n3 ? n4 : n3;
            }
            n2 = n2 > 0 ? n2 : 0;
            return new Dimension(n2, n3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void computeLayout(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                int n;
                int n2;
                Dimension dimension;
                Component component;
                int n3;
                Insets insets = container.getInsets();
                Dimension dimension2 = this.getTotalSize(this.leftComponents, 2);
                Dimension dimension3 = this.getTotalSize(this.rightComponents, 2);
                int n4 = container.getWidth() - (2 * this.hGapSize + dimension2.width + dimension3.width + insets.left + insets.right);
                n4 = n4 > 0 ? n4 : 0;
                int n5 = insets.left + this.hGapSize;
                int n6 = 0;
                for (n3 = 0; n3 < this.leftComponents.size(); ++n3) {
                    component = (Component)this.leftComponents.get(n3);
                    dimension = component.getPreferredSize();
                    n6 = (container.getHeight() - dimension.height) / 2 + insets.top;
                    n2 = dimension.width;
                    if (n3 == this.leftComponents.size() - 1) {
                        n2 += n4;
                    }
                    n = dimension.height;
                    component.setBounds(n5, n6, n2, n);
                    component.setVisible(true);
                    n5 += n2 + this.hGapSize;
                }
                n5 -= this.hGapSize;
                for (n3 = 0; n3 < this.rightComponents.size(); ++n3) {
                    component = (Component)this.rightComponents.get(n3);
                    dimension = component.getPreferredSize();
                    n6 = (container.getHeight() - dimension.height) / 2 + insets.top;
                    n2 = dimension.width;
                    n = dimension.height;
                    component.setBounds(n5, n6, n2, n);
                    component.setVisible(true);
                    n5 += n2 + this.hGapSize;
                }
            }
        }
    }
}

