/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiComponent;
import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.mathdoc.components.WmiNumFormatDelegate;
import com.maplesoft.mathdoc.components.WmiStepperControl;
import com.maplesoft.mathdoc.components.WmiStepperTarget;
import com.maplesoft.mathdoc.components.WmiToolBarSpinTarget;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WmiToolBarSpinControl
extends JPanel
implements WmiComponent,
WmiStepperTarget {
    public static final int DEFAULT_ICON_SIZE = 1;
    private int ctrlId = -1;
    private int ctrlSize = 0;
    private String ctrlLabel = null;
    private String ctrlIcon = null;
    private float ctrlValue = 0.0f;
    private float ctrlStepSize = 1.0f;
    private JLabel myLabel = null;
    private JTextField myTextField = null;
    private WmiStepperControl myStepper = null;
    private WmiNumFormatDelegate myFmtDelegate = null;
    private WmiEditHandler editHandler = new WmiEditHandler();
    private Vector targets = new Vector();

    public WmiToolBarSpinControl(int n, int n2, String string, String string2) {
        this.ctrlId = n;
        this.ctrlSize = n2;
        this.ctrlLabel = string;
        this.ctrlIcon = string2;
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalStrut(5));
        if (string != null || string2 != null) {
            this.myLabel = new JLabel();
            if (string != null) {
                this.myLabel.setText(string);
            } else {
                ImageIcon imageIcon = WmiComponentUtil.getImageIcon(string2);
                if (imageIcon != null) {
                    this.myLabel.setIcon(imageIcon);
                }
            }
            this.add(this.myLabel);
            this.add(Box.createHorizontalStrut(5));
        }
        this.myTextField = new JTextField();
        this.myTextField.setHorizontalAlignment(0);
        this.myTextField.setPreferredSize(new Dimension(40, 20));
        this.myTextField.setMaximumSize(new Dimension(40, 20));
        this.myTextField.addActionListener(this.editHandler);
        this.add(this.myTextField);
        this.add(Box.createHorizontalStrut(5));
        this.myStepper = new WmiStepperControl(n2);
        this.add(this.myStepper);
        this.add(Box.createHorizontalStrut(5));
        this.myStepper.addTarget(this);
        this.updateValueDisplay();
    }

    public WmiToolBarSpinControl(int n, int n2) {
        this(n, n2, null, null);
    }

    public WmiToolBarSpinControl(int n) {
        this(n, 1, null, null);
    }

    public WmiToolBarSpinControl() {
        this(-1, 1, null, null);
    }

    public void setFormatDelegate(WmiNumFormatDelegate wmiNumFormatDelegate) {
        this.myFmtDelegate = wmiNumFormatDelegate;
        this.updateValueDisplay();
    }

    public WmiNumFormatDelegate getFormateDelegate() {
        return this.myFmtDelegate;
    }

    public void setControlValue(float f, boolean bl) {
        this.ctrlValue = f;
        this.updateValueDisplay(bl);
    }

    public void setControlValue(float f) {
        this.setControlValue(f, false);
    }

    public float getControlValue() {
        return this.ctrlValue;
    }

    public void synchronizeValueWithDisplay() {
        try {
            float f = Float.parseFloat(this.myTextField.getText());
            this.setControlValue(f, true);
        }
        catch (NumberFormatException numberFormatException) {
            this.setControlValue(this.ctrlValue, false);
        }
    }

    private void updateValueDisplay(boolean bl) {
        if (this.myFmtDelegate != null) {
            String string = this.myFmtDelegate.getDisplayString(this.ctrlValue);
        } else {
            String string = Integer.toString((int)this.ctrlValue);
        }
        this.myTextField.setText(Integer.toString((int)this.ctrlValue));
        if (bl) {
            this.notifyTargets(this.ctrlValue);
        }
    }

    private void updateValueDisplay() {
        this.updateValueDisplay(true);
    }

    public void addTarget(WmiToolBarSpinTarget wmiToolBarSpinTarget) {
        if (!this.targets.contains(wmiToolBarSpinTarget)) {
            this.targets.add(wmiToolBarSpinTarget);
        }
    }

    public void removeTarget(WmiToolBarSpinTarget wmiToolBarSpinTarget) {
        this.targets.remove(wmiToolBarSpinTarget);
    }

    private void notifyTargets(float f) {
        Iterator iterator = this.targets.iterator();
        while (iterator.hasNext()) {
            ((WmiToolBarSpinTarget)iterator.next()).valueChangeNotify(this.ctrlId, f);
        }
    }

    public void dispose() {
    }

    public void stepNotify(int n, int n2) {
        this.ctrlValue = n2 == 1 ? (this.ctrlValue += this.ctrlStepSize) : (this.ctrlValue -= this.ctrlStepSize);
        if (this.myFmtDelegate != null) {
            this.ctrlValue = this.myFmtDelegate.rangeClamp(this.ctrlValue);
        }
        this.updateValueDisplay();
    }

    private class WmiEditHandler
    implements ActionListener {
        private WmiEditHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WmiToolBarSpinControl.this.synchronizeValueWithDisplay();
        }
    }
}

