/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.dockingtools;

import com.maplesoft.util.RuntimePlatform;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class WmiBorderSplitPane
extends JPanel {
    public static final int NORTH_LOCATION = 0;
    public static final int SOUTH_LOCATION = 1;
    public static final int EAST_LOCATION = 2;
    public static final int WEST_LOCATION = 3;
    public static final int CENTRAL_LOCATION = 4;
    protected static final int FIRST_DOCK_LOCATION = 0;
    protected static final int COLLAPSED_VALUE_START = 4;
    protected static final int DEFAULT_SPLITTER_SIZE = RuntimePlatform.isWindows() ? 5 : 14;
    public static final int NUMBER_OF_DOCK_LOCATIONS = 4;
    public static final int MAX_COMPONENTS_SUPPORTED = 5;
    public static final int ADJUSTMENT_TO_PREFERRED_SIZE = 200;
    public static final int ADJUSTMENT_TO_MIN_SIZE = 0;
    public static final int LOC_OF_SPLIT_IN_SPLITPANE = 0;
    public static final int MINIMUM_DIVIDER_LOCATION_WIDTH = 80;
    public static final String NORTH_DIVIDER_LOCATION_PROPERTY = "dock.location.North";
    public static final String SOUTH_DIVIDER_LOCATION_PROPERTY = "dock.location.South";
    public static final String EAST_DIVIDER_LOCATION_PROPERTY = "dock.location.East";
    public static final String WEST_DIVIDER_LOCATION_PROPERTY = "dock.location.West";
    public static final String NORTH_DIVIDER_COLLAPSED_PROPERTY = "dock.collapsed.North";
    public static final String SOUTH_DIVIDER_COLLAPSED_PROPERTY = "dock.collapsed.South";
    public static final String EAST_DIVIDER_COLLAPSED_PROPERTY = "dock.collapsed.East";
    public static final String WEST_DIVIDER_COLLAPSED_PROPERTY = "dock.collapsed.West";
    protected static final String[] locationToPropertyTable = new String[]{"dock.location.North", "dock.location.South", "dock.location.East", "dock.location.West", "dock.collapsed.North", "dock.collapsed.South", "dock.collapsed.East", "dock.collapsed.West"};
    protected static int splitterSize = DEFAULT_SPLITTER_SIZE;
    protected boolean[] visible = new boolean[4];
    public int[] splitDividerOffset = new int[4];
    public boolean[] collapsed = new boolean[4];
    private boolean oneTouchExpandable = true;
    private Rectangle dividerDraggedRect = null;

    public WmiBorderSplitPane() {
        int n;
        super.setLayout(new SplitLayout());
        for (n = 0; n < 5; ++n) {
            this.add(new JPanel());
        }
        for (n = 0; n < 4; ++n) {
            this.setVisible(n, false);
        }
    }

    public boolean isVisible(int n) throws ArrayIndexOutOfBoundsException {
        return this.visible[n];
    }

    public void setVisible(int n, boolean bl) throws ArrayIndexOutOfBoundsException {
        this.visible[n] = bl;
        this.getComponent(n).setVisible(bl);
    }

    public void setCollapsed(int n, boolean bl) {
        boolean bl2 = this.collapsed[n];
        this.collapsed[n] = bl;
        if (this.getComponent(n) instanceof DockContainer) {
            ((DockContainer)this.getComponent(n)).updateSplitterSize();
            ((DockContainer)this.getComponent(n)).setCollapsed(bl);
            this.revalidate();
        }
        String string = this.getPropertyNameForLocation(n, 4);
        this.firePropertyChange(string, bl2, bl);
    }

    public void removeAtLocation(int n) {
        this.remove(n);
        this.add((Component)new JPanel(), n);
        this.setVisible(n, false);
        this.invalidate();
    }

    public boolean isCollapsed(int n) {
        return this.collapsed[n];
    }

    public void setOneTouchExpandable(boolean bl) {
        this.oneTouchExpandable = bl;
    }

    public boolean isOneTouchExpandable() {
        return this.oneTouchExpandable;
    }

    public int getDividerLocation(int n) {
        return this.splitDividerOffset[n];
    }

    public int getNorthDividerLocation() {
        return this.splitDividerOffset[0];
    }

    public int getSouthDividerLocation() {
        return this.splitDividerOffset[1];
    }

    public int getWestDividerLocation() {
        return this.splitDividerOffset[3];
    }

    public int getEastDividerLocation() {
        return this.splitDividerOffset[2];
    }

    public void setNorthDividerLocation(int n) {
        this.setDividerLocation(0, n);
    }

    public void setSouthDividerLocation(int n) {
        this.setDividerLocation(1, n);
    }

    public void setWestDividerLocation(int n) {
        this.setDividerLocation(3, n);
    }

    public void setEastDividerLocation(int n) {
        this.setDividerLocation(2, n);
    }

    public void setDividerLocation(int n, int n2) {
        int n3 = this.splitDividerOffset[n];
        this.splitDividerOffset[n] = n2 = n2 < 80 ? 80 : n2;
        this.revalidate();
        String string = this.getPropertyNameForLocation(n, 0);
        this.firePropertyChange(string, n3, n2);
    }

    protected String getPropertyNameForLocation(int n, int n2) {
        return locationToPropertyTable[n2 + this.getLocationOffset(n)];
    }

    private int getLocationOffset(int n) {
        return n;
    }

    public void setNorth(Component component) {
        this.addAtLocation(0, component);
    }

    public void setSouth(Component component) {
        this.addAtLocation(1, component);
    }

    public void setEast(Component component) {
        this.addAtLocation(2, component);
    }

    public void setWest(Component component) {
        this.addAtLocation(3, component);
    }

    public void setCentral(Component component) {
        this.add(component, 4);
        this.revalidate();
    }

    public void addAtLocation(int n, Component component) {
        this.remove(n);
        this.add((Component)new DockContainer(component, n), n);
        this.setVisible(n, true);
        this.revalidate();
    }

    public Component getFromLocation(int n) {
        Component component = null;
        Component component2 = this.getComponent(n);
        if (component2 instanceof DockContainer) {
            DockContainer dockContainer = (DockContainer)this.getComponent(n);
            component = dockContainer.getComponentCount() > 1 ? dockContainer.getComponent(1) : null;
        }
        return component;
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.dividerDraggedRect != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(10, 0.5f));
            graphics2D.setColor(Color.GRAY);
            graphics2D.fillRect(this.dividerDraggedRect.x, this.dividerDraggedRect.y, this.dividerDraggedRect.width, this.dividerDraggedRect.height);
            graphics2D.setComposite(composite);
        }
    }

    public class MouseDragger
    extends MouseAdapter
    implements MouseMotionListener {
        private int orientation;
        private int startingMouseLocation;
        private int startingDividerLocation;
        private int lastDelta = 0;

        public MouseDragger(int n) {
            this.orientation = n;
            this.startingMouseLocation = -1;
            this.startingDividerLocation = WmiBorderSplitPane.this.getDividerLocation(n);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (WmiBorderSplitPane.this.isVisible(this.orientation) && !WmiBorderSplitPane.this.collapsed[this.orientation]) {
                this.startingMouseLocation = this.orientation == 0 || this.orientation == 1 ? mouseEvent.getY() : mouseEvent.getX();
                this.startingDividerLocation = WmiBorderSplitPane.this.getDividerLocation(this.orientation);
            }
            mouseEvent.consume();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (WmiBorderSplitPane.this.isVisible(this.orientation) && !WmiBorderSplitPane.this.collapsed[this.orientation]) {
                Component component;
                int n = this.orientation == 0 || this.orientation == 1 ? mouseEvent.getY() : mouseEvent.getX();
                int n2 = this.startingMouseLocation - n;
                if (this.orientation == 3 || this.orientation == 0) {
                    n2 *= -1;
                }
                if (this.lastDelta != n2) {
                    WmiBorderSplitPane.this.setDividerLocation(this.orientation, this.startingDividerLocation + n2);
                }
                for (component = (Component)mouseEvent.getSource(); component != null && !(component instanceof WmiBorderSplitPane); component = component.getParent()) {
                }
                component.invalidate();
                this.lastDelta = n2;
            }
            WmiBorderSplitPane.this.dividerDraggedRect = null;
            WmiBorderSplitPane.this.repaint();
            mouseEvent.consume();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (WmiBorderSplitPane.this.isVisible(this.orientation) && !WmiBorderSplitPane.this.collapsed[this.orientation]) {
                Component component;
                Component component2;
                for (component2 = component = (Component)mouseEvent.getSource(); component2 != null && !(component2 instanceof WmiBorderSplitPane); component2 = component2.getParent()) {
                }
                int n = component2.getWidth();
                int n2 = component2.getHeight();
                Rectangle rectangle = WmiBorderSplitPane.this.dividerDraggedRect;
                if (this.orientation == 1 || this.orientation == 0) {
                    int n3 = this.orientation == 0 ? this.startingDividerLocation + mouseEvent.getY() : n2 - this.startingDividerLocation + mouseEvent.getY();
                    WmiBorderSplitPane.this.dividerDraggedRect = new Rectangle(0, n3, n, splitterSize);
                } else {
                    int n4 = this.orientation == 3 ? this.startingDividerLocation + mouseEvent.getX() : n - this.startingDividerLocation + mouseEvent.getX();
                    WmiBorderSplitPane.this.dividerDraggedRect = new Rectangle(n4 - splitterSize, 0, splitterSize, n2);
                }
                rectangle = rectangle != null ? SwingUtilities.computeUnion(((WmiBorderSplitPane)WmiBorderSplitPane.this).dividerDraggedRect.x, ((WmiBorderSplitPane)WmiBorderSplitPane.this).dividerDraggedRect.y, ((WmiBorderSplitPane)WmiBorderSplitPane.this).dividerDraggedRect.width, ((WmiBorderSplitPane)WmiBorderSplitPane.this).dividerDraggedRect.height, rectangle) : WmiBorderSplitPane.this.dividerDraggedRect;
                WmiBorderSplitPane.this.repaint(rectangle);
            }
            mouseEvent.consume();
        }
    }

    public class UnCollapseListener
    extends CollapseListener {
        public UnCollapseListener(int n) {
            super(n);
        }

        public boolean willCollapseTarget() {
            return false;
        }
    }

    public class CollapseListener
    implements ActionListener {
        protected int orientation;

        public CollapseListener(int n) {
            this.orientation = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WmiBorderSplitPane.this.setCollapsed(this.orientation, this.willCollapseTarget());
        }

        public boolean willCollapseTarget() {
            return true;
        }
    }

    public class DockContainer
    extends JPanel {
        private Cursor resizeCursor;

        public DockContainer(Component component, int n) {
            this.setLayout(new BorderLayout());
            String string = "South";
            JSplitPane jSplitPane = null;
            Container container = null;
            int n2 = 0;
            switch (n) {
                case 0: {
                    string = "South";
                    break;
                }
                case 1: {
                    string = "North";
                    break;
                }
                case 2: {
                    string = "West";
                    n2 = 1;
                    break;
                }
                case 3: {
                    string = "East";
                    n2 = 1;
                }
            }
            jSplitPane = new JSplitPane(n2);
            jSplitPane.setOneTouchExpandable(WmiBorderSplitPane.this.isOneTouchExpandable());
            container = (Container)jSplitPane.getComponent(0);
            MouseDragger mouseDragger = new MouseDragger(n);
            container.addMouseListener(mouseDragger);
            container.addMouseMotionListener(mouseDragger);
            if (RuntimePlatform.isUnix()) {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.setBorder(BorderFactory.createEtchedBorder());
                jPanel.add((Component)container, "Center");
                this.add((Component)jPanel, string);
            } else {
                this.add((Component)container, string);
            }
            this.resizeCursor = container.getCursor();
            this.updateSplitterSize();
            if (WmiBorderSplitPane.this.isOneTouchExpandable()) {
                int n3 = n == 0 || n == 3 ? 0 : 1;
                int n4 = n == 0 || n == 3 ? 1 : 0;
                ((JButton)container.getComponent(n3)).addActionListener(new CollapseListener(n));
                ((JButton)container.getComponent(n4)).addActionListener(new UnCollapseListener(n));
            }
            this.setComponent(component);
        }

        public void updateSplitterSize() {
            splitterSize = this.getComponent(0).getWidth() <= this.getComponent(0).getHeight() ? this.getComponent(0).getWidth() : this.getComponent(0).getHeight();
            splitterSize = splitterSize <= 0 ? DEFAULT_SPLITTER_SIZE : splitterSize;
        }

        public void validate() {
            super.validate();
            this.updateSplitterSize();
        }

        public void setComponent(Component component) {
            this.add(component, "Center");
        }

        public void setCollapsed(boolean bl) {
            Component component = this.getComponent(1);
            if (component != null) {
                component.setVisible(!bl);
            }
            Component component2 = this.getComponent(0);
            component2.setCursor(bl ? null : this.resizeCursor);
        }
    }

    private class SplitLayout
    implements LayoutManager {
        private SplitLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        private int getLocationWithCollapse(int n) {
            return WmiBorderSplitPane.this.isCollapsed(n) ? splitterSize : WmiBorderSplitPane.this.splitDividerOffset[n];
        }

        public void layoutContainer(Container container) {
            int n;
            int n2;
            int n3;
            int n4 = container.getWidth();
            int n5 = container.getHeight();
            if (WmiBorderSplitPane.this.isVisible(3)) {
                n3 = this.getLocationWithCollapse(3);
                n3 = n3 >= splitterSize ? n3 : splitterSize;
                n3 = n3 >= n4 - splitterSize * 2 ? n4 - splitterSize * 2 : n3;
            } else {
                n3 = 0;
            }
            int n6 = n4 - this.getLocationWithCollapse(2);
            if (WmiBorderSplitPane.this.isVisible(2)) {
                n6 = n6 >= n4 ? n4 - splitterSize : n6;
                n6 = n6 >= 0 ? n6 : 0;
            } else {
                n6 = n4;
            }
            int n7 = n6 - n3;
            if (WmiBorderSplitPane.this.isVisible(0)) {
                n2 = this.getLocationWithCollapse(0);
                n2 = n2 >= splitterSize ? n2 : splitterSize;
                n2 = n2 >= n5 - splitterSize * 2 ? n5 - splitterSize * 2 : n2;
            } else {
                n2 = 0;
            }
            if (WmiBorderSplitPane.this.isVisible(1)) {
                n = n5 - this.getLocationWithCollapse(1);
                n = n >= 0 ? n : 0;
                n = n >= n5 - splitterSize ? n5 - splitterSize : n;
            } else {
                n = n5;
            }
            int n8 = n - n2;
            n7 = n7 >= 0 ? n7 : 0;
            n8 = n8 >= 0 ? n8 : 0;
            n = n < this.getLocationWithCollapse(0) ? this.getLocationWithCollapse(0) : n;
            int n9 = n6 = n6 < n3 ? n3 : n6;
            if (WmiBorderSplitPane.this.getComponent(3) != null) {
                WmiBorderSplitPane.this.getComponent(3).setLocation(0, 0);
                WmiBorderSplitPane.this.getComponent(3).setSize(n3, n5);
            }
            if (WmiBorderSplitPane.this.getComponent(2) != null) {
                WmiBorderSplitPane.this.getComponent(2).setLocation(n6, 0);
                WmiBorderSplitPane.this.getComponent(2).setSize(n4 - n6, n5);
            }
            if (WmiBorderSplitPane.this.getComponent(4) != null) {
                WmiBorderSplitPane.this.getComponent(4).setLocation(n3, n2);
                WmiBorderSplitPane.this.getComponent(4).setSize(n7, n8);
            }
            if (WmiBorderSplitPane.this.getComponent(0) != null) {
                WmiBorderSplitPane.this.getComponent(0).setLocation(n3, 0);
                WmiBorderSplitPane.this.getComponent(0).setSize(n7, n2);
            }
            if (WmiBorderSplitPane.this.getComponent(1) != null) {
                WmiBorderSplitPane.this.getComponent(1).setLocation(n3, n);
                WmiBorderSplitPane.this.getComponent(1).setSize(n7, n5 - n);
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.calculateSize(container, 0);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.calculateSize(container, 200);
        }

        private Dimension calculateSize(Container container, int n) {
            int n2 = WmiBorderSplitPane.this.collapsed[2] || WmiBorderSplitPane.this.getComponent(2) == null ? 0 : WmiBorderSplitPane.this.splitDividerOffset[2];
            n2 += WmiBorderSplitPane.this.collapsed[3] || WmiBorderSplitPane.this.getComponent(3) == null ? 0 : WmiBorderSplitPane.this.splitDividerOffset[3];
            n2 += WmiBorderSplitPane.this.getComponent(4) == null ? 0 : WmiBorderSplitPane.this.getComponent(4).getWidth();
            int n3 = WmiBorderSplitPane.this.collapsed[0] || WmiBorderSplitPane.this.getComponent(0) == null ? 0 : WmiBorderSplitPane.this.splitDividerOffset[0];
            n3 += WmiBorderSplitPane.this.collapsed[1] || WmiBorderSplitPane.this.getComponent(1) == null ? 0 : WmiBorderSplitPane.this.splitDividerOffset[1];
            n3 += WmiBorderSplitPane.this.getComponent(4) == null ? 0 : WmiBorderSplitPane.this.getComponent(4).getHeight();
            return new Dimension(n2 += n, n3 += n);
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

