/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.dockingtools;

import com.maplesoft.mathdoc.components.dockingtools.WmiDockable;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockingHost;
import com.maplesoft.mathdoc.components.dockingtools.WmiPalette;
import com.maplesoft.mathdoc.components.dockingtools.WmiPaletteDnDManager;
import com.maplesoft.mathdoc.controller.view.palettes.WmiPaletteButtonDnDManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

public class WmiPaletteStackPanel
extends JPanel
implements WmiDockingHost {
    public static final int DOCK_INLINE = 999;
    public static final int DOCK_INTER_VERTICAL_SPACE = 4;
    public static final int DROP_TARGET_STRUT_SIZE = 24;
    public static final Insets AUTOSCROLL_INSETS = new Insets(100, 0, 150, 0);
    public static final Insets NO_AUTOSCROLL_INSETS = new Insets(0, 0, 0, 0);
    public static final int AUTOSCROLL_DELTA_Y = 60;
    protected PaletteStackContentPanel content = null;
    protected JViewport viewport = null;
    protected WmiDockingHost host = null;
    private boolean isChildResizing = false;
    private int targetIndex = -1;
    private Window myWindow = null;
    private StrutResizer resizer = null;
    static /* synthetic */ Class class$java$awt$Window;

    public WmiPaletteStackPanel() {
        this((WmiDockingHost)null);
    }

    public WmiPaletteStackPanel(WmiDockingHost wmiDockingHost) {
        this.host = wmiDockingHost;
        this.configurePanel();
    }

    public void configurePanel() {
        this.setLayout(new BorderLayout());
        this.content = new PaletteStackContentPanel();
        this.content.add(new PanelFiller());
        PaletteStackDropTarget paletteStackDropTarget = new PaletteStackDropTarget();
        this.content.setDropTarget(new DropTarget(this.content, 2, paletteStackDropTarget, true, WmiPaletteDnDManager.PALETTE_DRAG_FLAVOR_MAP));
        BoxLayout boxLayout = new BoxLayout(this.content, 1);
        this.content.setLayout(boxLayout);
        JScrollPane jScrollPane = new JScrollPane(this.content, 22, 31);
        this.viewport = jScrollPane.getViewport();
        this.add((Component)jScrollPane, "Center");
        this.resizer = new StrutResizer();
        Thread thread = new Thread(this.resizer);
        thread.setName("palette panel movement animation thread");
        thread.start();
    }

    public void release() {
        if (this.resizer != null) {
            this.resizer.interrupt();
            this.resizer = null;
        }
    }

    public void invalidate() {
        if (!this.isChildResizing) {
            this.content.invalidate();
        }
        super.invalidate();
    }

    public void setChildResizing(boolean bl) {
        this.isChildResizing = bl;
    }

    public Iterator getPaletteIterator() {
        return new PaletteIterator();
    }

    public void addPopupListener(MouseListener mouseListener) {
        this.content.addMouseListener(mouseListener);
    }

    public void dock(WmiDockable wmiDockable) {
        this.dockComponentAtIndex(wmiDockable, -1);
    }

    public void dock(WmiDockable wmiDockable, int n) {
        this.dockComponentAtIndex(wmiDockable, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dockComponentAtIndex(WmiDockable wmiDockable, int n) {
        if (wmiDockable instanceof Component) {
            Object object = this.getTreeLock();
            synchronized (object) {
                PanelFiller panelFiller = new PanelFiller();
                if (n < 0 || n >= this.content.getComponentCount()) {
                    n = this.content.getComponentCount() - 1;
                }
                if (n % 2 == 1) {
                    --n;
                }
                this.content.add((Component)panelFiller, n);
                this.content.add((Component)((Object)wmiDockable), n + 1);
                if (SwingUtilities.isEventDispatchThread()) {
                    this.invalidate();
                    this.validate();
                    this.repaint();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            WmiPaletteStackPanel.this.invalidate();
                            WmiPaletteStackPanel.this.validate();
                            WmiPaletteStackPanel.this.repaint();
                        }
                    });
                }
            }
        }
    }

    public WmiDockable getDocked() {
        return this.getDocked(0);
    }

    public WmiDockable getDocked(int n) {
        if (n % 2 == 0) {
            ++n;
        }
        return this.content.getComponentCount() > n ? (WmiDockable)((Object)this.content.getComponent(n)) : null;
    }

    public int getWhereDocked(WmiDockable wmiDockable) {
        return this.getComponentIndexWhereDocked(wmiDockable) != -1 ? 999 : -1;
    }

    public int getComponentIndexWhereDocked(WmiDockable wmiDockable) {
        int n = -1;
        for (int i = 0; i < this.content.getComponentCount(); ++i) {
            if (this.content.getComponent(i) != wmiDockable) continue;
            n = i;
            break;
        }
        return n;
    }

    public WmiDockable undock(WmiDockable wmiDockable) {
        return this.undock(wmiDockable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WmiDockable undock(WmiDockable wmiDockable, boolean bl) {
        WmiDockable wmiDockable2 = null;
        if (wmiDockable instanceof Component) {
            Object object = this.getTreeLock();
            synchronized (object) {
                for (int i = 0; i < this.content.getComponentCount(); ++i) {
                    if (this.content.getComponent(i) != wmiDockable || i <= 0) continue;
                    if (bl && i + 1 < this.content.getComponentCount()) {
                        Component component = this.content.getComponent(i + 1);
                        int n = ((Component)((Object)wmiDockable)).getHeight();
                        component.setSize(0, n);
                    }
                    this.content.remove(i - 1);
                    break;
                }
                this.content.remove((Component)((Object)wmiDockable));
                this.invalidate();
                this.validate();
                this.repaint();
            }
            wmiDockable2 = wmiDockable;
        }
        return wmiDockable2;
    }

    public void undockAll() {
        this.content.removeAll();
        this.content.add(new PanelFiller());
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public boolean isValidDockLocation(int n) {
        return n == 999;
    }

    public boolean isDocked(WmiDockable wmiDockable) {
        return this.getWhereDocked(wmiDockable) == 999;
    }

    public boolean isDockOpen(int n) {
        return n == 999;
    }

    public int getPreferredDockLocation() {
        return 999;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void targetStrut(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            WmiPaletteStackPanel wmiPaletteStackPanel = this;
            synchronized (wmiPaletteStackPanel) {
                if (n != this.targetIndex) {
                    this.targetIndex = n;
                    this.setTargetHighlight(this.targetIndex != -1);
                    this.notifyAll();
                }
            }
        }
    }

    private void setTargetHighlight(boolean bl) {
        Component component;
        if (this.targetIndex >= 0 && this.targetIndex < this.content.getComponentCount() && (component = this.content.getComponent(this.targetIndex)) instanceof PanelFiller) {
            ((PanelFiller)component).setHighlight(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dragExited() {
        this.targetStrut(-1);
        this.myWindow = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            WmiPaletteStackPanel wmiPaletteStackPanel = this;
            synchronized (wmiPaletteStackPanel) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        Dimension dimension = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            WmiPaletteStackPanel wmiPaletteStackPanel = this;
            synchronized (wmiPaletteStackPanel) {
                dimension = super.getPreferredSize();
            }
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getSize() {
        Dimension dimension = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            WmiPaletteStackPanel wmiPaletteStackPanel = this;
            synchronized (wmiPaletteStackPanel) {
                dimension = super.getSize();
            }
        }
        return dimension;
    }

    protected Insets getAutoscrollInsets() {
        return WmiPaletteButtonDnDManager.getDragButton() == null ? AUTOSCROLL_INSETS : NO_AUTOSCROLL_INSETS;
    }

    protected int getAutoscrollAmount() {
        return 60;
    }

    private class PanelFiller
    extends JPanel {
        private boolean highlight = false;

        public PanelFiller() {
            this.setSize(WmiPaletteStackPanel.this.content.getWidth(), 4);
            this.setOpaque(false);
        }

        public void setHighlight(boolean bl) {
            this.highlight = bl;
            this.repaint();
        }

        public Dimension getSize() {
            Dimension dimension = super.getSize();
            dimension.width = WmiPaletteStackPanel.this.content.getWidth();
            return dimension;
        }

        public Dimension getPreferredSize() {
            return this.getSize();
        }

        public Dimension getMinimumSize() {
            return this.getSize();
        }

        public Dimension getMaximumSize() {
            return this.getSize();
        }

        public void paint(Graphics graphics) {
            if (this.highlight) {
                graphics.setColor(Color.GRAY);
                graphics.fillRoundRect(5, 5, this.getWidth() - 10, this.getHeight() - 10, 15, 15);
            } else {
                super.paint(graphics);
            }
        }
    }

    private class PaletteIterator
    implements Iterator {
        private int i = 1;

        private PaletteIterator() {
        }

        public boolean hasNext() {
            return this.i < WmiPaletteStackPanel.this.content.getComponentCount();
        }

        public Object next() {
            int n = this.i;
            this.i += 2;
            return WmiPaletteStackPanel.this.content.getComponent(n);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class StrutResizer
    implements Runnable {
        private static final int MOVEMENT_SIZE = 5;
        private static final int MOVEMENT_DELAY = 2;
        private boolean interrupted = false;

        private StrutResizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void interrupt() {
            WmiPaletteStackPanel wmiPaletteStackPanel = WmiPaletteStackPanel.this;
            synchronized (wmiPaletteStackPanel) {
                this.interrupted = true;
                WmiPaletteStackPanel.this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WmiPaletteStackPanel wmiPaletteStackPanel;
            try {
                wmiPaletteStackPanel = WmiPaletteStackPanel.this;
                synchronized (wmiPaletteStackPanel) {
                    WmiPaletteStackPanel.this.wait();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            while (true) {
                wmiPaletteStackPanel = WmiPaletteStackPanel.this;
                synchronized (wmiPaletteStackPanel) {
                    if (this.interrupted) {
                        break;
                    }
                }
                try {
                    boolean bl = false;
                    Object object = WmiPaletteStackPanel.this.getTreeLock();
                    synchronized (object) {
                        WmiPaletteStackPanel wmiPaletteStackPanel2 = WmiPaletteStackPanel.this;
                        synchronized (wmiPaletteStackPanel2) {
                            WmiPalette wmiPalette = WmiPaletteDnDManager.getDraggedPalette();
                            for (int i = 0; i < WmiPaletteStackPanel.this.content.getComponentCount(); i += 2) {
                                JComponent jComponent = (JComponent)WmiPaletteStackPanel.this.content.getComponent(i);
                                int n = jComponent.getHeight();
                                int n2 = 0;
                                n2 = i == WmiPaletteStackPanel.this.targetIndex && wmiPalette != null ? 24 : 4;
                                int n3 = Math.max(5, Math.abs(n - n2) / 10);
                                if (n > n2) {
                                    if ((n -= n3) < n2) {
                                        n = n2;
                                    }
                                } else if (n < n2 && (n += n3) > n2) {
                                    n = n2;
                                }
                                if (n == jComponent.getHeight()) continue;
                                bl = true;
                                jComponent.setSize(0, n);
                            }
                        }
                    }
                    if (bl) {
                        this.synchroUpdate(WmiPaletteStackPanel.this.content);
                        Thread.sleep(2L);
                        continue;
                    }
                    this.synchroUpdate(WmiPaletteStackPanel.this.viewport);
                    object = WmiPaletteStackPanel.this;
                    synchronized (object) {
                        WmiPaletteStackPanel.this.wait();
                        continue;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }

        private void synchroUpdate(final Component component) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = WmiPaletteStackPanel.this.getTreeLock();
                    synchronized (object) {
                        WmiPaletteStackPanel wmiPaletteStackPanel = WmiPaletteStackPanel.this;
                        synchronized (wmiPaletteStackPanel) {
                            component.invalidate();
                            component.doLayout();
                            WmiPaletteStackPanel.this.repaint();
                        }
                    }
                }
            });
        }
    }

    public class PaletteStackDropTarget
    implements DropTargetListener {
        public boolean acceptOrRejectDrag(Point point) {
            int n;
            boolean bl;
            Window window = WmiPaletteDnDManager.getDraggedPaletteOriginWindow();
            boolean bl2 = bl = WmiPaletteStackPanel.this.myWindow == window;
            if (bl && (n = WmiPaletteStackPanel.this.content.getAutoscrollDeltaY(point)) != 0) {
                Rectangle rectangle = WmiPaletteStackPanel.this.content.getVisibleRect();
                bl = rectangle.y == 0 && n < 0 || rectangle.y + rectangle.height == WmiPaletteStackPanel.this.content.getHeight() && n > 0;
            }
            return bl;
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            WmiPaletteStackPanel.this.myWindow = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = WmiPaletteStackPanel.class$("java.awt.Window")) : class$java$awt$Window, WmiPaletteStackPanel.this);
            if (this.acceptOrRejectDrag(dropTargetDragEvent.getLocation())) {
                dropTargetDragEvent.acceptDrag(2);
                WmiPaletteDnDManager.dragEntered(WmiPaletteStackPanel.this);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            WmiPaletteStackPanel.this.dragExited();
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            Point point = dropTargetDragEvent.getLocation();
            if (this.acceptOrRejectDrag(point)) {
                Component component;
                int n;
                point.x = WmiPaletteStackPanel.this.getWidth() / 2;
                int n2 = WmiPaletteStackPanel.this.content.getComponentCount() - 1;
                for (int i = WmiPaletteStackPanel.this.content.getComponentCount() - 2; i > 0 && (n = (component = WmiPaletteStackPanel.this.content.getComponent(i)).getY()) + component.getHeight() / 2 >= point.y; i -= 2) {
                    n2 = i - 1;
                }
                WmiPaletteStackPanel.this.targetStrut(n2);
                dropTargetDragEvent.acceptDrag(2);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            WmiPalette wmiPalette;
            Transferable transferable;
            boolean bl = false;
            if (this.acceptOrRejectDrag(dropTargetDropEvent.getLocation()) && (transferable = dropTargetDropEvent.getTransferable()).isDataFlavorSupported(WmiPaletteDnDManager.PALETTE_DRAG_FLAVOR) && (wmiPalette = WmiPaletteDnDManager.getDraggedPalette()) != null) {
                dropTargetDropEvent.acceptDrop(2);
                bl = true;
                WmiPaletteDnDManager.acceptPaletteDrag(WmiPaletteStackPanel.this);
                if (WmiPaletteStackPanel.this.targetIndex != -1) {
                    WmiPaletteStackPanel.this.content.getComponent(WmiPaletteStackPanel.this.targetIndex).setSize(0, 4);
                }
                WmiPaletteStackPanel.this.dockComponentAtIndex(wmiPalette, WmiPaletteStackPanel.this.targetIndex);
                wmiPalette.invalidate();
                wmiPalette.doLayout();
                WmiPaletteStackPanel.this.viewport.invalidate();
                WmiPaletteStackPanel.this.viewport.doLayout();
                WmiPaletteStackPanel.this.viewport.repaint();
            }
            dropTargetDropEvent.dropComplete(bl);
            WmiPaletteStackPanel.this.targetStrut(-1);
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }

    public class PaletteStackContentPanel
    extends JPanel
    implements Scrollable,
    Autoscroll {
        public Dimension getPreferredScrollableViewportSize() {
            return WmiPaletteStackPanel.this.viewport.getSize();
        }

        public boolean getScrollableTracksViewportHeight() {
            Dimension dimension = this.getPreferredSize();
            Dimension dimension2 = WmiPaletteStackPanel.this.viewport.getSize();
            return dimension2.height > dimension.height;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 10;
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return rectangle.height;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doLayout() {
            Object object = this.getTreeLock();
            synchronized (object) {
                WmiPaletteStackPanel wmiPaletteStackPanel = WmiPaletteStackPanel.this;
                synchronized (wmiPaletteStackPanel) {
                    super.doLayout();
                }
            }
        }

        public void autoscroll(Point point) {
            int n = this.getAutoscrollDeltaY(point);
            if (n != 0) {
                Rectangle rectangle = this.getVisibleRect();
                rectangle.y += n;
                this.scrollRectToVisible(rectangle);
            }
        }

        public int getAutoscrollDeltaY(Point point) {
            Rectangle rectangle = this.getVisibleRect();
            int n = 0;
            Insets insets = WmiPaletteStackPanel.this.getAutoscrollInsets();
            int n2 = WmiPaletteStackPanel.this.getAutoscrollAmount();
            if (point.y <= rectangle.y + insets.top) {
                n = Math.max(rectangle.y - n2, 0) - rectangle.y;
            } else if (point.y >= rectangle.y + rectangle.height - insets.bottom) {
                n = Math.min(rectangle.y + n2, this.getHeight() - rectangle.height) - rectangle.y;
            }
            return n;
        }

        public Insets getAutoscrollInsets() {
            Rectangle rectangle = this.getVisibleRect();
            Insets insets = WmiPaletteStackPanel.this.getAutoscrollInsets();
            return new Insets(insets.top + rectangle.y, 0, this.getHeight() - rectangle.y - rectangle.height + insets.bottom, 0);
        }
    }
}

