/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.components.WmiComboBox;
import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class WmiCommandProxy
extends WmiCommand {
    protected String commandClassName;
    protected String documentTypeTag;
    protected int type;
    protected boolean isBackground;
    protected boolean isUpdate;
    protected int lockType;
    protected int ignorableModifier;
    protected String resourcePath;
    protected boolean isConsuming;
    protected boolean needsInstance;
    static boolean doneSubclassCheck;
    private WmiCommand instance;

    private boolean matches(Method method, Method method2) {
        Class<?>[] classArray;
        if (!method.getName().equals(method2.getName())) {
            return false;
        }
        Class<?>[] classArray2 = method.getParameterTypes();
        if (classArray2.length != (classArray = method2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < classArray2.length; ++i) {
            if (classArray2[i] == classArray[i]) continue;
            return false;
        }
        return method.getReturnType() == method2.getReturnType();
    }

    private void subclassCheck() {
        Method[] methodArray = WmiCommandProxy.class.getDeclaredMethods();
        HashMap hashMap = new HashMap();
        for (int i = 0; i < methodArray.length; ++i) {
            String string = methodArray[i].getName();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new LinkedList());
            }
            LinkedList linkedList = (LinkedList)hashMap.get(string);
            linkedList.add(methodArray[i]);
        }
        Method[] methodArray2 = WmiCommand.class.getDeclaredMethods();
        for (int i = 0; i < methodArray2.length; ++i) {
            int n = methodArray2[i].getModifiers();
            if (Modifier.isAbstract(n) || Modifier.isFinal(n) || Modifier.isNative(n) || Modifier.isPrivate(n) || Modifier.isStatic(n)) continue;
            String string = methodArray2[i].getName();
            boolean bl = false;
            if (hashMap.containsKey(string)) {
                LinkedList linkedList = (LinkedList)hashMap.get(string);
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    Method method = (Method)iterator.next();
                    if (!this.matches(method, methodArray2[i])) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            throw new Error("WmiCommandProxy is missing an implementation of " + methodArray2[i]);
        }
    }

    private WmiCommandProxy(WmiCommand wmiCommand) {
        super(wmiCommand.getName(), false, false);
        if (!doneSubclassCheck) {
            this.subclassCheck();
            doneSubclassCheck = true;
        }
        this.instance = wmiCommand;
        this.commandClassName = wmiCommand.getClass().toString();
    }

    public static WmiCommandProxy getProxyForCommand(WmiCommand wmiCommand) {
        if (wmiCommand instanceof WmiCommandProxy) {
            return (WmiCommandProxy)wmiCommand;
        }
        return new WmiCommandProxy(wmiCommand);
    }

    public WmiCommandProxy(String string, String string2, String string3, int n, boolean bl, boolean bl2, int n2, int n3, String string4, boolean bl3) {
        super(string2, false);
        if (!doneSubclassCheck) {
            this.subclassCheck();
            doneSubclassCheck = true;
        }
        this.commandClassName = string;
        this.documentTypeTag = string3;
        this.type = n;
        this.isBackground = bl;
        this.isUpdate = bl2;
        this.lockType = n2;
        this.ignorableModifier = n3;
        this.resourcePath = string4;
        this.isConsuming = bl3;
    }

    public WmiCommandProxy(String string, String string2, WmiResourcePackage wmiResourcePackage) {
        super(string, false, true, wmiResourcePackage);
        this.needsInstance = true;
        this.commandClassName = string2;
        this.documentTypeTag = this.getResource(9);
        if (!doneSubclassCheck) {
            this.subclassCheck();
            doneSubclassCheck = true;
        }
    }

    public String getDocumentTypeTag() {
        if (this.instance != null) {
            this.documentTypeTag = this.getInstance().getDocumentTypeTag();
        }
        if (this.documentTypeTag == null) {
            return super.getDocumentTypeTag();
        }
        return this.documentTypeTag;
    }

    public int getType() {
        if (this.instance != null || this.needsInstance) {
            return this.getInstance().getType();
        }
        return this.type;
    }

    public boolean isBackgroundTask() {
        if (this.instance != null || this.needsInstance) {
            return this.getInstance().isBackgroundTask();
        }
        return this.isBackground;
    }

    public boolean isUpdateCommand() {
        if (this.instance != null || this.needsInstance) {
            return this.getInstance().isUpdateCommand();
        }
        return this.isUpdate;
    }

    public boolean isSelected() {
        return this.getInstance().isSelected();
    }

    public boolean isSelected(WmiMathDocumentView wmiMathDocumentView) {
        return this.getInstance().isSelected(wmiMathDocumentView);
    }

    public int lockTypeRequired() {
        if (this.instance != null || this.needsInstance) {
            return this.getInstance().lockTypeRequired();
        }
        return this.lockType;
    }

    public boolean isEnabled(WmiView wmiView) {
        return this.getInstance().isEnabled(wmiView);
    }

    public boolean waitsForInputLock() {
        return this.getInstance().waitsForInputLock();
    }

    public boolean isInputEnabled() {
        return this.getInstance().isInputEnabled();
    }

    public boolean shouldConsumeEvent() {
        if (this.instance != null || this.needsInstance) {
            return this.getInstance().shouldConsumeEvent();
        }
        return this.isConsuming;
    }

    protected int getIgnorableModifier() {
        if (this.instance != null || this.needsInstance) {
            return this.getInstance().getIgnorableModifier();
        }
        return this.ignorableModifier;
    }

    public void comboBoxItemLoader(WmiComboBox wmiComboBox, WmiModel wmiModel) {
        this.getInstance().comboBoxItemLoader(wmiComboBox, wmiModel);
    }

    public void updateComboBoxSelection(WmiComboBox wmiComboBox, WmiModel wmiModel) {
        this.getInstance().updateComboBoxSelection(wmiComboBox, wmiModel);
    }

    public void updateComboBoxSelection(WmiComboBox wmiComboBox, WmiView wmiView) {
        this.getInstance().updateComboBoxSelection(wmiComboBox, wmiView);
    }

    public AbstractButton createButton(int n) {
        return this.getInstance().createButton(n);
    }

    public AbstractButton createButton(int n, int n2) {
        return this.getInstance().createButton(n, n2);
    }

    protected String getResourcePath() {
        if (this.instance != null || this.needsInstance) {
            return this.getInstance().getResourcePath();
        }
        return this.resourcePath;
    }

    public void doCommand(ActionEvent actionEvent) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.getInstance().doCommand(actionEvent);
    }

    public JMenuItem createMenuItem() {
        return this.getInstance().createMenuItem();
    }

    public JMenuItem createMenuItem(String string) {
        return this.getInstance().createMenuItem(string);
    }

    public JMenuItem createMenuItem(String string, String string2) {
        return this.getInstance().createMenuItem(string, string2);
    }

    public JMenuItem createMenuItem(JMenu jMenu) {
        return this.getInstance().createMenuItem(jMenu);
    }

    public void addMenuListeners(JMenu jMenu, JMenuItem jMenuItem) {
        this.getInstance().addMenuListeners(jMenu, jMenuItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WmiCommand getInstance() {
        if (this.instance == null) {
            boolean bl = WmiCommand.isAutoRegisterEnabled();
            try {
                WmiCommand.setAutoRegister(false);
                Class<?> clazz = Class.forName(this.commandClassName);
                this.instance = (WmiCommand)clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                WmiErrorLog.log(illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                WmiErrorLog.log(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                WmiErrorLog.log(instantiationException);
            }
            finally {
                WmiCommand.setAutoRegister(bl);
            }
        }
        return this.instance;
    }

    public boolean canQueue(String string) {
        return this.getInstance().canQueue(string);
    }
}

