/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public final class WmiDocumentScroller {
    private static final int BUFFER = 2;

    private WmiDocumentScroller() {
    }

    public static void scrollVisible(WmiScrollableContainerView wmiScrollableContainerView, Rectangle rectangle) {
        Rectangle rectangle2 = wmiScrollableContainerView.getVisibleRect();
        boolean bl = false;
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        int n3 = WmiDocumentScroller.constrain(rectangle.y, wmiScrollableContainerView.getHeight());
        int n4 = WmiDocumentScroller.constrain(rectangle.y + rectangle.height, wmiScrollableContainerView.getHeight());
        int n5 = WmiDocumentScroller.constrain(rectangle.x, wmiScrollableContainerView.getWidth());
        int n6 = WmiDocumentScroller.constrain(rectangle.x + rectangle.width, wmiScrollableContainerView.getWidth());
        if (rectangle2 != null) {
            if (rectangle2.y + rectangle2.height < n4 - 2) {
                n2 = n4 - rectangle2.height;
                bl = true;
            } else if (rectangle2.y > n3) {
                n2 = n3;
                bl = true;
            }
            if (rectangle2.x + rectangle2.width < n6 - 2) {
                n = n6 - rectangle2.width;
                bl = true;
            } else if (rectangle2.x > n5) {
                n = n5;
                bl = true;
            }
        }
        if (bl) {
            if (wmiScrollableContainerView instanceof WmiMathDocumentView) {
                ((WmiMathDocumentView)wmiScrollableContainerView).setVisibleRegion(n, n2);
            } else {
                SwingUtilities.invokeLater(new WmiDelayedScroll(wmiScrollableContainerView, n, n2));
            }
        }
    }

    private static int constrain(int n, int n2) {
        n = Math.max(n, 0);
        n = Math.min(n, n2);
        return n;
    }

    public static void scrollToTop(WmiScrollableContainerView wmiScrollableContainerView, Rectangle rectangle) {
        Rectangle rectangle2 = wmiScrollableContainerView.getVisibleRect();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        if (rectangle2 != null) {
            n2 = rectangle.y > wmiScrollableContainerView.getHeight() - rectangle2.height ? wmiScrollableContainerView.getHeight() - rectangle2.height : rectangle.y;
            if (rectangle.x > wmiScrollableContainerView.getWidth() - rectangle2.width) {
                n = wmiScrollableContainerView.getWidth() - rectangle2.width;
            }
            SwingUtilities.invokeLater(new WmiDelayedScroll(wmiScrollableContainerView, n, n2));
        }
    }

    public static Rectangle getViewBounds(WmiPositionedView wmiPositionedView) {
        Point point = WmiViewUtil.getAbsoluteOffset(wmiPositionedView);
        return new Rectangle(point.x, point.y, wmiPositionedView.getWidth(), wmiPositionedView.getHeight());
    }

    private static class WmiDelayedScroll
    implements Runnable {
        private int x;
        private int y;
        private WmiScrollableContainerView scrollable;

        private WmiDelayedScroll(WmiScrollableContainerView wmiScrollableContainerView, int n, int n2) {
            this.scrollable = wmiScrollableContainerView;
            this.x = n;
            this.y = n2;
        }

        public void run() {
            this.scrollable.setScrollPosition(this.x, this.y);
        }
    }
}

