/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.insert.WmiInsertGenericMathCommand;
import com.maplesoft.mathdoc.controller.insert.WmiInsertTokenCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.WmiUndoManager;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPathInterval;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputContext;
import java.awt.im.InputMethodHighlight;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;

public class WmiInputMethodRequestHandler
implements InputMethodRequests,
InputMethodListener {
    private static String undoInsertText = null;
    private static String undoDeleteText = null;
    private static Map twoDEditorKeys = null;
    private static boolean IM_DEBUG = false;
    private WmiMathDocumentView docView;
    private WmiTextModel insertModel = null;
    private int insertOffset = 0;
    private WmiCompositeModel parentModel = null;
    private int parentIndex = -1;
    private int select = -1;
    private WmiComposedModel composedModel = null;
    private boolean isMath = false;
    private WmiModel leftChild = null;
    private WmiModel rightChild = null;

    private static void initialize2DEditorKeys() {
        twoDEditorKeys = new HashMap();
        twoDEditorKeys.put(new Character('\uff3e'), "Insert.Msup");
        twoDEditorKeys.put(new Character('\uff3f'), "Insert.Msub");
        twoDEditorKeys.put(new Character('\uff0f'), "Insert.Mfrac");
        twoDEditorKeys.put(new Character('^'), "Insert.Msup");
        twoDEditorKeys.put(new Character('_'), "Insert.Msub");
        twoDEditorKeys.put(new Character('/'), "Insert.Mfrac");
        twoDEditorKeys.put(new Character('\u201d'), new Character('\"'));
        twoDEditorKeys.put(new Character('\uff1c'), new Character('<'));
        twoDEditorKeys.put(new Character('\uff1e'), new Character('>'));
        twoDEditorKeys.put(new Character('\uff1f'), new Character('?'));
        twoDEditorKeys.put(new Character('\uff1a'), new Character(':'));
        twoDEditorKeys.put(new Character('\uff1b'), new Character(';'));
        twoDEditorKeys.put(new Character('\u300c'), new Character('['));
        twoDEditorKeys.put(new Character('\u300d'), new Character(']'));
        twoDEditorKeys.put(new Character('\u300e'), new Character('{'));
        twoDEditorKeys.put(new Character('\u300f'), new Character('}'));
        twoDEditorKeys.put(new Character('\\'), new Character('\\'));
        twoDEditorKeys.put(new Character('\uff5c'), new Character('|'));
        twoDEditorKeys.put(new Character('\uff40'), new Character('`'));
        twoDEditorKeys.put(new Character('\uff01'), new Character('!'));
        twoDEditorKeys.put(new Character('\uff05'), new Character('%'));
        twoDEditorKeys.put(new Character('\uff06'), new Character('&'));
        twoDEditorKeys.put(new Character('\uff0a'), new Character('*'));
        twoDEditorKeys.put(new Character('\uff08'), new Character('('));
        twoDEditorKeys.put(new Character('\uff09'), new Character(')'));
        twoDEditorKeys.put(new Character('\uff1d'), new Character('='));
        twoDEditorKeys.put(new Character('\uff0b'), new Character('+'));
        twoDEditorKeys.put(new Character('\uff10'), new Character('0'));
        twoDEditorKeys.put(new Character('\uff11'), new Character('1'));
        twoDEditorKeys.put(new Character('\uff12'), new Character('2'));
        twoDEditorKeys.put(new Character('\uff13'), new Character('3'));
        twoDEditorKeys.put(new Character('\uff14'), new Character('4'));
        twoDEditorKeys.put(new Character('\uff15'), new Character('5'));
        twoDEditorKeys.put(new Character('\uff16'), new Character('6'));
        twoDEditorKeys.put(new Character('\uff17'), new Character('7'));
        twoDEditorKeys.put(new Character('\uff18'), new Character('8'));
        twoDEditorKeys.put(new Character('\uff19'), new Character('9'));
    }

    public WmiInputMethodRequestHandler(WmiMathDocumentView wmiMathDocumentView) {
        this.docView = wmiMathDocumentView;
    }

    private String printAttributes(AttributedCharacterIterator.Attribute[] attributeArray) {
        String string = "null";
        if (IM_DEBUG && attributeArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            for (int i = 0; i < attributeArray.length; ++i) {
                stringBuffer.append(attributeArray[i]);
                if (i >= attributeArray.length - 1) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append(']');
            string = stringBuffer.toString();
        }
        return string;
    }

    private void imlog(String string) {
        if (IM_DEBUG) {
            System.out.println(string);
        }
    }

    public Rectangle getTextLocation(TextHitInfo textHitInfo) {
        int n = textHitInfo != null ? textHitInfo.getCharIndex() : 0;
        Rectangle rectangle = null;
        WmiCaret wmiCaret = this.docView.getCaret();
        if (wmiCaret != null) {
            rectangle = wmiCaret.getBounds();
            Point point = this.docView.getLocationOnScreen();
            rectangle.x += point.x;
            rectangle.y += point.y;
        } else if (this.composedModel != null) {
            rectangle = this.composedModel.getCaretBounds(n);
        }
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        if (IM_DEBUG) {
            System.out.println("getTextLocation returning [" + rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height + "]");
        }
        return rectangle;
    }

    public TextHitInfo getLocationOffset(int n, int n2) {
        this.imlog("*** getLocationOffset(" + n + "," + n2 + ")");
        return null;
    }

    public int getInsertPositionOffset() {
        this.imlog("*** getInsertPositionOffset()");
        return 0;
    }

    public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        if (IM_DEBUG) {
            System.out.println("*** getCommittedText(" + n + "," + n2 + "," + this.printAttributes(attributeArray) + ")");
        }
        return null;
    }

    public int getCommittedTextLength() {
        this.imlog("*** getCommittedTextLength()");
        return 0;
    }

    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        if (IM_DEBUG) {
            System.out.println("*** cancelLatestCommittedText(" + this.printAttributes(attributeArray) + ")");
        }
        return null;
    }

    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        if (IM_DEBUG) {
            System.out.println("*** getSelectedText(" + this.printAttributes(attributeArray) + ")");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        WmiCaret wmiCaret = this.docView.getCaret();
        boolean bl = false;
        if (WmiModelLock.readLock(this.docView.getModel(), true)) {
            try {
                bl = wmiCaret != null && !wmiCaret.isReadOnly();
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                WmiModelLock.readUnlock(this.docView.getModel());
            }
        }
        if (bl) {
            Object object;
            if (this.insertModel == null) {
                WmiPositionedView wmiPositionedView = wmiCaret.getView();
                object = wmiPositionedView != null ? wmiPositionedView.getModel() : null;
                this.isMath = object instanceof WmiMathModel;
            }
            int n = inputMethodEvent.getCommittedCharacterCount();
            object = inputMethodEvent.getText();
            Object var6_10 = null;
            if (this.isMath) {
                if (object != null) {
                    char c = object.last();
                    var6_10 = twoDEditorKeys.get(new Character(c));
                }
                if (var6_10 != null) {
                    this.commitComposedText();
                    InputContext inputContext = this.docView.getInputContext();
                    if (inputContext != null) {
                        inputContext.endComposition();
                    }
                    inputMethodEvent.consume();
                    if (n > 0) {
                        this.insert2DMathEquivalent(var6_10);
                    }
                }
            }
            if (!inputMethodEvent.isConsumed()) {
                if (this.composedModel == null && n > 0) {
                    if (this.isMath) {
                        WmiInsertTokenCommand.insertComposedText(this.getText(inputMethodEvent), this.docView, undoInsertText);
                    } else {
                        this.textInsert(inputMethodEvent);
                    }
                    inputMethodEvent.consume();
                } else {
                    if (this.isMath && this.composedModel == null && object != null) {
                        WmiInsertTokenCommand.createComposedText(this.docView, undoInsertText);
                        this.beginEdit();
                    }
                    if (WmiModelLock.writeLock(this.docView.getModel(), true)) {
                        try {
                            this.updateComposedText(inputMethodEvent);
                        }
                        catch (WmiNoReadAccessException wmiNoReadAccessException) {
                            WmiErrorLog.log(wmiNoReadAccessException);
                        }
                        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                            WmiErrorLog.log(wmiNoWriteAccessException);
                        }
                        finally {
                            WmiModelLock.writeUnlock(this.docView.getModel());
                        }
                    }
                }
            }
        } else {
            inputMethodEvent.consume();
            InputContext inputContext = this.docView.getInputContext();
            if (inputContext != null) {
                inputContext.endComposition();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert2DMathEquivalent(Object object) {
        if (object instanceof Character) {
            char c = ((Character)object).charValue();
            if (WmiModelLock.writeLock(this.docView.getModel(), true)) {
                try {
                    WmiInsertTokenCommand.insertAndUpdate(c, this.docView, undoInsertText);
                }
                catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                    WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
                catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
                    WmiErrorLog.log(wmiNoUpdateAccessException);
                }
                catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                    WmiErrorLog.log(wmiNoWriteAccessException);
                }
                finally {
                    WmiModelLock.writeUnlock(this.docView.getModel());
                }
            }
        } else if (object instanceof String) {
            WmiCommand.invokeCommand((String)object);
        }
    }

    private void textInsert(InputMethodEvent inputMethodEvent) {
        WmiPositionedView wmiPositionedView;
        WmiCaret wmiCaret = this.docView.getCaret();
        WmiSelection wmiSelection = this.docView.getSelection();
        if (wmiSelection != null) {
            wmiSelection.replaceSelection(this.getText(inputMethodEvent));
        } else if (wmiCaret != null && (wmiPositionedView = wmiCaret.getView()) instanceof WmiTextView) {
            int n = wmiCaret.getOffset();
            ((WmiTextView)wmiPositionedView).insertString(this.getText(inputMethodEvent), n);
        }
    }

    private String getText(InputMethodEvent inputMethodEvent) {
        String string = null;
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        char c = attributedCharacterIterator.first();
        int n = inputMethodEvent.getCommittedCharacterCount();
        if (n == 1) {
            string = Character.toString(c);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            while (c != '\uffff') {
                stringBuffer.append(c);
                c = attributedCharacterIterator.next();
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private void updateComposedText(InputMethodEvent inputMethodEvent) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int n;
        TextHitInfo textHitInfo = inputMethodEvent.getCaret();
        int n2 = n = textHitInfo != null ? textHitInfo.getCharIndex() : 0;
        if (RuntimePlatform.isMac() && RuntimePlatform.isJava15()) {
            ++n;
        }
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        int n3 = inputMethodEvent.getCommittedCharacterCount();
        boolean bl = true;
        if (attributedCharacterIterator != null) {
            if (this.insertModel == null) {
                this.setupInsertModel();
            }
            if (this.insertModel != null) {
                this.beginEdit();
                if (this.composedModel == null) {
                    this.composedModel = new WmiComposedModel(this.insertModel.getDocument(), this.insertModel, this.insertOffset);
                } else {
                    this.composedModel.removeComposedTextFromParent();
                    this.composedModel.reset(false);
                }
            }
            this.composedModel.setPositionMarker(n);
            if (this.insertModel != null && this.parentIndex >= 0) {
                bl = this.composedModel.update(attributedCharacterIterator, n3);
                try {
                    int n4 = this.composedModel.getChildCount();
                    int n5 = this.parentIndex;
                    for (int i = 0; i < n4; ++i) {
                        WmiTextModel wmiTextModel = (WmiTextModel)this.composedModel.getChild(i);
                        if (wmiTextModel.getText().length() <= 0) continue;
                        this.parentModel.addChild(wmiTextModel, n5);
                        ++n5;
                    }
                    if (!bl) {
                        WmiMathDocumentModel wmiMathDocumentModel = this.composedModel.getDocument();
                        wmiMathDocumentModel.update(undoInsertText);
                    }
                }
                catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                    WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
                }
                catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
                    WmiErrorLog.log(wmiNoUpdateAccessException);
                }
            }
            this.composedModel.updateCaretPosition();
            if (this.select != -1) {
                WmiTextModel wmiTextModel = null;
                wmiTextModel = (WmiTextModel)this.composedModel.getChild(this.select);
                WmiInputMethodPathInterval wmiInputMethodPathInterval = new WmiInputMethodPathInterval(this.docView);
                wmiInputMethodPathInterval.updateSelection(wmiTextModel, 0, wmiTextModel, wmiTextModel.getText().length());
                this.docView.setSelection(wmiInputMethodPathInterval);
                this.select = -1;
            } else {
                this.docView.setSelection(null);
            }
        } else if (this.composedModel != null) {
            this.composedModel.removeComposedTextFromParent();
            this.composedModel.reset(true);
        }
        if (bl) {
            this.commitComposedText();
        }
        inputMethodEvent.consume();
    }

    public void commitComposedText() {
        if (this.composedModel != null) {
            this.composedModel.finalCommit();
            WmiUndoManager wmiUndoManager = this.composedModel.getDocument().getUndoManager();
            wmiUndoManager.endEdit();
        }
        this.insertModel = null;
        this.parentModel = null;
        this.leftChild = null;
        this.rightChild = null;
        this.composedModel = null;
        this.parentIndex = -1;
        this.insertOffset = 0;
        this.select = -1;
    }

    private void setupInsertModel() {
        WmiCaret wmiCaret;
        WmiPositionedView wmiPositionedView;
        WmiSelection wmiSelection = this.docView.getSelection();
        if (wmiSelection != null) {
            wmiSelection.deleteSelection();
        }
        if ((wmiPositionedView = (wmiCaret = this.docView.getCaret()).getView()) instanceof WmiTextView) {
            this.insertModel = (WmiTextModel)wmiPositionedView.getModel();
            this.insertOffset = wmiCaret.getOffset() + ((WmiTextView)wmiPositionedView).getStartOffset();
        }
    }

    private void beginEdit() {
        WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)this.docView.getModel();
        WmiUndoManager wmiUndoManager = wmiMathDocumentModel.getUndoManager();
        wmiUndoManager.beginEdit(undoInsertText);
    }

    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
        this.imlog("*** caretPositionChanged");
    }

    public boolean isActive() {
        return this.insertModel != null;
    }

    static {
        try {
            WmiResourcePackage wmiResourcePackage = WmiResourcePackage.getResourcePackage("com.maplesoft.mathdoc.view.resources.View");
            undoInsertText = wmiResourcePackage.getStringForKey("InsertText.undo");
            undoDeleteText = wmiResourcePackage.getStringForKey("DeleteText.undo");
        }
        catch (MissingResourceException missingResourceException) {
            WmiErrorLog.log(missingResourceException);
        }
        WmiInputMethodRequestHandler.initialize2DEditorKeys();
    }

    protected static class WmiInputMethodPathInterval
    extends WmiViewPathInterval {
        private WmiInputMethodPathInterval(WmiMathDocumentView wmiMathDocumentView) {
            super(wmiMathDocumentView);
        }

        public boolean hideCaret() {
            return false;
        }
    }

    protected class WmiComposedModel
    extends WmiAbstractArrayCompositeModel {
        private WmiFontAttributeSet composedAttributes;
        private WmiFontAttributeSet convertedSelectedAttributes;
        private WmiFontAttributeSet convertedUnselectedAttributes;
        private WmiTextModel prefixModel;
        private WmiTextModel suffixModel;
        private WmiTextModel originalModel;
        private int caretPositionIndex;
        private boolean reset;

        private WmiComposedModel(WmiMathDocumentModel wmiMathDocumentModel, WmiTextModel wmiTextModel, int n) {
            super(wmiMathDocumentModel);
            this.composedAttributes = null;
            this.convertedSelectedAttributes = null;
            this.convertedUnselectedAttributes = null;
            this.prefixModel = null;
            this.suffixModel = null;
            this.originalModel = null;
            this.caretPositionIndex = 0;
            this.reset = false;
            this.initialize(wmiTextModel, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize(WmiTextModel wmiTextModel, int n) {
            this.originalModel = wmiTextModel;
            WmiMathDocumentModel wmiMathDocumentModel = this.originalModel.getDocument();
            try {
                WmiModelLock.writeLock(wmiMathDocumentModel, true);
                WmiFontAttributeSet wmiFontAttributeSet = (WmiFontAttributeSet)this.originalModel.getAttributesForRead();
                this.composedAttributes = (WmiFontAttributeSet)wmiFontAttributeSet.copyAttributes();
                this.convertedSelectedAttributes = (WmiFontAttributeSet)wmiFontAttributeSet.copyAttributes();
                this.convertedUnselectedAttributes = (WmiFontAttributeSet)wmiFontAttributeSet.copyAttributes();
                WmiInputMethodRequestHandler.this.parentModel = this.originalModel.getParent();
                this.composedAttributes.setExtendedStyle(256);
                this.convertedSelectedAttributes.setExtendedStyle(1536);
                this.convertedUnselectedAttributes.setExtendedStyle(512);
                String string = this.getTextContents(this.originalModel);
                String string2 = string.substring(0, n);
                String string3 = string.substring(n);
                this.prefixModel = this.createTextModel(string2, this.originalModel, wmiFontAttributeSet);
                this.suffixModel = this.createTextModel(string3, this.originalModel, wmiFontAttributeSet);
                this.appendChild(this.prefixModel);
                this.appendChild(this.suffixModel);
                WmiInputMethodRequestHandler.this.parentIndex = WmiInputMethodRequestHandler.this.parentModel.indexOf(this.originalModel);
                if (WmiInputMethodRequestHandler.this.parentIndex > 0) {
                    WmiInputMethodRequestHandler.this.leftChild = WmiInputMethodRequestHandler.this.parentModel.getChild(WmiInputMethodRequestHandler.this.parentIndex - 1);
                } else {
                    WmiInputMethodRequestHandler.this.leftChild = null;
                }
                if (WmiInputMethodRequestHandler.this.parentIndex < WmiInputMethodRequestHandler.this.parentModel.getChildCount() - 1) {
                    WmiInputMethodRequestHandler.this.rightChild = WmiInputMethodRequestHandler.this.parentModel.getChild(WmiInputMethodRequestHandler.this.parentIndex + 1);
                } else {
                    WmiInputMethodRequestHandler.this.rightChild = null;
                }
                if (WmiInputMethodRequestHandler.this.parentIndex >= 0) {
                    WmiInputMethodRequestHandler.this.parentModel.removeChild(WmiInputMethodRequestHandler.this.parentIndex);
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
            finally {
                WmiModelLock.writeUnlock(wmiMathDocumentModel);
            }
        }

        private String getTextContents(WmiTextModel wmiTextModel) throws WmiNoReadAccessException {
            return wmiTextModel.getText();
        }

        protected void reset(boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            this.reset = bl;
            try {
                int n = this.getChildCount();
                if (n > 2) {
                    this.removeChildren(1, n - 2);
                }
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
        }

        protected void removeComposedTextFromParent() throws WmiNoReadAccessException, WmiNoWriteAccessException {
            if (WmiInputMethodRequestHandler.this.parentModel != null && WmiInputMethodRequestHandler.this.parentIndex >= 0) {
                try {
                    int n = this.getChildCount();
                    if (n > 0) {
                        int n2 = 0;
                        if (WmiInputMethodRequestHandler.this.leftChild != null) {
                            n2 = WmiInputMethodRequestHandler.this.parentModel.indexOf(WmiInputMethodRequestHandler.this.leftChild) + 1;
                        }
                        int n3 = WmiInputMethodRequestHandler.this.rightChild != null ? WmiInputMethodRequestHandler.this.parentModel.indexOf(WmiInputMethodRequestHandler.this.rightChild) - n2 : WmiInputMethodRequestHandler.this.parentModel.getChildCount() - n2;
                        WmiInputMethodRequestHandler.this.parentModel.removeChildren(n2, n3);
                    }
                }
                catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                    WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
                }
            }
        }

        protected WmiTextModel createTextModel(String string, WmiModel wmiModel, WmiFontAttributeSet wmiFontAttributeSet) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            return new WmiTextModel(WmiInputMethodRequestHandler.this.parentModel.getDocument(), string, wmiFontAttributeSet);
        }

        protected boolean update(AttributedCharacterIterator attributedCharacterIterator, int n) {
            boolean bl = attributedCharacterIterator.getEndIndex() == n;
            char c = attributedCharacterIterator.first();
            int n2 = attributedCharacterIterator.getRunLimit();
            Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
            InputMethodHighlight inputMethodHighlight = null;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            int n4 = 1;
            while (c != '\uffff') {
                stringBuffer.append(c);
                map = attributedCharacterIterator.getAttributes();
                inputMethodHighlight = (InputMethodHighlight)map.get(TextAttribute.INPUT_METHOD_HIGHLIGHT);
                if (inputMethodHighlight != null) {
                    bl3 = inputMethodHighlight.getState() == 1;
                    bl2 = inputMethodHighlight.isSelected();
                }
                c = attributedCharacterIterator.next();
                if (++n3 < n2) continue;
                if (stringBuffer.length() > 0 && n3 >= n) {
                    if (n3 == n) {
                        this.commitText(stringBuffer.toString());
                    } else if (n3 > n) {
                        this.addChild(stringBuffer.toString(), n4++, bl2, bl3);
                    }
                    if (!bl2 && !bl3) {
                        bl4 = true;
                    }
                    if (bl2) {
                        this.setPositionMarker(n3);
                    }
                    if (bl2 && !bl3) {
                        WmiInputMethodRequestHandler.this.select = n4 - 1;
                    }
                    stringBuffer.setLength(0);
                }
                n2 = attributedCharacterIterator.getRunLimit();
            }
            if (stringBuffer.length() > 0) {
                this.addChild(stringBuffer.toString(), n4, bl2, bl3);
            }
            if (!bl4 || WmiInputMethodRequestHandler.this.select != -1) {
                this.setPositionMarker(attributedCharacterIterator.getEndIndex());
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void commitText(String string) {
            if (WmiModelLock.writeLock(this, true)) {
                try {
                    this.prefixModel.appendText(string);
                    this.setPositionMarker(0);
                }
                catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                    WmiErrorLog.log(wmiNoWriteAccessException);
                }
                catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                    WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
                finally {
                    WmiModelLock.writeUnlock(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addChild(String string, int n, boolean bl, boolean bl2) {
            WmiFontAttributeSet wmiFontAttributeSet = null;
            wmiFontAttributeSet = bl2 ? (bl ? this.convertedSelectedAttributes : this.convertedUnselectedAttributes) : this.composedAttributes;
            if (WmiModelLock.writeLock(this, true)) {
                try {
                    WmiTextModel wmiTextModel = this.createTextModel(string, this.originalModel, wmiFontAttributeSet);
                    this.addChild(wmiTextModel, n);
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
                catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                    WmiErrorLog.log(wmiNoWriteAccessException);
                }
                catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                    WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
                }
                finally {
                    WmiModelLock.writeUnlock(this);
                }
            }
        }

        protected void setPositionMarker(int n) {
            this.caretPositionIndex = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateCaretPosition() {
            block9: {
                if (WmiModelLock.readLock(this, true)) {
                    try {
                        int n = this.getChildCount() - 1;
                        if (n <= 1) {
                            this.setPositionMarker(this.prefixModel, this.prefixModel.getLength());
                            break block9;
                        }
                        int n2 = 0;
                        for (int i = 1; i < n; ++i) {
                            WmiTextModel wmiTextModel = (WmiTextModel)this.getChild(i);
                            int n3 = this.getTextContents(wmiTextModel).length();
                            if ((n2 += n3) < this.caretPositionIndex) continue;
                            int n4 = this.caretPositionIndex - (n2 - n3);
                            if (n4 < 0) {
                                Toolkit.getDefaultToolkit().beep();
                                n4 = 0;
                            }
                            this.setPositionMarker(wmiTextModel, n4);
                            break;
                        }
                    }
                    catch (WmiNoReadAccessException wmiNoReadAccessException) {
                        WmiErrorLog.log(wmiNoReadAccessException);
                    }
                    finally {
                        WmiModelLock.readUnlock(this);
                    }
                }
            }
        }

        protected void setPositionMarker(WmiModel wmiModel, int n) throws WmiNoReadAccessException {
            WmiCaret wmiCaret = WmiInputMethodRequestHandler.this.docView.getCaret();
            if (wmiCaret != null) {
                wmiCaret.updateMarkerPosition(wmiModel, n);
            } else {
                wmiCaret = new WmiCaret(WmiInputMethodRequestHandler.this.docView);
                wmiCaret.updateMarkerPosition(wmiModel, n);
            }
        }

        protected int getCaretPositionIndex() {
            return this.caretPositionIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Rectangle getCaretBounds(int n) {
            Rectangle rectangle = null;
            try {
                WmiModelLock.readLock(this, true);
                int n2 = this.getChildCount();
                WmiTextModel wmiTextModel = null;
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    wmiTextModel = (WmiTextModel)this.getChild(i);
                    int n4 = wmiTextModel.getLength();
                    if (n3 + n4 >= n) {
                        int n5 = n - n3;
                        WmiView wmiView = WmiViewUtil.modelToView(WmiInputMethodRequestHandler.this.docView, wmiTextModel, n5);
                        if (wmiView instanceof WmiTextView) {
                            WmiTextView wmiTextView = (WmiTextView)wmiView;
                            Point point = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)wmiView);
                            int n6 = wmiTextView.getHorizontalOffset(n5 -= wmiTextView.getStartOffset());
                            int n7 = point.y;
                            point = WmiInputMethodRequestHandler.this.docView.getLocationOnScreen();
                            rectangle = new Rectangle(n6 += point.x, n7 += point.y, 1, ((WmiPositionedView)wmiView).getHeight());
                        }
                    }
                    n3 += n4;
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                WmiModelLock.readUnlock(this);
            }
            return rectangle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalCommit() {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                WmiModelLock.writeLock(this, true);
                int n = this.getChildCount();
                WmiTextModel wmiTextModel = null;
                for (int i = 0; i < n; ++i) {
                    wmiTextModel = (WmiTextModel)this.getChild(i);
                    stringBuffer.append(this.getTextContents(wmiTextModel));
                }
                WmiModel[] wmiModelArray = new WmiModel[]{this.createTextModel(stringBuffer.toString(), this.originalModel, (WmiFontAttributeSet)this.originalModel.getAttributes())};
                this.removeComposedTextFromParent();
                WmiInputMethodRequestHandler.this.parentModel.addChildren(wmiModelArray, WmiInputMethodRequestHandler.this.parentIndex);
                this.reset = false;
                WmiModel wmiModel = wmiModelArray[0];
                int n2 = stringBuffer.length() - this.getTextContents(this.suffixModel).length();
                WmiModelPosition wmiModelPosition = null;
                if (WmiInputMethodRequestHandler.this.isMath) {
                    wmiModelPosition = MathTokenizer.retokenize((WmiTextModel)wmiModel, n2);
                    WmiInsertGenericMathCommand.refreshSemantics(WmiInputMethodRequestHandler.this.parentModel);
                } else {
                    wmiModelPosition = new WmiModelPosition(wmiModel, n2);
                }
                WmiInputMethodRequestHandler.this.docView.setPendingPosition(wmiModelPosition);
                this.getDocument().update(undoInsertText);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
            catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
                WmiErrorLog.log(wmiNoUpdateAccessException);
            }
            finally {
                WmiModelLock.writeUnlock(this);
            }
        }

        public WmiModelTag getTag() {
            return WmiModelTag.COMPOSED;
        }

        public boolean isVisible() {
            return true;
        }
    }
}

