/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiClipboardManager;
import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.controller.WmiController;
import com.maplesoft.mathdoc.controller.WmiDataActionEvent;
import com.maplesoft.mathdoc.controller.WmiInputMethodRequestHandler;
import com.maplesoft.mathdoc.controller.WmiMouseInputAdapter;
import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.controller.edit.WmiMathDocumentEditUnixCopy;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiContainerView;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionInView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPosition;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.im.InputMethodRequests;
import java.util.EventListener;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class WmiMathDocumentMouseListener
extends WmiMouseInputAdapter
implements MouseWheelListener {
    public static final int MOUSE_DRAGGED = 0;
    public static final int MOUSE_MOVED = 1;
    public static final int MOUSE_CLICKED = 2;
    public static final int MOUSE_PRESSED = 3;
    public static final int MOUSE_RELEASED = 4;
    public static final int MOUSE_ENTERED = 5;
    public static final int MOUSE_EXITED = 6;
    public static final int MOUSE_WHEEL_MOVED = 7;
    protected WmiMathDocumentView rootView = null;
    private WmiView currentViewUnderMouse = null;
    private MousePathHierarchy viewHierarchyUnderMouse = new MousePathHierarchy();
    private WmiView mouseDragView = null;
    private WmiController mouseDragController = null;
    private Point lastMousePoint = null;
    private boolean mouseDown = false;
    private WmiModel dndModel = null;
    private Point mouseLocInDndView = null;
    private Autoscroller scroller = null;
    private boolean autoscrollEnabledOnNextDrag = false;
    private boolean autoscroll = true;
    private boolean mouseDragViewToReceiveMove = false;
    private static boolean selectionMade = false;

    public WmiMathDocumentMouseListener(WmiMathDocumentView wmiMathDocumentView) {
        this.rootView = wmiMathDocumentView;
    }

    protected void saveMousePoint(MouseEvent mouseEvent) {
        this.lastMousePoint = mouseEvent.getPoint();
    }

    public Point getLastMousePoint() {
        return this.lastMousePoint;
    }

    public WmiView getDragSourceView() {
        return this.mouseDragView;
    }

    public WmiView getDropTargetView() {
        return this.mouseDown ? this.currentViewUnderMouse : this.getDragSourceView();
    }

    public void notifyDragAndDropComplete(WmiModel wmiModel, Point point) {
        if (this.currentViewUnderMouse != null) {
            this.dndModel = wmiModel;
            this.mouseLocInDndView = point;
            this.mouseDragView = null;
        }
    }

    public void setDispatchInhibit(boolean bl) {
    }

    public void setMouseDragView(WmiView wmiView) {
        this.mouseDragView = wmiView;
    }

    public void setDragViewToReceiveMove(boolean bl) {
        this.mouseDragViewToReceiveMove = bl;
    }

    public void setAutoscroll(boolean bl) {
        this.autoscroll = bl;
    }

    public boolean isAutoscrollEnabled() {
        return this.autoscroll;
    }

    public boolean isDragAndDropArmed() {
        boolean bl = false;
        WmiClipboardManager wmiClipboardManager = this.rootView.getClipboardManager();
        bl = wmiClipboardManager != null ? wmiClipboardManager.isEnabled() : false;
        return bl;
    }

    protected void armDragAndDrop(boolean bl) {
        WmiClipboardManager wmiClipboardManager = this.rootView.getClipboardManager();
        if (wmiClipboardManager != null) {
            wmiClipboardManager.armDragAndDrop(bl);
        }
    }

    protected Object getListenerFromViewAndEventType(WmiView wmiView, int n) {
        EventListener eventListener = null;
        if (!this.rootView.getInputLock().isLocked()) {
            WmiController wmiController;
            WmiController wmiController2 = wmiController = this.mouseDragController != null ? this.mouseDragController : this.rootView.getViewFactory().getController(wmiView);
            if (wmiController != null) {
                if (n == 7) {
                    eventListener = wmiController.getMouseWheelListener();
                } else if (n >= 2) {
                    eventListener = wmiController.getMouseListener();
                } else if (n <= 1) {
                    eventListener = wmiController.getMouseMotionListener();
                }
            }
        }
        return eventListener;
    }

    protected void dispatchToView(WmiView wmiView, MouseEvent mouseEvent, int n) {
        Object object = this.getListenerFromViewAndEventType(wmiView, n);
        if (object != null) {
            Object object2 = mouseEvent.getSource();
            mouseEvent.setSource(wmiView);
            switch (n) {
                case 0: {
                    this.initiateAutoscroll((WmiPositionedView)wmiView, mouseEvent);
                    ((MouseMotionListener)object).mouseDragged(mouseEvent);
                    break;
                }
                case 1: {
                    ((MouseMotionListener)object).mouseMoved(mouseEvent);
                    break;
                }
                case 2: {
                    ((MouseListener)object).mouseClicked(mouseEvent);
                    break;
                }
                case 3: {
                    if (this.mouseDragViewToReceiveMove && this.mouseDragView != null && this.mouseDragView != wmiView) {
                        WmiView wmiView2 = this.mouseDragView;
                        this.mouseDragView = null;
                        this.mouseDragViewToReceiveMove = false;
                        this.rootView.notifyViewLostFocus(wmiView2);
                    }
                    this.autoscrollEnabledOnNextDrag = true;
                    ((MouseListener)object).mousePressed(mouseEvent);
                    break;
                }
                case 4: {
                    this.autoscrollEnabledOnNextDrag = false;
                    this.cancelAutoscroller();
                    ((MouseListener)object).mouseReleased(mouseEvent);
                    break;
                }
                case 5: {
                    this.autoscrollEnabledOnNextDrag = mouseEvent.getButton() == 1 && !mouseEvent.isPopupTrigger();
                    ((MouseListener)object).mouseEntered(mouseEvent);
                    break;
                }
                case 6: {
                    this.autoscrollEnabledOnNextDrag = false;
                    this.cancelAutoscroller();
                    ((MouseListener)object).mouseExited(mouseEvent);
                    break;
                }
                case 7: {
                    ((MouseWheelListener)object).mouseWheelMoved((MouseWheelEvent)mouseEvent);
                }
            }
            mouseEvent.setSource(object2);
        }
        if (n == 4) {
            if (!this.mouseDragViewToReceiveMove) {
                this.mouseDragView = null;
            }
            this.mouseDragController = null;
        }
    }

    private void initiateAutoscroll(WmiPositionedView wmiPositionedView, MouseEvent mouseEvent) {
        this.cancelAutoscroller();
        if (this.autoscrollEnabledOnNextDrag && this.autoscroll) {
            this.scroller = Autoscroller.createAutoscroller(this, wmiPositionedView, mouseEvent);
        }
    }

    private void cancelAutoscroller() {
        if (this.scroller != null) {
            this.scroller.reset();
            this.scroller = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WmiView findView(WmiView wmiView, int n, int n2) {
        WmiPositionedView wmiPositionedView = null;
        WmiView wmiView2 = null;
        boolean bl = false;
        if (wmiView instanceof WmiPositionedView) {
            WmiModel wmiModel = null;
            try {
                wmiModel = wmiView.getModel();
                if (wmiModel != null) {
                    if (!WmiModelLock.ownsWriteLock(wmiModel)) {
                        bl = WmiModelLock.readLock(wmiModel, true);
                    }
                    wmiPositionedView = ((WmiPositionedView)wmiView).getChildView(new Point(n -= ((WmiPositionedView)wmiView).getHorizontalOffset(), n2 -= ((WmiPositionedView)wmiView).getVerticalOffset()));
                }
            }
            finally {
                if (bl) {
                    WmiModelLock.readUnlock(wmiModel);
                }
            }
            wmiView2 = wmiPositionedView != null ? this.findView(wmiPositionedView, n, n2) : wmiView;
        }
        return wmiView2;
    }

    protected void findViewAndDispatch(WmiView wmiView, MouseEvent mouseEvent, int n, int n2) {
        WmiPositionedView wmiPositionedView = null;
        int n3 = 0;
        int n4 = 0;
        boolean bl = this.rootView.getInputLock().isLocked();
        if (bl) {
            if (mouseEvent.getID() == 501) {
                Toolkit.getDefaultToolkit().beep();
            }
            mouseEvent.consume();
        }
        if (!bl && wmiView instanceof WmiPositionedView) {
            if (n == 1) {
                this.viewHierarchyUnderMouse.setView(mouseEvent, (WmiPositionedView)wmiView, n2);
            }
            n3 = ((WmiPositionedView)wmiView).getHorizontalOffset();
            n4 = ((WmiPositionedView)wmiView).getVerticalOffset();
            mouseEvent.translatePoint(-n3, -n4);
            wmiPositionedView = ((WmiPositionedView)wmiView).getChildView(mouseEvent.getPoint());
            if (wmiPositionedView != null) {
                this.findViewAndDispatch(wmiPositionedView, mouseEvent, n, n2 + 1);
            } else if (n == 1) {
                this.viewHierarchyUnderMouse.exitViews(mouseEvent, n2 + 1);
            }
            if (!mouseEvent.isConsumed()) {
                this.dispatchToView(wmiView, mouseEvent, n);
            }
            mouseEvent.translatePoint(n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent mouseEvent) {
        try {
            WmiPositionedView wmiPositionedView;
            boolean bl;
            this.consumeOnActiveInputMethod(mouseEvent);
            boolean bl2 = bl = this.dndModel != null;
            if (!mouseEvent.isConsumed() && !this.isDragAndDropArmed()) {
                this.saveMousePoint(mouseEvent);
                wmiPositionedView = this.findEventSourceView(mouseEvent);
                WmiPositionedView wmiPositionedView2 = (WmiPositionedView)this.mouseDragView;
                if (!mouseEvent.isConsumed()) {
                    this.currentViewUnderMouse = this.findView(this.rootView, mouseEvent.getX(), mouseEvent.getY());
                    if (this.dndModel != null && WmiModelLock.readLock(this.dndModel, true)) {
                        try {
                            this.mouseDragView = WmiViewUtil.modelToView(this.rootView, this.dndModel, 0);
                        }
                        catch (WmiNoReadAccessException wmiNoReadAccessException) {
                            WmiErrorLog.log(wmiNoReadAccessException);
                        }
                        finally {
                            WmiModelLock.readUnlock(this.dndModel);
                        }
                    }
                    if (wmiPositionedView2 == null || wmiPositionedView2.getModel() == null) {
                        this.findViewAndDispatch(wmiPositionedView, mouseEvent, 0, 0);
                        this.mouseDragView = null;
                    } else {
                        Object object;
                        int n = 0;
                        int n2 = 0;
                        if (wmiPositionedView2 != null) {
                            object = WmiViewUtil.containerRelativeOffset(wmiPositionedView2);
                            n = ((Point)object).x;
                            n2 = ((Point)object).y;
                            mouseEvent.translatePoint(-n, -n2);
                        }
                        if (this.dndModel != null && wmiPositionedView2 instanceof WmiContainerView) {
                            object = (WmiContainerView)((Object)wmiPositionedView2);
                            object.setPositionMarker(0);
                            Point point = mouseEvent.getPoint();
                            mouseEvent.translatePoint(-point.x + this.mouseLocInDndView.x, -point.y + this.mouseLocInDndView.y);
                            object.onMousePressed(mouseEvent);
                            mouseEvent.translatePoint(point.x - this.mouseLocInDndView.x, point.y - this.mouseLocInDndView.y);
                        }
                        this.dispatchToView(wmiPositionedView2, mouseEvent, 0);
                        mouseEvent.translatePoint(n, n2);
                    }
                }
            }
            if (bl) {
                this.dndModel = null;
            }
            if (!mouseEvent.isConsumed() && this.dndModel == null && (mouseEvent.getModifiers() & 0x10) != 0) {
                if (!this.isDragAndDropArmed()) {
                    WmiMathDocumentMouseListener.updateSelection(mouseEvent);
                } else {
                    wmiPositionedView = this.findEventSourceView(mouseEvent);
                    wmiPositionedView.getDocumentView().setCursor(WmiClipboardManager.getMoveCursor());
                }
            }
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        try {
            WmiPositionedView wmiPositionedView;
            this.saveMousePoint(mouseEvent);
            WmiPositionedView wmiPositionedView2 = wmiPositionedView = this.mouseDragViewToReceiveMove && this.mouseDragView != null ? (WmiPositionedView)this.mouseDragView : this.findEventSourceView(mouseEvent);
            if (this.mouseDragViewToReceiveMove && this.mouseDragView != null) {
                Point point = WmiViewUtil.getAbsoluteOffset(wmiPositionedView);
                mouseEvent.translatePoint(-point.x, -point.y);
            }
            this.findViewAndDispatch(wmiPositionedView, mouseEvent, 1, 0);
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            this.consumeOnActiveInputMethod(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                this.saveMousePoint(mouseEvent);
                WmiPositionedView wmiPositionedView = this.findEventSourceView(mouseEvent);
                int n = mouseEvent.getClickCount();
                if (this.enableDragOperation(mouseEvent) && n == 1) {
                    this.findViewAndDispatch(wmiPositionedView, mouseEvent, 3, 0);
                    if (!mouseEvent.isConsumed() && WmiMathDocumentMouseListener.isCaretPlacingEvent(mouseEvent)) {
                        if (!mouseEvent.isShiftDown()) {
                            WmiMathDocumentMouseListener.snapToNearestView(mouseEvent);
                        } else {
                            WmiMathDocumentMouseListener.updateSelection(mouseEvent);
                        }
                    }
                }
                this.findViewAndDispatch(wmiPositionedView, mouseEvent, 2, 0);
                if (!mouseEvent.isConsumed()) {
                    WmiCommandProxy wmiCommandProxy;
                    Transferable transferable;
                    Toolkit toolkit;
                    Clipboard clipboard;
                    if (mouseEvent.getButton() == 1) {
                        if (n > 1) {
                            WmiMathDocumentMouseListener.snapToNearestView(mouseEvent);
                            WmiPositionMarker wmiPositionMarker = this.rootView.getPositionMarker();
                            WmiPositionedView wmiPositionedView2 = wmiPositionMarker != null ? wmiPositionMarker.getView() : null;
                            WmiCommandProxy wmiCommandProxy2 = null;
                            if (n == 2) {
                                wmiCommandProxy2 = WmiCommand.getCommandProxy("select.word");
                            } else if (n == 3) {
                                wmiCommandProxy2 = WmiCommand.getCommandProxy("select.paragraph");
                            }
                            if (wmiCommandProxy2 != null && wmiPositionedView2 != null) {
                                ActionEvent actionEvent = new ActionEvent(wmiPositionedView2, 0, null);
                                wmiCommandProxy2.actionPerformed(actionEvent);
                                mouseEvent.consume();
                            }
                        }
                    } else if (mouseEvent.getButton() == 2 && n == 1 && RuntimePlatform.isUnix() && (clipboard = (toolkit = Toolkit.getDefaultToolkit()).getSystemSelection()) != null && (transferable = clipboard.getContents(null)) != null && (wmiCommandProxy = WmiCommand.getCommandProxy("MathDoc.Edit.Paste")) != null && ((WmiCommand)wmiCommandProxy).isEnabled(this.rootView)) {
                        WmiDataActionEvent wmiDataActionEvent = new WmiDataActionEvent((Object)this.rootView, 0, null, transferable);
                        wmiCommandProxy.actionPerformed(wmiDataActionEvent);
                        mouseEvent.consume();
                    }
                }
                if (!mouseEvent.isConsumed()) {
                    if (this.rootView.isBelowDocument(mouseEvent.getY()) && WmiMathDocumentMouseListener.isCaretPlacingEvent(mouseEvent)) {
                        WmiCommand.invokeCommand("move.document.end");
                    }
                    mouseEvent.consume();
                }
            }
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        try {
            this.consumeOnActiveInputMethod(mouseEvent);
            this.mouseDown = true;
            this.rootView.notifyMousePressed(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                WmiPositionedView wmiPositionedView = this.findEventSourceView(mouseEvent);
                this.saveMousePoint(mouseEvent);
                if (this.enableDragOperation(mouseEvent)) {
                    this.armDragAndDrop(true);
                } else {
                    this.armDragAndDrop(false);
                    this.findViewAndDispatch(wmiPositionedView, mouseEvent, 3, 0);
                    if (!mouseEvent.isConsumed()) {
                        if (WmiMathDocumentMouseListener.isPopupTrigger(mouseEvent)) {
                            this.rootView.notifyPopupRequest(this.rootView, mouseEvent);
                            mouseEvent.consume();
                        } else if (WmiMathDocumentMouseListener.isCaretPlacingEvent(mouseEvent)) {
                            WmiMathDocumentMouseListener.snapToNearestView(mouseEvent);
                            WmiMathDocumentMouseListener.updateSelection(mouseEvent);
                            mouseEvent.consume();
                        } else if (WmiMathDocumentMouseListener.isHighlightChangingEvent(mouseEvent)) {
                            WmiMathDocumentMouseListener.updateSelection(mouseEvent);
                            mouseEvent.consume();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    protected boolean enableDragOperation(MouseEvent mouseEvent) {
        boolean bl = false;
        boolean bl2 = false;
        Cursor cursor = this.rootView.getCursor();
        if (cursor.equals(Cursor.getPredefinedCursor(10))) {
            bl2 = true;
        }
        bl = this.rootView.isInHighlight(mouseEvent);
        return bl;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (RuntimePlatform.isUnix() && selectionMade) {
            WmiCommand.invokeCommand("MathDoc.Edit.UnixCopy");
        }
        try {
            this.consumeOnActiveInputMethod(mouseEvent);
            this.currentViewUnderMouse = null;
            this.mouseDown = false;
            boolean bl = this.isDragAndDropArmed();
            this.armDragAndDrop(false);
            if (!mouseEvent.isConsumed()) {
                this.saveMousePoint(mouseEvent);
                WmiPositionedView wmiPositionedView = this.findEventSourceView(mouseEvent);
                if (this.mouseDragView == null) {
                    this.findViewAndDispatch(wmiPositionedView, mouseEvent, 4, 0);
                } else {
                    int n = 0;
                    int n2 = 0;
                    if (this.mouseDragView instanceof WmiPositionedView) {
                        Point point = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)this.mouseDragView);
                        n = point.x;
                        n2 = point.y;
                        mouseEvent.translatePoint(-n, -n2);
                    }
                    this.dispatchToView(this.mouseDragView, mouseEvent, 4);
                    mouseEvent.translatePoint(n, n2);
                }
                if (!mouseEvent.isConsumed() && WmiMathDocumentMouseListener.isPopupTrigger(mouseEvent)) {
                    this.rootView.notifyPopupRequest(this.rootView, mouseEvent);
                    mouseEvent.consume();
                }
                if (!mouseEvent.isConsumed() && bl && wmiPositionedView != null) {
                    WmiSelection wmiSelection = wmiPositionedView.getDocumentView().getSelection();
                    WmiMathDocumentMouseListener.snapToNearestView(mouseEvent);
                }
            }
            if (this.dndModel != null) {
                this.dndModel = null;
                this.mouseLocInDndView = null;
            }
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.saveMousePoint(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.saveMousePoint(mouseEvent);
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        JScrollPane jScrollPane;
        this.consumeOnActiveInputMethod(mouseWheelEvent);
        this.findViewAndDispatch(this.rootView, mouseWheelEvent, 7, 0);
        if (!mouseWheelEvent.isConsumed() && (jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this.rootView)) != null) {
            jScrollPane.dispatchEvent(mouseWheelEvent);
        }
    }

    private WmiPositionedView findEventSourceView(MouseEvent mouseEvent) {
        WmiPositionedView wmiPositionedView = this.rootView;
        if (mouseEvent != null) {
            Object object = mouseEvent.getSource();
            wmiPositionedView = object instanceof WmiPositionedView ? (WmiPositionedView)object : this.rootView;
        }
        return wmiPositionedView;
    }

    private void consumeOnActiveInputMethod(MouseEvent mouseEvent) {
        InputMethodRequests inputMethodRequests = this.rootView.getInputMethodRequests();
        if (inputMethodRequests instanceof WmiInputMethodRequestHandler && ((WmiInputMethodRequestHandler)inputMethodRequests).isActive()) {
            mouseEvent.consume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSelection(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        Object object = mouseEvent.getSource();
        if (!(object instanceof WmiPositionedView)) {
            return;
        }
        WmiMathDocumentView wmiMathDocumentView = ((WmiView)object).getDocumentView();
        if (wmiMathDocumentView == null) {
            return;
        }
        Point point = mouseEvent.getPoint();
        Point point2 = WmiViewUtil.containerRelativeOffset((WmiPositionedView)object);
        point2.x += point.x;
        point2.y += point.y;
        WmiViewFactory wmiViewFactory = wmiMathDocumentView.getViewFactory();
        WmiViewPosition wmiViewPosition = WmiViewUtil.findNearestView((WmiPositionedView)object, point2);
        WmiPositionedView wmiPositionedView = null;
        int n = 0;
        if (wmiViewPosition != null && wmiViewFactory != null) {
            wmiPositionedView = wmiViewPosition.getView();
            n = wmiViewPosition.getOffset();
            wmiViewFactory.updateSelection(wmiPositionedView, n);
            WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
            boolean bl = false;
            try {
                Rectangle rectangle;
                WmiHighlightPainter wmiHighlightPainter;
                bl = WmiModelLock.readLock(wmiMathDocumentModel, true);
                WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
                WmiHighlightPainter wmiHighlightPainter2 = wmiHighlightPainter = wmiSelection != null ? wmiSelection.getSelectionHighlighter() : null;
                if (wmiHighlightPainter != null && ((rectangle = wmiHighlightPainter.getBounds()) == null || rectangle.width <= 1)) {
                    wmiMathDocumentView.setSelection(null);
                    wmiPositionedView.setPositionMarker(n);
                }
                selectionMade = wmiSelection != null;
            }
            finally {
                if (bl) {
                    WmiModelLock.readUnlock(wmiMathDocumentModel);
                }
            }
        }
    }

    public static void snapToNearestView(MouseEvent mouseEvent) {
        WmiViewPosition wmiViewPosition = WmiMathDocumentMouseListener.getNearestViewPosition(mouseEvent, null);
        if (wmiViewPosition != null && wmiViewPosition.snapToPosition()) {
            mouseEvent.consume();
        }
    }

    public static void snapToNearestView(MouseEvent mouseEvent, WmiView wmiView) {
        WmiViewPosition wmiViewPosition = WmiMathDocumentMouseListener.getNearestViewPosition(mouseEvent, wmiView);
        if (wmiViewPosition != null && wmiViewPosition.snapToPosition()) {
            mouseEvent.consume();
        }
    }

    public static WmiViewPosition getNearestViewPosition(MouseEvent mouseEvent, WmiView wmiView) {
        WmiPositionInView wmiPositionInView = WmiViewUtil.getPositionInView(mouseEvent, wmiView);
        WmiViewPosition wmiViewPosition = WmiViewUtil.findNearestView(wmiPositionInView.getView(), wmiPositionInView.getPosition());
        return wmiViewPosition;
    }

    static {
        if (RuntimePlatform.isUnix()) {
            new WmiMathDocumentEditUnixCopy();
        }
    }

    protected static class Autoscroller
    implements Runnable {
        private static final int SCROLL_DELAY = 100;
        private WmiMathDocumentView docView = null;
        private boolean shutdown = false;
        private Point offset = null;
        private WmiMathDocumentMouseListener listener = null;

        private Autoscroller(WmiMathDocumentMouseListener wmiMathDocumentMouseListener, WmiMathDocumentView wmiMathDocumentView, Point point) {
            this.listener = wmiMathDocumentMouseListener;
            this.docView = wmiMathDocumentView;
            Rectangle rectangle = wmiMathDocumentView.getVisibleRegion();
            this.offset = rectangle != null ? new Point(point.x - rectangle.x, point.y - rectangle.y) : point;
        }

        protected static Autoscroller createAutoscroller(WmiMathDocumentMouseListener wmiMathDocumentMouseListener, WmiPositionedView wmiPositionedView, MouseEvent mouseEvent) {
            Object object;
            Autoscroller autoscroller = null;
            Point point = mouseEvent.getPoint();
            Point point2 = WmiViewUtil.getAbsoluteOffset(wmiPositionedView);
            point2.x += point.x;
            point2.y += point.y;
            boolean bl = false;
            WmiMathDocumentView wmiMathDocumentView = wmiPositionedView.getDocumentView();
            if (wmiMathDocumentView != null) {
                object = wmiMathDocumentView.getAutoscrollInsets();
                if (point2.x < ((Insets)object).left || point2.x > ((Insets)object).right) {
                    bl = true;
                }
                if (point2.y < ((Insets)object).top || point2.y > ((Insets)object).bottom) {
                    bl = true;
                }
            }
            if (bl) {
                autoscroller = new Autoscroller(wmiMathDocumentMouseListener, wmiMathDocumentView, point2);
                object = new Thread((Runnable)autoscroller, "autoscroll" + autoscroller.hashCode());
                ((Thread)object).start();
            }
            return autoscroller;
        }

        public void reset() {
            this.shutdown = true;
        }

        public void run() {
            try {
                while (!this.shutdown) {
                    final Rectangle rectangle = this.docView.getVisibleRegion();
                    final Point point = rectangle != null ? new Point(this.offset.x + rectangle.x, this.offset.y + rectangle.y) : this.offset;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Autoscroller.this.docView.autoscroll(point);
                            Rectangle rectangle2 = Autoscroller.this.docView.getVisibleRegion();
                            if (rectangle2 != null && (rectangle2.x != rectangle.x || rectangle2.y != rectangle.y)) {
                                MouseEvent mouseEvent = new MouseEvent(Autoscroller.this.docView, 506, System.currentTimeMillis(), 0, ((Autoscroller)Autoscroller.this).offset.x + rectangle2.x, ((Autoscroller)Autoscroller.this).offset.y + rectangle2.y, 0, false);
                                if (!Autoscroller.this.shutdown) {
                                    Autoscroller.this.listener.findViewAndDispatch(Autoscroller.this.docView, mouseEvent, 0, 0);
                                }
                            }
                        }
                    });
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                WmiErrorLog.log(interruptedException);
            }
        }
    }

    protected class MousePathHierarchy {
        private static final int ARRAY_GROWBY = 10;
        private WmiPositionedView[] hierarchy = null;

        protected MousePathHierarchy() {
        }

        public void setView(MouseEvent mouseEvent, WmiPositionedView wmiPositionedView, int n) {
            if (this.hierarchy == null || n >= this.hierarchy.length) {
                WmiPositionedView[] wmiPositionedViewArray = new WmiPositionedView[n + 10];
                if (this.hierarchy != null) {
                    System.arraycopy(this.hierarchy, 0, wmiPositionedViewArray, 0, this.hierarchy.length);
                }
                this.hierarchy = wmiPositionedViewArray;
            }
            if (wmiPositionedView != this.hierarchy[n]) {
                this.exitViews(mouseEvent, n);
                this.enterView(mouseEvent, wmiPositionedView, n);
            }
        }

        public void exitViews(MouseEvent mouseEvent, int n) {
            Point point = null;
            if (this.hierarchy != null && n < this.hierarchy.length) {
                WmiPositionedView wmiPositionedView = this.hierarchy[n];
                point = wmiPositionedView != null ? WmiViewUtil.getAbsoluteOffset(wmiPositionedView) : new Point(0, 0);
                for (int i = this.hierarchy.length - 1; i >= n; --i) {
                    wmiPositionedView = this.hierarchy[i];
                    if (wmiPositionedView == null) continue;
                    Point point2 = WmiViewUtil.getAbsoluteOffset(wmiPositionedView);
                    int n2 = point2.x - point.x;
                    int n3 = point2.y - point.y;
                    mouseEvent.translatePoint(-n2, -n3);
                    WmiMathDocumentMouseListener.this.dispatchToView(wmiPositionedView, mouseEvent, 6);
                    mouseEvent.translatePoint(n2, n3);
                    this.hierarchy[i] = null;
                }
            }
        }

        public void enterView(MouseEvent mouseEvent, WmiPositionedView wmiPositionedView, int n) {
            this.hierarchy[n] = wmiPositionedView;
            WmiMathDocumentMouseListener.this.dispatchToView(wmiPositionedView, mouseEvent, 5);
        }
    }
}

