/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.controller.WmiMenuBuilder;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.StringTools;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class WmiMenu
extends JMenu
implements Cloneable {
    public static final String LIST_DELIMITER = " ";
    public static final String ITEM_DELIMITER = ".";
    public static final String SEPERATOR_TOKEN = "-";
    protected static String MENU_BUILDER_SUFFIX;
    protected String menuKey = null;
    private WmiResourcePackage menuResourceBundle = null;
    protected String menuResourcePath = null;
    private HashMap commandMap = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    protected WmiResourcePackage getMenuResourceBundle() {
        if (this.menuResourceBundle == null) {
            this.menuResourceBundle = WmiResourcePackage.getResourcePackage(this.menuResourcePath);
        }
        return this.menuResourceBundle;
    }

    public WmiMenu(String string, String string2) {
        super("<>");
        this.fixMenuUI();
        this.initialize(string, string2);
    }

    public WmiMenu() {
        super("<>");
        this.fixMenuUI();
    }

    private void fixMenuUI() {
        if (RuntimePlatform.isWindows()) {
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    WmiMenu.this.setOpaque(true);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    WmiMenu.this.setOpaque(WmiMenu.this.isSelected());
                }
            });
            if (RuntimeLocale.isSimplifiedChinese()) {
                Font font = this.getFont();
                this.setFont(font.deriveFont(12.0f));
            }
        }
    }

    public void initialize(String string, String string2) {
        this.menuKey = string;
        if (string2 != null && string2.length() > 0) {
            this.menuResourcePath = string2;
            String string3 = this.getItemNameForKey(this.menuKey);
            if (string3 != null) {
                String string4 = WmiComponentUtil.getMnemonic(string3);
                string3 = StringTools.removeTilde(string3);
                this.setText(string3);
                if (string4 != null && string4.length() == 1) {
                    this.setMnemonic(string4.charAt(0));
                }
            }
        }
    }

    protected static void addItemToMenu(String string, WmiCommand wmiCommand, JMenu jMenu) {
        JMenuItem jMenuItem = null;
        if (wmiCommand != null) {
            jMenuItem = wmiCommand.createMenuItem(jMenu);
            if (jMenuItem != null) {
                jMenuItem.setFont(WmiFontResolver.getFontForCharacter(string, jMenuItem.getFont()));
                jMenuItem.setText(WmiFontResolver.mapCharactersForFont(string, jMenuItem.getFont(), 100));
            }
        } else {
            jMenuItem = new JMenuItem(string);
            jMenuItem.setEnabled(false);
            jMenu.add(jMenuItem);
        }
    }

    protected static void buildMenu(String string, WmiMenu wmiMenu) {
        String string2 = wmiMenu.getMenuElementKeys(string);
        JPopupMenu jPopupMenu = wmiMenu.getPopupMenu();
        if (string2 != null && jPopupMenu != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals(SEPERATOR_TOKEN)) {
                    jPopupMenu.addSeparator();
                    continue;
                }
                String string4 = string + ITEM_DELIMITER + string3;
                String string5 = wmiMenu.getMenuElementKeys(string4);
                if (string5 != null) {
                    jPopupMenu.add(wmiMenu.createMenuForItem(string4));
                    continue;
                }
                WmiCommand wmiCommand = null;
                wmiCommand = wmiMenu.getProxyCommand(string, string3);
                if (wmiCommand == null) {
                    wmiCommand = wmiMenu.getCommand(string, string3);
                }
                wmiMenu.createMenuItem(wmiCommand, wmiMenu);
            }
        }
    }

    protected static JMenu getSubMenu(String string, HashMap hashMap) {
        JMenu jMenu = (JMenu)hashMap.get(string);
        if (jMenu == null) {
            int n = string.lastIndexOf(ITEM_DELIMITER);
            if (n <= 0) {
                jMenu = new JMenu(string);
                hashMap.put(string, jMenu);
            } else {
                String string2 = string.substring(n + 1);
                String string3 = string.substring(0, n);
                jMenu = new JMenu(string2);
                hashMap.put(string, jMenu);
                JMenu jMenu2 = WmiMenu.getSubMenu(string3, hashMap);
                if (jMenu2 != null) {
                    jMenu2.add(jMenu);
                }
            }
        }
        return jMenu;
    }

    public static ActionEvent createDefaultEvent(JMenuItem jMenuItem, ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            string = jMenuItem.getActionCommand();
        }
        return new ActionEvent(jMenuItem, 1001, string, actionEvent.getWhen(), actionEvent.getModifiers());
    }

    protected WmiMenuBuilder getMenuBuilder(String string) {
        String string2 = "com.maplesoft.wksload." + string + "Menu" + MENU_BUILDER_SUFFIX;
        WmiMenuBuilder wmiMenuBuilder = null;
        try {
            Class<?> clazz = Class.forName(string2);
            wmiMenuBuilder = (WmiMenuBuilder)clazz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return wmiMenuBuilder;
    }

    protected void buildMenu(WmiMenuBuilder wmiMenuBuilder) {
        if (wmiMenuBuilder != null) {
            wmiMenuBuilder.buildMenu(this);
        } else {
            this.buildMenu();
        }
    }

    protected void setLightweightPopupEnabled(JPopupMenu jPopupMenu) {
        boolean bl = JPopupMenu.getDefaultLightWeightPopupEnabled();
        jPopupMenu.setLightWeightPopupEnabled(bl);
        Component component = null;
        for (int i = 0; i < jPopupMenu.getComponentCount(); ++i) {
            component = jPopupMenu.getComponent(i);
            if (!(component instanceof JMenu)) continue;
            this.setLightweightPopupEnabled(((JMenu)component).getPopupMenu());
        }
    }

    protected void buildMenu() {
        WmiMenu.buildMenu(this.menuKey, this);
    }

    protected void buildMenuFromStringArray(String[] stringArray, WmiCommand[] wmiCommandArray, String string, JMenu jMenu) {
        int n;
        JMenu jMenu2 = jMenu != null ? jMenu : this;
        String string2 = string;
        if (string2 == null) {
            int n2 = -1;
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals(SEPERATOR_TOKEN)) continue;
                n2 = n;
                break;
            }
            if (n2 >= 0 && (n = stringArray[n2].indexOf(ITEM_DELIMITER)) >= 0) {
                string2 = stringArray[n2].substring(0, n);
            }
        }
        HashMap<String, JMenu> hashMap = new HashMap<String, JMenu>();
        hashMap.put(string2, jMenu2);
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals(SEPERATOR_TOKEN)) {
                jMenu2.addSeparator();
                continue;
            }
            WmiCommand wmiCommand = wmiCommandArray != null ? wmiCommandArray[n] : WmiCommand.getCommandProxy(stringArray[n]);
            String string3 = stringArray[n];
            if (string3.length() <= 0) continue;
            if (!string3.startsWith(string2)) {
                if (wmiCommand != null) {
                    wmiCommand.createMenuItem(jMenu2);
                    continue;
                }
                WmiMenu.addItemToMenu(string3, null, jMenu2);
                continue;
            }
            String string4 = null;
            String string5 = null;
            int n3 = string3.lastIndexOf(ITEM_DELIMITER);
            if (n3 < 0) {
                if (string3.length() <= 0) continue;
                WmiMenu.addItemToMenu(string3, wmiCommand, jMenu2);
                continue;
            }
            string4 = string3.substring(n3 + 1);
            string5 = string3.substring(0, n3);
            JMenu jMenu3 = WmiMenu.getSubMenu(string5, hashMap);
            if (jMenu3 == null) continue;
            WmiMenu.addItemToMenu(string4, wmiCommand, jMenu3);
        }
    }

    public ActionEvent createEvent(JMenuItem jMenuItem, ActionEvent actionEvent) {
        return WmiMenu.createDefaultEvent(jMenuItem, actionEvent);
    }

    protected WmiCommand getCommand(String string, String string2) {
        return WmiCommand.getCommandInstance(string + ITEM_DELIMITER + string2);
    }

    public String getItemNameForKey(String string) {
        return this.getMenuResourceBundle().getStringForKey(string + ".menuitem");
    }

    public String getMenuElementKeys(String string) {
        return this.getMenuResourceBundle().getStringForKey(string + ".menu");
    }

    protected String getProxiedCommandForKey(String string) {
        return this.getMenuResourceBundle().getStringForKey(string + ".proxy");
    }

    protected String getFullyQualifiedProxiedCommandForKey(String string) {
        return this.getMenuResourceBundle().getStringForKey(string + ".fullyQualifiedProxy");
    }

    protected WmiCommandProxy createProxiedCommandForFullyQualifiedKey(String string) {
        String[] stringArray = string.split(":");
        if (!$assertionsDisabled && stringArray.length != 1 && stringArray.length != 2) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && stringArray[0].length() <= 0) {
            throw new AssertionError((Object)("this should be <class>:<command name> but isn't: " + string));
        }
        WmiCommandProxy wmiCommandProxy = null;
        try {
            if (stringArray.length == 1) {
                Class<?> clazz = Class.forName(stringArray[0].trim());
                wmiCommandProxy = (WmiCommandProxy)clazz.newInstance();
            } else {
                if (!$assertionsDisabled && stringArray[1].length() <= 0) {
                    throw new AssertionError();
                }
                String string2 = stringArray[1];
                wmiCommandProxy = new WmiCommandProxy(string2, stringArray[0], this.menuResourceBundle);
            }
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
        return wmiCommandProxy;
    }

    protected WmiCommand getProxyCommand(String string, String string2) {
        WmiCommandProxy wmiCommandProxy = null;
        String string3 = this.getProxiedCommandForKey(string + ITEM_DELIMITER + string2);
        if (string3 != null) {
            wmiCommandProxy = WmiCommand.getCommandProxy(string3);
        }
        if (wmiCommandProxy == null && (string3 = this.getFullyQualifiedProxiedCommandForKey(string + ITEM_DELIMITER + string2)) != null) {
            wmiCommandProxy = this.createProxiedCommandForFullyQualifiedKey(string3);
        }
        return wmiCommandProxy;
    }

    protected JMenu createMenuForItem(String string) {
        WmiMenu wmiMenu = new WmiMenu(string, this.menuResourcePath);
        wmiMenu.buildMenu();
        return wmiMenu;
    }

    protected void createMenuItem(WmiCommand wmiCommand, JMenu jMenu) {
        JMenuItem jMenuItem;
        if (wmiCommand != null && jMenu != null && (jMenuItem = wmiCommand.createMenuItem(jMenu)) != null) {
            this.commandMap.put(jMenuItem, wmiCommand);
        }
    }

    protected WmiCommand getCommandForItem(JMenuItem jMenuItem) {
        return (WmiCommand)this.commandMap.get(jMenuItem);
    }

    protected JMenuItem getMenuItemForKey(String string) {
        String string2 = this.getItemNameForKey(string);
        return this.getMenuItemForName(string2);
    }

    protected JMenuItem getMenuItemForName(String string) {
        JMenuItem jMenuItem = null;
        if (string != null) {
            int n = this.getItemCount();
            for (int i = 0; i < n; ++i) {
                String string2;
                JMenuItem jMenuItem2 = this.getItem(i);
                if (jMenuItem2 == null || (string2 = jMenuItem2.getText()) == null || !string2.equals(string)) continue;
                jMenuItem = jMenuItem2;
                break;
            }
        }
        return jMenuItem;
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = super.getPopupMenu();
        this.setLightweightPopupEnabled(jPopupMenu);
        return jPopupMenu;
    }

    static {
        boolean bl = $assertionsDisabled = !WmiMenu.class.desiredAssertionStatus();
        MENU_BUILDER_SUFFIX = RuntimePlatform.isMac() ? "Mac" : (RuntimePlatform.isUnix() ? "Unix" : "Win");
        Locale locale = RuntimeLocale.getDisplayLocale();
        MENU_BUILDER_SUFFIX = MENU_BUILDER_SUFFIX + "_" + locale.toString();
    }
}

