/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.edit;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.util.WmiSearchVisitor;
import java.awt.event.ActionEvent;

public class WmiDiscardParsedMeaningCommand
extends WmiCommand {
    private static final String RESOURCE_LOCATION = "com.maplesoft.mathdoc.controller.edit.resources.Edit";

    public WmiDiscardParsedMeaningCommand() {
        super("edit.discardmeaning");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled(WmiView wmiView) {
        WmiMathDocumentView wmiMathDocumentView;
        boolean bl = false;
        WmiMathDocumentView wmiMathDocumentView2 = wmiMathDocumentView = wmiView != null ? wmiView.getDocumentView() : null;
        if (wmiMathDocumentView != null) {
            WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
            if (WmiModelLock.readLock(wmiView.getModel(), false)) {
                try {
                    WmiMathWrapperModel wmiMathWrapperModel = this.getMathWrapper(wmiPositionMarker);
                    if (wmiMathWrapperModel != null && !wmiPositionMarker.isReadOnly()) {
                        bl = true;
                    }
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
                finally {
                    WmiModelLock.readUnlock(wmiView.getModel());
                }
            }
        }
        return bl;
    }

    private WmiMathWrapperModel getMathWrapper(WmiPositionMarker wmiPositionMarker) throws WmiNoReadAccessException {
        WmiModel wmiModel;
        WmiPositionedView wmiPositionedView;
        WmiMathWrapperModel wmiMathWrapperModel = null;
        if (wmiPositionMarker != null && (wmiPositionedView = wmiPositionMarker.getView()) != null && (wmiModel = wmiPositionedView.getModel()) != null) {
            wmiMathWrapperModel = (WmiMathWrapperModel)WmiModelUtil.findAncestorOfTag(wmiModel, WmiModelTag.MATH);
        }
        return wmiMathWrapperModel;
    }

    public static void discardSemantics(WmiMathWrapperModel wmiMathWrapperModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        wmiMathWrapperModel.discardSemantics();
    }

    public static void discardAllSemantics(WmiModel wmiModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModelUtil.visitModels(wmiModel, (WmiSearchVisitor)new DiscardSemanticsVisitor(), WmiModelTag.MATH, WmiModelTag.MATH);
    }

    public void doCommand(ActionEvent actionEvent) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathDocumentView wmiMathDocumentView = WmiDiscardParsedMeaningCommand.getDocumentView(actionEvent);
        if (wmiMathDocumentView != null && this.isEnabled(wmiMathDocumentView)) {
            WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
            WmiMathWrapperModel wmiMathWrapperModel = null;
            wmiMathWrapperModel = this.getMathWrapper(wmiPositionMarker);
            if (wmiMathWrapperModel != null) {
                WmiDiscardParsedMeaningCommand.discardSemantics(wmiMathWrapperModel);
                try {
                    wmiMathWrapperModel.getDocument().update(this.getResource(5));
                }
                catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
                    WmiErrorLog.log(wmiNoUpdateAccessException);
                }
            }
        }
    }

    protected String getResourcePath() {
        return RESOURCE_LOCATION;
    }

    private static class DiscardSemanticsVisitor
    implements WmiSearchVisitor {
        private DiscardSemanticsVisitor() {
        }

        public int visitMatch(Object object) {
            int n = 0;
            if (object instanceof WmiMathWrapperModel) {
                WmiMathWrapperModel wmiMathWrapperModel = (WmiMathWrapperModel)object;
                WmiMathDocumentModel wmiMathDocumentModel = wmiMathWrapperModel.getDocument();
                try {
                    if (wmiMathDocumentModel.isMutableModel(wmiMathWrapperModel)) {
                        WmiDiscardParsedMeaningCommand.discardSemantics(wmiMathWrapperModel);
                    }
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
                catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                    WmiErrorLog.log(wmiNoWriteAccessException);
                }
                n = 1;
            }
            return n;
        }
    }
}

